/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.FileNotFoundException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.viewfs.ViewFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.spark.HoodieHadoopFSUtils;
import org.apache.spark.HoodieHadoopFSUtils$;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class HoodieHadoopFSUtils$
implements Logging {
    public static final HoodieHadoopFSUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HoodieHadoopFSUtils$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Seq<Tuple2<Path, Seq<FileStatus>>> parallelListLeafFiles(SparkContext sc, Seq<Path> paths, Configuration hadoopConf, PathFilter filter, boolean ignoreMissingFiles, boolean ignoreLocality, int parallelismThreshold, int parallelismMax) {
        return this.parallelListLeafFilesInternal(sc, paths, hadoopConf, filter, true, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Tuple2<Path, Seq<FileStatus>>> parallelListLeafFilesInternal(SparkContext sc, Seq<Path> paths, Configuration hadoopConf, PathFilter filter, boolean isRootLevel, boolean ignoreMissingFiles, boolean ignoreLocality, int parallelismThreshold, int parallelismMax) {
        Tuple2[] tuple2Array;
        if (paths.size() <= parallelismThreshold) {
            return (Seq)paths.map((Function1)new Serializable(sc, hadoopConf, filter, isRootLevel, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax){
                public static final long serialVersionUID = 0L;
                private final SparkContext sc$1;
                private final Configuration hadoopConf$1;
                private final PathFilter filter$1;
                private final boolean isRootLevel$1;
                private final boolean ignoreMissingFiles$1;
                private final boolean ignoreLocality$1;
                private final int parallelismThreshold$1;
                private final int parallelismMax$1;

                public final Tuple2<Path, Seq<FileStatus>> apply(Path path) {
                    Seq<FileStatus> leafFiles = HoodieHadoopFSUtils$.MODULE$.org$apache$spark$HoodieHadoopFSUtils$$listLeafFiles(path, this.hadoopConf$1, this.filter$1, (Option<SparkContext>)new Some((Object)this.sc$1), this.ignoreMissingFiles$1, this.ignoreLocality$1, this.isRootLevel$1, this.parallelismThreshold$1, this.parallelismMax$1);
                    return new Tuple2((Object)path, leafFiles);
                }
                {
                    this.sc$1 = sc$1;
                    this.hadoopConf$1 = hadoopConf$1;
                    this.filter$1 = filter$1;
                    this.isRootLevel$1 = isRootLevel$1;
                    this.ignoreMissingFiles$1 = ignoreMissingFiles$1;
                    this.ignoreLocality$1 = ignoreLocality$1;
                    this.parallelismThreshold$1 = parallelismThreshold$1;
                    this.parallelismMax$1 = parallelismMax$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        this.logInfo((Function0<String>)new Serializable(paths){
            public static final long serialVersionUID = 0L;
            private final Seq paths$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories in parallel under ", " paths."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.paths$1.length())}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" The first several paths are: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((TraversableOnce)this.paths$1.take(10)).mkString(", ")}))).toString();
            }
            {
                this.paths$1 = paths$1;
            }
        });
        HiveCatalogMetrics$.MODULE$.incrementParallelListingJobCount(1);
        SerializableConfiguration serializableConfiguration = new SerializableConfiguration(hadoopConf);
        Seq serializedPaths = (Seq)paths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Path x$1) {
                return x$1.toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        int numParallelism = Math.min(paths.size(), parallelismMax);
        String previousJobDescription = sc.getLocalProperty(SparkContext$.MODULE$.SPARK_JOB_DESCRIPTION());
        try {
            String string;
            int n = paths.size();
            switch (n) {
                default: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories for ", " paths:<br/>", ", ..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)n), paths.apply(0)}));
                    break;
                }
                case 1: {
                    string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing leaf files and directories for 1 path:<br/>", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{paths.apply(0)}));
                    break;
                }
                case 0: {
                    string = "Listing leaf files and directories 0 paths";
                }
            }
            String description = string;
            sc.setJobDescription(description);
            RDD qual$1 = sc.parallelize(serializedPaths, numParallelism, ClassTag$.MODULE$.apply(String.class));
            Serializable x$7 = new Serializable(filter, isRootLevel, ignoreMissingFiles, ignoreLocality, serializableConfiguration){
                public static final long serialVersionUID = 0L;
                public final PathFilter filter$1;
                public final boolean isRootLevel$1;
                public final boolean ignoreMissingFiles$1;
                public final boolean ignoreLocality$1;
                private final SerializableConfiguration serializableConfiguration$1;

                public final Iterator<Tuple2<Path, Seq<FileStatus>>> apply(Iterator<String> pathStrings) {
                    Configuration hadoopConf = this.serializableConfiguration$1.value();
                    return ((IterableLike)pathStrings.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(String x$2) {
                            return new Path(x$2);
                        }
                    }).toSeq().map((Function1)new Serializable(this, hadoopConf){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.2 $outer;
                        private final Configuration hadoopConf$3;

                        public final Tuple2<Path, Seq<FileStatus>> apply(Path path) {
                            Seq<FileStatus> leafFiles = HoodieHadoopFSUtils$.MODULE$.org$apache$spark$HoodieHadoopFSUtils$$listLeafFiles(path, this.hadoopConf$3, this.$outer.filter$1, (Option<SparkContext>)None$.MODULE$, this.$outer.ignoreMissingFiles$1, this.$outer.ignoreLocality$1, this.$outer.isRootLevel$1, Integer.MAX_VALUE, 0);
                            return new Tuple2((Object)path, leafFiles);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.hadoopConf$3 = hadoopConf$3;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).iterator();
                }
                {
                    this.filter$1 = filter$1;
                    this.isRootLevel$1 = isRootLevel$1;
                    this.ignoreMissingFiles$1 = ignoreMissingFiles$1;
                    this.ignoreLocality$1 = ignoreLocality$1;
                    this.serializableConfiguration$1 = serializableConfiguration$1;
                }
            };
            boolean x$8 = qual$1.mapPartitions$default$2();
            tuple2Array = (Tuple2[])qual$1.mapPartitions((Function1)x$7, x$8, ClassTag$.MODULE$.apply(Tuple2.class)).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Seq<HoodieHadoopFSUtils.SerializableFileStatus>> apply(Tuple2<Path, Seq<FileStatus>> x0$1) {
                    Tuple2<Path, Seq<FileStatus>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        Path path = (Path)tuple2._1();
                        Seq statuses = (Seq)tuple2._2();
                        Seq serializableStatuses = (Seq)statuses.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final HoodieHadoopFSUtils.SerializableFileStatus apply(FileStatus status) {
                                HoodieHadoopFSUtils.SerializableBlockLocation[] serializableBlockLocationArray;
                                FileStatus fileStatus = status;
                                if (fileStatus instanceof LocatedFileStatus) {
                                    LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                                    serializableBlockLocationArray = (HoodieHadoopFSUtils.SerializableBlockLocation[])Predef$.MODULE$.refArrayOps((Object[])locatedFileStatus.getBlockLocations()).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final HoodieHadoopFSUtils.SerializableBlockLocation apply(BlockLocation loc) {
                                            return new HoodieHadoopFSUtils.SerializableBlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieHadoopFSUtils.SerializableBlockLocation.class)));
                                } else {
                                    serializableBlockLocationArray = (HoodieHadoopFSUtils.SerializableBlockLocation[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(HoodieHadoopFSUtils.SerializableBlockLocation.class));
                                }
                                HoodieHadoopFSUtils.SerializableBlockLocation[] blockLocations = serializableBlockLocationArray;
                                return new HoodieHadoopFSUtils.SerializableFileStatus(status.getPath().toString(), status.getLen(), status.isDirectory(), status.getReplication(), status.getBlockSize(), status.getModificationTime(), status.getAccessTime(), blockLocations);
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                        Tuple2 tuple22 = new Tuple2((Object)path.toString(), (Object)serializableStatuses);
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
            }, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
        }
        catch (Throwable throwable) {
            void var13_13;
            sc.setJobDescription((String)var13_13);
            throw throwable;
        }
        sc.setJobDescription(previousJobDescription);
        Tuple2[] statusMap = tuple2Array;
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])statusMap).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Path, Seq<LocatedFileStatus>> apply(Tuple2<String, Seq<HoodieHadoopFSUtils.SerializableFileStatus>> x0$2) {
                Tuple2<String, Seq<HoodieHadoopFSUtils.SerializableFileStatus>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String path = (String)tuple2._1();
                    Seq serializableStatuses = (Seq)tuple2._2();
                    Seq statuses = (Seq)serializableStatuses.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final LocatedFileStatus apply(HoodieHadoopFSUtils.SerializableFileStatus f) {
                            BlockLocation[] blockLocations = (BlockLocation[])Predef$.MODULE$.refArrayOps((Object[])f.blockLocations()).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final BlockLocation apply(HoodieHadoopFSUtils.SerializableBlockLocation loc) {
                                    return new BlockLocation(loc.names(), loc.hosts(), loc.offset(), loc.length());
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                            return new LocatedFileStatus(new FileStatus(f.length(), f.isDir(), (int)f.blockReplication(), f.blockSize(), f.modificationTime(), new Path(f.path())), blockLocations);
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Tuple2 tuple22 = new Tuple2((Object)new Path(path), (Object)statuses);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    /*
     * Unable to fully structure code
     */
    public Seq<FileStatus> org$apache$spark$HoodieHadoopFSUtils$$listLeafFiles(Path path, Configuration hadoopConf, PathFilter filter, Option<SparkContext> contextOpt, boolean ignoreMissingFiles, boolean ignoreLocality, boolean isRootPath, int parallelismThreshold, int parallelismMax) {
        block7: {
            block8: {
                this.logTrace((Function0<String>)new Serializable(path){
                    public static final long serialVersionUID = 0L;
                    private final Path path$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Listing ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                    }
                    {
                        this.path$1 = path$1;
                    }
                });
                fs = path.getFileSystem(hadoopConf);
                try {
                    var15_11 = fs;
                    var16_12 = var15_11 instanceof DistributedFileSystem != false ? true : var15_11 instanceof ViewFileSystem != false;
                    if (var16_12 && !ignoreLocality) {
                        remoteIter = fs.listLocatedStatus(path);
                        var17_14 = (FileStatus[])new Iterator<LocatedFileStatus>(remoteIter){
                            private final RemoteIterator remoteIter$1;

                            public Iterator<LocatedFileStatus> seq() {
                                return Iterator.class.seq((Iterator)this);
                            }

                            public boolean isEmpty() {
                                return Iterator.class.isEmpty((Iterator)this);
                            }

                            public boolean isTraversableAgain() {
                                return Iterator.class.isTraversableAgain((Iterator)this);
                            }

                            public boolean hasDefiniteSize() {
                                return Iterator.class.hasDefiniteSize((Iterator)this);
                            }

                            public Iterator<LocatedFileStatus> take(int n) {
                                return Iterator.class.take((Iterator)this, (int)n);
                            }

                            public Iterator<LocatedFileStatus> drop(int n) {
                                return Iterator.class.drop((Iterator)this, (int)n);
                            }

                            public Iterator<LocatedFileStatus> slice(int from, int until) {
                                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
                            }

                            public <B> Iterator<B> map(Function1<LocatedFileStatus, B> f) {
                                return Iterator.class.map((Iterator)this, f);
                            }

                            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                                return Iterator.class.$plus$plus((Iterator)this, that);
                            }

                            public <B> Iterator<B> flatMap(Function1<LocatedFileStatus, GenTraversableOnce<B>> f) {
                                return Iterator.class.flatMap((Iterator)this, f);
                            }

                            public Iterator<LocatedFileStatus> filter(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.filter((Iterator)this, p);
                            }

                            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<LocatedFileStatus, B, Object> p) {
                                return Iterator.class.corresponds((Iterator)this, that, p);
                            }

                            public Iterator<LocatedFileStatus> withFilter(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.withFilter((Iterator)this, p);
                            }

                            public Iterator<LocatedFileStatus> filterNot(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.filterNot((Iterator)this, p);
                            }

                            public <B> Iterator<B> collect(PartialFunction<LocatedFileStatus, B> pf) {
                                return Iterator.class.collect((Iterator)this, pf);
                            }

                            public <B> Iterator<B> scanLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                                return Iterator.class.scanLeft((Iterator)this, z, op);
                            }

                            public <B> Iterator<B> scanRight(B z, Function2<LocatedFileStatus, B, B> op) {
                                return Iterator.class.scanRight((Iterator)this, z, op);
                            }

                            public Iterator<LocatedFileStatus> takeWhile(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.takeWhile((Iterator)this, p);
                            }

                            public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> partition(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.partition((Iterator)this, p);
                            }

                            public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> span(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.span((Iterator)this, p);
                            }

                            public Iterator<LocatedFileStatus> dropWhile(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.dropWhile((Iterator)this, p);
                            }

                            public <B> Iterator<Tuple2<LocatedFileStatus, B>> zip(Iterator<B> that) {
                                return Iterator.class.zip((Iterator)this, that);
                            }

                            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                                return Iterator.class.padTo((Iterator)this, (int)len, elem);
                            }

                            public Iterator<Tuple2<LocatedFileStatus, Object>> zipWithIndex() {
                                return Iterator.class.zipWithIndex((Iterator)this);
                            }

                            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
                            }

                            public <U> void foreach(Function1<LocatedFileStatus, U> f) {
                                Iterator.class.foreach((Iterator)this, f);
                            }

                            public boolean forall(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.forall((Iterator)this, p);
                            }

                            public boolean exists(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.exists((Iterator)this, p);
                            }

                            public boolean contains(Object elem) {
                                return Iterator.class.contains((Iterator)this, (Object)elem);
                            }

                            public Option<LocatedFileStatus> find(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.find((Iterator)this, p);
                            }

                            public int indexWhere(Function1<LocatedFileStatus, Object> p) {
                                return Iterator.class.indexWhere((Iterator)this, p);
                            }

                            public <B> int indexOf(B elem) {
                                return Iterator.class.indexOf((Iterator)this, elem);
                            }

                            public BufferedIterator<LocatedFileStatus> buffered() {
                                return Iterator.class.buffered((Iterator)this);
                            }

                            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                                return Iterator.class.grouped((Iterator)this, (int)size);
                            }

                            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
                            }

                            public int length() {
                                return Iterator.class.length((Iterator)this);
                            }

                            public Tuple2<Iterator<LocatedFileStatus>, Iterator<LocatedFileStatus>> duplicate() {
                                return Iterator.class.duplicate((Iterator)this);
                            }

                            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
                            }

                            public <B> void copyToArray(Object xs, int start, int len) {
                                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
                            }

                            public boolean sameElements(Iterator<?> that) {
                                return Iterator.class.sameElements((Iterator)this, that);
                            }

                            public Traversable<LocatedFileStatus> toTraversable() {
                                return Iterator.class.toTraversable((Iterator)this);
                            }

                            public Iterator<LocatedFileStatus> toIterator() {
                                return Iterator.class.toIterator((Iterator)this);
                            }

                            public Stream<LocatedFileStatus> toStream() {
                                return Iterator.class.toStream((Iterator)this);
                            }

                            public String toString() {
                                return Iterator.class.toString((Iterator)this);
                            }

                            public <B> int sliding$default$2() {
                                return Iterator.class.sliding$default$2((Iterator)this);
                            }

                            public List<LocatedFileStatus> reversed() {
                                return TraversableOnce.class.reversed((TraversableOnce)this);
                            }

                            public int size() {
                                return TraversableOnce.class.size((TraversableOnce)this);
                            }

                            public boolean nonEmpty() {
                                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
                            }

                            public int count(Function1<LocatedFileStatus, Object> p) {
                                return TraversableOnce.class.count((TraversableOnce)this, p);
                            }

                            public <B> Option<B> collectFirst(PartialFunction<LocatedFileStatus, B> pf) {
                                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
                            }

                            public <B> B $div$colon(B z, Function2<B, LocatedFileStatus, B> op) {
                                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
                            }

                            public <B> B $colon$bslash(B z, Function2<LocatedFileStatus, B, B> op) {
                                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
                            }

                            public <B> B foldLeft(B z, Function2<B, LocatedFileStatus, B> op) {
                                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
                            }

                            public <B> B foldRight(B z, Function2<LocatedFileStatus, B, B> op) {
                                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
                            }

                            public <B> B reduceLeft(Function2<B, LocatedFileStatus, B> op) {
                                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
                            }

                            public <B> B reduceRight(Function2<LocatedFileStatus, B, B> op) {
                                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
                            }

                            public <B> Option<B> reduceLeftOption(Function2<B, LocatedFileStatus, B> op) {
                                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
                            }

                            public <B> Option<B> reduceRightOption(Function2<LocatedFileStatus, B, B> op) {
                                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
                            }

                            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
                            }

                            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
                            }

                            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
                            }

                            public <B> B aggregate(Function0<B> z, Function2<B, LocatedFileStatus, B> seqop, Function2<B, B, B> combop) {
                                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
                            }

                            public <B> B sum(Numeric<B> num) {
                                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
                            }

                            public <B> B product(Numeric<B> num) {
                                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
                            }

                            public Object min(Ordering cmp) {
                                return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
                            }

                            public Object max(Ordering cmp) {
                                return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
                            }

                            public Object maxBy(Function1 f, Ordering cmp) {
                                return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                            }

                            public Object minBy(Function1 f, Ordering cmp) {
                                return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
                            }

                            public <B> void copyToBuffer(Buffer<B> dest) {
                                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
                            }

                            public <B> void copyToArray(Object xs, int start) {
                                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
                            }

                            public <B> void copyToArray(Object xs) {
                                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
                            }

                            public <B> Object toArray(ClassTag<B> evidence$1) {
                                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
                            }

                            public List<LocatedFileStatus> toList() {
                                return TraversableOnce.class.toList((TraversableOnce)this);
                            }

                            public Iterable<LocatedFileStatus> toIterable() {
                                return TraversableOnce.class.toIterable((TraversableOnce)this);
                            }

                            public Seq<LocatedFileStatus> toSeq() {
                                return TraversableOnce.class.toSeq((TraversableOnce)this);
                            }

                            public IndexedSeq<LocatedFileStatus> toIndexedSeq() {
                                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
                            }

                            public <B> Buffer<B> toBuffer() {
                                return TraversableOnce.class.toBuffer((TraversableOnce)this);
                            }

                            public <B> Set<B> toSet() {
                                return TraversableOnce.class.toSet((TraversableOnce)this);
                            }

                            public Vector<LocatedFileStatus> toVector() {
                                return TraversableOnce.class.toVector((TraversableOnce)this);
                            }

                            public <Col> Col to(CanBuildFrom<Nothing$, LocatedFileStatus, Col> cbf) {
                                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
                            }

                            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<LocatedFileStatus, Tuple2<T, U>> ev) {
                                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
                            }

                            public String mkString(String start, String sep, String end) {
                                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
                            }

                            public String mkString(String sep) {
                                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
                            }

                            public String mkString() {
                                return TraversableOnce.class.mkString((TraversableOnce)this);
                            }

                            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                            }

                            public StringBuilder addString(StringBuilder b, String sep) {
                                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
                            }

                            public StringBuilder addString(StringBuilder b) {
                                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
                            }

                            public LocatedFileStatus next() {
                                return (LocatedFileStatus)this.remoteIter$1.next();
                            }

                            public boolean hasNext() {
                                return this.remoteIter$1.hasNext();
                            }
                            {
                                this.remoteIter$1 = remoteIter$1;
                                TraversableOnce.class.$init$((TraversableOnce)this);
                                Iterator.class.$init$((Iterator)this);
                            }
                        }.toArray(ClassTag$.MODULE$.apply(FileStatus.class));
                    } else {
                        var17_14 = fs.listStatus(path);
                    }
                    v0 = var17_14;
                }
                catch (Throwable var12_15) {
                    var13_16 = var12_15;
                    if (!(var13_16 instanceof FileNotFoundException) || !isRootPath && !ignoreMissingFiles) break block7;
                    this.logWarning((Function0<String>)new Serializable(path){
                        public static final long serialVersionUID = 0L;
                        private final Path path$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The directory ", " was not found. Was it deleted very recently?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.path$1}));
                        }
                        {
                            this.path$1 = path$1;
                        }
                    });
                    var14_17 = (FileStatus[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(FileStatus.class));
                    v0 = var14_17;
                }
                statuses = v0;
                filteredStatuses = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])statuses).filterNot((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus status) {
                        return HoodieHadoopFSUtils$.MODULE$.shouldFilterOutPathName(status.getPath().getName());
                    }
                });
                var22_20 = Predef$.MODULE$.refArrayOps((Object[])filteredStatuses).partition((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileStatus x$3) {
                        return x$3.isDirectory();
                    }
                });
                if (var22_20 == null) break block8;
                dirs = (FileStatus[])var22_20._1();
                topLevelFiles = (FileStatus[])var22_20._2();
                var21_24 = var25_23 = new Tuple2((Object)dirs, (Object)topLevelFiles);
                dirs = (FileStatus[])var21_24._1();
                topLevelFiles = (FileStatus[])var21_24._2();
                var29_27 = contextOpt;
                if (!(var29_27 instanceof Some)) ** GOTO lbl-1000
                var30_28 = (Some)var29_27;
                context = (SparkContext)var30_28.x();
                if (Predef$.MODULE$.refArrayOps((Object[])dirs).size() > parallelismThreshold) {
                    var32_30 = (Seq)this.parallelListLeafFilesInternal(context, (Seq<Path>)((Seq)Predef$.MODULE$.refArrayOps((Object[])dirs).map((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Path apply(FileStatus x$5) {
                            return x$5.getPath();
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))), hadoopConf, filter, false, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax).flatMap((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Seq<FileStatus> apply(Tuple2<Path, Seq<FileStatus>> x$6) {
                            return (Seq)x$6._2();
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                } else lbl-1000:
                // 2 sources

                {
                    var32_30 = (Seq)Predef$.MODULE$.refArrayOps((Object[])dirs).flatMap((Function1)new Serializable(hadoopConf, filter, contextOpt, ignoreMissingFiles, ignoreLocality, parallelismThreshold, parallelismMax){
                        public static final long serialVersionUID = 0L;
                        private final Configuration hadoopConf$2;
                        private final PathFilter filter$2;
                        private final Option contextOpt$1;
                        private final boolean ignoreMissingFiles$2;
                        private final boolean ignoreLocality$2;
                        private final int parallelismThreshold$2;
                        private final int parallelismMax$2;

                        public final Seq<FileStatus> apply(FileStatus dir) {
                            return HoodieHadoopFSUtils$.MODULE$.org$apache$spark$HoodieHadoopFSUtils$$listLeafFiles(dir.getPath(), this.hadoopConf$2, this.filter$2, (Option<SparkContext>)this.contextOpt$1, this.ignoreMissingFiles$2, this.ignoreLocality$2, false, this.parallelismThreshold$2, this.parallelismMax$2);
                        }
                        {
                            this.hadoopConf$2 = hadoopConf$2;
                            this.filter$2 = filter$2;
                            this.contextOpt$1 = contextOpt$1;
                            this.ignoreMissingFiles$2 = ignoreMissingFiles$2;
                            this.ignoreLocality$2 = ignoreLocality$2;
                            this.parallelismThreshold$2 = parallelismThreshold$2;
                            this.parallelismMax$2 = parallelismMax$2;
                        }
                    }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                }
                nestedFiles = var32_30;
                allFiles = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])topLevelFiles).$plus$plus((GenTraversableOnce)nestedFiles, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
                allLeafStatuses = filter == null ? allFiles : (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])allFiles).filter((Function1)new Serializable(filter){
                    public static final long serialVersionUID = 0L;
                    private final PathFilter filter$2;

                    public final boolean apply(FileStatus f) {
                        return this.filter$2.accept(f.getPath());
                    }
                    {
                        this.filter$2 = filter$2;
                    }
                });
                missingFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
                resolvedLeafStatuses = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])allLeafStatuses).flatMap((Function1)new Serializable(ignoreMissingFiles, ignoreLocality, fs, missingFiles){
                    public static final long serialVersionUID = 0L;
                    private final boolean ignoreMissingFiles$2;
                    private final boolean ignoreLocality$2;
                    private final FileSystem fs$1;
                    private final ArrayBuffer missingFiles$1;

                    public final Iterable<FileStatus> apply(FileStatus x0$3) {
                        Throwable throwable2;
                        block7: {
                            Iterable iterable;
                            FileStatus fileStatus = x0$3;
                            if (fileStatus instanceof LocatedFileStatus) {
                                LocatedFileStatus locatedFileStatus = (LocatedFileStatus)fileStatus;
                                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)locatedFileStatus));
                            } else if (this.ignoreLocality$2) {
                                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)fileStatus));
                            } else {
                                Iterable iterable2;
                                try {
                                    BlockLocation[] locations = (BlockLocation[])Predef$.MODULE$.refArrayOps((Object[])this.fs$1.getFileBlockLocations(fileStatus, 0L, fileStatus.getLen())).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final BlockLocation apply(BlockLocation loc) {
                                            Class<?> clazz = loc.getClass();
                                            Class<BlockLocation> clazz2 = BlockLocation.class;
                                            return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) ? loc : new BlockLocation(loc.getNames(), loc.getHosts(), loc.getOffset(), loc.getLength());
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BlockLocation.class)));
                                    LocatedFileStatus lfs = new LocatedFileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), 0L, null, null, null, null, fileStatus.getPath(), locations);
                                    if (fileStatus.isSymlink()) {
                                        lfs.setSymlink(fileStatus.getSymlink());
                                    }
                                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)lfs));
                                }
                                catch (Throwable throwable2) {
                                    Iterable iterable3;
                                    Throwable throwable3 = throwable2;
                                    if (!(throwable3 instanceof FileNotFoundException) || !this.ignoreMissingFiles$2) break block7;
                                    this.missingFiles$1.$plus$eq((Object)fileStatus.getPath().toString());
                                    iterable2 = iterable3 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                }
                                iterable = iterable2;
                            }
                            return iterable;
                        }
                        throw throwable2;
                    }
                    {
                        this.ignoreMissingFiles$2 = ignoreMissingFiles$2;
                        this.ignoreLocality$2 = ignoreLocality$2;
                        this.fs$1 = fs$1;
                        this.missingFiles$1 = missingFiles$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(FileStatus.class)));
                if (missingFiles.nonEmpty()) {
                    this.logWarning((Function0<String>)new Serializable(missingFiles){
                        public static final long serialVersionUID = 0L;
                        private final ArrayBuffer missingFiles$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"the following files were missing during file scan:\\n  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.missingFiles$1.mkString("\n  ")}));
                        }
                        {
                            this.missingFiles$1 = missingFiles$1;
                        }
                    });
                }
                return Predef$.MODULE$.wrapRefArray((Object[])resolvedLeafStatuses);
            }
            throw new MatchError((Object)var22_20);
        }
        throw var12_15;
    }

    public boolean shouldFilterOutPathName(String pathName) {
        boolean exclude = pathName.startsWith("_") && !pathName.contains("=") || pathName.endsWith("._COPYING_");
        boolean include = pathName.startsWith("_common_metadata") || pathName.startsWith("_metadata");
        return exclude && !include;
    }

    private HoodieHadoopFSUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

