/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.payload;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.spark.sql.avro.HoodieAvroDeserializer;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public final class SqlTypedRecord$ {
    public static final SqlTypedRecord$ MODULE$;
    private final Cache<Schema, StructType> sqlTypeCache;
    private final ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCacheLocal;

    static {
        new SqlTypedRecord$();
    }

    private Cache<Schema, StructType> sqlTypeCache() {
        return this.sqlTypeCache;
    }

    private ThreadLocal<Cache<Schema, HoodieAvroDeserializer>> avroDeserializerCacheLocal() {
        return this.avroDeserializerCacheLocal;
    }

    public StructType getSqlType(Schema schema2) {
        return (StructType)this.sqlTypeCache().get((Object)schema2, (Function)new Function<Schema, StructType>(){

            public StructType apply(Schema t) {
                return AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(t);
            }
        });
    }

    public HoodieAvroDeserializer getAvroDeserializer(Schema schema2) {
        return (HoodieAvroDeserializer)this.avroDeserializerCacheLocal().get().get((Object)schema2, (Function)new Function<Schema, HoodieAvroDeserializer>(){

            public HoodieAvroDeserializer apply(Schema t) {
                return HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(t, (DataType)SqlTypedRecord$.MODULE$.getSqlType(t));
            }
        });
    }

    private SqlTypedRecord$() {
        MODULE$ = this;
        this.sqlTypeCache = Caffeine.newBuilder().maximumSize(16L).build();
        this.avroDeserializerCacheLocal = new ThreadLocal<Cache<Schema, HoodieAvroDeserializer>>(){

            public Cache<Schema, HoodieAvroDeserializer> initialValue() {
                return Caffeine.newBuilder().maximumSize(16L).build();
            }
        };
    }
}

