/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.catalog;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.util.ConfigUtils;
import org.apache.hudi.sql.InsertMode;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieSpark3SqlUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.connector.catalog.DelegatingCatalogExtension;
import org.apache.spark.sql.connector.catalog.HoodieIdentifier;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.StagedTable;
import org.apache.spark.sql.connector.catalog.StagingTableCatalog;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.analysis.HoodieV1OrV2Table$;
import org.apache.spark.sql.hudi.catalog.BasicStagedTable;
import org.apache.spark.sql.hudi.catalog.HoodieInternalV2Table;
import org.apache.spark.sql.hudi.catalog.HoodieInternalV2Table$;
import org.apache.spark.sql.hudi.catalog.HoodieStagedTable;
import org.apache.spark.sql.hudi.catalog.TableCreationMode;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand$;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001B\u000b\u0017\u0001\rBQa\u000e\u0001\u0005\u0002aBq!\b\u0001C\u0002\u0013\u00051\b\u0003\u0004A\u0001\u0001\u0006I\u0001\u0010\u0005\u0006\u0003\u0002!\tE\u0011\u0005\u0006m\u0002!\te\u001e\u0005\u0006y\u0002!\t% \u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!!\b\u0001\t\u0003\ny\u0002C\u0004\u0002*\u0001!\t%a\u000b\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBAU\u0001\u0011\u0005\u00131\u0016\u0005\b\u0003\u007f\u0003A\u0011BAa\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KDqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0003.\u0001!\tBa\r\t\u000f\t5\u0002\u0001\"\u0005\u0003@!9!Q\n\u0001\u0005\n\t=\u0003b\u0002B+\u0001\u0011%!q\u000b\u0002\u000e\u0011>|G-[3DCR\fGn\\4\u000b\u0005]A\u0012aB2bi\u0006dwn\u001a\u0006\u00033i\tA\u0001[;eS*\u00111\u0004H\u0001\u0004gFd'BA\u000f\u001f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0002%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002C\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001J\u0016/gA\u0011Q%K\u0007\u0002M)\u0011qc\n\u0006\u0003Qi\t\u0011bY8o]\u0016\u001cGo\u001c:\n\u0005)2#A\u0007#fY\u0016<\u0017\r^5oO\u000e\u000bG/\u00197pO\u0016CH/\u001a8tS>t\u0007CA\u0013-\u0013\ticEA\nTi\u0006<\u0017N\\4UC\ndWmQ1uC2|w\r\u0005\u00020c5\t\u0001G\u0003\u0002\u001a=%\u0011!\u0007\r\u0002\u0014'B\f'o[!eCB$XM]*vaB|'\u000f\u001e\t\u0003iUj\u0011\u0001G\u0005\u0003ma\u0011A\u0003\u0015:pm&$Wm\u001d%p_\u0012LWmQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u0001:!\tQ\u0004!D\u0001\u0017+\u0005a\u0004CA\u001f?\u001b\u0005Q\u0012BA \u001b\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0019\u0019\b/\u0019:lA\u0005Y1\u000f^1hK\u000e\u0013X-\u0019;f)\u0015\u0019eiS*b!\t)C)\u0003\u0002FM\tY1\u000b^1hK\u0012$\u0016M\u00197f\u0011\u00159E\u00011\u0001I\u0003\u0015IG-\u001a8u!\t)\u0013*\u0003\u0002KM\tQ\u0011\nZ3oi&4\u0017.\u001a:\t\u000b1#\u0001\u0019A'\u0002\rM\u001c\u0007.Z7b!\tq\u0015+D\u0001P\u0015\t\u0001&$A\u0003usB,7/\u0003\u0002S\u001f\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bQ#\u0001\u0019A+\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0002W3nk\u0011a\u0016\u0006\u00021\u0006)1oY1mC&\u0011!l\u0016\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00039~k\u0011!\u0018\u0006\u0003=\u001e\n1\"\u001a=qe\u0016\u001c8/[8og&\u0011\u0001-\u0018\u0002\n)J\fgn\u001d4pe6DQA\u0019\u0003A\u0002\r\f!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011!\u0017n[6\u000e\u0003\u0015T!AZ4\u0002\tU$\u0018\u000e\u001c\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQWMA\u0002NCB\u0004\"\u0001\\:\u000f\u00055\f\bC\u00018X\u001b\u0005y'B\u00019#\u0003\u0019a$o\\8u}%\u0011!oV\u0001\u0007!J,G-\u001a4\n\u0005Q,(AB*ue&twM\u0003\u0002s/\u0006a1\u000f^1hKJ+\u0007\u000f\\1dKR)1\t_={w\")q)\u0002a\u0001\u0011\")A*\u0002a\u0001\u001b\")A+\u0002a\u0001+\")!-\u0002a\u0001G\u0006!2\u000f^1hK\u000e\u0013X-\u0019;f\u001fJ\u0014V\r\u001d7bG\u0016$ra\u0011@\u0000\u0003\u0003\t\u0019\u0001C\u0003H\r\u0001\u0007\u0001\nC\u0003M\r\u0001\u0007Q\nC\u0003U\r\u0001\u0007Q\u000bC\u0003c\r\u0001\u00071-A\u0005m_\u0006$G+\u00192mKR!\u0011\u0011BA\b!\r)\u00131B\u0005\u0004\u0003\u001b1#!\u0002+bE2,\u0007\"B$\b\u0001\u0004A\u0015aC2sK\u0006$X\rV1cY\u0016$\"\"!\u0003\u0002\u0016\u0005]\u0011\u0011DA\u000e\u0011\u00159\u0005\u00021\u0001I\u0011\u0015a\u0005\u00021\u0001N\u0011\u0015!\u0006\u00021\u0001V\u0011\u0015\u0011\u0007\u00021\u0001d\u0003-!\u0018M\u00197f\u000bbL7\u000f^:\u0015\t\u0005\u0005\u0012q\u0005\t\u0004-\u0006\r\u0012bAA\u0013/\n9!i\\8mK\u0006t\u0007\"B$\n\u0001\u0004A\u0015!\u00033s_B$\u0016M\u00197f)\u0011\t\t#!\f\t\u000b\u001dS\u0001\u0019\u0001%\u0002\u0015A,(oZ3UC\ndW\r\u0006\u0003\u0002\"\u0005M\u0002\"B$\f\u0001\u0004A\u0015a\u0003:f]\u0006lW\rV1cY\u0016$b!!\u000f\u0002@\u0005\r\u0003c\u0001,\u0002<%\u0019\u0011QH,\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003\u0003b\u0001\u0019\u0001%\u0002\u0011=dG-\u00133f]RDa!!\u0012\r\u0001\u0004A\u0015\u0001\u00038fo&#WM\u001c;)\u000b1\tI%a\u0018\u0011\u000bY\u000bY%a\u0014\n\u0007\u00055sK\u0001\u0004uQJ|wo\u001d\t\u0005\u0003#\nY&\u0004\u0002\u0002T)!\u0011QKA,\u0003!\tg.\u00197zg&\u001c(bAA-5\u0005A1-\u0019;bYf\u001cH/\u0003\u0003\u0002^\u0005M#a\u0007+bE2,\u0017\t\u001c:fC\u0012LX\t_5tiN,\u0005pY3qi&|g.\r\u0004\u001fW\u0006\u0005\u00141S\u0019\nG\u0005\r\u00141NAE\u0003[*B!!\u001a\u0002hU\t1\u000eB\u0004\u0002j\t\u0012\r!a\u001d\u0003\u0003QKA!!\u001c\u0002p\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIER1!!\u001dX\u0003\u0019!\bN]8xgF!\u0011QOA>!\r1\u0016qO\u0005\u0004\u0003s:&a\u0002(pi\"Lgn\u001a\t\u0005\u0003{\n\u0019ID\u0002W\u0003\u007fJ1!!!X\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\"\u0002\b\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003;\u0016'C\u0012\u0002\f\u00065\u0015qRA9\u001d\r1\u0016QR\u0005\u0004\u0003c:\u0016'\u0002\u0012W/\u0006E%!B:dC2\f\u0017g\u0001\u0014\u0002P!*A\"a&\u0002 B)a+a\u0013\u0002\u001aB!\u0011\u0011KAN\u0013\u0011\ti*a\u0015\u0003)9{7+^2i)\u0006\u0014G.Z#yG\u0016\u0004H/[8oc\u0019q2.!)\u0002(FJ1%a\u0019\u0002l\u0005\r\u0016QN\u0019\nG\u0005-\u0015QRAS\u0003c\nTA\t,X\u0003#\u000b4AJAM\u0003)\tG\u000e^3s)\u0006\u0014G.\u001a\u000b\u0007\u0003\u0013\ti+a,\t\u000b\u001dk\u0001\u0019\u0001%\t\u000f\u0005EV\u00021\u0001\u00024\u000691\r[1oO\u0016\u001c\b#\u0002,\u00026\u0006e\u0016bAA\\/\nQAH]3qK\u0006$X\r\u001a \u0011\u0007\u0015\nY,C\u0002\u0002>\u001a\u00121\u0002V1cY\u0016\u001c\u0005.\u00198hK\u0006\u0011C-\u001a3vG\u0016$\u0016M\u00197f\u0019>\u001c\u0017\r^5p]V\u0013\u0016*\u00118e)\u0006\u0014G.\u001a+za\u0016$b!a1\u0002`\u0006\u0005\bc\u0002,\u0002F\u0006%\u0017Q[\u0005\u0004\u0003\u000f<&A\u0002+va2,'\u0007\u0005\u0003\u0002L\u0006EWBAAg\u0015\r\tymZ\u0001\u0004]\u0016$\u0018\u0002BAj\u0003\u001b\u00141!\u0016*J!\u0011\t9.a7\u000e\u0005\u0005e'bA\f\u0002X%!\u0011Q\\Am\u0005A\u0019\u0015\r^1m_\u001e$\u0016M\u00197f)f\u0004X\rC\u0003H\u001d\u0001\u0007\u0001\nC\u0003c\u001d\u0001\u00071-A\tde\u0016\fG/\u001a%p_\u0012LW\rV1cY\u0016$\"#!\u0003\u0002h\u0006%\u00181^Ax\u0003c\f)0!@\u0003$!)qi\u0004a\u0001\u0011\")Aj\u0004a\u0001\u001b\"9\u0011Q^\bA\u0002\u0005\r\u0017A\u00057pGV\u0013\u0018.\u00118e)\u0006\u0014G.\u001a+za\u0016DQ\u0001V\bA\u0002UCa!a=\u0010\u0001\u0004\u0019\u0017AE1mYR\u000b'\r\\3Qe>\u0004XM\u001d;jKNDq!a>\u0010\u0001\u0004\tI0\u0001\u0007xe&$Xm\u00149uS>t7\u000fE\u0003m\u0003w\\7.\u0003\u0002kk\"9\u0011q`\bA\u0002\t\u0005\u0011aC:pkJ\u001cW-U;fef\u0004RA\u0016B\u0002\u0005\u000fI1A!\u0002X\u0005\u0019y\u0005\u000f^5p]B!!\u0011\u0002B\u000f\u001d\u0011\u0011YAa\u0007\u000f\t\t5!\u0011\u0004\b\u0005\u0005\u001f\u00119B\u0004\u0003\u0003\u0012\tUab\u00018\u0003\u0014%\t\u0011%\u0003\u0002 A%\u0011QDH\u0005\u00037qI1!!!\u001b\u0013\u0011\u0011yB!\t\u0003\u0013\u0011\u000bG/\u0019$sC6,'bAAA5!9!QE\bA\u0002\t\u001d\u0012!C8qKJ\fG/[8o!\rQ$\u0011F\u0005\u0004\u0005W1\"!\u0005+bE2,7I]3bi&|g.T8eK\u0006\u0001\u0012n\u001d)bi\"LE-\u001a8uS\u001aLWM\u001d\u000b\u0005\u0003C\u0011\t\u0004C\u0003H!\u0001\u0007\u0001\n\u0006\u0003\u0002\"\tU\u0002b\u0002B\u001c#\u0001\u0007!\u0011H\u0001\u0006i\u0006\u0014G.\u001a\t\u0005\u0003/\u0014Y$\u0003\u0003\u0003>\u0005e'\u0001D\"bi\u0006dwn\u001a+bE2,G\u0003BA\u0011\u0005\u0003BqAa\u0011\u0013\u0001\u0004\u0011)%A\buC\ndW-\u00133f]RLg-[3s!\u0011\u00119E!\u0013\u000e\u0005\u0005]\u0013\u0002\u0002B&\u0003/\u0012q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\u0019O\u0016$X\t_5ti&tw\rV1cY\u0016Le-\u0012=jgR\u001cH\u0003\u0002B)\u0005'\u0002RA\u0016B\u0002\u0005sAqAa\u000e\u0014\u0001\u0004\u0011)%\u0001\u0007tCZ,7k\\;sG\u0016$e\t\u0006\u0004\u0002:\te#Q\u000f\u0005\b\u0003\u007f$\u0002\u0019\u0001B.!\u00151&1\u0001B/a\u0011\u0011yF!\u001b\u0011\u000bu\u0012\tG!\u001a\n\u0007\t\r$DA\u0004ECR\f7/\u001a;\u0011\t\t\u001d$\u0011\u000e\u0007\u0001\t1\u0011YG!\u0017\u0002\u0002\u0003\u0005)\u0011\u0001B7\u0005\ryF%M\t\u0005\u0003k\u0012y\u0007E\u0002W\u0005cJ1Aa\u001dX\u0005\r\te.\u001f\u0005\u0007ER\u0001\r!!?")
public class HoodieCatalog
extends DelegatingCatalogExtension
implements StagingTableCatalog,
SparkAdapterSupport,
ProvidesHoodieConfig {
    private final SparkSession spark;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public scala.collection.immutable.Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwrite, scala.collection.immutable.Map<String, Option<String>> insertPartitions, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession, (boolean)isOverwrite, insertPartitions, extraOptions);
    }

    public scala.collection.immutable.Map<String, Option<String>> buildHoodieInsertConfig$default$4() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$4$((ProvidesHoodieConfig)this);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (String)partitionsToDrop);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession);
    }

    public TypedProperties getHoodieProps(scala.collection.immutable.Map<String, String> catalogProperties, HoodieTableConfig tableConfig, SQLConf conf, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.getHoodieProps$((ProvidesHoodieConfig)this, catalogProperties, (HoodieTableConfig)tableConfig, (SQLConf)conf, extraOptions);
    }

    public scala.collection.immutable.Map<String, String> getHoodieProps$default$4() {
        return ProvidesHoodieConfig.getHoodieProps$default$4$((ProvidesHoodieConfig)this);
    }

    public HiveSyncConfig buildHiveSyncConfig(TypedProperties props, HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$((ProvidesHoodieConfig)this, (TypedProperties)props, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieCatalog hoodieCatalog = this;
        synchronized (hoodieCatalog) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    public SparkSession spark() {
        return this.spark;
    }

    public StagedTable stageCreate(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        Object object;
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            object = new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitions, properties, TableCreationMode.STAGE_CREATE);
        } else {
            object = new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
        }
        return object;
    }

    public StagedTable stageReplace(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        Object object;
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            object = new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitions, properties, TableCreationMode.STAGE_REPLACE);
        } else {
            super.dropTable(ident);
            object = new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
        }
        return object;
    }

    public StagedTable stageCreateOrReplace(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        Object object;
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            object = new HoodieStagedTable(ident, locUriAndTableType, this, schema, partitions, properties, TableCreationMode.CREATE_OR_REPLACE);
        } else {
            Object object2;
            try {
                object2 = BoxesRunTime.boxToBoolean((boolean)super.dropTable(ident));
            }
            catch (NoSuchTableException noSuchTableException) {
                object2 = BoxedUnit.UNIT;
            }
            object = new BasicStagedTable(ident, super.createTable(ident, schema, partitions, properties), (TableCatalog)this);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Table loadTable(Identifier ident) {
        void var2_35;
        Table table = super.loadTable(ident);
        if (table instanceof V1Table) {
            V1Table v1Table = (V1Table)table;
            CatalogTable catalogTable0 = v1Table.v1Table();
            if (this.sparkAdapter().isHoodieTable(catalogTable0)) {
                CatalogTable catalogTable;
                Option option = catalogTable0.comment();
                if (option instanceof Some) {
                    scala.collection.immutable.Map newProps;
                    Some some = (Some)option;
                    String v = (String)some.value();
                    scala.collection.immutable.Map x$1 = newProps = catalogTable0.properties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"comment"), (Object)v));
                    TableIdentifier x$2 = catalogTable0.copy$default$1();
                    CatalogTableType x$3 = catalogTable0.copy$default$2();
                    CatalogStorageFormat x$4 = catalogTable0.copy$default$3();
                    StructType x$5 = catalogTable0.copy$default$4();
                    Option x$6 = catalogTable0.copy$default$5();
                    Seq x$7 = catalogTable0.copy$default$6();
                    Option x$8 = catalogTable0.copy$default$7();
                    String x$9 = catalogTable0.copy$default$8();
                    long x$10 = catalogTable0.copy$default$9();
                    long x$11 = catalogTable0.copy$default$10();
                    String x$12 = catalogTable0.copy$default$11();
                    Option x$13 = catalogTable0.copy$default$13();
                    Option x$14 = catalogTable0.copy$default$14();
                    Option x$15 = catalogTable0.copy$default$15();
                    Seq x$16 = catalogTable0.copy$default$16();
                    boolean x$17 = catalogTable0.copy$default$17();
                    boolean x$18 = catalogTable0.copy$default$18();
                    scala.collection.immutable.Map x$19 = catalogTable0.copy$default$19();
                    Option x$20 = catalogTable0.copy$default$20();
                    catalogTable = catalogTable0.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$1, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
                } else {
                    catalogTable = catalogTable0;
                }
                CatalogTable catalogTable2 = catalogTable;
                HoodieInternalV2Table v2Table = new HoodieInternalV2Table(this.spark(), catalogTable2.location().toString(), (Option<CatalogTable>)new Some((Object)catalogTable2), (Option<String>)new Some((Object)ident.toString()), HoodieInternalV2Table$.MODULE$.apply$default$5());
                boolean schemaEvolutionEnabled = new StringOps(Predef$.MODULE$.augmentString(this.spark().sessionState().conf().getConfString(DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key(), DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().defaultValue().toString()))).toBoolean();
                HoodieInternalV2Table hoodieInternalV2Table = schemaEvolutionEnabled ? v2Table : v2Table.v1TableWrapper();
                return var2_35;
            }
        }
        Table table2 = table;
        return var2_35;
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, java.util.Map<String, String> properties) {
        Table table;
        if (this.sparkAdapter().isHoodieTable(properties)) {
            Tuple2<URI, CatalogTableType> locUriAndTableType = this.deduceTableLocationURIAndTableType(ident, properties);
            table = this.createHoodieTable(ident, schema, locUriAndTableType, partitions, properties, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<Dataset<Row>>)Option$.MODULE$.empty(), TableCreationMode.CREATE);
        } else {
            table = super.createTable(ident, schema, partitions, properties);
        }
        return table;
    }

    public boolean tableExists(Identifier ident) {
        return super.tableExists(ident);
    }

    public boolean dropTable(Identifier ident) {
        boolean bl;
        Table table = this.loadTable(ident);
        Table table2 = table;
        Option<CatalogTable> option = HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            new DropHoodieTableCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier(), true, false, false).run(this.spark());
            bl = true;
        } else {
            bl = super.dropTable(ident);
        }
        return bl;
    }

    public boolean purgeTable(Identifier ident) {
        boolean bl;
        Table table = this.loadTable(ident);
        Table table2 = table;
        Option<CatalogTable> option = HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            new DropHoodieTableCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier(), true, false, true).run(this.spark());
            bl = true;
        } else {
            bl = super.purgeTable(ident);
        }
        return bl;
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        Table table = this.loadTable(oldIdent);
        Option<CatalogTable> option = HoodieV1OrV2Table$.MODULE$.unapply(table);
        if (!option.isEmpty()) {
            new AlterHoodieTableRenameCommand(CatalogV2Implicits$.MODULE$.IdentifierHelper(oldIdent).asTableIdentifier(), CatalogV2Implicits$.MODULE$.IdentifierHelper(newIdent).asTableIdentifier(), false).run(this.spark());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            super.renameTable(oldIdent, newIdent);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        Table table;
        Table table2 = this.loadTable(ident);
        Option<CatalogTable> option = HoodieV1OrV2Table$.MODULE$.unapply(table2);
        if (!option.isEmpty()) {
            CatalogTable table3 = (CatalogTable)option.get();
            TableIdentifier tableIdent = new TableIdentifier(ident.name(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).lastOption());
            changes.groupBy((Function1 & Serializable & scala.Serializable)c -> c.getClass()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    Seq newColumns = (Seq)tuple2._2();
                    Class clazz = t;
                    Class<TableChange.AddColumn> clazz2 = TableChange.AddColumn.class;
                    if (clazz == null) {
                        if (clazz2 == null) return new AlterHoodieTableAddColumnsCommand(tableIdent, (Seq)newColumns.map((Function1 & Serializable & scala.Serializable)col -> new StructField(col.fieldNames()[0], col.dataType(), col.isNullable(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())).run(this.spark());
                    } else if (clazz.equals(clazz2)) {
                        return new AlterHoodieTableAddColumnsCommand(tableIdent, (Seq)newColumns.map((Function1 & Serializable & scala.Serializable)col -> new StructField(col.fieldNames()[0], col.dataType(), col.isNullable(), StructField$.MODULE$.apply$default$4()), Seq$.MODULE$.canBuildFrom())).run(this.spark());
                    }
                }
                if (tuple2 != null) {
                    Class t = (Class)tuple2._1();
                    Seq columnChanges = (Seq)tuple2._2();
                    if (TableChange.ColumnChange.class.isAssignableFrom(t)) {
                        columnChanges.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                            Seq seq;
                            TableChange tableChange = x0$2;
                            if (tableChange instanceof TableChange.UpdateColumnType) {
                                TableChange.UpdateColumnType updateColumnType = (TableChange.UpdateColumnType)tableChange;
                                String colName = new UnresolvedAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnType.fieldNames())).name();
                                DataType newDataType = updateColumnType.newDataType();
                                StructField structField = new StructField(colName, newDataType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                                seq = new AlterHoodieTableChangeColumnCommand(tableIdent, colName, structField).run(this.spark());
                            } else if (tableChange instanceof TableChange.UpdateColumnComment) {
                                TableChange.UpdateColumnComment updateColumnComment = (TableChange.UpdateColumnComment)tableChange;
                                String newComment = updateColumnComment.newComment();
                                String colName = new UnresolvedAttribute((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames())).name();
                                Option fieldOpt = table3.schema().findNestedField((Seq)Predef$.MODULE$.wrapRefArray((Object[])updateColumnComment.fieldNames()), true, this.spark().sessionState().conf().resolver(), table3.schema().findNestedField$default$4()).map((Function1 & Serializable & scala.Serializable)x$1 -> (StructField)x$1._2());
                                StructField field = (StructField)fieldOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new AnalysisException(new StringBuilder(26).append("Couldn't find column ").append(colName).append(" in:\n").append(table3.schema().treeString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
                                });
                                seq = new AlterHoodieTableChangeColumnCommand(tableIdent, colName, field.withComment(newComment)).run(this.spark());
                            } else {
                                throw new MatchError((Object)tableChange);
                            }
                            return seq;
                        });
                        return BoxedUnit.UNIT;
                    }
                }
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                Class t = (Class)tuple2._1();
                throw new UnsupportedOperationException(new StringBuilder(28).append("not supported table change: ").append(t.getClass()).toString());
            });
            table = this.loadTable(ident);
        } else {
            table = super.alterTable(ident, (TableChange[])changes.toArray(ClassTag$.MODULE$.apply(TableChange.class)));
        }
        return table;
    }

    private Tuple2<URI, CatalogTableType> deduceTableLocationURIAndTableType(Identifier ident, java.util.Map<String, String> properties) {
        Option locOpt = this.isPathIdentifier(ident) ? Option$.MODULE$.apply((Object)ident.name()) : Option$.MODULE$.apply((Object)properties.get("location"));
        CatalogTableType tableType = locOpt.nonEmpty() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        Option locUriOpt = locOpt.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        TableIdentifier tableIdent = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier();
        Option<CatalogTable> existingTableOpt = this.getExistingTableIfExists(tableIdent);
        URI locURI = (URI)locUriOpt.orElse((Function0 & Serializable & scala.Serializable)() -> existingTableOpt.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.storage().locationUri())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.spark().sessionState().catalog().defaultTablePath(tableIdent));
        return new Tuple2((Object)locURI, (Object)tableType);
    }

    public Table createHoodieTable(Identifier ident, StructType schema, Tuple2<URI, CatalogTableType> locUriAndTableType, Transform[] partitions, java.util.Map<String, String> allTableProperties, scala.collection.immutable.Map<String, String> writeOptions, Option<Dataset<Row>> sourceQuery, TableCreationMode operation) {
        Seq seq;
        Tuple2 tuple2 = HoodieSpark3SqlUtils$.MODULE$.convertTransforms((Seq)Predef$.MODULE$.wrapRefArray((Object[])partitions));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq partitionColumns = (Seq)tuple2._1();
        Option maybeBucketSpec = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)partitionColumns, (Object)maybeBucketSpec);
        Tuple2 tuple23 = tuple22;
        Seq partitionColumns2 = (Seq)tuple23._1();
        Option maybeBucketSpec2 = (Option)tuple23._2();
        StructType newSchema = schema;
        Seq newPartitionColumns = partitionColumns2;
        Option newBucketSpec = maybeBucketSpec2;
        CatalogStorageFormat qual$1 = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map)writeOptions.$minus$minus((GenTraversableOnce)HoodieCatalogTable$.MODULE$.needFilterProps()));
        Option x$1 = Option$.MODULE$.apply(locUriAndTableType._1());
        Option x$2 = qual$1.copy$default$2();
        Option x$3 = qual$1.copy$default$3();
        Option x$4 = qual$1.copy$default$4();
        boolean x$5 = qual$1.copy$default$5();
        scala.collection.immutable.Map x$6 = qual$1.copy$default$6();
        CatalogStorageFormat storage = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6);
        Option commentOpt = Option$.MODULE$.apply((Object)allTableProperties.get("comment"));
        HashMap<String, String> tablePropertiesNew = new HashMap<String, String>(allTableProperties);
        tablePropertiesNew.put("path", ((URI)locUriAndTableType._1()).getPath());
        TableIdentifier x$7 = CatalogV2Implicits$.MODULE$.IdentifierHelper(ident).asTableIdentifier();
        CatalogTableType x$8 = (CatalogTableType)locUriAndTableType._2();
        CatalogStorageFormat x$9 = storage;
        StructType x$10 = newSchema;
        Option x$11 = Option$.MODULE$.apply((Object)"hudi");
        Seq x$12 = newPartitionColumns;
        Option x$13 = newBucketSpec;
        scala.collection.immutable.Map x$14 = (scala.collection.immutable.Map)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(tablePropertiesNew).asScala()).toMap(Predef$.MODULE$.$conforms()).$minus$minus((GenTraversableOnce)HoodieCatalogTable$.MODULE$.needFilterProps());
        Option x$15 = commentOpt;
        String x$16 = CatalogTable$.MODULE$.$lessinit$greater$default$8();
        long x$17 = CatalogTable$.MODULE$.$lessinit$greater$default$9();
        long x$18 = CatalogTable$.MODULE$.$lessinit$greater$default$10();
        String x$19 = CatalogTable$.MODULE$.$lessinit$greater$default$11();
        Option x$20 = CatalogTable$.MODULE$.$lessinit$greater$default$13();
        Option x$21 = CatalogTable$.MODULE$.$lessinit$greater$default$14();
        Seq x$22 = CatalogTable$.MODULE$.$lessinit$greater$default$16();
        boolean x$23 = CatalogTable$.MODULE$.$lessinit$greater$default$17();
        boolean x$24 = CatalogTable$.MODULE$.$lessinit$greater$default$18();
        scala.collection.immutable.Map x$25 = CatalogTable$.MODULE$.$lessinit$greater$default$19();
        Option x$26 = CatalogTable$.MODULE$.$lessinit$greater$default$20();
        CatalogTable tableDesc = new CatalogTable(x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$16, x$17, x$18, x$19, x$14, x$20, x$21, x$15, x$22, x$23, x$24, x$25, x$26);
        HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(this.spark(), tableDesc);
        TableCreationMode tableCreationMode = operation;
        TableCreationMode tableCreationMode2 = TableCreationMode.STAGE_CREATE;
        if (!(tableCreationMode != null ? !((Object)((Object)tableCreationMode)).equals((Object)tableCreationMode2) : tableCreationMode2 != null)) {
            String tablePath = hoodieCatalogTable.tableLocation();
            Configuration hadoopConf = this.spark().sessionState().newHadoopConf();
            Predef$.MODULE$.assert(HoodieSqlCommonUtils$.MODULE$.isEmptyPath(tablePath, hadoopConf), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Path '").append(tablePath).append("' should be empty for CTAS").toString());
            hoodieCatalogTable.initHoodieTable();
            scala.collection.immutable.Map tblProperties = hoodieCatalogTable.catalogProperties();
            Tuple2[] tuple2Array = new Tuple2[5];
            CatalogTableType catalogTableType = tableDesc.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
            tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_CREATE_MANAGED_TABLE().key()), (Object)((Object)BoxesRunTime.boxToBoolean((!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) ? 1 : 0) != 0)).toString());
            tuple2Array[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_SERDE_PROPERTIES().key()), (Object)ConfigUtils.configToString((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tblProperties).asJava())));
            tuple2Array[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.HIVE_TABLE_PROPERTIES().key()), (Object)ConfigUtils.configToString((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)tableDesc.properties()).asJava())));
            tuple2Array[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_INSERT_MODE().key()), (Object)InsertMode.NON_STRICT.value());
            tuple2Array[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SQL_ENABLE_BULK_INSERT().key()), (Object)"true");
            scala.collection.immutable.Map options = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties().$plus$plus(this.buildHoodieInsertConfig(hoodieCatalogTable, this.spark(), false, (scala.collection.immutable.Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)options)));
            CreateHoodieTableCommand$.MODULE$.createTableInCatalog(this.spark(), hoodieCatalogTable, false);
            seq = BoxedUnit.UNIT;
        } else if (sourceQuery.isEmpty()) {
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties());
            seq = new CreateHoodieTableCommand(tableDesc, false).run(this.spark());
        } else {
            this.saveSourceDF(sourceQuery, (scala.collection.immutable.Map<String, String>)tableDesc.properties().$plus$plus(this.buildHoodieInsertConfig(hoodieCatalogTable, this.spark(), false, (scala.collection.immutable.Map<String, Option<String>>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty())));
            seq = new CreateHoodieTableCommand(tableDesc, false).run(this.spark());
        }
        return this.loadTable(ident);
    }

    private boolean isPathIdentifier(Identifier ident) {
        return new Path(ident.name()).isAbsolute();
    }

    public boolean isPathIdentifier(CatalogTable table) {
        return this.isPathIdentifier(table.identifier());
    }

    public boolean isPathIdentifier(TableIdentifier tableIdentifier) {
        return this.isPathIdentifier(new HoodieIdentifier((String[])Option$.MODULE$.option2Iterable(tableIdentifier.database()).toArray(ClassTag$.MODULE$.apply(String.class)), tableIdentifier.table()));
    }

    private Option<CatalogTable> getExistingTableIfExists(TableIdentifier table) {
        None$ none$;
        SessionCatalog catalog = this.spark().sessionState().catalog();
        if (this.isPathIdentifier(table)) {
            return None$.MODULE$;
        }
        boolean tableExists = catalog.tableExists(table);
        if (tableExists) {
            CatalogTable oldTable = catalog.getTableMetadata(table);
            CatalogTableType catalogTableType = oldTable.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                throw new HoodieException(new StringBuilder(47).append(table).append(" is a view. You may not write data into a view.").toString());
            }
            if (!this.sparkAdapter().isHoodieTable(oldTable)) {
                throw new HoodieException(new StringBuilder(23).append(table).append(" is not a Hoodie table.").toString());
            }
            none$ = new Some((Object)oldTable);
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void saveSourceDF(Option<Dataset<?>> sourceQuery, scala.collection.immutable.Map<String, String> properties) {
        sourceQuery.map((Function1 & Serializable & scala.Serializable)df -> {
            df.write().format("org.apache.hudi").options((Map)properties).mode(SaveMode.Append).save();
            return df;
        });
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public HoodieCatalog() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
        ProvidesHoodieConfig.$init$((ProvidesHoodieConfig)this);
        this.spark = SparkSession$.MODULE$.active();
    }
}

