/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.repository.config;

import java.util.Map;
import org.apache.nifi.security.repository.RepositoryType;
import org.apache.nifi.security.repository.config.RepositoryEncryptionConfiguration;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.util.NiFiProperties;

public class ProvenanceRepositoryEncryptionConfiguration
extends RepositoryEncryptionConfiguration {
    public ProvenanceRepositoryEncryptionConfiguration(NiFiProperties niFiProperties) {
        this(niFiProperties.getProperty("nifi.provenance.repository.encryption.key.provider.implementation"), niFiProperties.getProperty("nifi.provenance.repository.encryption.key.provider.location"), niFiProperties.getProvenanceRepoEncryptionKeyId(), niFiProperties.getProvenanceRepoEncryptionKeys(), niFiProperties.getProperty("nifi.provenance.repository.implementation"), niFiProperties.getProperty("nifi.provenance.repository.encryption.key.provider.password"));
    }

    public ProvenanceRepositoryEncryptionConfiguration(String keyProviderImplementation, String keyProviderLocation, String encryptionKeyId, Map<String, String> encryptionKeys, String repositoryImplementation, String keyProviderPassword) {
        this.keyProviderImplementation = keyProviderImplementation;
        this.keyProviderLocation = keyProviderLocation;
        this.encryptionKeyId = encryptionKeyId;
        this.encryptionKeys = encryptionKeys;
        this.repositoryImplementation = repositoryImplementation;
        this.repositoryType = RepositoryType.CONTENT;
        this.keyStoreType = KeyStoreUtils.getKeystoreTypeFromExtension(keyProviderLocation).getType();
        this.keyProviderPassword = keyProviderPassword;
    }
}

