/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.namesrv.kvconfig;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.protocol.body.KVTable;
import org.apache.rocketmq.namesrv.NamesrvController;
import org.apache.rocketmq.namesrv.kvconfig.KVConfigSerializeWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVConfigManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqNamesrv");
    private final NamesrvController namesrvController;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final HashMap<String, HashMap<String, String>> configTable = new HashMap();

    public KVConfigManager(NamesrvController namesrvController) {
        this.namesrvController = namesrvController;
    }

    public void load() {
        KVConfigSerializeWrapper kvConfigSerializeWrapper;
        String content = null;
        try {
            content = MixAll.file2String((String)this.namesrvController.getNamesrvConfig().getKvConfigPath());
        }
        catch (IOException e) {
            log.warn("Load KV config table exception", (Throwable)e);
        }
        if (content != null && null != (kvConfigSerializeWrapper = (KVConfigSerializeWrapper)((Object)KVConfigSerializeWrapper.fromJson((String)content, KVConfigSerializeWrapper.class)))) {
            this.configTable.putAll(kvConfigSerializeWrapper.getConfigTable());
            log.info("load KV config table OK");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putKVConfig(String namespace, String key, String value) {
        try {
            this.lock.writeLock().lockInterruptibly();
            try {
                String prev;
                HashMap<String, String> kvTable = this.configTable.get(namespace);
                if (null == kvTable) {
                    kvTable = new HashMap();
                    this.configTable.put(namespace, kvTable);
                    log.info("putKVConfig create new Namespace {}", (Object)namespace);
                }
                if (null != (prev = kvTable.put(key, value))) {
                    log.info("putKVConfig update config item, Namespace: {} Key: {} Value: {}", new Object[]{namespace, key, value});
                } else {
                    log.info("putKVConfig create new config item, Namespace: {} Key: {} Value: {}", new Object[]{namespace, key, value});
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("putKVConfig InterruptedException", (Throwable)e);
        }
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        try {
            this.lock.readLock().lockInterruptibly();
            try {
                KVConfigSerializeWrapper kvConfigSerializeWrapper = new KVConfigSerializeWrapper();
                kvConfigSerializeWrapper.setConfigTable(this.configTable);
                String content = kvConfigSerializeWrapper.toJson();
                if (null != content) {
                    MixAll.string2File((String)content, (String)this.namesrvController.getNamesrvConfig().getKvConfigPath());
                }
            }
            catch (IOException e) {
                log.error("persist kvconfig Exception, " + this.namesrvController.getNamesrvConfig().getKvConfigPath(), (Throwable)e);
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("persist InterruptedException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteKVConfig(String namespace, String key) {
        try {
            this.lock.writeLock().lockInterruptibly();
            try {
                HashMap<String, String> kvTable = this.configTable.get(namespace);
                if (null != kvTable) {
                    String value = kvTable.remove(key);
                    log.info("deleteKVConfig delete a config item, Namespace: {} Key: {} Value: {}", new Object[]{namespace, key, value});
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("deleteKVConfig InterruptedException", (Throwable)e);
        }
        this.persist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getKVListByNamespace(String namespace) {
        try {
            this.lock.readLock().lockInterruptibly();
            try {
                HashMap<String, String> kvTable = this.configTable.get(namespace);
                if (null == kvTable) return null;
                KVTable table = new KVTable();
                table.setTable(kvTable);
                byte[] byArray = table.encode();
                return byArray;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("getKVListByNamespace InterruptedException", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getKVConfig(String namespace, String key) {
        try {
            this.lock.readLock().lockInterruptibly();
            try {
                HashMap<String, String> kvTable = this.configTable.get(namespace);
                if (null == kvTable) return null;
                String string = kvTable.get(key);
                return string;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("getKVConfig InterruptedException", (Throwable)e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAllPeriodically() {
        try {
            this.lock.readLock().lockInterruptibly();
            try {
                log.info("--------------------------------------------------------");
                log.info("configTable SIZE: {}", (Object)this.configTable.size());
                for (Map.Entry<String, HashMap<String, String>> next : this.configTable.entrySet()) {
                    for (Map.Entry<String, String> nextSub : next.getValue().entrySet()) {
                        log.info("configTable NS: {} Key: {} Value: {}", new Object[]{next.getKey(), nextSub.getKey(), nextSub.getValue()});
                    }
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        catch (InterruptedException e) {
            log.error("printAllPeriodically InterruptedException", (Throwable)e);
        }
    }
}

