/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.rocketmq.schema.registry.common.context.RequestContext;
import org.apache.rocketmq.schema.registry.common.context.RequestContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Expected an HttpServletRequest but didn't get one");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String method = httpServletRequest.getMethod();
        RequestContext context = RequestContext.builder().build();
        RequestContextManager.putContext(context);
        log.info("filter " + context.toString());
        chain.doFilter(request, response);
        RequestContextManager.removeContext();
    }

    public void destroy() {
        super.destroy();
    }
}

