/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.schema.registry.common.storage;

import java.util.List;
import org.apache.rocketmq.schema.registry.common.QualifiedName;
import org.apache.rocketmq.schema.registry.common.context.StorageServiceContext;
import org.apache.rocketmq.schema.registry.common.model.BaseInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaInfo;
import org.apache.rocketmq.schema.registry.common.model.SchemaRecordInfo;

public interface StorageService<T extends BaseInfo> {
    public static final String ERROR_MESSAGE_DEFAULT = "Not supported method for this storage type";

    default public SchemaInfo register(StorageServiceContext context, T schemaInfo) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public void delete(StorageServiceContext context, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public T update(StorageServiceContext context, T schemaInfo) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public T get(StorageServiceContext context, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public SchemaRecordInfo getBySubject(StorageServiceContext context, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public SchemaRecordInfo getTargetSchema(StorageServiceContext context, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public List<SchemaRecordInfo> listBySubject(StorageServiceContext context, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public List<String> listSubjectsByTenant(StorageServiceContext storageServiceContext, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }

    default public List<String> listTenants(StorageServiceContext storageService, QualifiedName name) {
        throw new UnsupportedOperationException(ERROR_MESSAGE_DEFAULT);
    }
}

