/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.tracing.rdb.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.tracing.api.TracingStorageConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.exception.TracingStorageUnavailableException;
import org.apache.shardingsphere.elasticjob.tracing.rdb.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.elasticjob.tracing.storage.TracingStorageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DataSourceTracingStorageConverter
implements TracingStorageConverter<DataSource> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourceTracingStorageConverter.class);

    public TracingStorageConfiguration<DataSource> convertObjectToConfiguration(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            log.trace("Try to get connection from {}", (Object)connection.getMetaData().getURL());
        }
        catch (SQLException ex) {
            log.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw new TracingStorageUnavailableException((Throwable)ex);
        }
        return DataSourceConfiguration.getDataSourceConfiguration(dataSource);
    }

    public Class<DataSource> storageType() {
        return DataSource.class;
    }
}

