/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.TaskRunner;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.physical.Partitioning;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.UnaryExecNode;
import org.apache.spark.sql.hive.HiveSessionState;
import org.apache.spark.sql.hive.HiveShim;
import org.apache.spark.sql.hive.HiveShim$;
import org.apache.spark.sql.hive.MetastoreRelation;
import org.apache.spark.sql.hive.SparkHiveDynamicPartitionWriterContainer;
import org.apache.spark.sql.hive.SparkHiveWriterContainer;
import org.apache.spark.sql.hive.SparkHiveWriterContainer$;
import org.apache.spark.sql.hive.execution.InsertIntoHiveTable$;
import org.apache.spark.util.SerializableJobConf;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001B\u0001\u0003\u0001>\u00111#\u00138tKJ$\u0018J\u001c;p\u0011&4X\rV1cY\u0016T!a\u0001\u0003\u0002\u0013\u0015DXmY;uS>t'BA\u0003\u0007\u0003\u0011A\u0017N^3\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\u0001R\u0003\u0007\u0010\u0011\u0005E\u0019R\"\u0001\n\u000b\u0005\r1\u0011B\u0001\u000b\u0013\u0005%\u0019\u0006/\u0019:l!2\fg\u000e\u0005\u0002\u0012-%\u0011qC\u0005\u0002\u000e+:\f'/_#yK\u000etu\u000eZ3\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011dH\u0005\u0003Ai\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001B\t\u0001\u0003\u0016\u0004%\taI\u0001\u0006i\u0006\u0014G.Z\u000b\u0002IA\u0011QEJ\u0007\u0002\t%\u0011q\u0005\u0002\u0002\u0012\u001b\u0016$\u0018m\u001d;pe\u0016\u0014V\r\\1uS>t\u0007\u0002C\u0015\u0001\u0005#\u0005\u000b\u0011\u0002\u0013\u0002\rQ\f'\r\\3!\u0011!Y\u0003A!f\u0001\n\u0003a\u0013!\u00039beRLG/[8o+\u0005i\u0003\u0003\u0002\u00182i]r!!G\u0018\n\u0005AR\u0012A\u0002)sK\u0012,g-\u0003\u00023g\t\u0019Q*\u00199\u000b\u0005AR\u0002C\u0001\u00186\u0013\t14G\u0001\u0004TiJLgn\u001a\t\u00043a\"\u0014BA\u001d\u001b\u0005\u0019y\u0005\u000f^5p]\"A1\b\u0001B\tB\u0003%Q&\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001\"\u0010\u0001\u0003\u0016\u0004%\tAP\u0001\u0006G\"LG\u000eZ\u000b\u0002!!A\u0001\t\u0001B\tB\u0003%\u0001#\u0001\u0004dQ&dG\r\t\u0005\t\u0005\u0002\u0011)\u001a!C\u0001\u0007\u0006IqN^3soJLG/Z\u000b\u0002\tB\u0011\u0011$R\u0005\u0003\rj\u0011qAQ8pY\u0016\fg\u000e\u0003\u0005I\u0001\tE\t\u0015!\u0003E\u0003)yg/\u001a:xe&$X\r\t\u0005\t\u0015\u0002\u0011)\u001a!C\u0001\u0007\u0006Y\u0011N\u001a(pi\u0016C\u0018n\u001d;t\u0011!a\u0005A!E!\u0002\u0013!\u0015\u0001D5g\u001d>$X\t_5tiN\u0004\u0003\"\u0002(\u0001\t\u0003y\u0015A\u0002\u001fj]&$h\b\u0006\u0004Q%N#VK\u0016\t\u0003#\u0002i\u0011A\u0001\u0005\u0006E5\u0003\r\u0001\n\u0005\u0006W5\u0003\r!\f\u0005\u0006{5\u0003\r\u0001\u0005\u0005\u0006\u00056\u0003\r\u0001\u0012\u0005\u0006\u00156\u0003\r\u0001\u0012\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u00031\u0019Xm]:j_:\u001cF/\u0019;f+\u0005Q\u0006CA\u0013\\\u0013\taFA\u0001\tISZ,7+Z:tS>t7\u000b^1uK\"1a\f\u0001Q\u0001\ni\u000bQb]3tg&|gn\u0015;bi\u0016\u0004\u0003FA/a!\tI\u0012-\u0003\u0002c5\tIAO]1og&,g\u000e\u001e\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0003=)\u0007\u0010^3s]\u0006d7)\u0019;bY><W#\u00014\u0011\u0005\u001ddW\"\u00015\u000b\u0005%T\u0017aB2bi\u0006dwn\u001a\u0006\u0003W\u001a\t\u0001bY1uC2L8\u000f^\u0005\u0003[\"\u0014q\"\u0012=uKJt\u0017\r\\\"bi\u0006dwn\u001a\u0005\u0007_\u0002\u0001\u000b\u0011\u00024\u0002!\u0015DH/\u001a:oC2\u001c\u0015\r^1m_\u001e\u0004\u0003F\u00018a\u0011\u0015\u0011\b\u0001\"\u0001t\u0003\u0019yW\u000f\u001e9viV\tA\u000f\u0005\u0003v{\u0006\u0005aB\u0001<|\u001d\t9(0D\u0001y\u0015\tIh\"\u0001\u0004=e>|GOP\u0005\u00027%\u0011APG\u0001\ba\u0006\u001c7.Y4f\u0013\tqxPA\u0002TKFT!\u0001 \u000e\u0011\t\u0005\r\u0011\u0011B\u0007\u0003\u0003\u000bQ1!a\u0002k\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\t\u0005-\u0011Q\u0001\u0002\n\u0003R$(/\u001b2vi\u0016D\u0011\"a\u0004\u0001\u0005\u0004%\t!!\u0005\u0002\u0015!\fGm\\8q\u0007>tg-\u0006\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011\u0001B2p]\u001aT1!!\b\u000b\u0003\u0019A\u0017\rZ8pa&!\u0011\u0011EA\f\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"A\u0011Q\u0005\u0001!\u0002\u0013\t\u0019\"A\u0006iC\u0012|w\u000e]\"p]\u001a\u0004\u0003\"CA\u0015\u0001\t\u0007I\u0011AA\u0016\u0003)\u0019H/Y4j]\u001e$\u0015N]\u000b\u0003\u0003[\u0001B!a\f\u0002:5\u0011\u0011\u0011\u0007\u0006\u0005\u0003g\t)$\u0001\u0003mC:<'BAA\u001c\u0003\u0011Q\u0017M^1\n\u0007Y\n\t\u0004\u0003\u0005\u0002>\u0001\u0001\u000b\u0011BA\u0017\u0003-\u0019H/Y4j]\u001e$\u0015N\u001d\u0011\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D\u0005YQ\r_3dkRLwN\\%e+\u0005!\u0004bBA$\u0001\u0011%\u0011\u0011J\u0001\u000eO\u0016$8\u000b^1hS:<G)\u001b:\u0015\r\u0005-\u0013qKA.!\u0011\ti%a\u0015\u000e\u0005\u0005=#\u0002BA)\u00037\t!AZ:\n\t\u0005U\u0013q\n\u0002\u0005!\u0006$\b\u000e\u0003\u0005\u0002Z\u0005\u0015\u0003\u0019AA&\u0003%Ig\u000e];u!\u0006$\b\u000e\u0003\u0005\u0002\u0010\u0005\u0015\u0003\u0019AA\n\u0011\u001d\ty\u0006\u0001C\u0005\u0003C\nQcZ3u\u000bb$XM\u001d8bYN\u001b'/\u0019;dQ\u0012K'\u000f\u0006\u0004\u0002L\u0005\r\u00141\u000f\u0005\t\u0003K\ni\u00061\u0001\u0002h\u00051Q\r\u001f;V%&\u0003B!!\u001b\u0002p5\u0011\u00111\u000e\u0006\u0005\u0003[\n)$A\u0002oKRLA!!\u001d\u0002l\t\u0019QKU%\t\u0011\u0005=\u0011Q\fa\u0001\u0003'Aq!a\u001e\u0001\t\u0003\tI(\u0001\nhKR,\u0005\u0010^3s]\u0006dG+\u001c9QCRDGCBA&\u0003w\ny\b\u0003\u0005\u0002~\u0005U\u0004\u0019AA&\u0003\u0011\u0001\u0018\r\u001e5\t\u0011\u0005=\u0011Q\u000fa\u0001\u0003'Aq!a!\u0001\t\u0003\t))\u0001\nhKR,\u0005\u0010\u001e+naB\u000bG\u000f\u001b*fYR{GCBA&\u0003\u000f\u000bI\t\u0003\u0005\u0002~\u0005\u0005\u0005\u0019AA&\u0011!\ty!!!A\u0002\u0005M\u0001bBAG\u0001\u0011%\u0011qR\u0001\u000fg\u00064X-Q:ISZ,g)\u001b7f)1\t\t*a&\u0002.\u0006=\u0017Q\u001fB\u0002!\rI\u00121S\u0005\u0004\u0003+S\"\u0001B+oSRD\u0001\"!'\u0002\f\u0002\u0007\u00111T\u0001\u0004e\u0012$\u0007CBAO\u0003C\u000b)+\u0004\u0002\u0002 *\u0019\u0011\u0011\u0014\u0005\n\t\u0005\r\u0016q\u0014\u0002\u0004%\u0012#\u0005\u0003BAT\u0003Sk\u0011A[\u0005\u0004\u0003WS'aC%oi\u0016\u0014h.\u00197S_^D\u0001\"a,\u0002\f\u0002\u0007\u0011\u0011W\u0001\u000bm\u0006dW/Z\"mCN\u001c\b\u0007BAZ\u0003{\u0003RALA[\u0003sK1!a.4\u0005\u0015\u0019E.Y:t!\u0011\tY,!0\r\u0001\u0011a\u0011qXAW\u0003\u0003\u0005\tQ!\u0001\u0002B\n\u0019q\fJ\u0019\u0012\t\u0005\r\u0017\u0011\u001a\t\u00043\u0005\u0015\u0017bAAd5\t9aj\u001c;iS:<\u0007cA\r\u0002L&\u0019\u0011Q\u001a\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002R\u0006-\u0005\u0019AAj\u000311\u0017\u000e\\3TS:\\7i\u001c8g!\u0011\t).a<\u000f\t\u0005]\u00171\u001e\b\u0005\u00033\fIO\u0004\u0003\u0002\\\u0006\u001dh\u0002BAo\u0003KtA!a8\u0002d:\u0019q/!9\n\u00035I!a\u0003\u0007\n\u0005%Q\u0011BA\u0004\t\u0013\t)a!C\u0002\u0002n\u0012\t\u0001\u0002S5wKNC\u0017.\\\u0005\u0005\u0003c\f\u0019P\u0001\tTQ&lg)\u001b7f'&t7\u000eR3tG*\u0019\u0011Q\u001e\u0003\t\u0011\u0005e\u00111\u0012a\u0001\u0003o\u0004B!!?\u0002\u00006\u0011\u00111 \u0006\u0004\u0003{D\u0011\u0001B;uS2LAA!\u0001\u0002|\n\u00192+\u001a:jC2L'0\u00192mK*{'mQ8oM\"A!QAAF\u0001\u0004\u00119!A\bxe&$XM]\"p]R\f\u0017N\\3s!\r)#\u0011B\u0005\u0004\u0005\u0017!!\u0001G*qCJ\\\u0007*\u001b<f/JLG/\u001a:D_:$\u0018-\u001b8fe\"Y!q\u0002\u0001\t\u0006\u0004%\tB\u0002B\t\u0003A\u0019\u0018\u000eZ3FM\u001a,7\r\u001e*fgVdG/\u0006\u0002\u0003\u0014A!Q/`AS\u0011)\u00119\u0002\u0001E\u0001B\u0003&!1C\u0001\u0012g&$W-\u00124gK\u000e$(+Z:vYR\u0004\u0003b\u0002B\u000e\u0001\u0011\u0005#QD\u0001\u0013_V$\b/\u001e;QCJ$\u0018\u000e^5p]&tw-\u0006\u0002\u0003 A!!\u0011\u0005B\u0016\u001b\t\u0011\u0019C\u0003\u0003\u0003&\t\u001d\u0012\u0001\u00039isNL7-\u00197\u000b\u0007\t%\".A\u0003qY\u0006t7/\u0003\u0003\u0003.\t\r\"\u0001\u0004)beRLG/[8oS:<\u0007b\u0002B\u0019\u0001\u0011\u0005#1G\u0001\u000fKb,7-\u001e;f\u0007>dG.Z2u)\t\u0011)\u0004E\u0003\u001a\u0005o\t)+C\u0002\u0003:i\u0011Q!\u0011:sCfDqA!\u0010\u0001\t#\u0012y$A\u0005e_\u0016CXmY;uKR\u0011\u00111\u0014\u0005\n\u0005\u0007\u0002\u0011\u0011!C\u0001\u0005\u000b\nAaY8qsRY\u0001Ka\u0012\u0003J\t-#Q\nB(\u0011!\u0011#\u0011\tI\u0001\u0002\u0004!\u0003\u0002C\u0016\u0003BA\u0005\t\u0019A\u0017\t\u0011u\u0012\t\u0005%AA\u0002AA\u0001B\u0011B!!\u0003\u0005\r\u0001\u0012\u0005\t\u0015\n\u0005\u0003\u0013!a\u0001\t\"I!1\u000b\u0001\u0012\u0002\u0013\u0005!QK\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119FK\u0002%\u00053Z#Aa\u0017\u0011\t\tu#qM\u0007\u0003\u0005?RAA!\u0019\u0003d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005KR\u0012AC1o]>$\u0018\r^5p]&!!\u0011\u000eB0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0005[\u0002\u0011\u0013!C\u0001\u0005_\nabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0003r)\u001aQF!\u0017\t\u0013\tU\u0004!%A\u0005\u0002\t]\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005sR3\u0001\u0005B-\u0011%\u0011i\bAI\u0001\n\u0003\u0011y(\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u0005%f\u0001#\u0003Z!I!Q\u0011\u0001\u0012\u0002\u0013\u0005!qP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011%\u0011I\tAA\u0001\n\u0003\nY#A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e\u001f\u0005\n\u0005\u001b\u0003\u0011\u0011!C\u0001\u0005\u001f\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"A!%\u0011\u0007e\u0011\u0019*C\u0002\u0003\u0016j\u00111!\u00138u\u0011%\u0011I\nAA\u0001\n\u0003\u0011Y*\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%'Q\u0014\u0005\u000b\u0005?\u00139*!AA\u0002\tE\u0015a\u0001=%c!I!1\u0015\u0001\u0002\u0002\u0013\u0005#QU\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!q\u0015\t\u0007\u0005S\u0013y+!3\u000e\u0005\t-&b\u0001BW5\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tE&1\u0016\u0002\t\u0013R,'/\u0019;pe\"I!Q\u0017\u0001\u0002\u0002\u0013\u0005!qW\u0001\tG\u0006tW)];bYR\u0019AI!/\t\u0015\t}%1WA\u0001\u0002\u0004\tI\rC\u0005\u0003>\u0002\t\t\u0011\"\u0011\u0003@\u00061Q-];bYN$2\u0001\u0012Ba\u0011)\u0011yJa/\u0002\u0002\u0003\u0007\u0011\u0011Z\u0004\n\u0005\u000b\u0014\u0011\u0011!E\u0001\u0005\u000f\f1#\u00138tKJ$\u0018J\u001c;p\u0011&4X\rV1cY\u0016\u00042!\u0015Be\r!\t!!!A\t\u0002\t-7#\u0002Be\u0005\u001bt\u0002C\u0003Bh\u0005+$S\u0006\u0005#E!6\u0011!\u0011\u001b\u0006\u0004\u0005'T\u0012a\u0002:v]RLW.Z\u0005\u0005\u0005/\u0014\tNA\tBEN$(/Y2u\rVt7\r^5p]VBqA\u0014Be\t\u0003\u0011Y\u000e\u0006\u0002\u0003H\"Q!q\u001cBe\u0003\u0003%)E!9\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\f\t\u0015\t\u0015(\u0011ZA\u0001\n\u0003\u00139/A\u0003baBd\u0017\u0010F\u0006Q\u0005S\u0014YO!<\u0003p\nE\bB\u0002\u0012\u0003d\u0002\u0007A\u0005\u0003\u0004,\u0005G\u0004\r!\f\u0005\u0007{\t\r\b\u0019\u0001\t\t\r\t\u0013\u0019\u000f1\u0001E\u0011\u0019Q%1\u001da\u0001\t\"Q!Q\u001fBe\u0003\u0003%\tIa>\u0002\u000fUt\u0017\r\u001d9msR!!\u0011`B\u0001!\u0011I\u0002Ha?\u0011\u0011e\u0011i\u0010J\u0017\u0011\t\u0012K1Aa@\u001b\u0005\u0019!V\u000f\u001d7fk!I11\u0001Bz\u0003\u0003\u0005\r\u0001U\u0001\u0004q\u0012\u0002\u0004BCB\u0004\u0005\u0013\f\t\u0011\"\u0003\u0004\n\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\u0001\u0005\u0003\u00020\r5\u0011\u0002BB\b\u0003c\u0011aa\u00142kK\u000e$\b")
public class InsertIntoHiveTable
extends SparkPlan
implements UnaryExecNode {
    private final MetastoreRelation table;
    private final Map<String, Option<String>> partition;
    private final SparkPlan child;
    private final boolean overwrite;
    private final boolean ifNotExists;
    private final transient HiveSessionState sessionState;
    private final transient ExternalCatalog externalCatalog;
    private final Configuration hadoopConf;
    private final String stagingDir;
    private Seq<InternalRow> sideEffectResult;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<MetastoreRelation, Map<String, Option<String>>, SparkPlan, Object, Object>> unapply(InsertIntoHiveTable insertIntoHiveTable) {
        return InsertIntoHiveTable$.MODULE$.unapply(insertIntoHiveTable);
    }

    public static Function1<Tuple5<MetastoreRelation, Map<String, Option<String>>, SparkPlan, Object, Object>, InsertIntoHiveTable> tupled() {
        return InsertIntoHiveTable$.MODULE$.tupled();
    }

    public static Function1<MetastoreRelation, Function1<Map<String, Option<String>>, Function1<SparkPlan, Function1<Object, Function1<Object, InsertIntoHiveTable>>>>> curried() {
        return InsertIntoHiveTable$.MODULE$.curried();
    }

    private Seq sideEffectResult$lzycompute() {
        InsertIntoHiveTable insertIntoHiveTable = this;
        synchronized (insertIntoHiveTable) {
            block20: {
                if (!this.bitmap$0) {
                    SparkHiveWriterContainer sparkHiveWriterContainer;
                    TableDesc tableDesc = this.table().tableDesc();
                    Path tableLocation = this.table().hiveQlTable().getDataLocation();
                    Path tmpLocation = this.getExternalTmpPath(tableLocation, this.hadoopConf());
                    HiveShim.ShimFileSinkDesc fileSinkConf = new HiveShim.ShimFileSinkDesc(tmpLocation.toString(), tableDesc, false);
                    boolean isCompressed = new StringOps(Predef$.MODULE$.augmentString(this.hadoopConf().get("hive.exec.compress.output", "false"))).toBoolean();
                    if (isCompressed) {
                        this.hadoopConf().set("mapred.output.compress", "true");
                        fileSinkConf.setCompressed(true);
                        fileSinkConf.setCompressCodec(this.hadoopConf().get("mapred.output.compression.codec"));
                        fileSinkConf.setCompressType(this.hadoopConf().get("mapred.output.compression.type"));
                    }
                    int numDynamicPartitions = this.partition().values().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Option<String> x$1) {
                            return x$1.isEmpty();
                        }
                    });
                    int numStaticPartitions = this.partition().values().count((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Option<String> x$2) {
                            return x$2.nonEmpty();
                        }
                    });
                    Map partitionSpec = (Map)this.partition().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<String, String> apply(Tuple2<String, Option<String>> x0$1) {
                            Tuple2<String, Option<String>> tuple2;
                            block4: {
                                Tuple2 tuple22;
                                block3: {
                                    block2: {
                                        tuple2 = x0$1;
                                        if (tuple2 == null) break block2;
                                        String key = (String)tuple2._1();
                                        Option option = (Option)tuple2._2();
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        String value = (String)some.x();
                                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value);
                                        break block3;
                                    }
                                    if (tuple2 == null) break block4;
                                    String key = (String)tuple2._1();
                                    Option option = (Option)tuple2._2();
                                    if (!None$.MODULE$.equals(option)) break block4;
                                    tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)"");
                                }
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Map$.MODULE$.canBuildFrom());
                    String partitionColumns = HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo().getProperties().getProperty("partition_columns");
                    String[] partitionColumnNames = (String[])Option$.MODULE$.apply((Object)partitionColumns).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String[] apply(String x$3) {
                            return x$3.split("/");
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String[] apply() {
                            return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
                        }
                    });
                    Set set = Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).toSet();
                    Set set2 = this.partition().keySet();
                    if (set != null ? !set.equals(set2) : set2 != null) break block20;
                    if (numDynamicPartitions > 0) {
                        if (new StringOps(Predef$.MODULE$.augmentString(this.hadoopConf().get("hive.exec.dynamic.partition", "true"))).toBoolean()) {
                            if (numStaticPartitions == 0 && this.hadoopConf().get("hive.exec.dynamic.partition.mode", "strict").equalsIgnoreCase("strict")) {
                                throw new SparkException(ErrorMsg.DYNAMIC_PARTITION_STRICT_MODE.getMsg());
                            }
                            boolean[] isDynamic = (boolean[])Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).map((Function1)new Serializable(this, partitionSpec){
                                public static final long serialVersionUID = 0L;
                                private final Map partitionSpec$1;

                                public final boolean apply(String x$5) {
                                    return ((String)this.partitionSpec$1.apply((Object)x$5)).isEmpty();
                                }
                                {
                                    this.partitionSpec$1 = partitionSpec$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Boolean()));
                            if (Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.booleanArrayOps((boolean[])Predef$.MODULE$.booleanArrayOps(isDynamic).init()).zip((GenIterable)Predef$.MODULE$.wrapBooleanArray((boolean[])Predef$.MODULE$.booleanArrayOps(isDynamic).tail()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).contains((Object)new Tuple2.mcZZ.sp(true, false))) {
                                throw new AnalysisException(ErrorMsg.PARTITION_DYN_STA_ORDER.getMsg(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                            }
                        } else {
                            throw new SparkException(ErrorMsg.DYNAMIC_PARTITION_DISABLED.getMsg());
                        }
                    }
                    JobConf jobConf = new JobConf(this.hadoopConf());
                    SerializableJobConf jobConfSer = new SerializableJobConf(jobConf);
                    boolean speculationEnabled = this.sqlContext().sparkContext().conf().getBoolean("spark.speculation", false);
                    String outputCommitterClass = jobConf.get("mapred.output.committer.class", "");
                    if (speculationEnabled && outputCommitterClass.contains("Direct")) {
                        String warningMessage = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " may be an output committer that writes data directly to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputCommitterClass}))).append((Object)"the final location. Because speculation is enabled, this output committer may ").append((Object)"cause data loss (see the case in SPARK-10063). If possible, please use an output ").append((Object)"committer that does not have this behavior (e.g. FileOutputCommitter).").toString();
                        this.logWarning((Function0)new Serializable(this, warningMessage){
                            public static final long serialVersionUID = 0L;
                            private final String warningMessage$1;

                            public final String apply() {
                                return this.warningMessage$1;
                            }
                            {
                                this.warningMessage$1 = warningMessage$1;
                            }
                        });
                    }
                    if (numDynamicPartitions > 0) {
                        String[] dynamicPartColNames = (String[])Predef$.MODULE$.refArrayOps((Object[])partitionColumnNames).takeRight(numDynamicPartitions);
                        sparkHiveWriterContainer = new SparkHiveDynamicPartitionWriterContainer(jobConf, fileSinkConf, dynamicPartColNames, (Seq<Attribute>)this.child().output());
                    } else {
                        sparkHiveWriterContainer = new SparkHiveWriterContainer(jobConf, fileSinkConf, (Seq<Attribute>)this.child().output());
                    }
                    SparkHiveWriterContainer writerContainer = sparkHiveWriterContainer;
                    Class outputClass = writerContainer.newSerializer(this.table().tableDesc()).getSerializedClass();
                    this.saveAsHiveFile((RDD<InternalRow>)this.child().execute(), outputClass, fileSinkConf, jobConfSer, writerContainer);
                    Path outputPath = FileOutputFormat.getOutputPath((JobConf)jobConf);
                    boolean holdDDLTime = false;
                    if (this.partition().nonEmpty()) {
                        if (numDynamicPartitions > 0) {
                            this.externalCatalog().loadDynamicPartitions(this.table().catalogTable().database(), this.table().catalogTable().identifier().table(), outputPath.toString(), partitionSpec, this.overwrite(), numDynamicPartitions, holdDDLTime);
                        } else {
                            Option oldPart = this.externalCatalog().getPartitionOption(this.table().catalogTable().database(), this.table().catalogTable().identifier().table(), partitionSpec);
                            BooleanRef doHiveOverwrite = BooleanRef.create((boolean)this.overwrite());
                            if (oldPart.isEmpty() || !this.ifNotExists()) {
                                if (oldPart.nonEmpty() && this.overwrite()) {
                                    ((CatalogTablePartition)oldPart.get()).storage().locationUri().foreach((Function1)new Serializable(this, doHiveOverwrite){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ InsertIntoHiveTable $outer;
                                        private final BooleanRef doHiveOverwrite$1;

                                        public final void apply(String uri) {
                                            Path partitionPath = new Path(uri);
                                            FileSystem fs = partitionPath.getFileSystem(this.$outer.hadoopConf());
                                            if (fs.exists(partitionPath)) {
                                                if (fs.delete(partitionPath, true)) {
                                                    this.doHiveOverwrite$1.elem = false;
                                                } else {
                                                    throw new RuntimeException(new StringBuilder().append((Object)"Cannot remove partition directory '").append((Object)partitionPath.toString()).toString());
                                                }
                                            }
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.doHiveOverwrite$1 = doHiveOverwrite$1;
                                        }
                                    });
                                }
                                boolean inheritTableSpecs = true;
                                this.externalCatalog().loadPartition(this.table().catalogTable().database(), this.table().catalogTable().identifier().table(), outputPath.toString(), partitionSpec, doHiveOverwrite.elem, holdDDLTime, inheritTableSpecs);
                            }
                        }
                    } else {
                        this.externalCatalog().loadTable(this.table().catalogTable().database(), this.table().catalogTable().identifier().table(), outputPath.toString(), this.overwrite(), holdDDLTime);
                    }
                    this.sqlContext().sharedState().cacheManager().invalidateCache((LogicalPlan)this.table());
                    this.sqlContext().sessionState().catalog().refreshTable(this.table().catalogTable().identifier());
                    this.sideEffectResult = (Seq)Seq$.MODULE$.empty();
                    this.bitmap$0 = true;
                }
                return this.sideEffectResult;
            }
            throw new SparkException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requested partitioning does not match the ", " table:\n           |Requested partitions: ", "\n           |Table partitions: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.table().tableName(), this.partition().keys().mkString(","), ((TraversableOnce)this.table().partitionKeys().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(AttributeReference x$4) {
                    return x$4.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(",")})))).stripMargin());
        }
    }

    public final Seq<SparkPlan> children() {
        return UnaryExecNode.class.children((UnaryExecNode)this);
    }

    public MetastoreRelation table() {
        return this.table;
    }

    public Map<String, Option<String>> partition() {
        return this.partition;
    }

    public SparkPlan child() {
        return this.child;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    private HiveSessionState sessionState() {
        return this.sessionState;
    }

    private ExternalCatalog externalCatalog() {
        return this.externalCatalog;
    }

    public Seq<Attribute> output() {
        return (Seq)Seq$.MODULE$.empty();
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public String stagingDir() {
        return this.stagingDir;
    }

    private String executionId() {
        Random rand = new Random();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss_SSS", Locale.US);
        return new StringBuilder().append((Object)"hive_").append((Object)format.format(new Date())).append((Object)"_").append((Object)BoxesRunTime.boxToLong((long)Math.abs(rand.nextLong()))).toString();
    }

    private Path getStagingDir(Path inputPath, Configuration hadoopConf) {
        Path dir;
        block3: {
            URI inputPathUri = inputPath.toUri();
            String inputPathName = inputPathUri.getPath();
            FileSystem fs = inputPath.getFileSystem(hadoopConf);
            String stagingPathName = inputPathName.indexOf(this.stagingDir()) == -1 ? new Path(inputPathName, this.stagingDir()).toString() : inputPathName.substring(0, inputPathName.indexOf(this.stagingDir()) + this.stagingDir().length());
            dir = fs.makeQualified(new Path(new StringBuilder().append((Object)stagingPathName).append((Object)"_").append((Object)this.executionId()).append((Object)"-").append((Object)BoxesRunTime.boxToLong((long)TaskRunner.getTaskRunnerID())).toString()));
            this.logDebug((Function0)new Serializable(this, inputPath, dir){
                public static final long serialVersionUID = 0L;
                private final Path inputPath$1;
                private final Path dir$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Created staging dir = ").append((Object)this.dir$1).append((Object)" for path = ").append((Object)this.inputPath$1).toString();
                }
                {
                    this.inputPath$1 = inputPath$1;
                    this.dir$1 = dir$1;
                }
            });
            try {
                if (!FileUtils.mkdir((FileSystem)fs, (Path)dir, (boolean)true, (Configuration)hadoopConf)) break block3;
                fs.deleteOnExit(dir);
            }
            catch (IOException iOException) {
                throw new RuntimeException(new StringBuilder().append((Object)"Cannot create staging directory '").append((Object)dir.toString()).append((Object)"': ").append((Object)iOException.getMessage()).toString(), iOException);
            }
            return dir;
        }
        throw new IllegalStateException(new StringBuilder().append((Object)"Cannot create staging directory  '").append((Object)dir.toString()).append((Object)"'").toString());
    }

    private Path getExternalScratchDir(URI extURI, Configuration hadoopConf) {
        return this.getStagingDir(new Path(extURI.getScheme(), extURI.getAuthority(), extURI.getPath()), hadoopConf);
    }

    public Path getExternalTmpPath(Path path, Configuration hadoopConf) {
        URI extURI = path.toUri();
        String string = extURI.getScheme();
        String string2 = "viewfs";
        return !(string != null ? !string.equals(string2) : string2 != null) ? this.getExtTmpPathRelTo(path.getParent(), hadoopConf) : new Path(this.getExternalScratchDir(extURI, hadoopConf), "-ext-10000");
    }

    public Path getExtTmpPathRelTo(Path path, Configuration hadoopConf) {
        return new Path(this.getStagingDir(path, hadoopConf), "-ext-10000");
    }

    private void saveAsHiveFile(RDD<InternalRow> rdd, Class<?> valueClass, HiveShim.ShimFileSinkDesc fileSinkConf, SerializableJobConf conf, SparkHiveWriterContainer writerContainer) {
        Predef$.MODULE$.assert(valueClass != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Output value class not set";
            }
        });
        conf.value().setOutputValueClass(valueClass);
        String outputFileFormatClassName = HiveShim$.MODULE$.wrapperToFileSinkDesc(fileSinkConf).getTableInfo().getOutputFileFormatClassName();
        Predef$.MODULE$.assert(outputFileFormatClassName != null, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Output format class not set";
            }
        });
        conf.value().set("mapred.output.format.class", outputFileFormatClassName);
        FileOutputFormat.setOutputPath((JobConf)conf.value(), (Path)SparkHiveWriterContainer$.MODULE$.createPathFromString(fileSinkConf.getDirName(), conf.value()));
        this.log().debug(new StringBuilder().append((Object)"Saving as hadoop file of type ").append((Object)valueClass.getSimpleName()).toString());
        writerContainer.driverSideSetup();
        this.sqlContext().sparkContext().runJob(rdd, (Function2)new Serializable(this, writerContainer){
            public static final long serialVersionUID = 0L;
            private final SparkHiveWriterContainer writerContainer$1;

            public final void apply(TaskContext context, Iterator<InternalRow> iterator) {
                this.writerContainer$1.writeToFile(context, iterator);
            }
            {
                this.writerContainer$1 = writerContainer$1;
            }
        }, ClassTag$.MODULE$.Unit());
        writerContainer.commitJob();
    }

    public Seq<InternalRow> sideEffectResult() {
        return this.bitmap$0 ? this.sideEffectResult : this.sideEffectResult$lzycompute();
    }

    public Partitioning outputPartitioning() {
        return this.child().outputPartitioning();
    }

    public InternalRow[] executeCollect() {
        return (InternalRow[])this.sideEffectResult().toArray(ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public RDD<InternalRow> doExecute() {
        return this.sqlContext().sparkContext().parallelize(this.sideEffectResult(), 1, ClassTag$.MODULE$.apply(InternalRow.class));
    }

    public InsertIntoHiveTable copy(MetastoreRelation table, Map<String, Option<String>> partition, SparkPlan child, boolean overwrite, boolean ifNotExists) {
        return new InsertIntoHiveTable(table, partition, child, overwrite, ifNotExists);
    }

    public MetastoreRelation copy$default$1() {
        return this.table();
    }

    public Map<String, Option<String>> copy$default$2() {
        return this.partition();
    }

    public SparkPlan copy$default$3() {
        return this.child();
    }

    public boolean copy$default$4() {
        return this.overwrite();
    }

    public boolean copy$default$5() {
        return this.ifNotExists();
    }

    public String productPrefix() {
        return "InsertIntoHiveTable";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToBoolean((boolean)this.ifNotExists());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.overwrite());
                break;
            }
            case 2: {
                object = this.child();
                break;
            }
            case 1: {
                object = this.partition();
                break;
            }
            case 0: {
                object = this.table();
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof InsertIntoHiveTable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof InsertIntoHiveTable)) return false;
        boolean bl = true;
        if (!bl) return false;
        InsertIntoHiveTable insertIntoHiveTable = (InsertIntoHiveTable)((Object)x$1);
        MetastoreRelation metastoreRelation = this.table();
        MetastoreRelation metastoreRelation2 = insertIntoHiveTable.table();
        if (metastoreRelation == null) {
            if (metastoreRelation2 != null) {
                return false;
            }
        } else if (!((Object)((Object)metastoreRelation)).equals((Object)metastoreRelation2)) return false;
        Map<String, Option<String>> map = this.partition();
        Map<String, Option<String>> map2 = insertIntoHiveTable.partition();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        SparkPlan sparkPlan = this.child();
        SparkPlan sparkPlan2 = insertIntoHiveTable.child();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!sparkPlan.equals(sparkPlan2)) return false;
        if (this.overwrite() != insertIntoHiveTable.overwrite()) return false;
        if (this.ifNotExists() != insertIntoHiveTable.ifNotExists()) return false;
        if (!insertIntoHiveTable.canEqual((Object)this)) return false;
        return true;
    }

    public InsertIntoHiveTable(MetastoreRelation table, Map<String, Option<String>> partition, SparkPlan child, boolean overwrite, boolean ifNotExists) {
        this.table = table;
        this.partition = partition;
        this.child = child;
        this.overwrite = overwrite;
        this.ifNotExists = ifNotExists;
        UnaryExecNode.class.$init$((UnaryExecNode)this);
        this.sessionState = (HiveSessionState)this.sqlContext().sessionState();
        this.externalCatalog = this.sqlContext().sharedState().externalCatalog();
        this.hadoopConf = this.sessionState().newHadoopConf();
        this.stagingDir = this.hadoopConf().get("hive.exec.stagingdir", ".hive-staging");
    }
}

