/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.execution;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.SparkException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.command.DataWritingCommand;
import org.apache.spark.sql.execution.datasources.BasicWriteJobStatsTracker;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hive.HiveShim;
import org.apache.spark.sql.hive.client.HiveClientImpl$;
import org.apache.spark.sql.hive.execution.InsertIntoHiveDirCommand$;
import org.apache.spark.sql.hive.execution.SaveAsHiveFile;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005ug\u0001B\u0001\u0003\u0001>\u0011\u0001$\u00138tKJ$\u0018J\u001c;p\u0011&4X\rR5s\u0007>lW.\u00198e\u0015\t\u0019A!A\u0005fq\u0016\u001cW\u000f^5p]*\u0011QAB\u0001\u0005Q&4XM\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!iqB\u0005\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u00059An\\4jG\u0006d'BA\u000b\u0017\u0003\u0015\u0001H.\u00198t\u0015\t9b!\u0001\u0005dCR\fG._:u\u0013\tI\"CA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u000e\u001d\u001b\u0005\u0011\u0011BA\u000f\u0003\u00059\u0019\u0016M^3Bg\"Kg/\u001a$jY\u0016\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u00059\u0011n\u001d'pG\u0006dW#\u0001\u0016\u0011\u0005}Y\u0013B\u0001\u0017!\u0005\u001d\u0011un\u001c7fC:D\u0001B\f\u0001\u0003\u0012\u0003\u0006IAK\u0001\tSNdunY1mA!A\u0001\u0007\u0001BK\u0002\u0013\u0005\u0011'A\u0004ti>\u0014\u0018mZ3\u0016\u0003I\u0002\"a\r\u001c\u000e\u0003QR!!\u000e\f\u0002\u000f\r\fG/\u00197pO&\u0011q\u0007\u000e\u0002\u0015\u0007\u0006$\u0018\r\\8h'R|'/Y4f\r>\u0014X.\u0019;\t\u0011e\u0002!\u0011#Q\u0001\nI\n\u0001b\u001d;pe\u0006<W\r\t\u0005\tw\u0001\u0011)\u001a!C\u0001y\u0005)\u0011/^3ssV\t\u0001\u0003\u0003\u0005?\u0001\tE\t\u0015!\u0003\u0011\u0003\u0019\tX/\u001a:zA!A\u0001\t\u0001BK\u0002\u0013\u0005\u0011&A\u0005pm\u0016\u0014xO]5uK\"A!\t\u0001B\tB\u0003%!&\u0001\u0006pm\u0016\u0014xO]5uK\u0002B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!R\u0001\u0012_V$\b/\u001e;D_2,XN\u001c(b[\u0016\u001cX#\u0001$\u0011\u0007\u001d{%K\u0004\u0002I\u001b:\u0011\u0011\nT\u0007\u0002\u0015*\u00111JD\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005J!A\u0014\u0011\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0004'\u0016\f(B\u0001(!!\t\u0019vK\u0004\u0002U+B\u0011\u0011\nI\u0005\u0003-\u0002\na\u0001\u0015:fI\u00164\u0017B\u0001-Z\u0005\u0019\u0019FO]5oO*\u0011a\u000b\t\u0005\t7\u0002\u0011\t\u0012)A\u0005\r\u0006\u0011r.\u001e;qkR\u001cu\u000e\\;n]:\u000bW.Z:!\u0011\u0015i\u0006\u0001\"\u0001_\u0003\u0019a\u0014N\\5u}Q1q\fY1cG\u0012\u0004\"a\u0007\u0001\t\u000b!b\u0006\u0019\u0001\u0016\t\u000bAb\u0006\u0019\u0001\u001a\t\u000bmb\u0006\u0019\u0001\t\t\u000b\u0001c\u0006\u0019\u0001\u0016\t\u000b\u0011c\u0006\u0019\u0001$\t\u000b\u0019\u0004A\u0011I4\u0002\u0007I,h\u000eF\u0002i[J\u00042aR(j!\tQ7.D\u0001\u0007\u0013\tagAA\u0002S_^DQA\\3A\u0002=\fAb\u001d9be.\u001cVm]:j_:\u0004\"A\u001b9\n\u0005E4!\u0001D*qCJ\\7+Z:tS>t\u0007\"B:f\u0001\u0004!\u0018!B2iS2$\u0007CA;x\u001b\u00051(BA\u0002\u0007\u0013\tAhOA\u0005Ta\u0006\u00148\u000e\u00157b]\"9!\u0010AA\u0001\n\u0003Y\u0018\u0001B2paf$ra\u0018?~}~\f\t\u0001C\u0004)sB\u0005\t\u0019\u0001\u0016\t\u000fAJ\b\u0013!a\u0001e!91(\u001fI\u0001\u0002\u0004\u0001\u0002b\u0002!z!\u0003\u0005\rA\u000b\u0005\b\tf\u0004\n\u00111\u0001G\u0011%\t)\u0001AI\u0001\n\u0003\t9!\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005%!f\u0001\u0016\u0002\f-\u0012\u0011Q\u0002\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0018\u0001\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY\"!\u0005\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u0002 \u0001\t\n\u0011\"\u0001\u0002\"\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u0012U\r\u0011\u00141\u0002\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003S\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0002,)\u001a\u0001#a\u0003\t\u0013\u0005=\u0002!%A\u0005\u0002\u0005\u001d\u0011AD2paf$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003k\tabY8qs\u0012\"WMZ1vYR$S'\u0006\u0002\u00028)\u001aa)a\u0003\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001\u00027b]\u001eT!!!\u0013\u0002\t)\fg/Y\u0005\u00041\u0006\r\u0003\"CA(\u0001\u0005\u0005I\u0011AA)\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\u0019\u0006E\u0002 \u0003+J1!a\u0016!\u0005\rIe\u000e\u001e\u0005\n\u00037\u0002\u0011\u0011!C\u0001\u0003;\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002`\u0005\u0015\u0004cA\u0010\u0002b%\u0019\u00111\r\u0011\u0003\u0007\u0005s\u0017\u0010\u0003\u0006\u0002h\u0005e\u0013\u0011!a\u0001\u0003'\n1\u0001\u001f\u00132\u0011%\tY\u0007AA\u0001\n\u0003\ni'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0007\u0005\u0004\u0002r\u0005]\u0014qL\u0007\u0003\u0003gR1!!\u001e!\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003s\n\u0019H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ti\bAA\u0001\n\u0003\ty(\u0001\u0005dC:,\u0015/^1m)\rQ\u0013\u0011\u0011\u0005\u000b\u0003O\nY(!AA\u0002\u0005}\u0003\"CAC\u0001\u0005\u0005I\u0011IAD\u0003\u0019)\u0017/^1mgR\u0019!&!#\t\u0015\u0005\u001d\u00141QA\u0001\u0002\u0004\tyfB\u0005\u0002\u000e\n\t\t\u0011#\u0001\u0002\u0010\u0006A\u0012J\\:feRLe\u000e^8ISZ,G)\u001b:D_6l\u0017M\u001c3\u0011\u0007m\t\tJ\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012AAJ'\u0015\t\t*!&%!)\t9*!(+eAQciX\u0007\u0003\u00033S1!a'!\u0003\u001d\u0011XO\u001c;j[\u0016LA!a(\u0002\u001a\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u001b\t\u000fu\u000b\t\n\"\u0001\u0002$R\u0011\u0011q\u0012\u0005\u000b\u0003O\u000b\t*!A\u0005F\u0005%\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005}\u0002BCAW\u0003#\u000b\t\u0011\"!\u00020\u0006)\u0011\r\u001d9msRYq,!-\u00024\u0006U\u0016qWA]\u0011\u0019A\u00131\u0016a\u0001U!1\u0001'a+A\u0002IBaaOAV\u0001\u0004\u0001\u0002B\u0002!\u0002,\u0002\u0007!\u0006\u0003\u0004E\u0003W\u0003\rA\u0012\u0005\u000b\u0003{\u000b\t*!A\u0005\u0002\u0006}\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u0003\fi\rE\u0003 \u0003\u0007\f9-C\u0002\u0002F\u0002\u0012aa\u00149uS>t\u0007\u0003C\u0010\u0002J*\u0012\u0004C\u000b$\n\u0007\u0005-\u0007E\u0001\u0004UkBdW-\u000e\u0005\n\u0003\u001f\fY,!AA\u0002}\u000b1\u0001\u001f\u00131\u0011)\t\u0019.!%\u0002\u0002\u0013%\u0011Q[\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002XB!\u0011\u0011IAm\u0013\u0011\tY.a\u0011\u0003\r=\u0013'.Z2u\u0001")
public class InsertIntoHiveDirCommand
extends LogicalPlan
implements SaveAsHiveFile,
scala.Serializable {
    private final boolean isLocal;
    private final CatalogStorageFormat storage;
    private final LogicalPlan query;
    private final boolean overwrite;
    private final Seq<String> outputColumnNames;
    private Option<Path> createdTempDir;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple5<Object, CatalogStorageFormat, LogicalPlan, Object, Seq<String>>> unapply(InsertIntoHiveDirCommand insertIntoHiveDirCommand) {
        return InsertIntoHiveDirCommand$.MODULE$.unapply(insertIntoHiveDirCommand);
    }

    public static Function1<Tuple5<Object, CatalogStorageFormat, LogicalPlan, Object, Seq<String>>, InsertIntoHiveDirCommand> tupled() {
        return InsertIntoHiveDirCommand$.MODULE$.tupled();
    }

    public static Function1<Object, Function1<CatalogStorageFormat, Function1<LogicalPlan, Function1<Object, Function1<Seq<String>, InsertIntoHiveDirCommand>>>>> curried() {
        return InsertIntoHiveDirCommand$.MODULE$.curried();
    }

    @Override
    public Set<String> saveAsHiveFile(SparkSession sparkSession, SparkPlan plan, Configuration hadoopConf, HiveShim.ShimFileSinkDesc fileSinkConf, String outputLocation, Map<Map<String, String>, String> customPartitionLocations, Seq<Attribute> partitionAttributes) {
        return SaveAsHiveFile.saveAsHiveFile$(this, sparkSession, plan, hadoopConf, fileSinkConf, outputLocation, customPartitionLocations, partitionAttributes);
    }

    @Override
    public Path getExternalTmpPath(SparkSession sparkSession, Configuration hadoopConf, Path path) {
        return SaveAsHiveFile.getExternalTmpPath$(this, sparkSession, hadoopConf, path);
    }

    @Override
    public void deleteExternalTmpPath(Configuration hadoopConf) {
        SaveAsHiveFile.deleteExternalTmpPath$(this, hadoopConf);
    }

    @Override
    public Map<Map<String, String>, String> saveAsHiveFile$default$6() {
        return SaveAsHiveFile.saveAsHiveFile$default$6$(this);
    }

    @Override
    public Seq<Attribute> saveAsHiveFile$default$7() {
        return SaveAsHiveFile.saveAsHiveFile$default$7$(this);
    }

    public final Seq<LogicalPlan> children() {
        return DataWritingCommand.children$((DataWritingCommand)this);
    }

    public Seq<Attribute> outputColumns() {
        return DataWritingCommand.outputColumns$((DataWritingCommand)this);
    }

    public BasicWriteJobStatsTracker basicWriteJobStatsTracker(Configuration hadoopConf) {
        return DataWritingCommand.basicWriteJobStatsTracker$((DataWritingCommand)this, (Configuration)hadoopConf);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    @Override
    public Option<Path> createdTempDir() {
        return this.createdTempDir;
    }

    @Override
    public void createdTempDir_$eq(Option<Path> x$1) {
        this.createdTempDir = x$1;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        InsertIntoHiveDirCommand insertIntoHiveDirCommand = this;
        synchronized (insertIntoHiveDirCommand) {
            if (!this.bitmap$0) {
                this.metrics = DataWritingCommand.metrics$((DataWritingCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public CatalogStorageFormat storage() {
        return this.storage;
    }

    public LogicalPlan query() {
        return this.query;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public Seq<String> outputColumnNames() {
        return this.outputColumnNames;
    }

    public Seq<Row> run(SparkSession sparkSession, SparkPlan child) {
        Path path;
        Predef$.MODULE$.assert(this.storage().locationUri().nonEmpty());
        SchemaUtils$.MODULE$.checkColumnNameDuplication(this.outputColumnNames(), new StringBuilder(20).append("when inserting into ").append(this.storage().locationUri().get()).toString(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        Table hiveTable = HiveClientImpl$.MODULE$.toHiveTable(new CatalogTable(new TableIdentifier(((URI)this.storage().locationUri().get()).toString(), (Option)new Some((Object)"default")), CatalogTableType$.MODULE$.VIEW(), this.storage(), package$.MODULE$.AttributeSeq(this.outputColumns()).toStructType(), CatalogTable$.MODULE$.apply$default$5(), CatalogTable$.MODULE$.apply$default$6(), CatalogTable$.MODULE$.apply$default$7(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19()), HiveClientImpl$.MODULE$.toHiveTable$default$2());
        hiveTable.getMetadata().put("serialization.lib", this.storage().serde().getOrElse((Function0 & Serializable & scala.Serializable)() -> LazySimpleSerDe.class.getName()));
        TableDesc tableDesc = new TableDesc(hiveTable.getInputFormatClass(), hiveTable.getOutputFormatClass(), hiveTable.getMetadata());
        Configuration hadoopConf = sparkSession.sessionState().newHadoopConf();
        JobConf jobConf = new JobConf(hadoopConf);
        Path targetPath = new Path((URI)this.storage().locationUri().get());
        if (this.isLocal()) {
            LocalFileSystem localFileSystem = FileSystem.getLocal((Configuration)jobConf);
            path = localFileSystem.makeQualified(targetPath);
        } else {
            Path qualifiedPath = FileUtils.makeQualified((Path)targetPath, (Configuration)hadoopConf);
            FileSystem dfs = qualifiedPath.getFileSystem((Configuration)jobConf);
            Object object = !dfs.exists(qualifiedPath) ? BoxesRunTime.boxToBoolean((boolean)dfs.mkdirs(qualifiedPath.getParent())) : BoxedUnit.UNIT;
            path = qualifiedPath;
        }
        Path writeToPath = path;
        Path tmpPath = this.getExternalTmpPath(sparkSession, hadoopConf, writeToPath);
        HiveShim.ShimFileSinkDesc fileSinkConf = new HiveShim.ShimFileSinkDesc(tmpPath.toString(), tableDesc, false);
        try {
            try {
                this.saveAsHiveFile(sparkSession, child, hadoopConf, fileSinkConf, tmpPath.toString(), this.saveAsHiveFile$default$6(), this.saveAsHiveFile$default$7());
                FileSystem fs = writeToPath.getFileSystem(hadoopConf);
                if (this.overwrite() && fs.exists(writeToPath)) {
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(writeToPath))).foreach((Function1 & Serializable & scala.Serializable)existFile -> {
                        Option option = Option$.MODULE$.apply((Object)existFile.getPath());
                        Option<Path> option2 = this.createdTempDir();
                        return (option == null ? option2 != null : !option.equals(option2)) ? BoxesRunTime.boxToBoolean((boolean)fs.delete(existFile.getPath(), true)) : BoxedUnit.UNIT;
                    });
                }
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(tmpPath))).foreach((Function1 & Serializable & scala.Serializable)tmpFile -> BoxesRunTime.boxToBoolean((boolean)fs.rename(tmpFile.getPath(), writeToPath)));
            }
            catch (Throwable e) {
                throw new SparkException(new StringBuilder(37).append("Failed inserting overwrite directory ").append(this.storage().locationUri().get()).toString(), e);
            }
        }
        finally {
            this.deleteExternalTmpPath(hadoopConf);
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    public InsertIntoHiveDirCommand copy(boolean isLocal, CatalogStorageFormat storage, LogicalPlan query, boolean overwrite, Seq<String> outputColumnNames) {
        return new InsertIntoHiveDirCommand(isLocal, storage, query, overwrite, outputColumnNames);
    }

    public boolean copy$default$1() {
        return this.isLocal();
    }

    public CatalogStorageFormat copy$default$2() {
        return this.storage();
    }

    public LogicalPlan copy$default$3() {
        return this.query();
    }

    public boolean copy$default$4() {
        return this.overwrite();
    }

    public Seq<String> copy$default$5() {
        return this.outputColumnNames();
    }

    public String productPrefix() {
        return "InsertIntoHiveDirCommand";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToBoolean((boolean)this.isLocal());
                break;
            }
            case 1: {
                object = this.storage();
                break;
            }
            case 2: {
                object = this.query();
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.overwrite());
                break;
            }
            case 4: {
                object = this.outputColumnNames();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof InsertIntoHiveDirCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof InsertIntoHiveDirCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        InsertIntoHiveDirCommand insertIntoHiveDirCommand = (InsertIntoHiveDirCommand)x$1;
        if (this.isLocal() != insertIntoHiveDirCommand.isLocal()) return false;
        CatalogStorageFormat catalogStorageFormat = this.storage();
        CatalogStorageFormat catalogStorageFormat2 = insertIntoHiveDirCommand.storage();
        if (catalogStorageFormat == null) {
            if (catalogStorageFormat2 != null) {
                return false;
            }
        } else if (!catalogStorageFormat.equals(catalogStorageFormat2)) return false;
        LogicalPlan logicalPlan = this.query();
        LogicalPlan logicalPlan2 = insertIntoHiveDirCommand.query();
        if (logicalPlan == null) {
            if (logicalPlan2 != null) {
                return false;
            }
        } else if (!logicalPlan.equals(logicalPlan2)) return false;
        if (this.overwrite() != insertIntoHiveDirCommand.overwrite()) return false;
        Seq<String> seq = this.outputColumnNames();
        Seq<String> seq2 = insertIntoHiveDirCommand.outputColumnNames();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!insertIntoHiveDirCommand.canEqual(this)) return false;
        return true;
    }

    public InsertIntoHiveDirCommand(boolean isLocal, CatalogStorageFormat storage, LogicalPlan query, boolean overwrite, Seq<String> outputColumnNames) {
        this.isLocal = isLocal;
        this.storage = storage;
        this.query = query;
        this.overwrite = overwrite;
        this.outputColumnNames = outputColumnNames;
        Command.$init$((Command)this);
        DataWritingCommand.$init$((DataWritingCommand)this);
        SaveAsHiveFile.$init$(this);
    }
}

