/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.PredictorParams$class;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0002\u0002-\u0011q\u0002\u0015:fI&\u001cG/[8o\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\t!!\u001c7\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019\t\u0007/Y2iK*\t\u0011\"A\u0002pe\u001e\u001c\u0001!F\u0002\r=M\u00192\u0001A\u0007%!\rqq\"E\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0006\u001b>$W\r\u001c\t\u0003%Ma\u0001\u0001B\u0003\u0015\u0001\t\u0007QCA\u0001N#\t1B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002DA\u0004O_RD\u0017N\\4\u0011\t9\u0001Q$\u0005\t\u0003%y!Qa\b\u0001C\u0002\u0001\u0012ABR3biV\u0014Xm\u001d+za\u0016\f\"AF\u0011\u0011\u0005]\u0011\u0013BA\u0012\u0019\u0005\r\te.\u001f\t\u0003\u001d\u0015J!A\n\u0002\u0003\u001fA\u0013X\rZ5di>\u0014\b+\u0019:b[NDQ\u0001\u000b\u0001\u0005\u0002%\na\u0001P5oSRtD#\u0001\u000f\t\u000b-\u0002A\u0011\u0001\u0017\u0002\u001dM,GOR3biV\u0014Xm]\"pYR\u0011\u0011#\f\u0005\u0006])\u0002\raL\u0001\u0006m\u0006dW/\u001a\t\u0003aMr!aF\u0019\n\u0005IB\u0012A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!A\r\r\t\u000b]\u0002A\u0011\u0001\u001d\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGCA\t:\u0011\u0015qc\u00071\u00010\u0011\u0015Y\u0004\u0001\"\u0001=\u0003-qW/\u001c$fCR,(/Z:\u0016\u0003u\u0002\"a\u0006 \n\u0005}B\"aA%oi\"\u001a!(Q$\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0011AC1o]>$\u0018\r^5p]&\u0011ai\u0011\u0002\u0006'&t7-Z\u0011\u0002\u0011\u0006)\u0011G\f\u001c/a!)!\n\u0001C\t\u0017\u0006\u0001b-Z1ukJ,7\u000fR1uCRK\b/Z\u000b\u0002\u0019B\u0011QJU\u0007\u0002\u001d*\u0011q\nU\u0001\u0006if\u0004Xm\u001d\u0006\u0003#\u0012\t1a]9m\u0013\t\u0019fJ\u0001\u0005ECR\fG+\u001f9f\u0011\u0015)\u0006\u0001\"\u0011W\u0003=!(/\u00198tM>\u0014XnU2iK6\fGCA,[!\ti\u0005,\u0003\u0002Z\u001d\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000bm#\u0006\u0019A,\u0002\rM\u001c\u0007.Z7b\u0011\u0015i\u0006\u0001\"\u0011_\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0002`GB\u0011\u0001-Y\u0007\u0002!&\u0011!\r\u0015\u0002\n\t\u0006$\u0018M\u0012:b[\u0016DQ\u0001\u001a/A\u0002}\u000bq\u0001Z1uCN,G\u000fC\u0003g\u0001\u0011Eq-A\u0007ue\u0006t7OZ8s[&k\u0007\u000f\u001c\u000b\u0003?\"DQ\u0001Z3A\u0002}CQA\u001b\u0001\u0007\u0012-\fq\u0001\u001d:fI&\u001cG\u000f\u0006\u0002m_B\u0011q#\\\u0005\u0003]b\u0011a\u0001R8vE2,\u0007\"\u00029j\u0001\u0004i\u0012\u0001\u00034fCR,(/Z:)\u0005\u0001\u0011\bC\u0001\"t\u0013\t!8I\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000e")
public abstract class PredictionModel<FeaturesType, M extends PredictionModel<FeaturesType, M>>
extends Model<M>
implements PredictorParams {
    private final Param<String> predictionCol;
    private final Param<String> featuresCol;
    private final Param<String> labelCol;

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    public M setFeaturesCol(String value) {
        return (M)((PredictionModel)this.set(this.featuresCol(), value));
    }

    public M setPredictionCol(String value) {
        return (M)((PredictionModel)this.set(this.predictionCol(), value));
    }

    public int numFeatures() {
        return -1;
    }

    public DataType featuresDataType() {
        return new VectorUDT();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, false, this.featuresDataType());
    }

    @Override
    public DataFrame transform(DataFrame dataset) {
        DataFrame dataFrame;
        this.transformSchema(dataset.schema(), true);
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            dataFrame = this.transformImpl(dataset);
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PredictionModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Predictor.transform() was called as NOOP"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uid()}))).append((Object)" since no output columns were set.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            dataFrame = dataset;
        }
        return dataFrame;
    }

    public DataFrame transformImpl(DataFrame dataset) {
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PredictionModel $outer;

            public final double apply(Object features) {
                return this.$outer.predict(features);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    public abstract double predict(FeaturesType var1);

    public PredictionModel() {
        HasLabelCol$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        PredictorParams$class.$init$(this);
    }
}

