/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.classification.GBTClassificationModel;
import org.apache.spark.ml.classification.GBTClassificationModel$;
import org.apache.spark.ml.classification.GBTClassifier$;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasStepSize$class;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTParams$class;
import org.apache.spark.ml.tree.TreeClassifierParams;
import org.apache.spark.ml.tree.TreeClassifierParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.LogLoss$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005Eh\u0001B\u0001\u0003\u00055\u0011Qb\u0012\"U\u00072\f7o]5gS\u0016\u0014(BA\u0002\u0005\u00039\u0019G.Y:tS\u001aL7-\u0019;j_:T!!\u0002\u0004\u0002\u00055d'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001AD\u0010&QA)q\u0002\u0005\n\u001b95\tA!\u0003\u0002\u0012\t\tI\u0001K]3eS\u000e$xN\u001d\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\ta\u0001\\5oC2<'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBC\u0001\u0004WK\u000e$xN\u001d\t\u00037\u0001i\u0011A\u0001\t\u00037uI!A\b\u0002\u0003-\u001d\u0013Ek\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001I\u0012\u000e\u0003\u0005R!A\t\u0003\u0002\tQ\u0014X-Z\u0005\u0003I\u0005\u0012\u0011b\u0012\"U!\u0006\u0014\u0018-\\:\u0011\u0005\u00012\u0013BA\u0014\"\u0005Q!&/Z3DY\u0006\u001c8/\u001b4jKJ\u0004\u0016M]1ngB\u0011\u0011FK\u0007\u0002\r%\u00111F\u0002\u0002\b\u0019><w-\u001b8h\u0011!i\u0003A!b\u0001\n\u0003r\u0013aA;jIV\tq\u0006\u0005\u00021m9\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\u00051\u0001K]3eK\u001aL!a\u000e\u001d\u0003\rM#(/\u001b8h\u0015\t)$\u0007K\u0002-u\u0001\u0003\"a\u000f \u000e\u0003qR!!\u0010\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002@y\t)1+\u001b8dK\u0006\n\u0011)A\u00032]Qr\u0003\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00030\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007\tS\u0004\tC\u0003G\u0001\u0011\u0005q)\u0001\u0004=S:LGO\u0010\u000b\u00035!CQ!L#A\u0002=B3\u0001\u0013\u001eAQ\r)%\b\u0011\u0005\u0006\r\u0002!\t\u0001\u0014\u000b\u00025!\u001a1J\u000f!\t\u000b=\u0003A\u0011\t)\u0002\u0017M,G/T1y\t\u0016\u0004H\u000f\u001b\u000b\u0003#Jk\u0011\u0001\u0001\u0005\u0006':\u0003\r\u0001V\u0001\u0006m\u0006dW/\u001a\t\u0003cUK!A\u0016\u001a\u0003\u0007%sG\u000fK\u0002Ou\u0001CQ!\u0017\u0001\u0005Bi\u000b!b]3u\u001b\u0006D()\u001b8t)\t\t6\fC\u0003T1\u0002\u0007A\u000bK\u0002Yu\u0001CQA\u0018\u0001\u0005B}\u000bac]3u\u001b&t\u0017J\\:uC:\u001cWm\u001d)fe:{G-\u001a\u000b\u0003#\u0002DQaU/A\u0002QC3!\u0018\u001eA\u0011\u0015\u0019\u0007\u0001\"\u0011e\u00039\u0019X\r^'j]&sgm\\$bS:$\"!U3\t\u000bM\u0013\u0007\u0019\u00014\u0011\u0005E:\u0017B\u000153\u0005\u0019!u.\u001e2mK\"\u001a!M\u000f!\t\u000b-\u0004A\u0011\t7\u0002!M,G/T1y\u001b\u0016lwN]=J]6\u0013ECA)n\u0011\u0015\u0019&\u000e1\u0001UQ\rQ'\b\u0011\u0005\u0006a\u0002!\t%]\u0001\u0010g\u0016$8)Y2iK:{G-Z%egR\u0011\u0011K\u001d\u0005\u0006'>\u0004\ra\u001d\t\u0003cQL!!\u001e\u001a\u0003\u000f\t{w\u000e\\3b]\"\u001aqN\u000f!\t\u000ba\u0004A\u0011I=\u0002+M,Go\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYR\u0011\u0011K\u001f\u0005\u0006'^\u0004\r\u0001\u0016\u0015\u0004oj\u0002\u0005\"B?\u0001\t\u0003r\u0018aC:fi&k\u0007/\u001e:jif$\"!U@\t\u000bMc\b\u0019A\u0018)\u0007qT\u0004\tC\u0004\u0002\u0006\u0001!\t%a\u0002\u0002%M,GoU;cg\u0006l\u0007\u000f\\5oOJ\u000bG/\u001a\u000b\u0004#\u0006%\u0001BB*\u0002\u0004\u0001\u0007a\r\u000b\u0003\u0002\u0004i\u0002\u0005bBA\b\u0001\u0011\u0005\u0013\u0011C\u0001\bg\u0016$8+Z3e)\r\t\u00161\u0003\u0005\b'\u00065\u0001\u0019AA\u000b!\r\t\u0014qC\u0005\u0004\u00033\u0011$\u0001\u0002'p]\u001eDC!!\u0004;\u0001\"9\u0011q\u0004\u0001\u0005B\u0005\u0005\u0012AC:fi6\u000b\u00070\u0013;feR\u0019\u0011+a\t\t\rM\u000bi\u00021\u0001UQ\u0011\tiB\u000f!\t\u000f\u0005%\u0002\u0001\"\u0011\u0002,\u0005Y1/\u001a;Ti\u0016\u00048+\u001b>f)\r\t\u0016Q\u0006\u0005\u0007'\u0006\u001d\u0002\u0019\u00014)\t\u0005\u001d\"\b\u0011\u0005\n\u0003g\u0001!\u0019!C\u0001\u0003k\t\u0001\u0002\\8tgRK\b/Z\u000b\u0003\u0003o\u0001R!!\u000f\u0002@=j!!a\u000f\u000b\u0007\u0005uB!A\u0003qCJ\fW.\u0003\u0003\u0002B\u0005m\"!\u0002)be\u0006l\u0007\u0006BA\u0019u\u0001C\u0001\"a\u0012\u0001A\u0003%\u0011qG\u0001\nY>\u001c8\u000fV=qK\u0002BC!!\u0012;\u0001\"9\u0011Q\n\u0001\u0005\u0002\u0005=\u0013aC:fi2{7o\u001d+za\u0016$2!UA)\u0011\u0019\u0019\u00161\na\u0001_!\"\u00111\n\u001eA\u0011\u0019\t9\u0006\u0001C\u0001]\u0005Yq-\u001a;M_N\u001cH+\u001f9fQ\u0011\t)F\u000f!\t\u0011\u0005u\u0003\u0001\"\u0011\u0005\u0003?\nabZ3u\u001f2$Gj\\:t)f\u0004X-\u0006\u0002\u0002bA!\u00111MA6\u001b\t\t)G\u0003\u0003\u0002h\u0005%\u0014\u0001\u00027pgNT!A\t\f\n\t\u00055\u0014Q\r\u0002\u0005\u0019>\u001c8\u000fC\u0004\u0002r\u0001!\t&a\u001d\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0007q\t)\b\u0003\u0005\u0002x\u0005=\u0004\u0019AA=\u0003\u001d!\u0017\r^1tKR\u0004B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007f2\u0011aA:rY&!\u00111QA?\u0005%!\u0015\r^1Ge\u0006lW\rC\u0004\u0002\b\u0002!\t%!#\u0002\t\r|\u0007/\u001f\u000b\u00045\u0005-\u0005\u0002CAG\u0003\u000b\u0003\r!a$\u0002\u000b\u0015DHO]1\u0011\t\u0005e\u0012\u0011S\u0005\u0005\u0003'\u000bYD\u0001\u0005QCJ\fW.T1qQ\u0015\t)IOALC\t\tI*A\u00032]Qr\u0013\u0007K\u0002\u0001\u0003;\u00032aOAP\u0013\r\t\t\u000b\u0010\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0004\u0001i\u0002uaBAT\u0005!\u0005\u0011\u0011V\u0001\u000e\u000f\n#6\t\\1tg&4\u0017.\u001a:\u0011\u0007m\tYK\u0002\u0004\u0002\u0005!\u0005\u0011QV\n\u0007\u0003W\u000by+!.\u0011\u0007E\n\t,C\u0002\u00024J\u0012a!\u00118z%\u00164\u0007cA\u0019\u00028&\u0019\u0011\u0011\u0018\u001a\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000f\u0019\u000bY\u000b\"\u0001\u0002>R\u0011\u0011\u0011\u0016\u0005\u000b\u0003\u0003\fYK1A\u0005\u0006\u0005\r\u0017AE:vaB|'\u000f^3e\u0019>\u001c8\u000fV=qKN,\"!!2\u0011\tE\n9mL\u0005\u0004\u0003\u0013\u0014$!B!se\u0006L\b\u0006BA`u\u0001C\u0011\"a4\u0002,\u0002\u0006i!!2\u0002'M,\b\u000f]8si\u0016$Gj\\:t)f\u0004Xm\u001d\u0011)\t\u00055'\b\u0011\u0005\u000b\u0003+\fY+!A\u0005\n\u0005]\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!7\u0011\t\u0005m\u0017Q]\u0007\u0003\u0003;TA!a8\u0002b\u0006!A.\u00198h\u0015\t\t\u0019/\u0001\u0003kCZ\f\u0017\u0002BAt\u0003;\u0014aa\u00142kK\u000e$\b\u0006BAV\u0003;CC!a+;\u0001\"\"\u0011QUAOQ\u0011\t)K\u000f!")
public final class GBTClassifier
extends Predictor<Vector, GBTClassifier, GBTClassificationModel>
implements GBTParams,
TreeClassifierParams {
    private final String uid;
    private final Param<String> lossType;
    private final Param<String> impurity;
    private final DoubleParam stepSize;
    private final IntParam maxIter;
    private final DoubleParam subsamplingRate;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static String[] supportedLossTypes() {
        return GBTClassifier$.MODULE$.supportedLossTypes();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeClassifierParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeClassifierParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeClassifierParams$class.getOldImpurity(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public void validateParams() {
        GBTParams$class.validateParams(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final double getStepSize() {
        return HasStepSize$class.getStepSize(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public GBTClassifier setMaxDepth(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public GBTClassifier setMaxBins(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public GBTClassifier setMinInstancesPerNode(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public GBTClassifier setMinInfoGain(double value) {
        return (GBTClassifier)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public GBTClassifier setMaxMemoryInMB(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public GBTClassifier setCacheNodeIds(boolean value) {
        return (GBTClassifier)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public GBTClassifier setCheckpointInterval(int value) {
        return (GBTClassifier)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public GBTClassifier setImpurity(String value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "GBTClassifier.setImpurity should NOT be used";
            }
        });
        return this;
    }

    @Override
    public GBTClassifier setSubsamplingRate(double value) {
        return (GBTClassifier)TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public GBTClassifier setSeed(long value) {
        this.logWarning((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "The 'seed' parameter is currently ignored by Gradient Boosting.";
            }
        });
        return (GBTClassifier)DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public GBTClassifier setMaxIter(int value) {
        return (GBTClassifier)GBTParams$class.setMaxIter(this, value);
    }

    @Override
    public GBTClassifier setStepSize(double value) {
        return (GBTClassifier)GBTParams$class.setStepSize(this, value);
    }

    public Param<String> lossType() {
        return this.lossType;
    }

    public GBTClassifier setLossType(String value) {
        return (GBTClassifier)this.set(this.lossType(), value);
    }

    public String getLossType() {
        return this.$(this.lossType()).toLowerCase();
    }

    @Override
    public Loss getOldLossType() {
        String string = this.getLossType();
        if ("logistic".equals(string)) {
            LogLoss$ logLoss$ = LogLoss$.MODULE$;
            return logLoss$;
        }
        throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTClassifier was given bad loss type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getLossType()})));
    }

    @Override
    public GBTClassificationModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
        if (option instanceof Some) {
            Some some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.x());
            int n2 = n;
            int n3 = n2;
            int numClasses = n3;
            Predef$.MODULE$.require(numClasses == 2, (Function0)new Serializable(this, numClasses){
                public static final long serialVersionUID = 0L;
                private final int numClasses$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GBTClassifier only supports binary classification but was given numClasses = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numClasses$1)}));
                }
                {
                    this.numClasses$1 = numClasses$1;
                }
            });
            RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
            int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
            BoostingStrategy boostingStrategy = GBTParams$class.getOldBoostingStrategy(this, categoricalFeatures, Algo$.MODULE$.Classification());
            GradientBoostedTrees oldGBT = new GradientBoostedTrees(boostingStrategy);
            GradientBoostedTreesModel oldModel = oldGBT.run(oldDataset);
            return GBTClassificationModel$.MODULE$.fromOld(oldModel, this, categoricalFeatures, numFeatures);
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"GBTClassifier was given input").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with invalid label column ", ", without the number of classes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.labelCol())}))).append((Object)" specified. See StringIndexer.").toString());
        }
        throw new MatchError(option);
    }

    @Override
    public GBTClassifier copy(ParamMap extra) {
        return (GBTClassifier)this.defaultCopy(extra);
    }

    public GBTClassifier(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasStepSize$class.$init$(this);
        GBTParams$class.$init$(this);
        TreeClassifierParams$class.$init$(this);
        this.lossType = new Param(this, "lossType", new StringBuilder().append((Object)"Loss function which GBT tries to minimize (case-insensitive). Supported options:").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])GBTClassifier$.MODULE$.supportedLossTypes()).mkString(", ")}))).toString(), new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String value) {
                return Predef$.MODULE$.refArrayOps((Object[])GBTClassifier$.MODULE$.supportedLossTypes()).contains((Object)value.toLowerCase());
            }
        });
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.lossType().$minus$greater("logistic")}));
    }

    public GBTClassifier() {
        this(Identifiable$.MODULE$.randomUID("gbtc"));
    }
}

