/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator$;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasLabelCol$class;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u00015\u0011\u0011%T;mi&\u001cG.Y:t\u00072\f7o]5gS\u000e\fG/[8o\u000bZ\fG.^1u_JT!a\u0001\u0003\u0002\u0015\u00154\u0018\r\\;bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011#\u0002\u0001\u000f%ii\u0002CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u0005%)e/\u00197vCR|'\u000f\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u000511\u000f[1sK\u0012T!a\u0006\u0003\u0002\u000bA\f'/Y7\n\u0005e!\"\u0001\u0005%bgB\u0013X\rZ5di&|gnQ8m!\t\u00192$\u0003\u0002\u001d)\tY\u0001*Y:MC\n,GnQ8m!\tq\u0012%D\u0001 \u0015\t\u0001C!\u0001\u0003vi&d\u0017B\u0001\u0012 \u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016D\u0001\u0002\n\u0001\u0003\u0006\u0004%\t%J\u0001\u0004k&$W#\u0001\u0014\u0011\u0005\u001djcB\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J\u0013A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u0015)\u0007\r\nt\u0007\u0005\u00023k5\t1G\u0003\u00025\r\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Y\u001a$!B*j]\u000e,\u0017%\u0001\u001d\u0002\u000bErSG\f\u0019\t\u0011i\u0002!\u0011!Q\u0001\n\u0019\nA!^5eA!\u001a\u0011(M\u001c\t\u000bu\u0002A\u0011\u0001 \u0002\rqJg.\u001b;?)\ty\u0004\t\u0005\u0002\u0010\u0001!)A\u0005\u0010a\u0001M!\u001a\u0001)M\u001c)\u0007q\nt\u0007C\u0003>\u0001\u0011\u0005A\tF\u0001@Q\r\u0019\u0015g\u000e\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003)iW\r\u001e:jG:\u000bW.Z\u000b\u0002\u0013B\u0019!j\u0013\u0014\u000e\u0003YI!\u0001\u0014\f\u0003\u000bA\u000b'/Y7)\u0007\u0019\u000bt\u0007\u0003\u0004P\u0001\u0001\u0006I!S\u0001\f[\u0016$(/[2OC6,\u0007\u0005K\u0002Oc]BQA\u0015\u0001\u0005\u0002\u0015\nQbZ3u\u001b\u0016$(/[2OC6,\u0007fA)2o!)Q\u000b\u0001C\u0001-\u0006i1/\u001a;NKR\u0014\u0018n\u0019(b[\u0016$\"a\u0016-\u000e\u0003\u0001AQ!\u0017+A\u0002\u0019\nQA^1mk\u0016D3\u0001V\u00198\u0011\u0015a\u0006\u0001\"\u0001^\u0003A\u0019X\r\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002X=\")\u0011l\u0017a\u0001M!\u001a1,M\u001c\t\u000b\u0005\u0004A\u0011\u00012\u0002\u0017M,G\u000fT1cK2\u001cu\u000e\u001c\u000b\u0003/\u000eDQ!\u00171A\u0002\u0019B3\u0001Y\u00198\u0011\u00151\u0007\u0001\"\u0011h\u0003!)g/\u00197vCR,GC\u00015l!\tA\u0013.\u0003\u0002kS\t1Ai\\;cY\u0016DQ\u0001\\3A\u00025\fq\u0001Z1uCN,G\u000f\u0005\u0002oc6\tqN\u0003\u0002q\r\u0005\u00191/\u001d7\n\u0005I|'!\u0003#bi\u00064%/Y7fQ\r)\u0017g\u000e\u0005\u0006k\u0002!\tE^\u0001\u000fSNd\u0015M]4fe\n+G\u000f^3s+\u00059\bC\u0001\u0015y\u0013\tI\u0018FA\u0004C_>dW-\u00198)\u0007Q\ft\u0007C\u0003}\u0001\u0011\u0005S0\u0001\u0003d_BLHCA \u007f\u0011\u0019y8\u00101\u0001\u0002\u0002\u0005)Q\r\u001f;sCB\u0019!*a\u0001\n\u0007\u0005\u0015aC\u0001\u0005QCJ\fW.T1qQ\rY\u0018g\u000e\u0015\u0004\u0001\u0005-\u0001c\u0001\u001a\u0002\u000e%\u0019\u0011qB\u001a\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197)\u0007\u0001\ttgB\u0004\u0002\u0016\tA\t!a\u0006\u0002C5+H\u000e^5dY\u0006\u001c8o\u00117bgNLg-[2bi&|g.\u0012<bYV\fGo\u001c:\u0011\u0007=\tIB\u0002\u0004\u0002\u0005!\u0005\u00111D\n\t\u00033\ti\"a\t\u0002*A\u0019\u0001&a\b\n\u0007\u0005\u0005\u0012F\u0001\u0004B]f\u0014VM\u001a\t\u0005=\u0005\u0015r(C\u0002\u0002(}\u0011Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\rE\u0002)\u0003WI1!!\f*\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001di\u0014\u0011\u0004C\u0001\u0003c!\"!a\u0006\t\u0011\u0005U\u0012\u0011\u0004C!\u0003o\tA\u0001\\8bIR\u0019q(!\u000f\t\u000f\u0005m\u00121\u0007a\u0001M\u0005!\u0001/\u0019;iQ\u0015\t\u0019$MA C\t\t\t%A\u00032]Yr\u0003\u0007\u0003\u0006\u0002F\u0005e\u0011\u0011!C\u0005\u0003\u000f\n1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0013\u0001\u00026bm\u0006LA!a\u0016\u0002N\t1qJ\u00196fGRDS!!\u00072\u0003\u007fAS!a\u00052\u0003\u007f\u0001")
public class MulticlassClassificationEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MLReader<MulticlassClassificationEvaluator> read() {
        return MulticlassClassificationEvaluator$.MODULE$.read();
    }

    public static MulticlassClassificationEvaluator load(String string) {
        return MulticlassClassificationEvaluator$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol$class.getLabelCol(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public MulticlassClassificationEvaluator setMetricName(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.metricName(), value);
    }

    public MulticlassClassificationEvaluator setPredictionCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.predictionCol(), value);
    }

    public MulticlassClassificationEvaluator setLabelCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(DataFrame dataset) {
        String string;
        block7: {
            double d;
            block3: {
                MulticlassMetrics metrics;
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                StructType schema = dataset.schema();
                                SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
                                SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.labelCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
                                RDD predictionAndLabels = dataset.select(this.$(this.predictionCol()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.$(this.labelCol())})).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Tuple2<Object, Object> apply(Row x0$1) {
                                        Row row = x0$1;
                                        Some some = Row$.MODULE$.unapplySeq(row);
                                        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                                            Object prediction = ((SeqLike)some.get()).apply(0);
                                            Object label = ((SeqLike)some.get()).apply(1);
                                            if (prediction instanceof Double) {
                                                double d = BoxesRunTime.unboxToDouble((Object)prediction);
                                                if (label instanceof Double) {
                                                    double d2 = BoxesRunTime.unboxToDouble((Object)label);
                                                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(d, d2);
                                                    return sp2;
                                                }
                                            }
                                        }
                                        throw new MatchError((Object)row);
                                    }
                                }, ClassTag$.MODULE$.apply(Tuple2.class));
                                metrics = new MulticlassMetrics((RDD<Tuple2<Object, Object>>)predictionAndLabels);
                                string = this.$(this.metricName());
                                if (!"f1".equals(string)) break block2;
                                d = metrics.weightedFMeasure();
                                break block3;
                            }
                            if (!"precision".equals(string)) break block4;
                            d = metrics.precision();
                            break block3;
                        }
                        if (!"recall".equals(string)) break block5;
                        d = metrics.recall();
                        break block3;
                    }
                    if (!"weightedPrecision".equals(string)) break block6;
                    d = metrics.weightedPrecision();
                    break block3;
                }
                if (!"weightedRecall".equals(string)) break block7;
                d = metrics.weightedRecall();
            }
            double metric = d;
            return metric;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public boolean isLargerBetter() {
        String string;
        block7: {
            boolean bl;
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                string = this.$(this.metricName());
                                if (!"f1".equals(string)) break block2;
                                bl = true;
                                break block3;
                            }
                            if (!"precision".equals(string)) break block4;
                            bl = true;
                            break block3;
                        }
                        if (!"recall".equals(string)) break block5;
                        bl = true;
                        break block3;
                    }
                    if (!"weightedPrecision".equals(string)) break block6;
                    bl = true;
                    break block3;
                }
                if (!"weightedRecall".equals(string)) break block7;
                bl = true;
            }
            return bl;
        }
        throw new MatchError((Object)string);
    }

    @Override
    public MulticlassClassificationEvaluator copy(ParamMap extra) {
        return (MulticlassClassificationEvaluator)this.defaultCopy(extra);
    }

    public MulticlassClassificationEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol$class.$init$(this);
        HasLabelCol$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"f1", "precision", "recall", "weightedPrecision", "weightedRecall"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (f1|precision|recall|weightedPrecision|weightedRecall)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("f1")}));
    }

    public MulticlassClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("mcEval"));
    }
}

