/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressor$;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams$class;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.RandomForestParams$class;
import org.apache.spark.ml.tree.TreeEnsembleParams$class;
import org.apache.spark.ml.tree.TreeRegressorParams;
import org.apache.spark.ml.tree.TreeRegressorParams$class;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Array$;
import scala.Enumeration;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005ef\u0001B\u0001\u0003\u00055\u0011QCU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgN|'O\u0003\u0002\u0004\t\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019yR\u0005E\u0003\u0010!IQB$D\u0001\u0005\u0013\t\tBAA\u0005Qe\u0016$\u0017n\u0019;peB\u00111\u0003G\u0007\u0002))\u0011QCF\u0001\u0007Y&t\u0017\r\\4\u000b\u0005]1\u0011!B7mY&\u0014\u0017BA\r\u0015\u0005\u00191Vm\u0019;peB\u00111\u0004A\u0007\u0002\u0005A\u00111$H\u0005\u0003=\t\u00111DU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0005\u0003\u0011!(/Z3\n\u0005\u0011\n#A\u0005*b]\u0012|WNR8sKN$\b+\u0019:b[N\u0004\"\u0001\t\u0014\n\u0005\u001d\n#a\u0005+sK\u0016\u0014Vm\u001a:fgN|'\u000fU1sC6\u001c\b\u0002C\u0015\u0001\u0005\u000b\u0007I\u0011\t\u0016\u0002\u0007ULG-F\u0001,!\ta#G\u0004\u0002.a5\taFC\u00010\u0003\u0015\u00198-\u00197b\u0013\t\td&\u0001\u0004Qe\u0016$WMZ\u0005\u0003gQ\u0012aa\u0015;sS:<'BA\u0019/Q\rAc\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0003s\u0019\t!\"\u00198o_R\fG/[8o\u0013\tY\u0004HA\u0003TS:\u001cW-I\u0001>\u0003\u0015\td\u0006\u000e\u00181\u0011!y\u0004A!A!\u0002\u0013Y\u0013\u0001B;jI\u0002B3A\u0010\u001c=\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0003\u0019a\u0014N\\5u}Q\u0011!\u0004\u0012\u0005\u0006S\u0005\u0003\ra\u000b\u0015\u0004\tZb\u0004fA!7y!)!\t\u0001C\u0001\u0011R\t!\u0004K\u0002HmqBQa\u0013\u0001\u0005B1\u000b1b]3u\u001b\u0006DH)\u001a9uQR\u0011QJT\u0007\u0002\u0001!)qJ\u0013a\u0001!\u0006)a/\u00197vKB\u0011Q&U\u0005\u0003%:\u00121!\u00138uQ\rQe\u0007\u0010\u0005\u0006+\u0002!\tEV\u0001\u000bg\u0016$X*\u0019=CS:\u001cHCA'X\u0011\u0015yE\u000b1\u0001QQ\r!f\u0007\u0010\u0005\u00065\u0002!\teW\u0001\u0017g\u0016$X*\u001b8J]N$\u0018M\\2fgB+'OT8eKR\u0011Q\n\u0018\u0005\u0006\u001ff\u0003\r\u0001\u0015\u0015\u00043Zb\u0004\"B0\u0001\t\u0003\u0002\u0017AD:fi6Kg.\u00138g_\u001e\u000b\u0017N\u001c\u000b\u0003\u001b\u0006DQa\u00140A\u0002\t\u0004\"!L2\n\u0005\u0011t#A\u0002#pk\ndW\rK\u0002_mqBQa\u001a\u0001\u0005B!\f\u0001c]3u\u001b\u0006DX*Z7pefLe.\u0014\"\u0015\u00055K\u0007\"B(g\u0001\u0004\u0001\u0006f\u000147y!)A\u000e\u0001C![\u0006y1/\u001a;DC\u000eDWMT8eK&#7\u000f\u0006\u0002N]\")qj\u001ba\u0001_B\u0011Q\u0006]\u0005\u0003c:\u0012qAQ8pY\u0016\fg\u000eK\u0002lmqBQ\u0001\u001e\u0001\u0005BU\fQc]3u\u0007\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\u0006\u0002Nm\")qj\u001da\u0001!\"\u001a1O\u000e\u001f\t\u000be\u0004A\u0011\t>\u0002\u0017M,G/S7qkJLG/\u001f\u000b\u0003\u001bnDQa\u0014=A\u0002-B3\u0001\u001f\u001c=\u0011\u0015q\b\u0001\"\u0011\u0000\u0003I\u0019X\r^*vEN\fW\u000e\u001d7j]\u001e\u0014\u0016\r^3\u0015\u00075\u000b\t\u0001C\u0003P{\u0002\u0007!\rK\u0002~mqBq!a\u0002\u0001\t\u0003\nI!A\u0004tKR\u001cV-\u001a3\u0015\u00075\u000bY\u0001C\u0004P\u0003\u000b\u0001\r!!\u0004\u0011\u00075\ny!C\u0002\u0002\u00129\u0012A\u0001T8oO\"\"\u0011Q\u0001\u001c=\u0011\u001d\t9\u0002\u0001C!\u00033\t1b]3u\u001dVlGK]3fgR\u0019Q*a\u0007\t\r=\u000b)\u00021\u0001QQ\u0011\t)B\u000e\u001f\t\u000f\u0005\u0005\u0002\u0001\"\u0011\u0002$\u0005A2/\u001a;GK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ=\u0015\u00075\u000b)\u0003\u0003\u0004P\u0003?\u0001\ra\u000b\u0015\u0005\u0003?1D\bC\u0004\u0002,\u0001!\t&!\f\u0002\u000bQ\u0014\u0018-\u001b8\u0015\u0007q\ty\u0003\u0003\u0005\u00022\u0005%\u0002\u0019AA\u001a\u0003\u001d!\u0017\r^1tKR\u0004B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s1\u0011aA:rY&!\u0011QHA\u001c\u0005%!\u0015\r^1Ge\u0006lW\rC\u0004\u0002B\u0001!\t%a\u0011\u0002\t\r|\u0007/\u001f\u000b\u00045\u0005\u0015\u0003\u0002CA$\u0003\u007f\u0001\r!!\u0013\u0002\u000b\u0015DHO]1\u0011\t\u0005-\u0013\u0011K\u0007\u0003\u0003\u001bR1!a\u0014\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\t\u0019&!\u0014\u0003\u0011A\u000b'/Y7NCBDC!a\u00107y!\u001a\u0001!!\u0017\u0011\u0007]\nY&C\u0002\u0002^a\u0012A\"\u0012=qKJLW.\u001a8uC2D3\u0001\u0001\u001c=\u000f\u001d\t\u0019G\u0001E\u0001\u0003K\nQCU1oI>lgi\u001c:fgR\u0014Vm\u001a:fgN|'\u000fE\u0002\u001c\u0003O2a!\u0001\u0002\t\u0002\u0005%4CBA4\u0003W\n\t\bE\u0002.\u0003[J1!a\u001c/\u0005\u0019\te.\u001f*fMB\u0019Q&a\u001d\n\u0007\u0005UdF\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0004C\u0003O\"\t!!\u001f\u0015\u0005\u0005\u0015\u0004BCA?\u0003O\u0012\r\u0011\"\u0002\u0002\u0000\u0005\u00192/\u001e9q_J$X\rZ%naV\u0014\u0018\u000e^5fgV\u0011\u0011\u0011\u0011\t\u0005[\u0005\r5&C\u0002\u0002\u0006:\u0012Q!\u0011:sCfDC!a\u001f7y!I\u00111RA4A\u00035\u0011\u0011Q\u0001\u0015gV\u0004\bo\u001c:uK\u0012LU\u000e];sSRLWm\u001d\u0011)\t\u0005%e\u0007\u0010\u0005\u000b\u0003#\u000b9G1A\u0005\u0006\u0005}\u0014\u0001I:vaB|'\u000f^3e\r\u0016\fG/\u001e:f'V\u00147/\u001a;TiJ\fG/Z4jKNDC!a$7y!I\u0011qSA4A\u00035\u0011\u0011Q\u0001\"gV\u0004\bo\u001c:uK\u00124U-\u0019;ve\u0016\u001cVOY:fiN#(/\u0019;fO&,7\u000f\t\u0015\u0005\u0003+3D\b\u0003\u0006\u0002\u001e\u0006\u001d\u0014\u0011!C\u0005\u0003?\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0015\t\u0005\u0003G\u000bi+\u0004\u0002\u0002&*!\u0011qUAU\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0016\u0001\u00026bm\u0006LA!a,\u0002&\n1qJ\u00196fGRDC!a\u001a\u0002Z!\"\u0011q\r\u001c=Q\u0011\t\t'!\u0017)\t\u0005\u0005d\u0007\u0010")
public final class RandomForestRegressor
extends Predictor<Vector, RandomForestRegressor, RandomForestRegressionModel>
implements RandomForestParams,
TreeRegressorParams {
    private final String uid;
    private final Param<String> impurity;
    private final IntParam numTrees;
    private final Param<String> featureSubsetStrategy;
    private final DoubleParam subsamplingRate;
    private final IntParam maxDepth;
    private final IntParam maxBins;
    private final IntParam minInstancesPerNode;
    private final DoubleParam minInfoGain;
    private final IntParam maxMemoryInMB;
    private final BooleanParam cacheNodeIds;
    private final LongParam seed;
    private final IntParam checkpointInterval;

    public static String[] supportedFeatureSubsetStrategies() {
        return RandomForestRegressor$.MODULE$.supportedFeatureSubsetStrategies();
    }

    public static String[] supportedImpurities() {
        return RandomForestRegressor$.MODULE$.supportedImpurities();
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeRegressorParams$_setter_$impurity_$eq(Param x$1) {
        this.impurity = x$1;
    }

    @Override
    public final String getImpurity() {
        return TreeRegressorParams$class.getImpurity(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return TreeRegressorParams$class.getOldImpurity(this);
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$featureSubsetStrategy_$eq(Param x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams$class.getNumTrees(this);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return RandomForestParams$class.getFeatureSubsetStrategy(this);
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams$class.getSubsamplingRate(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams$class.getMaxDepth(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams$class.getMaxBins(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams$class.getMinInstancesPerNode(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams$class.getMinInfoGain(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams$class.getMaxMemoryInMB(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams$class.getCacheNodeIds(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams$class.getOldStrategy(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public RandomForestRegressor setMaxDepth(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMaxDepth(this, value);
    }

    @Override
    public RandomForestRegressor setMaxBins(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMaxBins(this, value);
    }

    @Override
    public RandomForestRegressor setMinInstancesPerNode(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMinInstancesPerNode(this, value);
    }

    @Override
    public RandomForestRegressor setMinInfoGain(double value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMinInfoGain(this, value);
    }

    @Override
    public RandomForestRegressor setMaxMemoryInMB(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setMaxMemoryInMB(this, value);
    }

    @Override
    public RandomForestRegressor setCacheNodeIds(boolean value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setCacheNodeIds(this, value);
    }

    @Override
    public RandomForestRegressor setCheckpointInterval(int value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setCheckpointInterval(this, value);
    }

    @Override
    public RandomForestRegressor setImpurity(String value) {
        return (RandomForestRegressor)TreeRegressorParams$class.setImpurity(this, value);
    }

    @Override
    public RandomForestRegressor setSubsamplingRate(double value) {
        return (RandomForestRegressor)TreeEnsembleParams$class.setSubsamplingRate(this, value);
    }

    @Override
    public RandomForestRegressor setSeed(long value) {
        return (RandomForestRegressor)DecisionTreeParams$class.setSeed(this, value);
    }

    @Override
    public RandomForestRegressor setNumTrees(int value) {
        return (RandomForestRegressor)RandomForestParams$class.setNumTrees(this, value);
    }

    @Override
    public RandomForestRegressor setFeatureSubsetStrategy(String value) {
        return (RandomForestRegressor)RandomForestParams$class.setFeatureSubsetStrategy(this, value);
    }

    @Override
    public RandomForestRegressionModel train(DataFrame dataset) {
        Map<Object, Object> categoricalFeatures = MetadataUtils$.MODULE$.getCategoricalFeatures(dataset.schema().apply(this.$(this.featuresCol())));
        RDD<LabeledPoint> oldDataset = this.extractLabeledPoints(dataset);
        Strategy strategy = TreeEnsembleParams$class.getOldStrategy(this, categoricalFeatures, 0, Algo$.MODULE$.Regression(), this.getOldImpurity());
        DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.run(oldDataset, strategy, this.getNumTrees(), this.getFeatureSubsetStrategy(), this.getSeed(), RandomForest$.MODULE$.run$default$6())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DecisionTreeRegressionModel apply(DecisionTreeModel x$1) {
                return (DecisionTreeRegressionModel)x$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class)));
        int numFeatures = ((LabeledPoint)oldDataset.first()).features().size();
        return new RandomForestRegressionModel(trees, numFeatures);
    }

    @Override
    public RandomForestRegressor copy(ParamMap extra) {
        return (RandomForestRegressor)this.defaultCopy(extra);
    }

    public RandomForestRegressor(String uid) {
        this.uid = uid;
        HasCheckpointInterval$class.$init$(this);
        HasSeed$class.$init$(this);
        DecisionTreeParams$class.$init$(this);
        TreeEnsembleParams$class.$init$(this);
        RandomForestParams$class.$init$(this);
        TreeRegressorParams$class.$init$(this);
    }

    public RandomForestRegressor() {
        this(Identifiable$.MODULE$.randomUID("rfr"));
    }
}

