/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.recommendation;

import com.clearspring.analytics.stream.cardinality.HyperLogLogPlus;
import com.github.fommil.netlib.BLAS;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel$SaveLoadV1_0$;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u00015\u0011\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bsK\u000e|W.\\3oI\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\u000b\u001b;A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\tU$\u0018\u000e\\\u0005\u00033Y\u0011\u0001bU1wK\u0006\u0014G.\u001a\t\u0003\u001fmI!\u0001\b\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005yyR\"\u0001\u0004\n\u0005\u00012!a\u0002'pO\u001eLgn\u001a\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005!!/\u00198l+\u0005!\u0003CA\b&\u0013\t1\u0003CA\u0002J]RD3!\t\u0015/!\tIC&D\u0001+\u0015\tYc!\u0001\u0006b]:|G/\u0019;j_:L!!\f\u0016\u0003\u000bMKgnY3\"\u0003=\nQ\u0001\r\u00189]AB\u0001\"\r\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0006e\u0006t7\u000e\t\u0015\u0004a!r\u0003\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\u0002\u0019U\u001cXM\u001d$fCR,(/Z:\u0016\u0003Y\u00022a\u000e\u001e=\u001b\u0005A$BA\u001d\u0007\u0003\r\u0011H\rZ\u0005\u0003wa\u00121A\u0015#E!\u0011yQ\bJ \n\u0005y\u0002\"A\u0002+va2,'\u0007E\u0002\u0010\u0001\nK!!\u0011\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=\u0019\u0015B\u0001#\u0011\u0005\u0019!u.\u001e2mK\"\u001a1\u0007\u000b\u0018\t\u0011\u001d\u0003!\u0011!Q\u0001\nY\nQ\"^:fe\u001a+\u0017\r^;sKN\u0004\u0003f\u0001$)]!A!\n\u0001BC\u0002\u0013\u0005Q'A\bqe>$Wo\u0019;GK\u0006$XO]3tQ\rI\u0005F\f\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005m\u0005\u0001\u0002O]8ek\u000e$h)Z1ukJ,7\u000f\t\u0015\u0004\u0019\"r\u0003\"\u0002)\u0001\t\u0003\t\u0016A\u0002\u001fj]&$h\b\u0006\u0003S)ZC\u0006CA*\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012P\u0001\u0004!\u0003f\u0001+)]!)Ag\u0014a\u0001m!\u001aa\u000b\u000b\u0018\t\u000b){\u0005\u0019\u0001\u001c)\u0007aCc\u0006K\u0002PQ9BQ\u0001\u0018\u0001\u0005\nu\u000b\u0001C^1mS\u0012\fG/\u001a$fCR,(/Z:\u0015\u0007y\u000b'\u000e\u0005\u0002\u0010?&\u0011\u0001\r\u0005\u0002\u0005+:LG\u000fC\u0003c7\u0002\u00071-\u0001\u0003oC6,\u0007C\u00013h\u001d\tyQ-\u0003\u0002g!\u00051\u0001K]3eK\u001aL!\u0001[5\u0003\rM#(/\u001b8h\u0015\t1\u0007\u0003C\u0003l7\u0002\u0007a'\u0001\u0005gK\u0006$XO]3t\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u001d\u0001(/\u001a3jGR$2AQ8r\u0011\u0015\u0001H\u000e1\u0001%\u0003\u0011)8/\u001a:\t\u000bId\u0007\u0019\u0001\u0013\u0002\u000fA\u0014x\u000eZ;di\"\u001aA\u000e\u000b\u0018\t\rU\u0004\u0001\u0015\"\u0003w\u0003y\u0019w.\u001e8u\u0003B\u0004(o\u001c=ESN$\u0018N\\2u+N,'\u000f\u0015:pIV\u001cG\u000f\u0006\u0002xwB!q\"\u0010=y!\ty\u00110\u0003\u0002{!\t!Aj\u001c8h\u0011\u0015aH\u000f1\u0001~\u00035)8/\u001a:t!J|G-^2ugB\u0019qG\u000f@\u0011\t=iD\u0005\n\u0005\u0007[\u0002!\t!!\u0001\u0015\t\u0005\r\u00111\u0002\t\u0005oi\n)\u0001E\u0002T\u0003\u000fI1!!\u0003\u0003\u0005\u0019\u0011\u0016\r^5oO\")Ap a\u0001{\"\"q\u0010KA\bC\t\t\t\"A\u00031]er\u0003\u0007\u0003\u0004n\u0001\u0011\u0005\u0011Q\u0003\u000b\u0005\u0003/\t9\u0003\u0005\u0004\u0002\u001a\u0005\r\u0012QA\u0007\u0003\u00037QA!!\b\u0002 \u0005!!.\u0019<b\u0015\r\t\tCB\u0001\u0004CBL\u0017\u0002BA\u0013\u00037\u0011qAS1wCJ#E\tC\u0004}\u0003'\u0001\r!!\u000b\u0011\u0011\u0005e\u00111FA\u0018\u0003_IA!!\f\u0002\u001c\tY!*\u0019<b!\u0006L'O\u0015#E!\u0011\t\t$!\u000f\u000e\u0005\u0005M\"\u0002BA\u001b\u0003o\tA\u0001\\1oO*\u0011\u0011QD\u0005\u0005\u0003w\t\u0019DA\u0004J]R,w-\u001a:)\u000b\u0005M\u0001&a\u0010\"\u0005\u0005\u0005\u0013!B\u0019/e9\u0002\u0004bBA#\u0001\u0011\u0005\u0011qI\u0001\u0012e\u0016\u001cw.\\7f]\u0012\u0004&o\u001c3vGR\u001cHCBA%\u0003\u0017\ni\u0005\u0005\u0003\u0010\u0001\u0006\u0015\u0001B\u00029\u0002D\u0001\u0007A\u0005C\u0004\u0002P\u0005\r\u0003\u0019\u0001\u0013\u0002\u00079,X\u000eK\u0003\u0002D!\n\u0019&\t\u0002\u0002V\u0005)\u0011GL\u0019/a!9\u0011\u0011\f\u0001\u0005\u0002\u0005m\u0013A\u0004:fG>lW.\u001a8e+N,'o\u001d\u000b\u0007\u0003\u0013\ni&a\u0018\t\rI\f9\u00061\u0001%\u0011\u001d\ty%a\u0016A\u0002\u0011BS!a\u0016)\u0003'B\u0011\"!\u001a\u0001\u0005\u0004%\t&a\u001a\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o+\u0005\u0019\u0007bBA6\u0001\u0001\u0006IaY\u0001\u000fM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8!\u0011\u001d\ty\u0007\u0001C!\u0003c\nAa]1wKR)a,a\u001d\u0002~!A\u0011QOA7\u0001\u0004\t9(\u0001\u0002tGB\u0019a$!\u001f\n\u0007\u0005mdA\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH\u000fC\u0004\u0002\u0000\u00055\u0004\u0019A2\u0002\tA\fG\u000f\u001b\u0015\u0006\u0003[B\u00131Q\u0011\u0003\u0003\u000b\u000bQ!\r\u00184]ABq!!#\u0001\t\u0003\tY)A\rsK\u000e|W.\\3oIB\u0013x\u000eZ;diN4uN]+tKJ\u001cH\u0003BAG\u0003#\u0003Ba\u000e\u001e\u0002\u0010B)q\"\u0010\u0013\u0002J!9\u0011qJAD\u0001\u0004!\u0003&BADQ\u0005U\u0015EAAL\u0003\u0015\td\u0006\u000e\u00181\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000b\u0011D]3d_6lWM\u001c3Vg\u0016\u00148OR8s!J|G-^2ugR!\u0011QRAP\u0011\u001d\ty%!'A\u0002\u0011BS!!')\u0003+C3\u0001\u0001\u0015/\u000f\u001d\t9K\u0001E\u0001\u0003S\u000b\u0001$T1ue&Dh)Y2u_JL'0\u0019;j_:lu\u000eZ3m!\r\u0019\u00161\u0016\u0004\u0007\u0003\tA\t!!,\u0014\r\u0005-f\"a,\u001b!\u0011)\u0012\u0011\u0017*\n\u0007\u0005MfC\u0001\u0004M_\u0006$WM\u001d\u0005\b!\u0006-F\u0011AA\\)\t\tI\u000b\u0003\u0005\u0002<\u0006-F\u0011BA_\u0003%\u0011XmY8n[\u0016tG\r\u0006\u0005\u0002@\u0006\r\u0017qYAf!\u0011y\u0001)!1\u0011\t=iDE\u0011\u0005\b\u0003\u000b\fI\f1\u0001@\u0003M\u0011XmY8n[\u0016tG\rV8GK\u0006$XO]3t\u0011\u001d\tI-!/A\u0002Y\nQC]3d_6lWM\u001c3bE2,g)Z1ukJ,7\u000fC\u0004\u0002P\u0005e\u0006\u0019\u0001\u0013\t\u0011\u0005=\u00171\u0016C\u0005\u0003#\fqB]3d_6lWM\u001c3G_J\fE\u000e\u001c\u000b\u000b\u0003'\f9.!7\u0002^\u0006\u0005\b\u0003B\u001c;\u0003+\u0004RaD\u001f%\u0003\u007fCaAIAg\u0001\u0004!\u0003bBAn\u0003\u001b\u0004\rAN\u0001\fgJ\u001cg)Z1ukJ,7\u000fC\u0004\u0002`\u00065\u0007\u0019\u0001\u001c\u0002\u0017\u0011\u001cHOR3biV\u0014Xm\u001d\u0005\b\u0003\u001f\ni\r1\u0001%\u0011!\t)/a+\u0005\n\u0005\u001d\u0018\u0001\u00032m_\u000e\\\u0017NZ=\u0015\r\u0005%\u00181`A\u007f!\u00119$(a;\u0011\r=i\u0014Q^Ax!\ry\u0001\t\n\t\u0005\u0003c\f90\u0004\u0002\u0002t*\u0019\u0011Q\u001f\u0003\u0002\r1Lg.\u00197h\u0013\u0011\tI0a=\u0003\u0017\u0011+gn]3NCR\u0014\u0018\u000e\u001f\u0005\u0007E\u0005\r\b\u0019\u0001\u0013\t\r-\f\u0019\u000f1\u00017\u0011!\u0011\t!a+\u0005B\t\r\u0011\u0001\u00027pC\u0012$RA\u0015B\u0003\u0005\u000fA\u0001\"!\u001e\u0002\u0000\u0002\u0007\u0011q\u000f\u0005\b\u0003\u007f\ny\u00101\u0001dQ\u0015\ty\u0010KAB\u000f%\u0011i!a+\t\u0002\t\u0011y!\u0001\u0007TCZ,Gj\\1e-Fz\u0006\u0007\u0005\u0003\u0003\u0012\tMQBAAV\r%\u0011)\"a+\t\u0002\t\u00119B\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0003\u00149Aq\u0001\u0015B\n\t\u0003\u0011Y\u0002\u0006\u0002\u0003\u0010!Q!q\u0004B\n\u0005\u0004%IA!\t\u0002#QD\u0017n\u001d$pe6\fGOV3sg&|g.\u0006\u0002\u0003$A!\u0011\u0011\u0007B\u0013\u0013\rA\u00171\u0007\u0005\n\u0005S\u0011\u0019\u0002)A\u0005\u0005G\t!\u0003\u001e5jg\u001a{'/\\1u-\u0016\u00148/[8oA!Y!Q\u0006B\n\u0005\u0004%\tA\u0001B\u0011\u00035!\b.[:DY\u0006\u001c8OT1nK\"I!\u0011\u0007B\nA\u0003%!1E\u0001\u000fi\"L7o\u00117bgNt\u0015-\\3!\u0011!\tyGa\u0005\u0005\u0002\tUB#\u00020\u00038\tm\u0002b\u0002B\u001d\u0005g\u0001\rAU\u0001\u0006[>$W\r\u001c\u0005\b\u0003\u007f\u0012\u0019\u00041\u0001d\u0011!\u0011\tAa\u0005\u0005\u0002\t}B#\u0002*\u0003B\t\r\u0003\u0002CA;\u0005{\u0001\r!a\u001e\t\u000f\u0005}$Q\ba\u0001G\"A!q\tB\n\t\u0013\u0011I%\u0001\u0005vg\u0016\u0014\b+\u0019;i)\r\u0019'1\n\u0005\b\u0003\u007f\u0012)\u00051\u0001d\u0011!\u0011yEa\u0005\u0005\n\tE\u0013a\u00039s_\u0012,8\r\u001e)bi\"$2a\u0019B*\u0011\u001d\tyH!\u0014A\u0002\rD!Ba\u0016\u0002,\u0006\u0005I\u0011\u0002B-\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\tm\u0003\u0003BA\u0019\u0005;JAAa\u0018\u00024\t1qJ\u00196fGRDS!a+)\u0003\u0007CS!!*)\u0003\u0007\u0003")
public class MatrixFactorizationModel
implements Saveable,
Serializable,
Logging {
    private final int rank;
    private final RDD<Tuple2<Object, double[]>> userFeatures;
    private final RDD<Tuple2<Object, double[]>> productFeatures;
    private final String formatVersion;
    private transient Logger org$apache$spark$Logging$$log_;

    public static MatrixFactorizationModel load(SparkContext sparkContext, String string) {
        return MatrixFactorizationModel$.MODULE$.load(sparkContext, string);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int rank() {
        return this.rank;
    }

    public RDD<Tuple2<Object, double[]>> userFeatures() {
        return this.userFeatures;
    }

    public RDD<Tuple2<Object, double[]>> productFeatures() {
        return this.productFeatures;
    }

    private void validateFeatures(String name, RDD<Tuple2<Object, double[]>> features) {
        Predef$.MODULE$.require(((double[])((Tuple2)features.first())._2()).length == this.rank(), (Function0)new Serializable(this, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MatrixFactorizationModel $outer;
            private final String name$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " feature dimension does not match the rank ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1, BoxesRunTime.boxToInteger((int)this.$outer.rank())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.name$1 = name$1;
            }
        });
        if (features.partitioner().isEmpty()) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor does not have a partitioner. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}))).append((Object)"Prediction on individual records could be slow.").toString();
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
        StorageLevel storageLevel = features.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this, name){
                public static final long serialVersionUID = 0L;
                private final String name$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " factor is not cached. Prediction could be slow."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name$1}));
                }
                {
                    this.name$1 = name$1;
                }
            });
        }
    }

    public double predict(int user, int product) {
        double[] userVector = (double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head();
        double[] productVector = (double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head();
        return BLAS.getInstance().ddot(this.rank(), userVector, 1, productVector, 1);
    }

    private Tuple2<Object, Object> countApproxDistinctUserProduct(RDD<Tuple2<Object, Object>> usersProducts) {
        HyperLogLogPlus zeroCounterUser = new HyperLogLogPlus(4, 0);
        HyperLogLogPlus zeroCounterProduct = new HyperLogLogPlus(4, 0);
        Tuple2 aggregated = (Tuple2)usersProducts.aggregate((Object)new Tuple2((Object)zeroCounterUser, (Object)zeroCounterProduct), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<HyperLogLogPlus, HyperLogLogPlus> apply(Tuple2<HyperLogLogPlus, HyperLogLogPlus> hllTuple, Tuple2<Object, Object> v) {
                ((HyperLogLogPlus)hllTuple._1()).offer((Object)BoxesRunTime.boxToInteger((int)v._1$mcI$sp()));
                ((HyperLogLogPlus)hllTuple._2()).offer((Object)BoxesRunTime.boxToInteger((int)v._2$mcI$sp()));
                return hllTuple;
            }
        }, (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<HyperLogLogPlus, HyperLogLogPlus> apply(Tuple2<HyperLogLogPlus, HyperLogLogPlus> h1, Tuple2<HyperLogLogPlus, HyperLogLogPlus> h2) {
                ((HyperLogLogPlus)h1._1()).addAll((HyperLogLogPlus)h2._1());
                ((HyperLogLogPlus)h1._2()).addAll((HyperLogLogPlus)h2._2());
                return h1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return new Tuple2.mcJJ.sp(((HyperLogLogPlus)aggregated._1()).cardinality(), ((HyperLogLogPlus)aggregated._2()).cardinality());
    }

    public RDD<Rating> predict(RDD<Tuple2<Object, Object>> usersProducts) {
        Tuple2<Object, Object> tuple2 = this.countApproxDistinctUserProduct(usersProducts);
        if (tuple2 != null) {
            RDD rDD;
            long productsCount;
            long productsCount2;
            long usersCount = tuple2._1$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(usersCount, productsCount2 = tuple2._2$mcJ$sp());
            Tuple2.mcJJ.sp sp3 = sp2;
            long usersCount2 = sp3._1$mcJ$sp();
            if (usersCount2 < (productsCount = sp3._2$mcJ$sp())) {
                RDD users = RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$1) {
                        Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$1;
                        if (tuple2 != null) {
                            int user = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double[] uFeatures = (double[])tuple22._1();
                                int product = tuple22._2$mcI$sp();
                                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)uFeatures));
                                return tuple23;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                rDD = RDD$.MODULE$.rddToPairRDDFunctions(users, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.productFeatures()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$2) {
                        Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            int product = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Tuple2 tuple23 = (Tuple2)tuple22._1();
                                double[] pFeatures = (double[])tuple22._2();
                                if (tuple23 != null) {
                                    int user = tuple23._1$mcI$sp();
                                    double[] uFeatures = (double[])tuple23._2();
                                    Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                                    return rating;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Rating.class));
            } else {
                RDD products = RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).join(usersProducts.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x$2) {
                        return x$2.swap$mcII$sp();
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Tuple2<Object, double[]>> apply(Tuple2<Object, Tuple2<double[], Object>> x0$3) {
                        Tuple2<Object, Tuple2<double[], Object>> tuple2 = x0$3;
                        if (tuple2 != null) {
                            int product = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double[] pFeatures = (double[])tuple22._1();
                                int user = tuple22._2$mcI$sp();
                                Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)pFeatures));
                                return tuple23;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                rDD = RDD$.MODULE$.rddToPairRDDFunctions(products, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).join(this.userFeatures()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Rating apply(Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> x0$4) {
                        Tuple2<Object, Tuple2<Tuple2<Object, double[]>, double[]>> tuple2 = x0$4;
                        if (tuple2 != null) {
                            int user = tuple2._1$mcI$sp();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                Tuple2 tuple23 = (Tuple2)tuple22._1();
                                double[] uFeatures = (double[])tuple22._2();
                                if (tuple23 != null) {
                                    int product = tuple23._1$mcI$sp();
                                    double[] pFeatures = (double[])tuple23._2();
                                    Rating rating = new Rating(user, product, BLAS.getInstance().ddot(uFeatures.length, uFeatures, 1, pFeatures, 1));
                                    return rating;
                                }
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                }, ClassTag$.MODULE$.apply(Rating.class));
            }
            return rDD;
        }
        throw new MatchError(tuple2);
    }

    public JavaRDD<Rating> predict(JavaPairRDD<Integer, Integer> usersProducts) {
        return this.predict((RDD<Tuple2<Object, Object>>)usersProducts.rdd()).toJavaRDD();
    }

    public Rating[] recommendProducts(int user, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.userFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)user)).head(), this.productFeatures(), num)).map((Function1)new Serializable(this, user){
            public static final long serialVersionUID = 0L;
            private final int user$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(this.user$1, t._1$mcI$sp(), t._2$mcD$sp());
            }
            {
                this.user$1 = user$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    public Rating[] recommendUsers(int product, int num) {
        return (Rating[])Predef$.MODULE$.refArrayOps((Object[])MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommend((double[])RDD$.MODULE$.rddToPairRDDFunctions(this.productFeatures(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)), (Ordering)Ordering.Int$.MODULE$).lookup((Object)BoxesRunTime.boxToInteger((int)product)).head(), this.userFeatures(), num)).map((Function1)new Serializable(this, product){
            public static final long serialVersionUID = 0L;
            private final int product$1;

            public final Rating apply(Tuple2<Object, Object> t) {
                return new Rating(t._1$mcI$sp(), this.product$1, t._2$mcD$sp());
            }
            {
                this.product$1 = product$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
    }

    @Override
    public String formatVersion() {
        return this.formatVersion;
    }

    @Override
    public void save(SparkContext sc, String path) {
        MatrixFactorizationModel$SaveLoadV1_0$.MODULE$.save(this, path);
    }

    public RDD<Tuple2<Object, Rating[]>> recommendProductsForUsers(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.userFeatures(), this.productFeatures(), num).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Tuple2<Object, Object>[]> x0$5) {
                Tuple2<Object, Tuple2<Object, Object>[]> tuple2 = x0$5;
                if (tuple2 != null) {
                    int user = tuple2._1$mcI$sp();
                    Tuple2[] top = (Tuple2[])tuple2._2();
                    Rating[] ratings = (Rating[])Predef$.MODULE$.refArrayOps((Object[])top).map((Function1)new Serializable(this, user){
                        public static final long serialVersionUID = 0L;
                        private final int user$2;

                        public final Rating apply(Tuple2<Object, Object> x0$6) {
                            Tuple2<Object, Object> tuple2 = x0$6;
                            if (tuple2 != null) {
                                int product = tuple2._1$mcI$sp();
                                double rating = tuple2._2$mcD$sp();
                                Rating rating2 = new Rating(this.user$2, product, rating);
                                return rating2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.user$2 = user$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)user), (Object)ratings);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public RDD<Tuple2<Object, Rating[]>> recommendUsersForProducts(int num) {
        return MatrixFactorizationModel$.MODULE$.org$apache$spark$mllib$recommendation$MatrixFactorizationModel$$recommendForAll(this.rank(), this.productFeatures(), this.userFeatures(), num).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Rating[]> apply(Tuple2<Object, Tuple2<Object, Object>[]> x0$7) {
                Tuple2<Object, Tuple2<Object, Object>[]> tuple2 = x0$7;
                if (tuple2 != null) {
                    int product = tuple2._1$mcI$sp();
                    Tuple2[] top = (Tuple2[])tuple2._2();
                    Rating[] ratings = (Rating[])Predef$.MODULE$.refArrayOps((Object[])top).map((Function1)new Serializable(this, product){
                        public static final long serialVersionUID = 0L;
                        private final int product$2;

                        public final Rating apply(Tuple2<Object, Object> x0$8) {
                            Tuple2<Object, Object> tuple2 = x0$8;
                            if (tuple2 != null) {
                                int user = tuple2._1$mcI$sp();
                                double rating = tuple2._2$mcD$sp();
                                Rating rating2 = new Rating(user, this.product$2, rating);
                                return rating2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.product$2 = product$2;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Rating.class)));
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)product), (Object)ratings);
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public MatrixFactorizationModel(int rank, RDD<Tuple2<Object, double[]>> userFeatures, RDD<Tuple2<Object, double[]>> productFeatures) {
        this.rank = rank;
        this.userFeatures = userFeatures;
        this.productFeatures = productFeatures;
        Logging.class.$init$((Logging)this);
        Predef$.MODULE$.require(rank > 0);
        this.validateFeatures("User", userFeatures);
        this.validateFeatures("Product", productFeatures);
        this.formatVersion = "1.0";
    }
}

