/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree.model;

import org.apache.spark.SparkContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.EnsembleCombiningStrategy$;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel$SaveLoadV1_0$;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel;
import org.apache.spark.mllib.tree.model.TreeEnsembleModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.json4s.JsonAST;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class GradientBoostedTreesModel$
implements Loader<GradientBoostedTreesModel>,
Serializable {
    public static final GradientBoostedTreesModel$ MODULE$;

    static {
        new GradientBoostedTreesModel$();
    }

    @DeveloperApi
    public RDD<Tuple2<Object, Object>> computeInitialPredictionAndError(RDD<LabeledPoint> data, double initTreeWeight, DecisionTreeModel initTree, Loss loss2) {
        return data.map((Function1)new Serializable(initTreeWeight, initTree, loss2){
            public static final long serialVersionUID = 0L;
            private final double initTreeWeight$1;
            private final DecisionTreeModel initTree$1;
            private final Loss loss$1;

            public final Tuple2<Object, Object> apply(LabeledPoint lp) {
                double pred = this.initTreeWeight$1 * this.initTree$1.predict(lp.features());
                double error = this.loss$1.computeError(pred, lp.label());
                return new Tuple2.mcDD.sp(pred, error);
            }
            {
                this.initTreeWeight$1 = initTreeWeight$1;
                this.initTree$1 = initTree$1;
                this.loss$1 = loss$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @DeveloperApi
    public RDD<Tuple2<Object, Object>> updatePredictionError(RDD<LabeledPoint> data, RDD<Tuple2<Object, Object>> predictionAndError, double treeWeight, DecisionTreeModel tree, Loss loss2) {
        RDD qual$2 = data.zip(predictionAndError, ClassTag$.MODULE$.apply(Tuple2.class));
        Serializable x$13 = new Serializable(treeWeight, tree, loss2){
            public static final long serialVersionUID = 0L;
            public final double treeWeight$1;
            public final DecisionTreeModel tree$1;
            public final Loss loss$2;

            public final Iterator<Tuple2<Object, Object>> apply(Iterator<Tuple2<LabeledPoint, Tuple2<Object, Object>>> iter) {
                return iter.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.6 $outer;

                    public final Tuple2<Object, Object> apply(Tuple2<LabeledPoint, Tuple2<Object, Object>> x0$2) {
                        Tuple2<LabeledPoint, Tuple2<Object, Object>> tuple2 = x0$2;
                        if (tuple2 != null) {
                            LabeledPoint lp = (LabeledPoint)tuple2._1();
                            Tuple2 tuple22 = (Tuple2)tuple2._2();
                            if (tuple22 != null) {
                                double pred = tuple22._1$mcD$sp();
                                double newPred = pred + this.$outer.tree$1.predict(lp.features()) * this.$outer.treeWeight$1;
                                double newError = this.$outer.loss$2.computeError(newPred, lp.label());
                                Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(newPred, newError);
                                return sp2;
                            }
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.treeWeight$1 = treeWeight$1;
                this.tree$1 = tree$1;
                this.loss$2 = loss$2;
            }
        };
        boolean x$14 = qual$2.mapPartitions$default$2();
        RDD newPredError = qual$2.mapPartitions((Function1)x$13, x$14, ClassTag$.MODULE$.apply(Tuple2.class));
        return newPredError;
    }

    public String formatVersion() {
        return TreeEnsembleModel$SaveLoadV1_0$.MODULE$.thisFormatVersion();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GradientBoostedTreesModel load(SparkContext sc, String path) {
        Tuple3<String, String, JsonAST.JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
        if (tuple3 != null) {
            void var12_12;
            void var10_10;
            void var9_9;
            Tuple3 tuple32;
            String loadedClassName = (String)tuple3._1();
            String version = (String)tuple3._2();
            JsonAST.JValue jsonMetadata = (JsonAST.JValue)tuple3._3();
            Tuple3 tuple33 = tuple32 = new Tuple3((Object)loadedClassName, (Object)version, (Object)jsonMetadata);
            String loadedClassName2 = (String)tuple33._1();
            String version2 = (String)tuple33._2();
            JsonAST.JValue jsonMetadata2 = (JsonAST.JValue)tuple33._3();
            String classNameV1_0 = GradientBoostedTreesModel$SaveLoadV1_0$.MODULE$.thisClassName();
            Tuple2 tuple2 = new Tuple2((Object)loadedClassName2, (Object)version2);
            if (tuple2 != null) {
                String className = (String)tuple2._1();
                String string = (String)tuple2._2();
                if ("1.0".equals(string)) {
                    String string2 = className;
                    String string3 = classNameV1_0;
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        TreeEnsembleModel.SaveLoadV1_0.Metadata metadata = TreeEnsembleModel$SaveLoadV1_0$.MODULE$.readMetadata(jsonMetadata2);
                        String string4 = metadata.combiningStrategy();
                        String string5 = EnsembleCombiningStrategy$.MODULE$.Sum().toString();
                        Predef$.MODULE$.assert(!(string4 != null ? !string4.equals(string5) : string5 != null));
                        DecisionTreeModel[] trees = TreeEnsembleModel$SaveLoadV1_0$.MODULE$.loadTrees(sc, path, metadata.treeAlgo());
                        GradientBoostedTreesModel gradientBoostedTreesModel = new GradientBoostedTreesModel(Algo$.MODULE$.fromString(metadata.algo()), trees, metadata.treeWeights());
                        return gradientBoostedTreesModel;
                    }
                }
            }
            throw new Exception(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GradientBoostedTreesModel.load did not recognize model"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" with (className, format version): (", ", ", ").  Supported:\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var9_9, var10_10}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  (", ", 1.0)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var12_12}))).toString());
        }
        throw new MatchError(tuple3);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GradientBoostedTreesModel$() {
        MODULE$ = this;
    }
}

