/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.spark.ml.Estimator;
import org.apache.spark.ml.clustering.BisectingKMeans$;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.clustering.BisectingKMeansParams;
import org.apache.spark.ml.clustering.BisectingKMeansParams$class;
import org.apache.spark.ml.clustering.BisectingKMeansSummary;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasDistanceMeasure$class;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasPredictionCol$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.DefaultParamsWritable$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.types.StructType;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u00015\u0011qBQ5tK\u000e$\u0018N\\4L\u001b\u0016\fgn\u001d\u0006\u0003\u0007\u0011\t!b\u00197vgR,'/\u001b8h\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa#\u0007\t\u0004\u001fA\u0011R\"\u0001\u0003\n\u0005E!!!C#ti&l\u0017\r^8s!\t\u0019B#D\u0001\u0003\u0013\t)\"A\u0001\u000bCSN,7\r^5oO.kU-\u00198t\u001b>$W\r\u001c\t\u0003']I!\u0001\u0007\u0002\u0003+\tK7/Z2uS:<7*T3b]N\u0004\u0016M]1ngB\u0011!$H\u0007\u00027)\u0011A\u0004B\u0001\u0005kRLG.\u0003\u0002\u001f7\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0007\u0002\u0003\u0011\u0001\u0005\u000b\u0007I\u0011I\u0011\u0002\u0007ULG-F\u0001#!\t\u0019\u0013F\u0004\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tAS%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015&Q\ryRf\r\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\t!\"\u00198o_R\fG/[8o\u0013\t\u0011tFA\u0003TS:\u001cW-I\u00015\u0003\u0015\u0011d\u0006\r\u00181\u0011!1\u0004A!A!\u0002\u0013\u0011\u0013\u0001B;jI\u0002B3!N\u00174\u0011\u0015I\u0004\u0001\"\u0001;\u0003\u0019a\u0014N\\5u}Q\u00111\b\u0010\t\u0003'\u0001AQ\u0001\t\u001dA\u0002\tB3\u0001P\u00174Q\rATf\r\u0005\u0006\u0001\u0002!\t%Q\u0001\u0005G>\u0004\u0018\u0010\u0006\u0002<\u0005\")1i\u0010a\u0001\t\u0006)Q\r\u001f;sCB\u0011Q\tS\u0007\u0002\r*\u0011q\tB\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003\u0013\u001a\u0013\u0001\u0002U1sC6l\u0015\r\u001d\u0015\u0004\u007f5\u001a\u0004\"B\u001d\u0001\t\u0003aE#A\u001e)\u0007-k3\u0007C\u0003P\u0001\u0011\u0005\u0001+\u0001\btKR4U-\u0019;ve\u0016\u001c8i\u001c7\u0015\u0005E\u0013V\"\u0001\u0001\t\u000bMs\u0005\u0019\u0001\u0012\u0002\u000bY\fG.^3)\u00079k3\u0007C\u0003W\u0001\u0011\u0005q+\u0001\ttKR\u0004&/\u001a3jGRLwN\\\"pYR\u0011\u0011\u000b\u0017\u0005\u0006'V\u0003\rA\t\u0015\u0004+6\u001a\u0004\"B.\u0001\t\u0003a\u0016\u0001B:fi.#\"!U/\t\u000bMS\u0006\u0019\u00010\u0011\u0005\u0011z\u0016B\u00011&\u0005\rIe\u000e\u001e\u0015\u000456\u001a\u0004\"B2\u0001\t\u0003!\u0017AC:fi6\u000b\u00070\u0013;feR\u0011\u0011+\u001a\u0005\u0006'\n\u0004\rA\u0018\u0015\u0004E6\u001a\u0004\"\u00025\u0001\t\u0003I\u0017aB:fiN+W\r\u001a\u000b\u0003#*DQaU4A\u0002-\u0004\"\u0001\n7\n\u00055,#\u0001\u0002'p]\u001eD3aZ\u00174\u0011\u0015\u0001\b\u0001\"\u0001r\u0003i\u0019X\r^'j]\u0012Kg/[:jE2,7\t\\;ti\u0016\u00148+\u001b>f)\t\t&\u000fC\u0003T_\u0002\u00071\u000f\u0005\u0002%i&\u0011Q/\n\u0002\u0007\t>,(\r\\3)\u0007=l3\u0007C\u0003y\u0001\u0011\u0005\u00110\u0001\ntKR$\u0015n\u001d;b]\u000e,W*Z1tkJ,GCA){\u0011\u0015\u0019v\u000f1\u0001#Q\r9X\u0006`\u0011\u0002{\u0006)!G\f\u001b/a!1q\u0010\u0001C!\u0003\u0003\t1AZ5u)\r\u0011\u00121\u0001\u0005\b\u0003\u000bq\b\u0019AA\u0004\u0003\u001d!\u0017\r^1tKR\u0004D!!\u0003\u0002\u001aA1\u00111BA\t\u0003+i!!!\u0004\u000b\u0007\u0005=a!A\u0002tc2LA!a\u0005\u0002\u000e\t9A)\u0019;bg\u0016$\b\u0003BA\f\u00033a\u0001\u0001\u0002\u0007\u0002\u001c\u0005\r\u0011\u0011!A\u0001\u0006\u0003\tiBA\u0002`IM\nB!a\b\u0002&A\u0019A%!\t\n\u0007\u0005\rREA\u0004O_RD\u0017N\\4\u0011\u0007\u0011\n9#C\u0002\u0002*\u0015\u00121!\u00118zQ\rqXf\r\u0005\b\u0003_\u0001A\u0011IA\u0019\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u001a\u0003\u007f\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0005\u0003s\ti!A\u0003usB,7/\u0003\u0003\u0002>\u0005]\"AC*ueV\u001cG\u000fV=qK\"A\u0011\u0011IA\u0017\u0001\u0004\t\u0019$\u0001\u0004tG\",W.\u0019\u0015\u0005\u0003[i3\u0007K\u0002\u0001[M:q!!\u0013\u0003\u0011\u0003\tY%A\bCSN,7\r^5oO.kU-\u00198t!\r\u0019\u0012Q\n\u0004\u0007\u0003\tA\t!a\u0014\u0014\u0011\u00055\u0013\u0011KA,\u0003;\u00022\u0001JA*\u0013\r\t)&\n\u0002\u0007\u0003:L(+\u001a4\u0011\ti\tIfO\u0005\u0004\u00037Z\"!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0004I\u0005}\u0013bAA1K\ta1+\u001a:jC2L'0\u00192mK\"9\u0011(!\u0014\u0005\u0002\u0005\u0015DCAA&\u0011!\tI'!\u0014\u0005B\u0005-\u0014\u0001\u00027pC\u0012$2aOA7\u0011\u001d\ty'a\u001aA\u0002\t\nA\u0001]1uQ\"\"\u0011qM\u00174\u0011)\t)(!\u0014\u0002\u0002\u0013%\u0011qO\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002zA!\u00111PAC\u001b\t\tiH\u0003\u0003\u0002\u0000\u0005\u0005\u0015\u0001\u00027b]\u001eT!!a!\u0002\t)\fg/Y\u0005\u0005\u0003\u000f\u000biH\u0001\u0004PE*,7\r\u001e\u0015\u0005\u0003\u001bj3\u0007\u000b\u0003\u0002H5\u001a\u0004")
public class BisectingKMeans
extends Estimator<BisectingKMeansModel>
implements BisectingKMeansParams,
DefaultParamsWritable {
    private final String uid;
    private final IntParam k;
    private final DoubleParam minDivisibleClusterSize;
    private final Param<String> distanceMeasure;
    private final Param<String> predictionCol;
    private final LongParam seed;
    private final Param<String> featuresCol;
    private final IntParam maxIter;

    public static MLReader<BisectingKMeans> read() {
        return BisectingKMeans$.MODULE$.read();
    }

    public static BisectingKMeans load(String string) {
        return BisectingKMeans$.MODULE$.load(string);
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable$class.write(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleParam minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    @Override
    public final void org$apache$spark$ml$clustering$BisectingKMeansParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$BisectingKMeansParams$_setter_$minDivisibleClusterSize_$eq(DoubleParam x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    @Override
    public int getK() {
        return BisectingKMeansParams$class.getK(this);
    }

    @Override
    public double getMinDivisibleClusterSize() {
        return BisectingKMeansParams$class.getMinDivisibleClusterSize(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return BisectingKMeansParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public final Param<String> distanceMeasure() {
        return this.distanceMeasure;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasDistanceMeasure$_setter_$distanceMeasure_$eq(Param x$1) {
        this.distanceMeasure = x$1;
    }

    @Override
    public final String getDistanceMeasure() {
        return HasDistanceMeasure$class.getDistanceMeasure(this);
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol$class.getPredictionCol(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public BisectingKMeans copy(ParamMap extra) {
        return (BisectingKMeans)this.defaultCopy(extra);
    }

    public BisectingKMeans setFeaturesCol(String value) {
        return (BisectingKMeans)this.set(this.featuresCol(), value);
    }

    public BisectingKMeans setPredictionCol(String value) {
        return (BisectingKMeans)this.set(this.predictionCol(), value);
    }

    public BisectingKMeans setK(int value) {
        return (BisectingKMeans)this.set(this.k(), BoxesRunTime.boxToInteger((int)value));
    }

    public BisectingKMeans setMaxIter(int value) {
        return (BisectingKMeans)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public BisectingKMeans setSeed(long value) {
        return (BisectingKMeans)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    public BisectingKMeans setMinDivisibleClusterSize(double value) {
        return (BisectingKMeans)this.set(this.minDivisibleClusterSize(), BoxesRunTime.boxToDouble((double)value));
    }

    public BisectingKMeans setDistanceMeasure(String value) {
        return (BisectingKMeans)this.set(this.distanceMeasure(), value);
    }

    @Override
    public BisectingKMeansModel fit(Dataset<?> dataset) {
        return (BisectingKMeansModel)Instrumentation$.MODULE$.instrumented(new Serializable(this, dataset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BisectingKMeans $outer;
            private final Dataset dataset$1;

            public final BisectingKMeansModel apply(Instrumentation instr) {
                this.$outer.transformSchema(this.dataset$1.schema(), true);
                RDD<org.apache.spark.mllib.linalg.Vector> rdd = DatasetUtils$.MODULE$.columnToOldVector(this.dataset$1, this.$outer.getFeaturesCol());
                instr.logPipelineStage(this.$outer);
                instr.logDataset(this.dataset$1);
                instr.logParams(this.$outer, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.$outer.featuresCol(), this.$outer.predictionCol(), this.$outer.k(), this.$outer.maxIter(), this.$outer.seed(), this.$outer.minDivisibleClusterSize(), this.$outer.distanceMeasure()}));
                org.apache.spark.mllib.clustering.BisectingKMeans bkm = new org.apache.spark.mllib.clustering.BisectingKMeans().setK(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.k()))).setMaxIterations(BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.maxIter()))).setMinDivisibleClusterSize(BoxesRunTime.unboxToDouble((Object)this.$outer.$(this.$outer.minDivisibleClusterSize()))).setSeed(BoxesRunTime.unboxToLong((Object)this.$outer.$(this.$outer.seed()))).setDistanceMeasure(this.$outer.$(this.$outer.distanceMeasure()));
                org.apache.spark.mllib.clustering.BisectingKMeansModel parentModel = bkm.run(rdd, (Option<Instrumentation>)new Some((Object)instr));
                BisectingKMeansModel model = this.$outer.copyValues(new BisectingKMeansModel(this.$outer.uid(), parentModel).setParent(this.$outer), this.$outer.copyValues$default$2());
                BisectingKMeansSummary summary2 = new BisectingKMeansSummary(model.transform(this.dataset$1), this.$outer.$(this.$outer.predictionCol()), this.$outer.$(this.$outer.featuresCol()), BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.k())), BoxesRunTime.unboxToInt((Object)this.$outer.$(this.$outer.maxIter())));
                instr.logNamedValue("clusterSizes", summary2.clusterSizes());
                instr.logNumFeatures(((Vector)Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).head()).size());
                return model.setSummary((Option<BisectingKMeansSummary>)new Some((Object)summary2));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataset$1 = dataset$1;
            }
        });
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public BisectingKMeans(String uid) {
        this.uid = uid;
        HasMaxIter$class.$init$(this);
        HasFeaturesCol$class.$init$(this);
        HasSeed$class.$init$(this);
        HasPredictionCol$class.$init$(this);
        HasDistanceMeasure$class.$init$(this);
        BisectingKMeansParams$class.$init$(this);
        MLWritable$class.$init$(this);
        DefaultParamsWritable$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.k().$minus$greater(BoxesRunTime.boxToInteger((int)4)), this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)20)), this.minDivisibleClusterSize().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
    }

    public BisectingKMeans() {
        this(Identifiable$.MODULE$.randomUID("bisecting-kmeans"));
    }
}

