/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.partial.BoundedDouble;
import org.apache.spark.partial.PartialResult;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.kafka010.CompactedKafkaRDDIterator;
import org.apache.spark.streaming.kafka010.HasOffsetRanges;
import org.apache.spark.streaming.kafka010.KafkaRDDIterator;
import org.apache.spark.streaming.kafka010.KafkaRDDPartition;
import org.apache.spark.streaming.kafka010.OffsetRange;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5b!B\u0001\u0003\u0001\u0019a!\u0001C&bM.\f'\u000b\u0012#\u000b\u0005\r!\u0011\u0001C6bM.\f\u0007'\r\u0019\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WcA\u0007!]M!\u0001A\u0004\u00197!\ry!\u0003F\u0007\u0002!)\u0011\u0011CB\u0001\u0004e\u0012$\u0017BA\n\u0011\u0005\r\u0011F\t\u0012\t\u0005+qqR&D\u0001\u0017\u0015\t9\u0002$\u0001\u0005d_:\u001cX/\\3s\u0015\tI\"$A\u0004dY&,g\u000e^:\u000b\u0005mA\u0011!B6bM.\f\u0017BA\u000f\u0017\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012\u0004\"a\b\u0011\r\u0001\u0011)\u0011\u0005\u0001b\u0001G\t\t1j\u0001\u0001\u0012\u0005\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#a\u0002(pi\"Lgn\u001a\t\u0003K-J!\u0001\f\u0014\u0003\u0007\u0005s\u0017\u0010\u0005\u0002 ]\u0011)q\u0006\u0001b\u0001G\t\ta\u000b\u0005\u00022i5\t!G\u0003\u00024\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0007CA\u001c9\u001b\u0005\u0011\u0011BA\u001d\u0003\u0005=A\u0015m](gMN,GOU1oO\u0016\u001c\b\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0005M\u001c\u0007CA\u001f?\u001b\u00051\u0011BA \u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011!\t\u0005A!b\u0001\n\u0003\u0011\u0015aC6bM.\f\u0007+\u0019:b[N,\u0012a\u0011\t\u0005\t&[e+D\u0001F\u0015\t1u)\u0001\u0003vi&d'\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\u0016\u00131!T1q!\ta5K\u0004\u0002N#B\u0011aJJ\u0007\u0002\u001f*\u0011\u0001KI\u0001\u0007yI|w\u000e\u001e \n\u0005I3\u0013A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!A\u0015\u0014\u0011\u0005]SV\"\u0001-\u000b\u0005e;\u0015\u0001\u00027b]\u001eL!a\u0017-\u0003\r=\u0013'.Z2u\u0011!i\u0006A!A!\u0002\u0013\u0019\u0015\u0001D6bM.\f\u0007+\u0019:b[N\u0004\u0003\u0002C0\u0001\u0005\u000b\u0007I\u0011\u00011\u0002\u0019=4gm]3u%\u0006tw-Z:\u0016\u0003\u0005\u00042!\n2e\u0013\t\u0019gEA\u0003BeJ\f\u0017\u0010\u0005\u00028K&\u0011aM\u0001\u0002\f\u001f\u001a47/\u001a;SC:<W\r\u0003\u0005i\u0001\t\u0005\t\u0015!\u0003b\u00035ygMZ:fiJ\u000bgnZ3tA!A!\u000e\u0001BC\u0002\u0013\u00051.\u0001\bqe\u00164WM\u001d:fI\"{7\u000f^:\u0016\u00031\u0004B\u0001R%n\u0017B\u0011a.]\u0007\u0002_*\u0011\u0001OG\u0001\u0007G>lWn\u001c8\n\u0005I|'A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\ti\u0002\u0011\t\u0011)A\u0005Y\u0006y\u0001O]3gKJ\u0014X\r\u001a%pgR\u001c\b\u0005\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003x\u0003A)8/Z\"p]N,X.\u001a:DC\u000eDW\r\u0005\u0002&q&\u0011\u0011P\n\u0002\b\u0005>|G.Z1o\u0011\u0015Y\b\u0001\"\u0001}\u0003\u0019a\u0014N\\5u}QIQP`@\u0002\u0002\u0005\r\u0011Q\u0001\t\u0005o\u0001qR\u0006C\u0003<u\u0002\u0007A\bC\u0003Bu\u0002\u00071\tC\u0003`u\u0002\u0007\u0011\rC\u0003ku\u0002\u0007A\u000eC\u0003wu\u0002\u0007q\u000fC\u0005\u0002\n\u0001\u0011\r\u0011\"\u0003\u0002\f\u0005Y\u0001o\u001c7m)&lWm\\;u+\t\ti\u0001E\u0002&\u0003\u001fI1!!\u0005'\u0005\u0011auN\\4\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001b\tA\u0002]8mYRKW.Z8vi\u0002B\u0011\"!\u0007\u0001\u0005\u0004%I!a\u0007\u0002)\r\f7\r[3J]&$\u0018.\u00197DCB\f7-\u001b;z+\t\ti\u0002E\u0002&\u0003?I1!!\t'\u0005\rIe\u000e\u001e\u0005\t\u0003K\u0001\u0001\u0015!\u0003\u0002\u001e\u0005)2-Y2iK&s\u0017\u000e^5bY\u000e\u000b\u0007/Y2jif\u0004\u0003\"CA\u0015\u0001\t\u0007I\u0011BA\u000e\u0003A\u0019\u0017m\u00195f\u001b\u0006D8)\u00199bG&$\u0018\u0010\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u000f\u0003E\u0019\u0017m\u00195f\u001b\u0006D8)\u00199bG&$\u0018\u0010\t\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003g\tqbY1dQ\u0016du.\u00193GC\u000e$xN]\u000b\u0003\u0003k\u00012!JA\u001c\u0013\r\tID\n\u0002\u0006\r2|\u0017\r\u001e\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00026\u0005\u00012-Y2iK2{\u0017\r\u001a$bGR|'\u000f\t\u0005\n\u0003\u0003\u0002!\u0019!C\u0005\u0003\u0007\n\u0011bY8na\u0006\u001cG/\u001a3\u0016\u0003]Dq!a\u0012\u0001A\u0003%q/\u0001\u0006d_6\u0004\u0018m\u0019;fI\u0002Bq!a\u0013\u0001\t\u0003\ni%A\u0004qKJ\u001c\u0018n\u001d;\u0015\t\u0005=\u0013\u0011K\u0007\u0002\u0001!A\u00111KA%\u0001\u0004\t)&\u0001\u0005oK^dUM^3m!\u0011\t9&!\u0018\u000e\u0005\u0005e#bAA.\r\u000591\u000f^8sC\u001e,\u0017\u0002BA0\u00033\u0012Ab\u0015;pe\u0006<W\rT3wK2Dq!a\u0019\u0001\t\u0003\n)'A\u0007hKR\u0004\u0016M\u001d;ji&|gn]\u000b\u0003\u0003O\u0002B!\n2\u0002jA\u0019Q(a\u001b\n\u0007\u00055dAA\u0005QCJ$\u0018\u000e^5p]\"9\u0011\u0011\u000f\u0001\u0005B\u0005M\u0014!B2pk:$HCAA\u0007\u0011\u001d\t9\b\u0001C!\u0003s\n1bY8v]R\f\u0005\u000f\u001d:pqR1\u00111PAG\u0003#\u0003b!! \u0002\u0004\u0006\u001dUBAA@\u0015\r\t\tIB\u0001\ba\u0006\u0014H/[1m\u0013\u0011\t))a \u0003\u001bA\u000b'\u000f^5bYJ+7/\u001e7u!\u0011\ti(!#\n\t\u0005-\u0015q\u0010\u0002\u000e\u0005>,h\u000eZ3e\t>,(\r\\3\t\u0011\u0005=\u0015Q\u000fa\u0001\u0003\u001b\tq\u0001^5nK>,H\u000f\u0003\u0006\u0002\u0014\u0006U\u0004\u0013!a\u0001\u0003+\u000b!bY8oM&$WM\\2f!\r)\u0013qS\u0005\u0004\u000333#A\u0002#pk\ndW\rC\u0004\u0002\u001e\u0002!\t%a(\u0002\u000f%\u001cX)\u001c9usR\tq\u000fC\u0004\u0002$\u0002!\t%!*\u0002\tQ\f7.\u001a\u000b\u0005\u0003O\u000bI\u000bE\u0002&ERA\u0001\"a+\u0002\"\u0002\u0007\u0011QD\u0001\u0004]Vl\u0007bBAX\u0001\u0011%\u0011\u0011W\u0001\nKb,7-\u001e;peN$\"!a-\u0011\t\u0015\u0012\u0017Q\u0017\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111\u0018\u0004\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\u0002BA`\u0003s\u0013\u0011$\u0012=fGV$xN]\"bG\",G+Y:l\u0019>\u001c\u0017\r^5p]\"A\u00111\u0019\u0001\u0005\u0012\t\t)-\u0001\td_6\u0004\u0018M]3Fq\u0016\u001cW\u000f^8sgR)q/a2\u0002L\"A\u0011\u0011ZAa\u0001\u0004\t),A\u0001b\u0011!\ti-!1A\u0002\u0005U\u0016!\u00012\t\u000f\u0005E\u0007\u0001\"\u0011\u0002T\u0006)r-\u001a;Qe\u00164WM\u001d:fI2{7-\u0019;j_:\u001cH\u0003BAk\u0003O\u0004R!a6\u0002b.sA!!7\u0002^:\u0019a*a7\n\u0003\u001dJ1!a8'\u0003\u001d\u0001\u0018mY6bO\u0016LA!a9\u0002f\n\u00191+Z9\u000b\u0007\u0005}g\u0005\u0003\u0005\u0002j\u0006=\u0007\u0019AA5\u0003\u001d!\b.\u001a)beRDq!!<\u0001\t\u0013\ty/\u0001\tfeJ\u0014UmZ5o\u0003\u001a$XM]#oIR\u00191*!=\t\u0011\u0005M\u00181\u001ea\u0001\u0003k\fA\u0001]1siB\u0019q'a>\n\u0007\u0005e(AA\tLC\u001a\\\u0017M\u0015#E!\u0006\u0014H/\u001b;j_:Dq!!@\u0001\t\u0003\ny0A\u0004d_6\u0004X\u000f^3\u0015\r\t\u0005!q\u0001B\u0005!\u0015\t9Na\u0001\u0015\u0013\u0011\u0011)!!:\u0003\u0011%#XM]1u_JD\u0001\"!;\u0002|\u0002\u0007\u0011\u0011\u000e\u0005\t\u0005\u0017\tY\u00101\u0001\u0003\u000e\u000591m\u001c8uKb$\bcA\u001f\u0003\u0010%\u0019!\u0011\u0003\u0004\u0003\u0017Q\u000b7o[\"p]R,\u0007\u0010\u001e\u0005\n\u0005+\u0001\u0011\u0013!C!\u0005/\tQcY8v]R\f\u0005\u000f\u001d:pq\u0012\"WMZ1vYR$#'\u0006\u0002\u0003\u001a)\"\u0011Q\u0013B\u000eW\t\u0011i\u0002\u0005\u0003\u0003 \t%RB\u0001B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0014M\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t-\"\u0011\u0005\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class KafkaRDD<K, V>
extends RDD<ConsumerRecord<K, V>>
implements HasOffsetRanges {
    private final Map<String, Object> kafkaParams;
    private final OffsetRange[] offsetRanges;
    private final Map<TopicPartition, String> preferredHosts;
    private final boolean useConsumerCache;
    private final long pollTimeout;
    private final int cacheInitialCapacity;
    private final int cacheMaxCapacity;
    private final float cacheLoadFactor;
    private final boolean compacted;

    public Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    @Override
    public OffsetRange[] offsetRanges() {
        return this.offsetRanges;
    }

    public Map<TopicPartition, String> preferredHosts() {
        return this.preferredHosts;
    }

    private long pollTimeout() {
        return this.pollTimeout;
    }

    private int cacheInitialCapacity() {
        return this.cacheInitialCapacity;
    }

    private int cacheMaxCapacity() {
        return this.cacheMaxCapacity;
    }

    private float cacheLoadFactor() {
        return this.cacheLoadFactor;
    }

    private boolean compacted() {
        return this.compacted;
    }

    public KafkaRDD<K, V> persist(StorageLevel newLevel) {
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Kafka ConsumerRecord is not serializable. Use .map to extract fields before calling .persist or .window");
        return (KafkaRDD)super.persist(newLevel);
    }

    public Partition[] getPartitions() {
        return (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OffsetRange o = (OffsetRange)tuple2._1();
            int i = tuple2._2$mcI$sp();
            KafkaRDDPartition kafkaRDDPartition = new KafkaRDDPartition(i, o.topic(), o.partition(), o.fromOffset(), o.untilOffset());
            return kafkaRDDPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class))))).toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public long count() {
        return this.compacted() ? super.count() : BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.offsetRanges())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.count()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public PartialResult<BoundedDouble> countApprox(long timeout, double confidence) {
        PartialResult partialResult;
        if (this.compacted()) {
            partialResult = super.countApprox(timeout, confidence);
        } else {
            long c = this.count();
            partialResult = new PartialResult((Object)new BoundedDouble((double)c, 1.0, (double)c, (double)c), true);
        }
        return partialResult;
    }

    public double countApprox$default$2() {
        return 0.95;
    }

    public boolean isEmpty() {
        return this.compacted() ? super.isEmpty() : this.count() == 0L;
    }

    public ConsumerRecord<K, V>[] take(int num) {
        ConsumerRecord[] consumerRecordArray;
        if (this.compacted()) {
            consumerRecordArray = (ConsumerRecord[])super.take(num);
        } else if (num < 1) {
            consumerRecordArray = (ConsumerRecord[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ConsumerRecord.class));
        } else {
            KafkaRDDPartition[] nonEmptyPartitions = (KafkaRDDPartition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.partitions())).map((Function1 & Serializable & scala.Serializable)x$2 -> (KafkaRDDPartition)x$2, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(KafkaRDDPartition.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KafkaRDD.$anonfun$take$2(x$3)));
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).isEmpty()) {
                consumerRecordArray = (ConsumerRecord[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ConsumerRecord.class));
            } else {
                scala.collection.immutable.Map parts = (scala.collection.immutable.Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nonEmptyPartitions)).foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(result, part) -> {
                    scala.collection.immutable.Map map;
                    int remain = num - BoxesRunTime.unboxToInt((Object)result.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    if (remain > 0) {
                        long taken = Math.min((long)remain, part.count());
                        map = result.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)part.index())), (Object)BoxesRunTime.boxToInteger((int)((int)taken))));
                    } else {
                        map = result;
                    }
                    return map;
                });
                consumerRecordArray = (ConsumerRecord[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.context().runJob((RDD)this, (Function2 & Serializable & scala.Serializable)(tc, it) -> (ConsumerRecord[])it.take(BoxesRunTime.unboxToInt((Object)parts.apply((Object)BoxesRunTime.boxToInteger((int)tc.partitionId())))).toArray(ClassTag$.MODULE$.apply(ConsumerRecord.class)), (Seq)Predef$.MODULE$.wrapIntArray((int[])parts.keys().toArray(ClassTag$.MODULE$.Int())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ConsumerRecord.class))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(ConsumerRecord.class));
            }
        }
        return consumerRecordArray;
    }

    private ExecutorCacheTaskLocation[] executors() {
        BlockManager bm = this.sparkContext().env().blockManager();
        return (ExecutorCacheTaskLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bm.master().getPeers(bm.blockManagerId()).toArray(ClassTag$.MODULE$.apply(BlockManagerId.class)))).map((Function1 & Serializable & scala.Serializable)x -> new ExecutorCacheTaskLocation(x.host(), x.executorId()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ExecutorCacheTaskLocation.class))))).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)this.compareExecutors(a, b)));
    }

    public boolean compareExecutors(ExecutorCacheTaskLocation a, ExecutorCacheTaskLocation b) {
        String string = a.host();
        String string2 = b.host();
        return !(string != null ? !string.equals(string2) : string2 != null) ? new StringOps(Predef$.MODULE$.augmentString(a.executorId())).$greater((Object)b.executorId()) : new StringOps(Predef$.MODULE$.augmentString(a.host())).$greater((Object)b.host());
    }

    public Seq<String> getPreferredLocations(Partition thePart) {
        Seq seq;
        ExecutorCacheTaskLocation[] execs;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        ExecutorCacheTaskLocation[] allExecs = this.executors();
        TopicPartition tp = part.topicPartition();
        String prefHost = this.preferredHosts().get(tp);
        ExecutorCacheTaskLocation[] prefExecs = prefHost == null ? allExecs : (ExecutorCacheTaskLocation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])allExecs)).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KafkaRDD.$anonfun$getPreferredLocations$1(prefHost, x$4)));
        ExecutorCacheTaskLocation[] executorCacheTaskLocationArray = execs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])prefExecs)).isEmpty() ? allExecs : prefExecs;
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])execs)).isEmpty()) {
            seq = (Seq)Seq$.MODULE$.empty();
        } else {
            int index = Math.floorMod(tp.hashCode(), execs.length);
            ExecutorCacheTaskLocation chosen = execs[index];
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{chosen.toString()}));
        }
        return seq;
    }

    private String errBeginAfterEnd(KafkaRDDPartition part) {
        return new StringBuilder(124).append("Beginning offset ").append(part.fromOffset()).append(" is after the ending offset ").append(part.untilOffset()).append(" ").append(new StringBuilder(23).append("for topic ").append(part.topic()).append(" partition ").append(part.partition()).append(". ").toString()).append("You either provided an invalid fromOffset, or the Kafka topic has been damaged").toString();
    }

    public Iterator<ConsumerRecord<K, V>> compute(Partition thePart, TaskContext context) {
        Iterator iterator;
        KafkaRDDPartition part = (KafkaRDDPartition)thePart;
        Predef$.MODULE$.require(part.fromOffset() <= part.untilOffset(), (Function0 & Serializable & scala.Serializable)() -> this.errBeginAfterEnd(part));
        if (part.fromOffset() == part.untilOffset()) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Beginning offset ").append(part.fromOffset()).append(" is the same as ending offset ").append(new StringBuilder(10).append("skipping ").append(part.topic()).append(" ").append(part.partition()).toString()).toString());
            iterator = package$.MODULE$.Iterator().empty();
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Computing topic ").append(part.topic()).append(", partition ").append(part.partition()).append(" ").append(new StringBuilder(12).append("offsets ").append(part.fromOffset()).append(" -> ").append(part.untilOffset()).toString()).toString());
            iterator = this.compacted() ? new CompactedKafkaRDDIterator(part, context, this.kafkaParams(), this.useConsumerCache, this.pollTimeout(), this.cacheInitialCapacity(), this.cacheMaxCapacity(), this.cacheLoadFactor()) : new KafkaRDDIterator(part, context, this.kafkaParams(), this.useConsumerCache, this.pollTimeout(), this.cacheInitialCapacity(), this.cacheMaxCapacity(), this.cacheLoadFactor());
        }
        return iterator;
    }

    public static final /* synthetic */ boolean $anonfun$take$2(KafkaRDDPartition x$3) {
        return x$3.count() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getPreferredLocations$1(String prefHost$1, ExecutorCacheTaskLocation x$4) {
        String string = x$4.host();
        String string2 = prefHost$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public KafkaRDD(SparkContext sc, Map<String, Object> kafkaParams, OffsetRange[] offsetRanges, Map<TopicPartition, String> preferredHosts, boolean useConsumerCache) {
        this.kafkaParams = kafkaParams;
        this.offsetRanges = offsetRanges;
        this.preferredHosts = preferredHosts;
        this.useConsumerCache = useConsumerCache;
        super(sc, (Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ConsumerRecord.class));
        Predef$.MODULE$.require("none".equals((String)kafkaParams.get("auto.offset.reset")), (Function0 & Serializable & scala.Serializable)() -> "auto.offset.reset must be set to none for executor kafka params, else messages may not match offsetRange");
        Predef$.MODULE$.require(false == BoxesRunTime.unboxToBoolean((Object)kafkaParams.get("enable.auto.commit")), (Function0 & Serializable & scala.Serializable)() -> "enable.auto.commit must be set to false for executor kafka params, else offsets may commit before processing");
        this.pollTimeout = this.conf().getLong("spark.streaming.kafka.consumer.poll.ms", this.conf().getTimeAsSeconds("spark.network.timeout", "120s") * 1000L);
        this.cacheInitialCapacity = this.conf().getInt("spark.streaming.kafka.consumer.cache.initialCapacity", 16);
        this.cacheMaxCapacity = this.conf().getInt("spark.streaming.kafka.consumer.cache.maxCapacity", 64);
        this.cacheLoadFactor = (float)this.conf().getDouble("spark.streaming.kafka.consumer.cache.loadFactor", 0.75);
        this.compacted = this.conf().getBoolean("spark.streaming.kafka.allowNonConsecutiveOffsets", false);
    }
}

