/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.streaming.Checkpoint;
import org.apache.spark.streaming.Checkpoint$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.JobGenerator;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!B\u0001\u0003\u0001\tQ!\u0001E\"iK\u000e\\\u0007o\\5oi^\u0013\u0018\u000e^3s\u0015\t\u0019A!A\u0005tiJ,\u0017-\\5oO*\u0011QAB\u0001\u0006gB\f'o\u001b\u0006\u0003\u000f!\ta!\u00199bG\",'\"A\u0005\u0002\u0007=\u0014xmE\u0002\u0001\u0017E\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0005\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\rU>\u0014w)\u001a8fe\u0006$xN]\u0002\u0001!\tYb$D\u0001\u001d\u0015\ti\"!A\u0005tG\",G-\u001e7fe&\u0011q\u0004\b\u0002\r\u0015>\u0014w)\u001a8fe\u0006$xN\u001d\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005!1m\u001c8g!\t\u0019C%D\u0001\u0005\u0013\t)CAA\u0005Ta\u0006\u00148nQ8oM\"Aq\u0005\u0001B\u0001B\u0003%\u0001&A\u0007dQ\u0016\u001c7\u000e]8j]R$\u0015N\u001d\t\u0003SAr!A\u000b\u0018\u0011\u0005-jQ\"\u0001\u0017\u000b\u00055J\u0012A\u0002\u001fs_>$h(\u0003\u00020\u001b\u00051\u0001K]3eK\u001aL!!\r\u001a\u0003\rM#(/\u001b8h\u0015\tyS\u0002\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003mij\u0011a\u000e\u0006\u0003CaR!!\u000f\u0004\u0002\r!\fGm\\8q\u0013\tYtGA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006{\u0001!\tAP\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b}\n%i\u0011#\u0011\u0005\u0001\u0003Q\"\u0001\u0002\t\u000baa\u0004\u0019\u0001\u000e\t\u000b\u0005b\u0004\u0019\u0001\u0012\t\u000b\u001db\u0004\u0019\u0001\u0015\t\u000bQb\u0004\u0019A\u001b\t\u000f\u0019\u0003!\u0019!C\u0001\u000f\u0006aQ*\u0011-`\u0003R#V)\u0014)U'V\t\u0001\n\u0005\u0002\r\u0013&\u0011!*\u0004\u0002\u0004\u0013:$\bB\u0002'\u0001A\u0003%\u0001*A\u0007N\u0003b{\u0016\t\u0016+F\u001bB#6\u000b\t\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0003!)\u00070Z2vi>\u0014X#\u0001)\u0011\u0005ECV\"\u0001*\u000b\u0005M#\u0016AC2p]\u000e,(O]3oi*\u0011QKV\u0001\u0005kRLGNC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e\u0013&A\u0005+ie\u0016\fG\rU8pY\u0016CXmY;u_JDaa\u0017\u0001!\u0002\u0013\u0001\u0016!C3yK\u000e,Ho\u001c:!\u0011\u001di\u0006A1A\u0005\u0002y\u000b\u0001cY8naJ,7o]5p]\u000e{G-Z2\u0016\u0003}\u0003\"\u0001Y2\u000e\u0003\u0005T!A\u0019\u0003\u0002\u0005%|\u0017B\u00013b\u0005A\u0019u.\u001c9sKN\u001c\u0018n\u001c8D_\u0012,7\r\u0003\u0004g\u0001\u0001\u0006IaX\u0001\u0012G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\u0003b\u00025\u0001\u0001\u0004%I![\u0001\bgR|\u0007\u000f]3e+\u0005Q\u0007C\u0001\u0007l\u0013\taWBA\u0004C_>dW-\u00198\t\u000f9\u0004\u0001\u0019!C\u0005_\u0006Y1\u000f^8qa\u0016$w\fJ3r)\t\u00018\u000f\u0005\u0002\rc&\u0011!/\u0004\u0002\u0005+:LG\u000fC\u0004u[\u0006\u0005\t\u0019\u00016\u0002\u0007a$\u0013\u0007\u0003\u0004w\u0001\u0001\u0006KA[\u0001\tgR|\u0007\u000f]3eA!1\u0001\u0010\u0001Q!\ne\f!AZ:\u0011\u0005idX\"A>\u000b\u0005aD\u0014BA?|\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0015\u0003o~\u00042\u0001DA\u0001\u0013\r\t\u0019!\u0004\u0002\tm>d\u0017\r^5mK\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011B\u0001\u0015Y\u0006$Xm\u001d;DQ\u0016\u001c7\u000e]8j]R$\u0016.\\3\u0016\u0005\u0005-\u0001c\u0001!\u0002\u000e%\u0019\u0011q\u0002\u0002\u0003\tQKW.\u001a\u0005\n\u0003'\u0001\u0001\u0019!C\u0005\u0003+\t\u0001\u0004\\1uKN$8\t[3dWB|\u0017N\u001c;US6,w\fJ3r)\r\u0001\u0018q\u0003\u0005\ni\u0006E\u0011\u0011!a\u0001\u0003\u0017A\u0001\"a\u0007\u0001A\u0003&\u00111B\u0001\u0016Y\u0006$Xm\u001d;DQ\u0016\u001c7\u000e]8j]R$\u0016.\\3!Q\r\tIb \u0004\u0007\u0003C\u0001\u0001!a\t\u0003-\rCWmY6q_&tGo\u0016:ji\u0016D\u0015M\u001c3mKJ\u001cb!a\b\u0002&\u0005E\u0002\u0003BA\u0014\u0003[i!!!\u000b\u000b\u0007\u0005-b+\u0001\u0003mC:<\u0017\u0002BA\u0018\u0003S\u0011aa\u00142kK\u000e$\b\u0003BA\u0014\u0003gIA!!\u000e\u0002*\tA!+\u001e8oC\ndW\rC\u0006\u0002:\u0005}!\u0011!Q\u0001\n\u0005-\u0011AD2iK\u000e\\\u0007o\\5oiRKW.\u001a\u0005\f\u0003{\tyB!A!\u0002\u0013\ty$A\u0003csR,7\u000fE\u0003\r\u0003\u0003\n)%C\u0002\u0002D5\u0011Q!\u0011:sCf\u00042\u0001DA$\u0013\r\tI%\u0004\u0002\u0005\u0005f$X\r\u0003\u0006\u0002N\u0005}!\u0011!Q\u0001\n)\f\u0001d\u00197fCJ\u001c\u0005.Z2la>Lg\u000e\u001e#bi\u0006d\u0015\r^3s\u0011\u001di\u0014q\u0004C\u0001\u0003#\"\u0002\"a\u0015\u0002X\u0005e\u00131\f\t\u0005\u0003+\ny\"D\u0001\u0001\u0011!\tI$a\u0014A\u0002\u0005-\u0001\u0002CA\u001f\u0003\u001f\u0002\r!a\u0010\t\u000f\u00055\u0013q\na\u0001U\"A\u0011qLA\u0010\t\u0003\t\t'A\u0002sk:$\u0012\u0001\u001d\u0005\b\u0003K\u0002A\u0011AA4\u0003\u00159(/\u001b;f)\u0015\u0001\u0018\u0011NA:\u0011!\tY'a\u0019A\u0002\u00055\u0014AC2iK\u000e\\\u0007o\\5oiB\u0019\u0001)a\u001c\n\u0007\u0005E$A\u0001\u0006DQ\u0016\u001c7\u000e]8j]RDq!!\u0014\u0002d\u0001\u0007!\u000eC\u0004\u0002x\u0001!\t!!\u0019\u0002\tM$x\u000e\u001d")
public class CheckpointWriter
implements Logging {
    public final JobGenerator org$apache$spark$streaming$CheckpointWriter$$jobGenerator;
    private final SparkConf conf;
    public final String org$apache$spark$streaming$CheckpointWriter$$checkpointDir;
    public final Configuration org$apache$spark$streaming$CheckpointWriter$$hadoopConf;
    private final int MAX_ATTEMPTS;
    private final ThreadPoolExecutor executor;
    private final CompressionCodec compressionCodec;
    private boolean org$apache$spark$streaming$CheckpointWriter$$stopped;
    public volatile FileSystem org$apache$spark$streaming$CheckpointWriter$$fs;
    private volatile Time org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int MAX_ATTEMPTS() {
        return this.MAX_ATTEMPTS;
    }

    public ThreadPoolExecutor executor() {
        return this.executor;
    }

    public CompressionCodec compressionCodec() {
        return this.compressionCodec;
    }

    public boolean org$apache$spark$streaming$CheckpointWriter$$stopped() {
        return this.org$apache$spark$streaming$CheckpointWriter$$stopped;
    }

    private void org$apache$spark$streaming$CheckpointWriter$$stopped_$eq(boolean x$1) {
        this.org$apache$spark$streaming$CheckpointWriter$$stopped = x$1;
    }

    public Time org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime() {
        return this.org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime;
    }

    public void org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime_$eq(Time x$1) {
        this.org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime = x$1;
    }

    public void write(Checkpoint checkpoint, boolean clearCheckpointDataLater) {
        try {
            byte[] bytes = Checkpoint$.MODULE$.serialize(checkpoint, this.conf);
            this.executor().execute(new CheckpointWriteHandler(this, checkpoint.checkpointTime(), bytes, clearCheckpointDataLater));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Submitted checkpoint of time ").append(checkpoint.checkpointTime()).append(" to writer queue").toString());
        }
        catch (RejectedExecutionException rej) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Could not submit checkpoint task to the thread pool executor", rej);
        }
    }

    public synchronized void stop() {
        if (this.org$apache$spark$streaming$CheckpointWriter$$stopped()) {
            return;
        }
        this.executor().shutdown();
        long startTime = System.currentTimeMillis();
        boolean terminated = this.executor().awaitTermination(10L, TimeUnit.SECONDS);
        Object object = !terminated ? this.executor().shutdownNow() : BoxedUnit.UNIT;
        long endTime = System.currentTimeMillis();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("CheckpointWriter executor terminated? ").append(terminated).append(",").append(new StringBuilder(16).append(" waited for ").append(endTime - startTime).append(" ms.").toString()).toString());
        this.org$apache$spark$streaming$CheckpointWriter$$stopped_$eq(true);
    }

    public CheckpointWriter(JobGenerator jobGenerator, SparkConf conf, String checkpointDir, Configuration hadoopConf) {
        this.org$apache$spark$streaming$CheckpointWriter$$jobGenerator = jobGenerator;
        this.conf = conf;
        this.org$apache$spark$streaming$CheckpointWriter$$checkpointDir = checkpointDir;
        this.org$apache$spark$streaming$CheckpointWriter$$hadoopConf = hadoopConf;
        Logging.$init$((Logging)this);
        this.MAX_ATTEMPTS = 3;
        this.executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000));
        this.compressionCodec = CompressionCodec$.MODULE$.createCodec(conf);
        this.org$apache$spark$streaming$CheckpointWriter$$stopped = false;
        this.org$apache$spark$streaming$CheckpointWriter$$fs = null;
        this.org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime = null;
    }

    public class CheckpointWriteHandler
    implements Runnable {
        private final Time checkpointTime;
        private final byte[] bytes;
        private final boolean clearCheckpointDataLater;
        public final /* synthetic */ CheckpointWriter $outer;

        @Override
        public void run() {
            if (this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime() == null || this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime().$less(this.checkpointTime)) {
                this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime_$eq(this.checkpointTime);
            }
            long startTime = System.currentTimeMillis();
            Path tempFile = new Path(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, "temp");
            Path checkpointFile = Checkpoint$.MODULE$.checkpointFile(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime());
            Path backupFile = Checkpoint$.MODULE$.checkpointBackupFile(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$latestCheckpointTime());
            for (int attempts = 0; attempts < this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().MAX_ATTEMPTS() && !this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$stopped(); ++attempts) {
                try {
                    Seq<Path> allCheckpointFiles;
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Saving checkpoint for time ").append($this.checkpointTime).append(" to file '").append(checkpointFile).append("'").toString());
                    if (this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs == null) {
                        this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs = new Path(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir).getFileSystem(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$hadoopConf);
                    }
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.delete(tempFile, true);
                    FSDataOutputStream fos = this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.create(tempFile);
                    Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fos.write($this.bytes), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fos.close());
                    if (this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.exists(checkpointFile)) {
                        this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.delete(backupFile, true);
                        if (!this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.rename(checkpointFile, backupFile)) {
                            this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Could not rename ").append(checkpointFile).append(" to ").append(backupFile).toString());
                        }
                    }
                    if (!this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.rename(tempFile, checkpointFile)) {
                        this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Could not rename ").append(tempFile).append(" to ").append(checkpointFile).toString());
                    }
                    if ((allCheckpointFiles = Checkpoint$.MODULE$.getCheckpointFiles(this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$checkpointDir, (Option<FileSystem>)new Some((Object)this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs))).size() > 10) {
                        ((IterableLike)allCheckpointFiles.take(allCheckpointFiles.size() - 10)).foreach((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)CheckpointWriteHandler.$anonfun$run$6(this, file)));
                    }
                    long finishTime = System.currentTimeMillis();
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Checkpoint for time ").append($this.checkpointTime).append(" saved to file '").append(checkpointFile).append("'").append(new StringBuilder(21).append(", took ").append($this.bytes.length).append(" bytes and ").append(finishTime - startTime).append(" ms").toString()).toString());
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$jobGenerator.onCheckpointCompletion(this.checkpointTime, this.clearCheckpointDataLater);
                    return;
                }
                catch (IOException ioe) {
                    String msg = new StringBuilder(45).append("Error in attempt ").append(attempts).append(" of writing checkpoint to '").append(checkpointFile).append("'").toString();
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg, ioe);
                    this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs = null;
                    continue;
                }
            }
            this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Could not write checkpoint for time ").append($this.checkpointTime).append(" to file '").append(checkpointFile).append("'").toString());
        }

        public /* synthetic */ CheckpointWriter org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$run$6(CheckpointWriteHandler $this, Path file) {
            $this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Deleting ").append(file).toString());
            return $this.org$apache$spark$streaming$CheckpointWriter$CheckpointWriteHandler$$$outer().org$apache$spark$streaming$CheckpointWriter$$fs.delete(file, true);
        }

        public CheckpointWriteHandler(CheckpointWriter $outer, Time checkpointTime, byte[] bytes, boolean clearCheckpointDataLater) {
            this.checkpointTime = checkpointTime;
            this.bytes = bytes;
            this.clearCheckpointDataLater = clearCheckpointDataLater;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

