/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.dstream;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.DStreamGraph;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=d!B\u0001\u0003\u0001\u0011a!!\u0006#TiJ,\u0017-\\\"iK\u000e\\\u0007o\\5oi\u0012\u000bG/\u0019\u0006\u0003\u0007\u0011\tq\u0001Z:ue\u0016\fWN\u0003\u0002\u0006\r\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011Q\"J\n\u0005\u00019!r\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\u0011\u0005aYR\"A\r\u000b\u0005i1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005qI\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005?\r\u0001\u0001c\u0001\u0011\"G5\t!!\u0003\u0002#\u0005\t9Ai\u0015;sK\u0006l\u0007C\u0001\u0013&\u0019\u0001!QA\n\u0001C\u0002\u001d\u0012\u0011\u0001V\t\u0003Q-\u0002\"aD\u0015\n\u0005)\u0002\"a\u0002(pi\"Lgn\u001a\t\u0003\u001f1J!!\f\t\u0003\u0007\u0005s\u0017\u0010\u0003\u00050\u0001\t\r\t\u0015a\u00031\u0003))g/\u001b3f]\u000e,G%\r\t\u0004cQ\u001aS\"\u0001\u001a\u000b\u0005M\u0002\u0012a\u0002:fM2,7\r^\u0005\u0003kI\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006o\u0001!\t\u0001O\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005ebDC\u0001\u001e<!\r\u0001\u0003a\t\u0005\u0006_Y\u0002\u001d\u0001\r\u0005\u0006\u0007Y\u0002\ra\b\u0005\b}\u0001\u0011\r\u0011\"\u0005@\u0003\u0011!\u0017\r^1\u0016\u0003\u0001\u0003B!\u0011$I\u001d5\t!I\u0003\u0002D\t\u00069Q.\u001e;bE2,'BA#\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u000f\n\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002J\u00156\tA!\u0003\u0002L\t\t!A+[7f\u0011\u0019i\u0005\u0001)A\u0005\u0001\u0006)A-\u0019;bA!9q\n\u0001a\u0001\n\u0013\u0001\u0016\u0001\u0006;j[\u0016$vn\u00115fG.\u0004x.\u001b8u\r&dW-F\u0001R!\u0011\te\t\u0013*\u0011\u0005MSfB\u0001+Y!\t)\u0006#D\u0001W\u0015\t9f$\u0001\u0004=e>|GOP\u0005\u00033B\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011\f\u0005\u0005\b=\u0002\u0001\r\u0011\"\u0003`\u0003a!\u0018.\\3U_\u000eCWmY6q_&tGOR5mK~#S-\u001d\u000b\u0003A\u000e\u0004\"aD1\n\u0005\t\u0004\"\u0001B+oSRDq\u0001Z/\u0002\u0002\u0003\u0007\u0011+A\u0002yIEBaA\u001a\u0001!B\u0013\t\u0016!\u0006;j[\u0016$vn\u00115fG.\u0004x.\u001b8u\r&dW\r\t\u0015\u0003K\"\u0004\"aD5\n\u0005)\u0004\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u001da\u0007\u00011A\u0005\n5\fa\u0004^5nKR{w\n\u001c3fgR\u001c\u0005.Z2la>Lg\u000e\u001e$jY\u0016$\u0016.\\3\u0016\u00039\u0004B!\u0011$I\u0011\"9\u0001\u000f\u0001a\u0001\n\u0013\t\u0018A\t;j[\u0016$vn\u00147eKN$8\t[3dWB|\u0017N\u001c;GS2,G+[7f?\u0012*\u0017\u000f\u0006\u0002ae\"9Am\\A\u0001\u0002\u0004q\u0007B\u0002;\u0001A\u0003&a.A\u0010uS6,Gk\\(mI\u0016\u001cHo\u00115fG.\u0004x.\u001b8u\r&dW\rV5nK\u0002B#a\u001d5\t\u000f]\u0004\u0001\u0019!C\u0005q\u0006Qa-\u001b7f'f\u001cH/Z7\u0016\u0003e\u0004\"A_@\u000e\u0003mT!\u0001`?\u0002\u0005\u0019\u001c(B\u0001@\t\u0003\u0019A\u0017\rZ8pa&\u0019\u0011\u0011A>\u0003\u0015\u0019KG.Z*zgR,W\u000eC\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b\u0005qa-\u001b7f'f\u001cH/Z7`I\u0015\fHc\u00011\u0002\n!AA-a\u0001\u0002\u0002\u0003\u0007\u0011\u0010C\u0004\u0002\u000e\u0001\u0001\u000b\u0015B=\u0002\u0017\u0019LG.Z*zgR,W\u000e\t\u0015\u0004\u0003\u0017A\u0007bBA\n\u0001\u0011EA\u0001U\u0001\u0017GV\u0014(/\u001a8u\u0007\",7m\u001b9pS:$h)\u001b7fg\"9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0011AB;qI\u0006$X\rF\u0002a\u00037Aq!!\b\u0002\u0016\u0001\u0007\u0001*\u0001\u0003uS6,\u0007bBA\u0011\u0001\u0011\u0005\u00111E\u0001\bG2,\u0017M\\;q)\r\u0001\u0017Q\u0005\u0005\b\u0003;\ty\u00021\u0001I\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\tqA]3ti>\u0014X\rF\u0001a\u0011\u001d\ty\u0003\u0001C!\u0003c\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002%\"9\u0011Q\u0007\u0001\u0005\n\u0005]\u0012aC<sSR,wJ\u00196fGR$2\u0001YA\u001d\u0011!\tY$a\rA\u0002\u0005u\u0012aA8pgB!\u0011qHA%\u001b\t\t\tE\u0003\u0003\u0002D\u0005\u0015\u0013AA5p\u0015\t\t9%\u0001\u0003kCZ\f\u0017\u0002BA&\u0003\u0003\u0012!c\u00142kK\u000e$x*\u001e;qkR\u001cFO]3b[\"2\u00111GA(\u00037\u0002RaDA)\u0003+J1!a\u0015\u0011\u0005\u0019!\bN]8xgB!\u0011qHA,\u0013\u0011\tI&!\u0011\u0003\u0017%{U\t_2faRLwN\\\u0012\u0003\u0003+Bq!a\u0018\u0001\t\u0013\t\t'\u0001\u0006sK\u0006$wJ\u00196fGR$2\u0001YA2\u0011!\t)'!\u0018A\u0002\u0005\u001d\u0014aA8jgB!\u0011qHA5\u0013\u0011\tY'!\u0011\u0003#=\u0013'.Z2u\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u000b\u0004\u0002^\u0005=\u00131\f")
public class DStreamCheckpointData<T>
implements scala.Serializable,
Logging {
    private final DStream<T> dstream;
    private final ClassTag<T> evidence$1;
    private final HashMap<Time, Object> data;
    private transient HashMap<Time, String> timeToCheckpointFile;
    private transient HashMap<Time, Time> timeToOldestCheckpointFileTime;
    private transient FileSystem fileSystem;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public HashMap<Time, Object> data() {
        return this.data;
    }

    private HashMap<Time, String> timeToCheckpointFile() {
        return this.timeToCheckpointFile;
    }

    private void timeToCheckpointFile_$eq(HashMap<Time, String> x$1) {
        this.timeToCheckpointFile = x$1;
    }

    private HashMap<Time, Time> timeToOldestCheckpointFileTime() {
        return this.timeToOldestCheckpointFileTime;
    }

    private void timeToOldestCheckpointFileTime_$eq(HashMap<Time, Time> x$1) {
        this.timeToOldestCheckpointFileTime = x$1;
    }

    private FileSystem fileSystem() {
        return this.fileSystem;
    }

    private void fileSystem_$eq(FileSystem x$1) {
        this.fileSystem = x$1;
    }

    public HashMap<Time, String> currentCheckpointFiles() {
        return this.data();
    }

    public void update(Time time) {
        block0: {
            HashMap checkpointFiles = (HashMap)((TraversableLike)this.dstream.generatedRDDs().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointData.$anonfun$update$1(x$1)))).map((Function1 & Serializable & scala.Serializable)x -> new Tuple2(x._1(), ((RDD)x._2()).getCheckpointFile().get()), HashMap$.MODULE$.canBuildFrom());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Current checkpoint files:\n").append(checkpointFiles.toSeq().mkString("\n")).toString());
            if (checkpointFiles.isEmpty()) break block0;
            this.currentCheckpointFiles().clear();
            this.currentCheckpointFiles().$plus$plus$eq((TraversableOnce)checkpointFiles);
            this.timeToCheckpointFile().$plus$plus$eq(this.currentCheckpointFiles());
            this.timeToOldestCheckpointFileTime().update((Object)time, this.currentCheckpointFiles().keys().min(Time$.MODULE$.ordering()));
        }
    }

    public void cleanup(Time time) {
        Option option = this.timeToOldestCheckpointFileTime().remove((Object)time);
        if (option instanceof Some) {
            Some some = (Some)option;
            Time lastCheckpointFileTime = (Time)some.value();
            HashMap filesToDelete = (HashMap)this.timeToCheckpointFile().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DStreamCheckpointData.$anonfun$cleanup$1(lastCheckpointFileTime, x$2)));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Files to delete:\n").append(filesToDelete.mkString(",")).toString());
            filesToDelete.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DStreamCheckpointData.$anonfun$cleanup$3(this, x0$1);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Nothing to delete");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void restore() {
        this.currentCheckpointFiles().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Time time = (Time)tuple2._1();
            String file = (String)tuple2._2();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Restoring checkpointed RDD for time ").append(time).append(" from file '").append(file).append("'").toString());
            HashMap hashMap = $this.dstream.generatedRDDs().$plus$eq(new Tuple2((Object)time, (Object)$this.dstream.context().sparkContext().checkpointFile(file, $this.evidence$1)));
            return hashMap;
        });
    }

    public String toString() {
        return new StringBuilder(23).append("[\n").append(this.currentCheckpointFiles().size()).append(" checkpoint files \n").append(this.currentCheckpointFiles().mkString("\n")).append("\n]").toString();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append(this.getClass().getSimpleName()).append(".writeObject used").toString());
            if ($this.dstream.context().graph() != null) {
                DStreamGraph dStreamGraph = $this.dstream.context().graph();
                synchronized (dStreamGraph) {
                    if (!$this.dstream.context().graph().checkpointInProgress()) {
                        String msg = new StringBuilder(317).append("Object of ").append(this.getClass().getName()).append(" is being serialized ").append(" possibly as a part of closure of an RDD operation. This is because ").append(" the DStream object is being referred to from within the closure. ").append(" Please rewrite the RDD operation inside this DStream to avoid this. ").append(" This has been enforced to avoid bloating of Spark tasks ").append(" with unnecessary objects.").toString();
                        throw new NotSerializableException(msg);
                    }
                    oos.defaultWriteObject();
                }
            } else {
                throw new NotSerializableException("Graph is unexpectedly null when DStream is being serialized.");
            }
        });
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        Utils$.MODULE$.tryOrIOException((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(this.getClass().getSimpleName()).append(".readObject used").toString());
            ois.defaultReadObject();
            this.timeToOldestCheckpointFileTime_$eq((HashMap<Time, Time>)new HashMap());
            this.timeToCheckpointFile_$eq((HashMap<Time, String>)new HashMap());
        });
    }

    public static final /* synthetic */ boolean $anonfun$update$1(Tuple2 x$1) {
        return ((RDD)x$1._2()).getCheckpointFile().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$cleanup$1(Time lastCheckpointFileTime$1, Tuple2 x$2) {
        return ((Time)x$2._1()).$less(lastCheckpointFileTime$1);
    }

    public static final /* synthetic */ void $anonfun$cleanup$3(DStreamCheckpointData $this, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Time time = (Time)tuple2._1();
            String file = (String)tuple2._2();
            try {
                Path path = new Path(file);
                if ($this.fileSystem() == null) {
                    $this.fileSystem_$eq(path.getFileSystem($this.dstream.ssc().sparkContext().hadoopConfiguration()));
                }
                $this.fileSystem().delete(path, true);
                $this.timeToCheckpointFile().$minus$eq((Object)time);
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Deleted checkpoint file '").append(file).append("' for time ").append(time).toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Error deleting old checkpoint file '").append(file).append("' for time ").append(time).toString(), e);
                $this.fileSystem_$eq(null);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public DStreamCheckpointData(DStream<T> dstream, ClassTag<T> evidence$1) {
        this.dstream = dstream;
        this.evidence$1 = evidence$1;
        Logging.$init$((Logging)this);
        this.data = new HashMap();
        this.timeToCheckpointFile = new HashMap();
        this.timeToOldestCheckpointFileTime = new HashMap();
        this.fileSystem = null;
    }
}

