/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.rdd;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDDPartition;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.HdfsUtils$;
import org.apache.spark.streaming.util.WriteAheadLog;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Mg!B\u0001\u0003\u0001\u0011a!aG,sSR,\u0017\t[3bI2{wMQ1dW\u0016$'\t\\8dWJ#EI\u0003\u0002\u0004\t\u0005\u0019!\u000f\u001a3\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<WCA\u0007\u0016'\t\u0001a\u0002E\u0002\u0010#Mi\u0011\u0001\u0005\u0006\u0003\u0007\u0019I!A\u0005\t\u0003\u0011\tcwnY6S\t\u0012\u0003\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u00011\t\tAk\u0001\u0001\u0012\u0005ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"\"\u0001\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005yY\"a\u0002(pi\"Lgn\u001a\t\u00035\u0001J!!I\u000e\u0003\u0007\u0005s\u0017\u0010\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0003\t\u00198\r\u0005\u0002&M5\ta!\u0003\u0002(\r\ta1\u000b]1sW\u000e{g\u000e^3yi\"A\u0011\u0006\u0001BC\u0002\u0013%!&A\u0005`E2|7m[%egV\t1\u0006E\u0002\u001bY9J!!L\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0005E2\u0011aB:u_J\fw-Z\u0005\u0003gA\u0012qA\u00117pG.LE\rC\u00056\u0001\t\u0005\t\u0015!\u0003,m\u0005QqL\u00197pG.LEm\u001d\u0011\n\u0005]\n\u0012\u0001\u00032m_\u000e\\\u0017\nZ:)\u0005QJ\u0004C\u0001\u000e;\u0013\tY4DA\u0005ue\u0006t7/[3oi\"AQ\b\u0001BC\u0002\u0013\u0005a(\u0001\txC2\u0014VmY8sI\"\u000bg\u000e\u001a7fgV\tq\bE\u0002\u001bY\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003\u000b\n\u0013\u0011d\u0016:ji\u0016\f\u0005.Z1e\u0019><'+Z2pe\u0012D\u0015M\u001c3mK\"Aq\t\u0001B\u0001B\u0003%q(A\txC2\u0014VmY8sI\"\u000bg\u000e\u001a7fg\u0002B#AR\u001d\t\u0011)\u0003!Q1A\u0005\n-\u000ba\"[:CY>\u001c7.\u00133WC2LG-F\u0001M!\rQB&\u0014\t\u000359K!aT\u000e\u0003\u000f\t{w\u000e\\3b]\"A\u0011\u000b\u0001B\u0001B\u0003%A*A\bjg\ncwnY6JIZ\u000bG.\u001b3!Q\t\u0001\u0016\b\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003N\u0003M\u0019Ho\u001c:f\u0013:\u0014En\\2l\u001b\u0006t\u0017mZ3s\u0011!1\u0006A!A!\u0002\u00139\u0016\u0001D:u_J\fw-\u001a'fm\u0016d\u0007CA\u0018Y\u0013\tI\u0006G\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0005\\\u0001\t\r\t\u0015a\u0003]\u0003))g/\u001b3f]\u000e,G%\r\t\u0004;\u0002\u001cR\"\u00010\u000b\u0005}[\u0012a\u0002:fM2,7\r^\u0005\u0003Cz\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006G\u0002!\t\u0001Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f\u0015L'n\u001b7n]R\u0011a\r\u001b\t\u0004O\u0002\u0019R\"\u0001\u0002\t\u000bm\u0013\u00079\u0001/\t\u000b\r\u0012\u0007\u0019\u0001\u0013\t\u000b%\u0012\u0007\u0019A\u0016\t\u000bu\u0012\u0007\u0019A \t\u000f)\u0013\u0007\u0013!a\u0001\u0019\"9AK\u0019I\u0001\u0002\u0004i\u0005b\u0002,c!\u0003\u0005\ra\u0016\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u00031A\u0017\rZ8pa\u000e{gNZ5h+\u0005\u0011\bCA:y\u001b\u0005!(BA;w\u0003\u0011\u0019wN\u001c4\u000b\u0005]D\u0011A\u00025bI>|\u0007/\u0003\u0002zi\ni1i\u001c8gS\u001e,(/\u0019;j_:Daa\u001f\u0001!\u0002\u0013\u0011\u0018!\u00045bI>|\u0007oQ8oM&<\u0007\u0005\u000b\u0002{s!9a\u0010\u0001b\u0001\n\u0013y\u0018!\u00062s_\u0006$7-Y:uK\u0012D\u0015\rZ8pa\u000e{gNZ\u000b\u0003\u0003\u0003\u0001B!a\u0001\u0002\b5\u0011\u0011Q\u0001\u0006\u0003\u0007\u001aIA!!\u0003\u0002\u0006\tI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0011!\ti\u0001\u0001Q\u0001\n\u0005\u0005\u0011A\u00062s_\u0006$7-Y:uK\u0012D\u0015\rZ8pa\u000e{gN\u001a\u0011\t\u000f\u0005E\u0001\u0001\"\u0011\u0002\u0014\u00059\u0011n\u001d,bY&$G#A'\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a\u0005iq-\u001a;QCJ$\u0018\u000e^5p]N,\"!a\u0007\u0011\tia\u0013Q\u0004\t\u0004K\u0005}\u0011bAA\u0011\r\tI\u0001+\u0019:uSRLwN\u001c\u0005\b\u0003K\u0001A\u0011IA\u0014\u0003\u001d\u0019w.\u001c9vi\u0016$b!!\u000b\u0002B\u0005\u0015\u0003#BA\u0016\u0003w\u0019b\u0002BA\u0017\u0003oqA!a\f\u000265\u0011\u0011\u0011\u0007\u0006\u0004\u0003g9\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\r\tIdG\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti$a\u0010\u0003\u0011%#XM]1u_JT1!!\u000f\u001c\u0011!\t\u0019%a\tA\u0002\u0005u\u0011!B:qY&$\b\u0002CA$\u0003G\u0001\r!!\u0013\u0002\u000f\r|g\u000e^3yiB\u0019Q%a\u0013\n\u0007\u00055cAA\u0006UCN\\7i\u001c8uKb$\bbBA)\u0001\u0011\u0005\u00131K\u0001\u0016O\u0016$\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t)\u0011\t)&a\u001b\u0011\r\u0005-\u0012qKA.\u0013\u0011\tI&a\u0010\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002^\u0005\u0015d\u0002BA0\u0003C\u00022!a\f\u001c\u0013\r\t\u0019gG\u0001\u0007!J,G-\u001a4\n\t\u0005\u001d\u0014\u0011\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\r4\u0004\u0003\u0005\u0002D\u0005=\u0003\u0019AA\u000f\u000f)\tyGAA\u0001\u0012\u0003!\u0011\u0011O\u0001\u001c/JLG/Z!iK\u0006$Gj\\4CC\u000e\\W\r\u001a\"m_\u000e\\'\u000b\u0012#\u0011\u0007\u001d\f\u0019HB\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001\u0003\u0002vM1\u00111OA<\u0003{\u00022AGA=\u0013\r\tYh\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0007i\ty(C\u0002\u0002\u0002n\u0011AbU3sS\u0006d\u0017N_1cY\u0016DqaYA:\t\u0003\t)\t\u0006\u0002\u0002r!Q\u0011\u0011RA:#\u0003%\t!a#\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\u0011\ti)a)\u0016\u0005\u0005=%f\u0001'\u0002\u0012.\u0012\u00111\u0013\t\u0005\u0003+\u000by*\u0004\u0002\u0002\u0018*!\u0011\u0011TAN\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001en\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\t+a&\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0002\u0004\u0017\u0003\u000f\u0013\r\u0001\u0007\u0005\u000b\u0003O\u000b\u0019(%A\u0005\u0002\u0005%\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0003\u0002,\u0006=VCAAWU\ri\u0015\u0011\u0013\u0003\u0007-\u0005\u0015&\u0019\u0001\r\t\u0015\u0005M\u00161OI\u0001\n\u0003\t),A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEN\u000b\u0005\u0003o\u000bY,\u0006\u0002\u0002:*\u001aq+!%\u0005\rY\t\tL1\u0001\u0019\u0011)\ty,a\u001d\u0002\u0002\u0013%\u0011\u0011Y\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002DB!\u0011QYAh\u001b\t\t9M\u0003\u0003\u0002J\u0006-\u0017\u0001\u00027b]\u001eT!!!4\u0002\t)\fg/Y\u0005\u0005\u0003#\f9M\u0001\u0004PE*,7\r\u001e")
public class WriteAheadLogBackedBlockRDD<T>
extends BlockRDD<T> {
    private final transient WriteAheadLogRecordHandle[] walRecordHandles;
    private final transient boolean[] isBlockIdValid;
    private final boolean storeInBlockManager;
    private final StorageLevel storageLevel;
    private final ClassTag<T> evidence$1;
    private final transient Configuration hadoopConfig;
    private final SerializableConfiguration broadcastedHadoopConf;

    public static <T> StorageLevel $lessinit$greater$default$6() {
        return WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6();
    }

    public static <T> boolean $lessinit$greater$default$5() {
        return WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5();
    }

    public static <T> boolean[] $lessinit$greater$default$4() {
        return WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
    }

    private BlockId[] _blockIds() {
        return super.blockIds();
    }

    public WriteAheadLogRecordHandle[] walRecordHandles() {
        return this.walRecordHandles;
    }

    private boolean[] isBlockIdValid() {
        return this.isBlockIdValid;
    }

    private Configuration hadoopConfig() {
        return this.hadoopConfig;
    }

    private SerializableConfiguration broadcastedHadoopConf() {
        return this.broadcastedHadoopConf;
    }

    public boolean isValid() {
        return true;
    }

    public Partition[] getPartitions() {
        this.assertValid();
        return (Partition[])Array$.MODULE$.tabulate(this._blockIds().length, (Function1 & Serializable & scala.Serializable)i -> WriteAheadLogBackedBlockRDD.$anonfun$getPartitions$1(this, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Partition.class));
    }

    public Iterator<T> compute(Partition split, TaskContext context) {
        this.assertValid();
        Configuration hadoopConf = this.broadcastedHadoopConf().value();
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        SerializerManager serializerManager = SparkEnv$.MODULE$.get().serializerManager();
        WriteAheadLogBackedBlockRDDPartition partition = (WriteAheadLogBackedBlockRDDPartition)split;
        BlockId blockId = partition.blockId();
        return partition.isBlockIdValid() ? (Iterator)this.getBlockFromBlockManager$1(blockManager, blockId).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.getBlockFromWriteAheadLog$1(hadoopConf, blockManager, serializerManager, partition, blockId)) : this.getBlockFromWriteAheadLog$1(hadoopConf, blockManager, serializerManager, partition, blockId);
    }

    public Seq<String> getPreferredLocations(Partition split) {
        WriteAheadLogBackedBlockRDDPartition partition = (WriteAheadLogBackedBlockRDDPartition)split;
        None$ blockLocations = partition.isBlockIdValid() ? this.getBlockIdLocations().get((Object)partition.blockId()) : None$.MODULE$;
        return (Seq)blockLocations.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Seq seq;
            WriteAheadLogRecordHandle writeAheadLogRecordHandle = partition.walRecordHandle();
            if (writeAheadLogRecordHandle instanceof FileBasedWriteAheadLogSegment) {
                WrappedArray wrappedArray;
                FileBasedWriteAheadLogSegment fileBasedWriteAheadLogSegment = (FileBasedWriteAheadLogSegment)writeAheadLogRecordHandle;
                try {
                    wrappedArray = Predef$.MODULE$.wrapRefArray((Object[])HdfsUtils$.MODULE$.getFileSegmentLocations(fileBasedWriteAheadLogSegment.path(), fileBasedWriteAheadLogSegment.offset(), fileBasedWriteAheadLogSegment.length(), this.hadoopConfig()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable e = (Throwable)option.get();
                    this.logError((Function0 & Serializable & scala.Serializable)() -> "Error getting WAL file segment locations", e);
                    Seq seq2 = (Seq)Seq$.MODULE$.empty();
                    wrappedArray = seq2;
                }
                seq = wrappedArray;
            } else {
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        });
    }

    public static final /* synthetic */ WriteAheadLogBackedBlockRDDPartition $anonfun$getPartitions$1(WriteAheadLogBackedBlockRDD $this, int i) {
        boolean isValid = $this.isBlockIdValid().length == 0 ? true : $this.isBlockIdValid()[i];
        return new WriteAheadLogBackedBlockRDDPartition(i, $this._blockIds()[i], isValid, $this.walRecordHandles()[i]);
    }

    private final Option getBlockFromBlockManager$1(BlockManager blockManager$1, BlockId blockId$1) {
        return blockManager$1.get(blockId$1, this.evidence$1).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.data());
    }

    private final Iterator getBlockFromWriteAheadLog$1(Configuration hadoopConf$1, BlockManager blockManager$1, SerializerManager serializerManager$1, WriteAheadLogBackedBlockRDDPartition partition$1, BlockId blockId$1) {
        Object object;
        ByteBuffer dataRead = null;
        WriteAheadLog writeAheadLog = null;
        try {
            try {
                String nonExistentDirectory = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString()).getAbsolutePath();
                writeAheadLog = WriteAheadLogUtils$.MODULE$.createLogForReceiver(SparkEnv$.MODULE$.get().conf(), nonExistentDirectory, hadoopConf$1);
                dataRead = writeAheadLog.read(partition$1.walRecordHandle());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new SparkException(new StringBuilder(48).append("Could not read data from write ahead log record ").append(partition$1.walRecordHandle()).toString(), e);
                }
                throw throwable;
            }
        }
        finally {
            if (writeAheadLog != null) {
                writeAheadLog.close();
                writeAheadLog = null;
            }
        }
        if (dataRead == null) {
            throw new SparkException(new StringBuilder(68).append("Could not read data from write ahead log record ").append(partition$1.walRecordHandle()).append(", ").append("read returned null").toString());
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Read partition data of ").append((Object)this).append(" from write ahead log, record handle ").append(partition$1.walRecordHandle()).toString());
        if (this.storeInBlockManager) {
            blockManager$1.putBytes(blockId$1, new ChunkedByteBuffer(dataRead.duplicate()), this.storageLevel, blockManager$1.putBytes$default$4(), this.evidence$1);
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Stored partition data of ").append((Object)this).append(" into block manager with level ").append($this.storageLevel).toString());
            object = dataRead.rewind();
        } else {
            object = BoxedUnit.UNIT;
        }
        ChunkedByteBuffer qual$1 = new ChunkedByteBuffer(dataRead);
        boolean x$2 = qual$1.toInputStream$default$1();
        return serializerManager$1.dataDeserializeStream(blockId$1, qual$1.toInputStream(x$2), this.elementClassTag());
    }

    public WriteAheadLogBackedBlockRDD(SparkContext sc, BlockId[] _blockIds, WriteAheadLogRecordHandle[] walRecordHandles, boolean[] isBlockIdValid, boolean storeInBlockManager, StorageLevel storageLevel, ClassTag<T> evidence$1) {
        this.walRecordHandles = walRecordHandles;
        this.isBlockIdValid = isBlockIdValid;
        this.storeInBlockManager = storeInBlockManager;
        this.storageLevel = storageLevel;
        this.evidence$1 = evidence$1;
        super(sc, _blockIds, evidence$1);
        Predef$.MODULE$.require(_blockIds.length == walRecordHandles.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Number of block Ids (").append(this._blockIds().length).append(") must be ").append(new StringBuilder(40).append(" same as number of WAL record handles (").append(this.walRecordHandles().length).append(")").toString()).toString());
        Predef$.MODULE$.require(new ArrayOps.ofBoolean(Predef$.MODULE$.booleanArrayOps(isBlockIdValid)).isEmpty() || isBlockIdValid.length == _blockIds.length, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Number of elements in isBlockIdValid (").append(this.isBlockIdValid().length).append(") must be ").append(new StringBuilder(31).append(" same as number of block Ids (").append(this._blockIds().length).append(")").toString()).toString());
        this.hadoopConfig = sc.hadoopConfiguration();
        this.broadcastedHadoopConf = new SerializableConfiguration(this.hadoopConfig());
    }
}

