/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGenerator$Block$;
import org.apache.spark.streaming.receiver.BlockGenerator$GeneratorState$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.RateLimiter;
import org.apache.spark.streaming.util.RecurringTimer;
import org.apache.spark.util.Clock;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}h!B\u0001\u0003\u0001\u0011a!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c2\u0001A\u0007\u0012!\tqq\"D\u0001\u0003\u0013\t\u0001\"AA\u0006SCR,G*[7ji\u0016\u0014\bC\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\f\u0014\u0005\u001daunZ4j]\u001eD\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\tY&\u001cH/\u001a8fe\u000e\u0001\u0001C\u0001\b\u001c\u0013\ta\"A\u0001\fCY>\u001c7nR3oKJ\fGo\u001c:MSN$XM\\3s\u0011!q\u0002A!A!\u0002\u0013y\u0012A\u0003:fG\u0016Lg/\u001a:JIB\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t\u0019\u0011J\u001c;\t\u0011\u0019\u0002!\u0011!Q\u0001\n\u001d\nAaY8oMB\u0011\u0001&K\u0007\u0002\r%\u0011!F\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0006G2|7m\u001b\t\u0003]Ej\u0011a\f\u0006\u0003a\u0019\tA!\u001e;jY&\u0011!g\f\u0002\u0006\u00072|7m\u001b\u0005\u0006i\u0001!\t!N\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bY:\u0004(\u000f\u001e\u0011\u00059\u0001\u0001\"\u0002\r4\u0001\u0004Q\u0002\"\u0002\u00104\u0001\u0004y\u0002\"\u0002\u00144\u0001\u00049\u0003b\u0002\u00174!\u0003\u0005\r!\f\u0004\u0005y\u0001!UHA\u0003CY>\u001c7n\u0005\u0003<}\u0005#\u0005C\u0001\u0011@\u0013\t\u0001\u0015E\u0001\u0004B]f\u0014VM\u001a\t\u0003A\tK!aQ\u0011\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001%R\u0005\u0003\r\u0006\u0012AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\u0002S\u001e\u0003\u0016\u0004%\t!S\u0001\u0003S\u0012,\u0012A\u0013\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u001a\tqa\u001d;pe\u0006<W-\u0003\u0002P\u0019\ni1\u000b\u001e:fC6\u0014En\\2l\u0013\u0012D\u0001\"U\u001e\u0003\u0012\u0003\u0006IAS\u0001\u0004S\u0012\u0004\u0003\u0002C*<\u0005+\u0007I\u0011\u0001+\u0002\r\t,hMZ3s+\u0005)\u0006c\u0001,\\;6\tqK\u0003\u0002Y3\u00069Q.\u001e;bE2,'B\u0001.\"\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039^\u00131\"\u0011:sCf\u0014UO\u001a4feB\u0011\u0001EX\u0005\u0003?\u0006\u00121!\u00118z\u0011!\t7H!E!\u0002\u0013)\u0016a\u00022vM\u001a,'\u000f\t\u0005\u0006im\"\ta\u0019\u000b\u0004I\u001a<\u0007CA3<\u001b\u0005\u0001\u0001\"\u0002%c\u0001\u0004Q\u0005\"B*c\u0001\u0004)\u0006bB5<\u0003\u0003%\tA[\u0001\u0005G>\u0004\u0018\u0010F\u0002eW2Dq\u0001\u00135\u0011\u0002\u0003\u0007!\nC\u0004TQB\u0005\t\u0019A+\t\u000f9\\\u0014\u0013!C\u0001_\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nT#\u00019+\u0005)\u000b8&\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018!C;oG\",7m[3e\u0015\t9\u0018%\u0001\u0006b]:|G/\u0019;j_:L!!\u001f;\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0004|wE\u0005I\u0011\u0001?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\tQP\u000b\u0002Vc\"AqpOA\u0001\n\u0003\n\t!A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u0007\u0001B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!\u0001\u0003mC:<'BAA\u0007\u0003\u0011Q\u0017M^1\n\t\u0005E\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0013\u0005U1(!A\u0005\u0002\u0005]\u0011\u0001\u00049s_\u0012,8\r^!sSRLX#A\u0010\t\u0013\u0005m1(!A\u0005\u0002\u0005u\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004;\u0006}\u0001\"CA\u0011\u00033\t\t\u00111\u0001 \u0003\rAH%\r\u0005\n\u0003KY\u0014\u0011!C!\u0003O\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003S\u0001R!a\u000b\u0002.uk\u0011!W\u0005\u0004\u0003_I&\u0001C%uKJ\fGo\u001c:\t\u0013\u0005M2(!A\u0005\u0002\u0005U\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005]\u0012Q\b\t\u0004A\u0005e\u0012bAA\u001eC\t9!i\\8mK\u0006t\u0007\"CA\u0011\u0003c\t\t\u00111\u0001^\u0011%\t\teOA\u0001\n\u0003\n\u0019%\u0001\u0005iCND7i\u001c3f)\u0005y\u0002\"CA$w\u0005\u0005I\u0011IA%\u0003!!xn\u0015;sS:<GCAA\u0002\u0011%\tieOA\u0001\n\u0003\ny%\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003o\t\t\u0006C\u0005\u0002\"\u0005-\u0013\u0011!a\u0001;\u001eI\u0011Q\u000b\u0001\u0002\u0002#%\u0011qK\u0001\u0006\u00052|7m\u001b\t\u0004K\u0006ec\u0001\u0003\u001f\u0001\u0003\u0003EI!a\u0017\u0014\u000b\u0005e\u0013Q\f#\u0011\u000f\u0005}\u0013Q\r&VI6\u0011\u0011\u0011\r\u0006\u0004\u0003G\n\u0013a\u0002:v]RLW.Z\u0005\u0005\u0003O\n\tGA\tBEN$(/Y2u\rVt7\r^5p]JBq\u0001NA-\t\u0003\tY\u0007\u0006\u0002\u0002X!Q\u0011qIA-\u0003\u0003%)%!\u0013\t\u0015\u0005E\u0014\u0011LA\u0001\n\u0003\u000b\u0019(A\u0003baBd\u0017\u0010F\u0003e\u0003k\n9\b\u0003\u0004I\u0003_\u0002\rA\u0013\u0005\u0007'\u0006=\u0004\u0019A+\t\u0015\u0005m\u0014\u0011LA\u0001\n\u0003\u000bi(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}\u00141\u0012\t\u0006A\u0005\u0005\u0015QQ\u0005\u0004\u0003\u0007\u000b#AB(qi&|g\u000eE\u0003!\u0003\u000fSU+C\u0002\u0002\n\u0006\u0012a\u0001V;qY\u0016\u0014\u0004\"CAG\u0003s\n\t\u00111\u0001e\u0003\rAH\u0005M\u0004\b\u0003#\u0003\u0001\u0012BAJ\u000399UM\\3sCR|'o\u0015;bi\u0016\u00042!ZAK\r\u001d\t9\n\u0001E\u0005\u00033\u0013abR3oKJ\fGo\u001c:Ti\u0006$Xm\u0005\u0003\u0002\u0016\u0006m\u0005c\u0001\u0011\u0002\u001e&\u0019\u0011qT\u0011\u0003\u0017\u0015sW/\\3sCRLwN\u001c\u0005\bi\u0005UE\u0011AAR)\t\t\u0019*B\u0004\u0002\u0018\u0006U\u0005!a*\u0011\t\u0005%\u00161V\u0007\u0003\u0003+KA!!,\u0002\u001e\n)a+\u00197vK\"Q\u0011\u0011WAK\u0005\u0004%\t!a-\u0002\u0017%s\u0017\u000e^5bY&TX\rZ\u000b\u0003\u0003OC\u0011\"a.\u0002\u0016\u0002\u0006I!a*\u0002\u0019%s\u0017\u000e^5bY&TX\r\u001a\u0011\t\u0015\u0005m\u0016Q\u0013b\u0001\n\u0003\t\u0019,\u0001\u0004BGRLg/\u001a\u0005\n\u0003\u007f\u000b)\n)A\u0005\u0003O\u000bq!Q2uSZ,\u0007\u0005\u0003\u0006\u0002D\u0006U%\u0019!C\u0001\u0003g\u000b\u0011c\u0015;paB,G-\u00113eS:<G)\u0019;b\u0011%\t9-!&!\u0002\u0013\t9+\u0001\nTi>\u0004\b/\u001a3BI\u0012Lgn\u001a#bi\u0006\u0004\u0003BCAf\u0003+\u0013\r\u0011\"\u0001\u00024\u000692\u000b^8qa\u0016$w)\u001a8fe\u0006$\u0018N\\4CY>\u001c7n\u001d\u0005\n\u0003\u001f\f)\n)A\u0005\u0003O\u000b\u0001d\u0015;paB,GmR3oKJ\fG/\u001b8h\u00052|7m[:!\u0011)\t\u0019.!&C\u0002\u0013\u0005\u00111W\u0001\u000b'R|\u0007\u000f]3e\u00032d\u0007\"CAl\u0003+\u0003\u000b\u0011BAT\u0003-\u0019Fo\u001c9qK\u0012\fE\u000e\u001c\u0011\t\u0013\u0005m\u0007A1A\u0005\n\u0005u\u0017a\u00042m_\u000e\\\u0017J\u001c;feZ\fG.T:\u0016\u0005\u0005}\u0007c\u0001\u0011\u0002b&\u0019\u00111]\u0011\u0003\t1{gn\u001a\u0005\t\u0003O\u0004\u0001\u0015!\u0003\u0002`\u0006\u0001\"\r\\8dW&sG/\u001a:wC2l5\u000f\t\u0005\n\u0003W\u0004!\u0019!C\u0005\u0003[\f!C\u00197pG.Le\u000e^3sm\u0006dG+[7feV\u0011\u0011q\u001e\t\u0005\u0003c\f)0\u0004\u0002\u0002t*\u0011\u0001\u0007B\u0005\u0005\u0003o\f\u0019P\u0001\bSK\u000e,(O]5oORKW.\u001a:\t\u0011\u0005m\b\u0001)A\u0005\u0003_\f1C\u00197pG.Le\u000e^3sm\u0006dG+[7fe\u0002B\u0011\"a@\u0001\u0005\u0004%I!a\u0006\u0002\u001d\tdwnY6Rk\u0016,XmU5{K\"9!1\u0001\u0001!\u0002\u0013y\u0012a\u00042m_\u000e\\\u0017+^3vKNK'0\u001a\u0011\t\u0013\t\u001d\u0001A1A\u0005\n\t%\u0011\u0001\u00052m_\u000e\\7OR8s!V\u001c\b.\u001b8h+\t\u0011Y\u0001E\u0003\u0003\u000e\tUA-\u0004\u0002\u0003\u0010)!!\u0011\u0003B\n\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004a\u0005-\u0011\u0002\u0002B\f\u0005\u001f\u0011!#\u0011:sCf\u0014En\\2lS:<\u0017+^3vK\"A!1\u0004\u0001!\u0002\u0013\u0011Y!A\tcY>\u001c7n\u001d$peB+8\u000f[5oO\u0002B\u0011Ba\b\u0001\u0005\u0004%IA!\t\u0002%\tdwnY6QkND\u0017N\\4UQJ,\u0017\rZ\u000b\u0003\u0005G\u0001B!!\u0002\u0003&%!!qEA\u0004\u0005\u0019!\u0006N]3bI\"A!1\u0006\u0001!\u0002\u0013\u0011\u0019#A\ncY>\u001c7\u000eU;tQ&tw\r\u00165sK\u0006$\u0007\u0005\u0003\u0005\u00030\u0001\u0001\r\u0011\"\u0003U\u00035\u0019WO\u001d:f]R\u0014UO\u001a4fe\"I!1\u0007\u0001A\u0002\u0013%!QG\u0001\u0012GV\u0014(/\u001a8u\u0005V4g-\u001a:`I\u0015\fH\u0003\u0002B\u001c\u0005{\u00012\u0001\tB\u001d\u0013\r\u0011Y$\t\u0002\u0005+:LG\u000fC\u0005\u0002\"\tE\u0012\u0011!a\u0001+\"9!\u0011\t\u0001!B\u0013)\u0016AD2veJ,g\u000e\u001e\"vM\u001a,'\u000f\t\u0015\u0005\u0005\u007f\u0011)\u0005E\u0002!\u0005\u000fJ1A!\u0013\"\u0005!1x\u000e\\1uS2,\u0007\"\u0003B'\u0001\u0001\u0007I\u0011\u0002B(\u0003\u0015\u0019H/\u0019;f+\t\u0011\t\u0006\u0005\u0003\u0003T\u0005-fbA3\u0002\u0010\"I!q\u000b\u0001A\u0002\u0013%!\u0011L\u0001\ngR\fG/Z0%KF$BAa\u000e\u0003\\!Q\u0011\u0011\u0005B+\u0003\u0003\u0005\rA!\u0015\t\u0011\t}\u0003\u0001)Q\u0005\u0005#\naa\u001d;bi\u0016\u0004\u0003\u0006\u0002B/\u0005\u000bBqA!\u001a\u0001\t\u0003\u00119'A\u0003ti\u0006\u0014H\u000f\u0006\u0002\u00038!9!1\u000e\u0001\u0005\u0002\t\u001d\u0014\u0001B:u_BDqAa\u001c\u0001\t\u0003\u0011\t(A\u0004bI\u0012$\u0015\r^1\u0015\t\t]\"1\u000f\u0005\b\u0005k\u0012i\u00071\u0001^\u0003\u0011!\u0017\r^1\t\u000f\te\u0004\u0001\"\u0001\u0003|\u0005\u0019\u0012\r\u001a3ECR\fw+\u001b;i\u0007\u0006dGNY1dWR1!q\u0007B?\u0005\u007fBqA!\u001e\u0003x\u0001\u0007Q\fC\u0004\u0003\u0002\n]\u0004\u0019A/\u0002\u00115,G/\u00193bi\u0006DqA!\"\u0001\t\u0003\u00119)A\u000ebI\u0012lU\u000f\u001c;ja2,G)\u0019;b/&$\bnQ1mY\n\f7m\u001b\u000b\u0007\u0005o\u0011IIa)\t\u0011\t-%1\u0011a\u0001\u0005\u001b\u000bA\u0002Z1uC&#XM]1u_J\u0004RAa$\u0003 vsAA!%\u0003\u001c:!!1\u0013BM\u001b\t\u0011)JC\u0002\u0003\u0018f\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0012\n\u0007\tu\u0015%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005=\"\u0011\u0015\u0006\u0004\u0005;\u000b\u0003b\u0002BA\u0005\u0007\u0003\r!\u0018\u0005\b\u0005O\u0003A\u0011\u0001BU\u0003!I7/Q2uSZ,GCAA\u001c\u0011\u001d\u0011i\u000b\u0001C\u0001\u0005S\u000b\u0011\"[:Ti>\u0004\b/\u001a3\t\u000f\tE\u0006\u0001\"\u0003\u00034\u0006\u0019R\u000f\u001d3bi\u0016\u001cUO\u001d:f]R\u0014UO\u001a4feR!!q\u0007B[\u0011!\u00119La,A\u0002\u0005}\u0017\u0001\u0002;j[\u0016DqAa/\u0001\t\u0013\u00119'A\tlK\u0016\u0004\b+^:iS:<'\t\\8dWNDqAa0\u0001\t\u0013\u0011\t-A\u0006sKB|'\u000f^#se>\u0014HC\u0002B\u001c\u0005\u0007\u0014)\u000e\u0003\u0005\u0003F\nu\u0006\u0019\u0001Bd\u0003\u001diWm]:bO\u0016\u0004BA!3\u0003R:!!1\u001aBg!\r\u0011\u0019*I\u0005\u0004\u0005\u001f\f\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0012\tM'b\u0001BhC!A!q\u001bB_\u0001\u0004\u0011I.A\u0001u!\u0011\u0011yIa7\n\t\tu'\u0011\u0015\u0002\n)\"\u0014xn^1cY\u0016DqA!9\u0001\t\u0013\u0011\u0019/A\u0005qkND'\t\\8dWR!!q\u0007Bs\u0011\u001d\u00119Oa8A\u0002\u0011\fQA\u00197pG.<!Ba;\u0003\u0003\u0003E\t\u0001\u0002Bw\u00039\u0011En\\2l\u000f\u0016tWM]1u_J\u00042A\u0004Bx\r%\t!!!A\t\u0002\u0011\u0011\tpE\u0002\u0003pzBq\u0001\u000eBx\t\u0003\u0011)\u0010\u0006\u0002\u0003n\"Q!\u0011 Bx#\u0003%\tAa?\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iP\u000b\u0002.c\u0002")
public class BlockGenerator
extends RateLimiter {
    private volatile BlockGenerator$Block$ Block$module;
    private volatile BlockGenerator$GeneratorState$ GeneratorState$module;
    private final BlockGeneratorListener listener;
    private final int receiverId;
    private final long blockIntervalMs;
    private final RecurringTimer blockIntervalTimer;
    private final int blockQueueSize;
    private final ArrayBlockingQueue<Block> blocksForPushing;
    private final Thread blockPushingThread;
    private volatile ArrayBuffer<Object> currentBuffer;
    private volatile Enumeration.Value state;

    public static Clock $lessinit$greater$default$4() {
        return BlockGenerator$.MODULE$.$lessinit$greater$default$4();
    }

    private BlockGenerator$Block$ Block() {
        if (this.Block$module == null) {
            this.Block$lzycompute$1();
        }
        return this.Block$module;
    }

    private BlockGenerator$GeneratorState$ GeneratorState() {
        if (this.GeneratorState$module == null) {
            this.GeneratorState$lzycompute$1();
        }
        return this.GeneratorState$module;
    }

    private long blockIntervalMs() {
        return this.blockIntervalMs;
    }

    private RecurringTimer blockIntervalTimer() {
        return this.blockIntervalTimer;
    }

    private int blockQueueSize() {
        return this.blockQueueSize;
    }

    private ArrayBlockingQueue<Block> blocksForPushing() {
        return this.blocksForPushing;
    }

    private Thread blockPushingThread() {
        return this.blockPushingThread;
    }

    private ArrayBuffer<Object> currentBuffer() {
        return this.currentBuffer;
    }

    private void currentBuffer_$eq(ArrayBuffer<Object> x$1) {
        this.currentBuffer = x$1;
    }

    private Enumeration.Value state() {
        return this.state;
    }

    private void state_$eq(Enumeration.Value x$1) {
        this.state = x$1;
    }

    public synchronized void start() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Initialized();
        if (value != null ? !value.equals(value2) : value2 != null) {
            throw new SparkException(new StringBuilder(74).append("Cannot start BlockGenerator as its not in the Initialized state [state = ").append(this.state()).append("]").toString());
        }
        this.state_$eq(this.GeneratorState().Active());
        this.blockIntervalTimer().start();
        this.blockPushingThread().start();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started BlockGenerator");
    }

    public void stop() {
        block11: {
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                block10: {
                    Enumeration.Value value = this.state();
                    Enumeration.Value value2 = this.GeneratorState().Active();
                    if (value != null ? !value.equals(value2) : value2 != null) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Cannot stop BlockGenerator as its not in the Active state [state = ").append(this.state()).append("]").toString());
                        break block10;
                    }
                    this.state_$eq(this.GeneratorState().StoppedAddingData());
                    break block11;
                }
                return;
            }
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping BlockGenerator");
        this.blockIntervalTimer().stop(false);
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            this.state_$eq(this.GeneratorState().StoppedGeneratingBlocks());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for block pushing thread to terminate");
        this.blockPushingThread().join();
        BlockGenerator blockGenerator2 = this;
        synchronized (blockGenerator2) {
            this.state_$eq(this.GeneratorState().StoppedAll());
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped BlockGenerator");
    }

    public void addData(Object data) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.waitToPush();
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = this.GeneratorState().Active();
                if (value3 != null ? !value3.equals(value4) : value4 != null) {
                    throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
                }
                this.currentBuffer().$plus$eq(data);
            }
        } else {
            throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        }
    }

    public void addDataWithCallback(Object data, Object metadata) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.waitToPush();
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = this.GeneratorState().Active();
                if (value3 != null ? !value3.equals(value4) : value4 != null) {
                    throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
                }
                this.currentBuffer().$plus$eq(data);
                this.listener.onAddData(data, metadata);
            }
        } else {
            throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        }
    }

    public void addMultipleDataWithCallback(Iterator<Object> dataIterator, Object metadata) {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            ArrayBuffer tempBuffer = new ArrayBuffer();
            dataIterator.foreach((Function1 & Serializable & scala.Serializable)data -> {
                this.waitToPush();
                return tempBuffer.$plus$eq(data);
            });
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                Enumeration.Value value3 = this.state();
                Enumeration.Value value4 = this.GeneratorState().Active();
                if (value3 != null ? !value3.equals(value4) : value4 != null) {
                    throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
                }
                this.currentBuffer().$plus$plus$eq((TraversableOnce)tempBuffer);
                this.listener.onAddData(tempBuffer, metadata);
            }
        } else {
            throw new SparkException("Cannot add data as BlockGenerator has not been started or has been stopped");
        }
    }

    public boolean isActive() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().Active();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isStopped() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().StoppedAll();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private void updateCurrentBuffer(long time) {
        try {
            Block newBlock = null;
            BlockGenerator blockGenerator = this;
            synchronized (blockGenerator) {
                if (this.currentBuffer().nonEmpty()) {
                    ArrayBuffer<Object> newBlockBuffer = this.currentBuffer();
                    this.currentBuffer_$eq((ArrayBuffer<Object>)new ArrayBuffer());
                    StreamBlockId blockId = new StreamBlockId(this.receiverId, time - this.blockIntervalMs());
                    this.listener.onGenerateBlock(blockId);
                    newBlock = new Block(this, blockId, newBlockBuffer);
                }
            }
            if (newBlock != null) {
                this.blocksForPushing().put(newBlock);
            }
        }
        catch (InterruptedException ie) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Block updating timer thread was interrupted");
        }
        catch (Exception e) {
            this.reportError("Error in block updating thread", e);
        }
    }

    public void org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started block pushing thread");
        try {
            while (this.areBlocksBeingGenerated$1()) {
                BoxedUnit boxedUnit;
                Option option = Option$.MODULE$.apply((Object)this.blocksForPushing().poll(10L, TimeUnit.MILLISECONDS));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Block block = (Block)some.value();
                    this.pushBlock(block);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (None$.MODULE$.equals(option)) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError((Object)option);
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Pushing out the last ").append(this.blocksForPushing().size()).append(" blocks").toString());
            while (!this.blocksForPushing().isEmpty()) {
                Block block = this.blocksForPushing().take();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Pushing block ").append(block).toString());
                this.pushBlock(block);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Blocks left to push ").append(this.blocksForPushing().size()).toString());
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped block pushing thread");
        }
        catch (InterruptedException ie) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Block pushing thread was interrupted");
        }
        catch (Exception e) {
            this.reportError("Error in block pushing thread", e);
        }
    }

    private void reportError(String message, Throwable t) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, t);
        this.listener.onError(message, t);
    }

    private void pushBlock(Block block) {
        this.listener.onPushBlock(block.id(), block.buffer());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Pushed block ").append(block.id()).toString());
    }

    private final void Block$lzycompute$1() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.Block$module == null) {
                this.Block$module = new BlockGenerator$Block$(this);
            }
        }
    }

    private final void GeneratorState$lzycompute$1() {
        BlockGenerator blockGenerator = this;
        synchronized (blockGenerator) {
            if (this.GeneratorState$module == null) {
                this.GeneratorState$module = new BlockGenerator$GeneratorState$(this);
            }
        }
    }

    private final synchronized boolean areBlocksBeingGenerated$1() {
        Enumeration.Value value = this.state();
        Enumeration.Value value2 = this.GeneratorState().StoppedGeneratingBlocks();
        return value == null ? value2 != null : !value.equals(value2);
    }

    public BlockGenerator(BlockGeneratorListener listener, int receiverId, SparkConf conf, Clock clock) {
        this.listener = listener;
        this.receiverId = receiverId;
        super(conf);
        this.blockIntervalMs = conf.getTimeAsMs("spark.streaming.blockInterval", "200ms");
        Predef$.MODULE$.require(this.blockIntervalMs() > 0L, (Function0 & Serializable & scala.Serializable)() -> "'spark.streaming.blockInterval' should be a positive value");
        this.blockIntervalTimer = new RecurringTimer(clock, this.blockIntervalMs(), (Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)time -> this.updateCurrentBuffer(time), "BlockGenerator");
        this.blockQueueSize = conf.getInt("spark.streaming.blockQueueSize", 10);
        this.blocksForPushing = new ArrayBlockingQueue(this.blockQueueSize());
        this.blockPushingThread = new Thread(this){
            private final /* synthetic */ BlockGenerator $outer;

            public void run() {
                this.$outer.org$apache$spark$streaming$receiver$BlockGenerator$$keepPushingBlocks();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.currentBuffer = new ArrayBuffer();
        this.state = this.GeneratorState().Initialized();
    }

    public class Block
    implements Product,
    scala.Serializable {
        private final StreamBlockId id;
        private final ArrayBuffer<Object> buffer;
        public final /* synthetic */ BlockGenerator $outer;

        public StreamBlockId id() {
            return this.id;
        }

        public ArrayBuffer<Object> buffer() {
            return this.buffer;
        }

        public Block copy(StreamBlockId id, ArrayBuffer<Object> buffer) {
            return new Block(this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer(), id, buffer);
        }

        public StreamBlockId copy$default$1() {
            return this.id();
        }

        public ArrayBuffer<Object> copy$default$2() {
            return this.buffer();
        }

        public String productPrefix() {
            return "Block";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            ArrayBuffer<Object> arrayBuffer;
            int n = x$1;
            switch (n) {
                case 0: {
                    arrayBuffer = this.id();
                    break;
                }
                case 1: {
                    arrayBuffer = this.buffer();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return arrayBuffer;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Block;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Block)) return false;
            if (((Block)object).org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() != this.org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Block block = (Block)x$1;
            StreamBlockId streamBlockId = this.id();
            StreamBlockId streamBlockId2 = block.id();
            if (streamBlockId == null) {
                if (streamBlockId2 != null) {
                    return false;
                }
            } else if (!streamBlockId.equals(streamBlockId2)) return false;
            ArrayBuffer<Object> arrayBuffer = this.buffer();
            ArrayBuffer<Object> arrayBuffer2 = block.buffer();
            if (arrayBuffer == null) {
                if (arrayBuffer2 != null) {
                    return false;
                }
            } else if (!arrayBuffer.equals(arrayBuffer2)) return false;
            if (!block.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BlockGenerator org$apache$spark$streaming$receiver$BlockGenerator$Block$$$outer() {
            return this.$outer;
        }

        public Block(BlockGenerator $outer, StreamBlockId id, ArrayBuffer<Object> buffer) {
            this.id = id;
            this.buffer = buffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

