/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor$ReceiverState$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tEeAB\u0001\u0003\u0003\u0003!AB\u0001\nSK\u000e,\u0017N^3s'V\u0004XM\u001d<jg>\u0014(BA\u0002\u0005\u0003!\u0011XmY3jm\u0016\u0014(BA\u0003\u0007\u0003%\u0019HO]3b[&twM\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h'\r\u0001Qb\u0005\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q9R\"A\u000b\u000b\u0005Y1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005a)\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u00057\r\u0001\u0001G\u0001\u000f#!\rib\u0004I\u0007\u0002\u0005%\u0011qD\u0001\u0002\t%\u0016\u001cW-\u001b<feB\u0011\u0011E\t\u0007\u0001\t%\u0019\u0013$!A\u0001\u0002\u000b\u0005AEA\u0002`IE\n\"!\n\u0015\u0011\u000591\u0013BA\u0014\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"AD\u0015\n\u0005)z!aA!os\"AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0003d_:4\u0007C\u0001\u00180\u001b\u00051\u0011B\u0001\u0019\u0007\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u00033\u0001\u0011\u00051'\u0001\u0004=S:LGO\u0010\u000b\u0004iUR\u0004CA\u000f\u0001\u0011\u0015\u0019\u0011\u00071\u00017a\t9\u0014\bE\u0002\u001e=a\u0002\"!I\u001d\u0005\u0013\r*\u0014\u0011!A\u0001\u0006\u0003!\u0003\"\u0002\u00172\u0001\u0004is!\u0002\u001f\u0001\u0011\u0003i\u0014!\u0004*fG\u0016Lg/\u001a:Ti\u0006$X\r\u0005\u0002?\u007f5\t\u0001AB\u0003A\u0001!\u0005\u0011IA\u0007SK\u000e,\u0017N^3s'R\fG/Z\n\u0003\u007f\t\u0003\"AD\"\n\u0005\u0011{!aC#ok6,'/\u0019;j_:DQAM \u0005\u0002\u0019#\u0012!P\u0003\u0005\u0011~\u0002\u0011JA\bDQ\u0016\u001c7\u000e]8j]R\u001cF/\u0019;f!\tQ5*D\u0001@\u0013\ta5IA\u0003WC2,X\rC\u0004O\u007f\t\u0007I\u0011A(\u0002\u0017%s\u0017\u000e^5bY&TX\rZ\u000b\u0002\u0013\"1\u0011k\u0010Q\u0001\n%\u000bA\"\u00138ji&\fG.\u001b>fI\u0002BqaU C\u0002\u0013\u0005q*A\u0004Ti\u0006\u0014H/\u001a3\t\rU{\u0004\u0015!\u0003J\u0003!\u0019F/\u0019:uK\u0012\u0004\u0003bB,@\u0005\u0004%\taT\u0001\b'R|\u0007\u000f]3e\u0011\u0019Iv\b)A\u0005\u0013\u0006A1\u000b^8qa\u0016$\u0007\u0005C\u0004\\\u0001\t\u0007I\u0011\u0002/\u0002-\u0019,H/\u001e:f\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u0012!\u0018\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A>\t!bY8oGV\u0014(/\u001a8u\u0013\t\u0011wLA\u0010Fq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\u001cVM\u001d<jG\u0016Da\u0001\u001a\u0001!\u0002\u0013i\u0016a\u00064viV\u0014X-\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;!\u0011\u001d1\u0007A1A\u0005\u0012\u001d\f\u0001b\u001d;sK\u0006l\u0017\nZ\u000b\u0002QB\u0011a\"[\u0005\u0003U>\u00111!\u00138u\u0011\u0019a\u0007\u0001)A\u0005Q\u0006I1\u000f\u001e:fC6LE\r\t\u0005\b]\u0002\u0011\r\u0011\"\u0003p\u0003%\u0019Ho\u001c9MCR\u001c\u0007.F\u0001q!\t\tx/D\u0001s\u0015\t\u00017O\u0003\u0002uk\u0006!Q\u000f^5m\u0015\u00051\u0018\u0001\u00026bm\u0006L!\u0001\u001f:\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\"1!\u0010\u0001Q\u0001\nA\f!b\u001d;pa2\u000bGo\u00195!\u0011\u001da\bA1A\u0005\n\u001d\f1\u0003Z3gCVdGOU3ti\u0006\u0014H\u000fR3mCfDaA \u0001!\u0002\u0013A\u0017\u0001\u00063fM\u0006,H\u000e\u001e*fgR\f'\u000f\u001e#fY\u0006L\b\u0005\u0003\u0005\u0002\u0002\u0001!\t\u0001BA\u0002\u0003M9W\r^\"veJ,g\u000e\u001e*bi\u0016d\u0015.\\5u+\t\t)\u0001E\u0002\u000f\u0003\u000fI1!!\u0003\u0010\u0005\u0011auN\\4\t\u0013\u00055\u0001\u00011A\u0005\u0012\u0005=\u0011!D:u_B\u0004\u0018N\\4FeJ|'/\u0006\u0002\u0002\u0012A!\u00111CA\u0012\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007\u001b\u0003\u0019a$o\\8u}%\t\u0001#C\u0002\u0002\"=\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0005\u001d\"!\u0003+ie><\u0018M\u00197f\u0015\r\t\tc\u0004\u0005\n\u0003W\u0001\u0001\u0019!C\t\u0003[\t\u0011c\u001d;paBLgnZ#se>\u0014x\fJ3r)\u0011\ty#!\u000e\u0011\u00079\t\t$C\u0002\u00024=\u0011A!\u00168ji\"Q\u0011qGA\u0015\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002<\u0001\u0001\u000b\u0015BA\t\u00039\u0019Ho\u001c9qS:<WI\u001d:pe\u0002BC!!\u000f\u0002@A\u0019a\"!\u0011\n\u0007\u0005\rsB\u0001\u0005w_2\fG/\u001b7f\u0011)\t9\u0005\u0001a\u0001\n\u0003!\u0011\u0011J\u0001\u000ee\u0016\u001cW-\u001b<feN#\u0018\r^3\u0016\u0005\u0005-\u0003cAA'\u0017:\u0011ah\u000f\u0005\u000b\u0003#\u0002\u0001\u0019!C\u0001\t\u0005M\u0013!\u0005:fG\u0016Lg/\u001a:Ti\u0006$Xm\u0018\u0013fcR!\u0011qFA+\u0011)\t9$a\u0014\u0002\u0002\u0003\u0007\u00111\n\u0005\t\u00033\u0002\u0001\u0015)\u0003\u0002L\u0005q!/Z2fSZ,'o\u0015;bi\u0016\u0004\u0003\u0006BA,\u0003\u007fAq!a\u0018\u0001\r\u0003\t\t'\u0001\u0006qkND7+\u001b8hY\u0016$B!a\f\u0002d!9\u0011QMA/\u0001\u0004A\u0013\u0001\u00023bi\u0006Dq!!\u001b\u0001\r\u0003\tY'A\u0005qkND')\u001f;fgRA\u0011qFA7\u0003{\n9\t\u0003\u0005\u0002p\u0005\u001d\u0004\u0019AA9\u0003\u0015\u0011\u0017\u0010^3t!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<k\u0006\u0019a.[8\n\t\u0005m\u0014Q\u000f\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\u0002CA@\u0003O\u0002\r!!!\u0002!=\u0004H/[8oC2lU\r^1eCR\f\u0007\u0003\u0002\b\u0002\u0004\"J1!!\"\u0010\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011RA4\u0001\u0004\tY)A\bpaRLwN\\1m\u00052|7m[%e!\u0015q\u00111QAG!\u0011\ty)!&\u000e\u0005\u0005E%bAAJ\r\u000591\u000f^8sC\u001e,\u0017\u0002BAL\u0003#\u0013Qb\u0015;sK\u0006l'\t\\8dW&#\u0007bBAN\u0001\u0019\u0005\u0011QT\u0001\raV\u001c\b.\u0013;fe\u0006$xN\u001d\u000b\t\u0003_\ty*!-\u00024\"A\u0011\u0011UAM\u0001\u0004\t\u0019+\u0001\u0005ji\u0016\u0014\u0018\r^8sa\u0011\t)+!,\u0011\r\u0005M\u0011qUAV\u0013\u0011\tI+a\n\u0003\u0011%#XM]1u_J\u00042!IAW\t-\ty+a(\u0002\u0002\u0003\u0005)\u0011\u0001\u0013\u0003\u0007}##\u0007\u0003\u0005\u0002\u0000\u0005e\u0005\u0019AAA\u0011!\tI)!'A\u0002\u0005-\u0005bBA\\\u0001\u0019\u0005\u0011\u0011X\u0001\u0010aV\u001c\b.\u0011:sCf\u0014UO\u001a4feRA\u0011qFA^\u0003/\fI\u000e\u0003\u0005\u0002>\u0006U\u0006\u0019AA`\u0003-\t'O]1z\u0005V4g-\u001a:1\t\u0005\u0005\u00171\u001b\t\u0007\u0003\u0007\fi-!5\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\fq!\\;uC\ndWMC\u0002\u0002L>\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty-!2\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004C\u0005MGaCAk\u0003w\u000b\t\u0011!A\u0003\u0002\u0011\u00121a\u0018\u00134\u0011!\ty(!.A\u0002\u0005\u0005\u0005\u0002CAE\u0003k\u0003\r!a#\t\u000f\u0005u\u0007A\"\u0001\u0002`\u0006!2M]3bi\u0016\u0014En\\2l\u000f\u0016tWM]1u_J$B!!9\u0002hB\u0019Q$a9\n\u0007\u0005\u0015(A\u0001\bCY>\u001c7nR3oKJ\fGo\u001c:\t\u0011\u0005%\u00181\u001ca\u0001\u0003W\faC\u00197pG.<UM\\3sCR|'\u000fT5ti\u0016tWM\u001d\t\u0004;\u00055\u0018bAAx\u0005\t1\"\t\\8dW\u001e+g.\u001a:bi>\u0014H*[:uK:,'\u000fC\u0004\u0002t\u00021\t!!>\u0002\u0017I,\u0007o\u001c:u\u000bJ\u0014xN\u001d\u000b\u0007\u0003_\t9Pa\u0003\t\u0011\u0005e\u0018\u0011\u001fa\u0001\u0003w\fq!\\3tg\u0006<W\r\u0005\u0003\u0002~\n\u0015a\u0002BA\u0000\u0005\u0003\u00012!a\u0006\u0010\u0013\r\u0011\u0019aD\u0001\u0007!J,G-\u001a4\n\t\t\u001d!\u0011\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t\rq\u0002\u0003\u0005\u0003\u000e\u0005E\b\u0019AA\t\u0003%!\bN]8xC\ndW\rC\u0004\u0003\u0012\u0001!\tBa\u0005\u0002\u000f=t7\u000b^1siR\u0011\u0011q\u0006\u0005\b\u0005/\u0001A\u0011\u0003B\r\u0003\u0019ygn\u0015;paR1\u0011q\u0006B\u000e\u0005;A\u0001\"!?\u0003\u0016\u0001\u0007\u00111 \u0005\t\u0005?\u0011)\u00021\u0001\u0003\"\u0005)QM\u001d:peB)a\"a!\u0002\u0012!9!Q\u0005\u0001\u0007\u0012\t\u001d\u0012aD8o%\u0016\u001cW-\u001b<feN#\u0018M\u001d;\u0015\u0005\t%\u0002c\u0001\b\u0003,%\u0019!QF\b\u0003\u000f\t{w\u000e\\3b]\"9!\u0011\u0007\u0001\u0005\u0012\tM\u0012AD8o%\u0016\u001cW-\u001b<feN#x\u000e\u001d\u000b\u0007\u0003_\u0011)Da\u000e\t\u0011\u0005e(q\u0006a\u0001\u0003wD\u0001Ba\b\u00030\u0001\u0007!\u0011\u0005\u0005\b\u0005w\u0001A\u0011\u0001B\n\u0003\u0015\u0019H/\u0019:u\u0011\u001d\u0011y\u0004\u0001C\u0001\u0005\u0003\nAa\u001d;paR1\u0011q\u0006B\"\u0005\u000bB\u0001\"!?\u0003>\u0001\u0007\u00111 \u0005\t\u0005?\u0011i\u00041\u0001\u0003\"!9!\u0011\n\u0001\u0005\u0002\tM\u0011!D:uCJ$(+Z2fSZ,'\u000fC\u0004\u0003N\u0001!\tAa\u0014\u0002\u0019M$x\u000e\u001d*fG\u0016Lg/\u001a:\u0015\r\u0005=\"\u0011\u000bB*\u0011!\tIPa\u0013A\u0002\u0005m\b\u0002\u0003B\u0010\u0005\u0017\u0002\rA!\t\t\u000f\t]\u0003\u0001\"\u0001\u0003Z\u0005y!/Z:uCJ$(+Z2fSZ,'\u000f\u0006\u0004\u00020\tm#Q\f\u0005\t\u0003s\u0014)\u00061\u0001\u0002|\"Q!q\u0004B+!\u0003\u0005\rA!\t\t\u000f\t]\u0003\u0001\"\u0001\u0003bQA\u0011q\u0006B2\u0005K\u00129\u0007\u0003\u0005\u0002z\n}\u0003\u0019AA~\u0011!\u0011yBa\u0018A\u0002\t\u0005\u0002b\u0002B5\u0005?\u0002\r\u0001[\u0001\u0006I\u0016d\u0017-\u001f\u0005\b\u0005[\u0002A\u0011\u0001B\u0014\u0003EI7OU3dK&4XM]*uCJ$X\r\u001a\u0005\b\u0005c\u0002A\u0011\u0001B\u0014\u0003EI7OU3dK&4XM]*u_B\u0004X\r\u001a\u0005\b\u0005k\u0002A\u0011\u0001B\n\u0003A\tw/Y5u)\u0016\u0014X.\u001b8bi&|g\u000eC\u0005\u0003z\u0001\t\n\u0011\"\u0001\u0003|\u0005I\"/Z:uCJ$(+Z2fSZ,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iH\u000b\u0003\u0003\"\t}4F\u0001BA!\u0011\u0011\u0019I!$\u000e\u0005\t\u0015%\u0002\u0002BD\u0005\u0013\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-u\"\u0001\u0006b]:|G/\u0019;j_:LAAa$\u0003\u0006\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public abstract class ReceiverSupervisor
implements Logging {
    private volatile ReceiverSupervisor$ReceiverState$ ReceiverState$module;
    private final Receiver<?> receiver;
    private final ExecutionContextExecutorService futureExecutionContext;
    private final int streamId;
    private final CountDownLatch stopLatch;
    private final int defaultRestartDelay;
    private volatile Throwable stoppingError;
    private volatile Enumeration.Value receiverState;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public ReceiverSupervisor$ReceiverState$ ReceiverState() {
        if (this.ReceiverState$module == null) {
            this.ReceiverState$lzycompute$1();
        }
        return this.ReceiverState$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ExecutionContextExecutorService futureExecutionContext() {
        return this.futureExecutionContext;
    }

    public int streamId() {
        return this.streamId;
    }

    private CountDownLatch stopLatch() {
        return this.stopLatch;
    }

    private int defaultRestartDelay() {
        return this.defaultRestartDelay;
    }

    public long getCurrentRateLimit() {
        return Long.MAX_VALUE;
    }

    public Throwable stoppingError() {
        return this.stoppingError;
    }

    public void stoppingError_$eq(Throwable x$1) {
        this.stoppingError = x$1;
    }

    public Enumeration.Value receiverState() {
        return this.receiverState;
    }

    public void receiverState_$eq(Enumeration.Value x$1) {
        this.receiverState = x$1;
    }

    public abstract void pushSingle(Object var1);

    public abstract void pushBytes(ByteBuffer var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushIterator(Iterator<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract void pushArrayBuffer(ArrayBuffer<?> var1, Option<Object> var2, Option<StreamBlockId> var3);

    public abstract BlockGenerator createBlockGenerator(BlockGeneratorListener var1);

    public abstract void reportError(String var1, Throwable var2);

    public void onStart() {
    }

    public void onStop(String message, Option<Throwable> error) {
    }

    public abstract boolean onReceiverStart();

    public void onReceiverStop(String message, Option<Throwable> error) {
    }

    public void start() {
        this.onStart();
        this.startReceiver();
    }

    public void stop(String message, Option<Throwable> error) {
        this.stoppingError_$eq((Throwable)error.orNull(Predef$.MODULE$.$conforms()));
        this.stopReceiver(message, error);
        this.onStop(message, error);
        this.futureExecutionContext().shutdownNow();
        this.stopLatch().countDown();
    }

    public synchronized void startReceiver() {
        try {
            if (this.onReceiverStart()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Starting receiver ").append(this.streamId()).toString());
                this.receiverState_$eq(this.ReceiverState().Started());
                this.receiver.onStart();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Called receiver ").append(this.streamId()).append(" onStart").toString());
            } else {
                this.stop(new StringBuilder(67).append("Registered unsuccessfully because Driver refused to start receiver ").append(this.streamId()).toString(), (Option<Throwable>)None$.MODULE$);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.stop(new StringBuilder(24).append("Error starting receiver ").append(this.streamId()).toString(), (Option<Throwable>)new Some((Object)t));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public synchronized void stopReceiver(String message, Option<Throwable> error) {
        block6: {
            try {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Stopping receiver with message: ").append(message).append(": ").append(error.getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
                Enumeration.Value value = this.receiverState();
                Enumeration.Value value2 = this.ReceiverState().Initialized();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skip stopping receiver because it has not yet stared");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                Enumeration.Value value4 = this.ReceiverState().Started();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    this.receiverState_$eq(this.ReceiverState().Stopped());
                    this.receiver.onStop();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Called receiver onStop");
                    this.onReceiverStop(message, error);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                Enumeration.Value value6 = this.ReceiverState().Stopped();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Receiver has been stopped");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)value);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Error stopping receiver ").append(this.streamId()).append(" ").append(Utils$.MODULE$.exceptionString(t)).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
    }

    public void restartReceiver(String message, Option<Throwable> error) {
        this.restartReceiver(message, error, this.defaultRestartDelay());
    }

    public void restartReceiver(String message, Option<Throwable> error, int delay) {
        Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Restarting receiver with delay ").append(delay).append(" ms: ").append(message).toString(), (Throwable)error.getOrElse((Function0 & Serializable & scala.Serializable)() -> null));
            this.stopReceiver(new StringBuilder(35).append("Restarting receiver with delay ").append(delay).append("ms: ").append(message).toString(), error);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Sleeping for ").append(delay).toString());
            Thread.sleep(delay);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting receiver again");
            this.startReceiver();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Receiver started again");
        }, (ExecutionContext)this.futureExecutionContext());
    }

    public Option<Throwable> restartReceiver$default$2() {
        return None$.MODULE$;
    }

    public boolean isReceiverStarted() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("state = ").append(this.receiverState()).toString());
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean isReceiverStopped() {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("state = ").append(this.receiverState()).toString());
        Enumeration.Value value = this.receiverState();
        Enumeration.Value value2 = this.ReceiverState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public void awaitTermination() {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for receiver to be stopped");
        this.stopLatch().await();
        if (this.stoppingError() != null) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Stopped receiver with error: ").append(this.stoppingError()).toString());
            throw this.stoppingError();
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped receiver without error");
    }

    private final void ReceiverState$lzycompute$1() {
        ReceiverSupervisor receiverSupervisor = this;
        synchronized (receiverSupervisor) {
            if (this.ReceiverState$module == null) {
                this.ReceiverState$module = new ReceiverSupervisor$ReceiverState$(this);
            }
        }
    }

    public ReceiverSupervisor(Receiver<?> receiver, SparkConf conf) {
        this.receiver = receiver;
        Logging.$init$((Logging)this);
        receiver.attachSupervisor(this);
        this.futureExecutionContext = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("receiver-supervisor-future", 128, ThreadUtils$.MODULE$.newDaemonCachedThreadPool$default$3()));
        this.streamId = receiver.streamId();
        this.stopLatch = new CountDownLatch(1);
        this.defaultRestartDelay = conf.getInt("spark.streaming.receiverRestartDelay", 2000);
        this.stoppingError = null;
        this.receiverState = this.ReceiverState().Initialized();
    }
}

