/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockGenerator;
import org.apache.spark.streaming.receiver.BlockGenerator$;
import org.apache.spark.streaming.receiver.BlockGeneratorListener;
import org.apache.spark.streaming.receiver.BlockManagerBasedBlockHandler;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisor;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl$$anon$1$;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler;
import org.apache.spark.streaming.receiver.WriteAheadLogBasedBlockHandler$;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.RpcUtils$;
import org.spark_project.guava.base.Throwables;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tec!B\u0001\u0003\u0001\u0011a!A\u0006*fG\u0016Lg/\u001a:TkB,'O^5t_JLU\u000e\u001d7\u000b\u0005\r!\u0011\u0001\u0003:fG\u0016Lg/\u001a:\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e#A\u0011abD\u0007\u0002\u0005%\u0011\u0001C\u0001\u0002\u0013%\u0016\u001cW-\u001b<feN+\b/\u001a:wSN|'\u000f\u0005\u0002\u0013+5\t1C\u0003\u0002\u0015\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0017'\t9Aj\\4hS:<\u0007\u0002C\u0002\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0004\u0001A\u0012!d\b\t\u0004\u001dmi\u0012B\u0001\u000f\u0003\u0005!\u0011VmY3jm\u0016\u0014\bC\u0001\u0010 \u0019\u0001!\u0011\u0002I\f\u0002\u0002\u0003\u0005)\u0011A\u0011\u0003\u0007}#\u0013'\u0005\u0002#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t9aj\u001c;iS:<\u0007CA\u0012*\u0013\tQCEA\u0002B]fD\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\u0004K:4\bC\u0001\u00180\u001b\u00051\u0011B\u0001\u0019\u0007\u0005!\u0019\u0006/\u0019:l\u000b:4\b\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u00025s5\tQG\u0003\u00027o\u0005!1m\u001c8g\u0015\tA\u0004\"\u0001\u0004iC\u0012|w\u000e]\u0005\u0003uU\u0012QbQ8oM&<WO]1uS>t\u0007\u0002\u0003\u001f\u0001\u0005\u0003\u0005\u000b\u0011B\u001f\u0002'\rDWmY6q_&tG\u000fR5s\u001fB$\u0018n\u001c8\u0011\u0007\rr\u0004)\u0003\u0002@I\t1q\n\u001d;j_:\u0004\"!\u0011%\u000f\u0005\t3\u0005CA\"%\u001b\u0005!%BA#\u0019\u0003\u0019a$o\\8u}%\u0011q\tJ\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002HI!)A\n\u0001C\u0001\u001b\u00061A(\u001b8jiz\"RAT(U+Z\u0003\"A\u0004\u0001\t\u000b\rY\u0005\u0019\u0001)1\u0005E\u001b\u0006c\u0001\b\u001c%B\u0011ad\u0015\u0003\nA=\u000b\t\u0011!A\u0003\u0002\u0005BQ\u0001L&A\u00025BQAM&A\u0002MBQ\u0001P&A\u0002uBq\u0001\u0017\u0001C\u0002\u0013%\u0011,\u0001\u0003i_N$X#\u0001!\t\rm\u0003\u0001\u0015!\u0003A\u0003\u0015Awn\u001d;!\u0011\u001di\u0006A1A\u0005\ne\u000b!\"\u001a=fGV$xN]%e\u0011\u0019y\u0006\u0001)A\u0005\u0001\u0006YQ\r_3dkR|'/\u00133!\u0011\u001d\t\u0007A1A\u0005\n\t\fAC]3dK&4X\r\u001a\"m_\u000e\\\u0007*\u00198eY\u0016\u0014X#A2\u0011\u00059!\u0017BA3\u0003\u0005Q\u0011VmY3jm\u0016$'\t\\8dW\"\u000bg\u000e\u001a7fe\"1q\r\u0001Q\u0001\n\r\fQC]3dK&4X\r\u001a\"m_\u000e\\\u0007*\u00198eY\u0016\u0014\b\u0005C\u0004j\u0001\t\u0007I\u0011\u00026\u0002\u001fQ\u0014\u0018mY6fe\u0016sG\r]8j]R,\u0012a\u001b\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u001a\t1A\u001d9d\u0013\t\u0001XN\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\t\rI\u0004\u0001\u0015!\u0003l\u0003A!(/Y2lKJ,e\u000e\u001a9pS:$\b\u0005C\u0004u\u0001\t\u0007I\u0011\u00026\u0002\u0011\u0015tG\r]8j]RDaA\u001e\u0001!\u0002\u0013Y\u0017!C3oIB|\u0017N\u001c;!\u0011\u001dA\bA1A\u0005\ne\f!B\\3x\u00052|7m[%e+\u0005Q\bcA>\u0002\n5\tAP\u0003\u0002~}\u00061\u0011\r^8nS\u000eT1a`A\u0001\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u0007\t)!\u0001\u0003vi&d'BAA\u0004\u0003\u0011Q\u0017M^1\n\u0007\u0005-AP\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDq!a\u0004\u0001A\u0003%!0A\u0006oK^\u0014En\\2l\u0013\u0012\u0004\u0003\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0003e\u0011XmZ5ti\u0016\u0014X\r\u001a\"m_\u000e\\w)\u001a8fe\u0006$xN]:\u0016\u0005\u0005]\u0001CBA\r\u00037\ty\"D\u0001\u007f\u0013\r\tiB \u0002\u0016\u0007>t7-\u001e:sK:$H*\u001b8lK\u0012\fV/Z;f!\rq\u0011\u0011E\u0005\u0004\u0003G\u0011!A\u0004\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0005\t\u0003O\u0001\u0001\u0015!\u0003\u0002\u0018\u0005Q\"/Z4jgR,'/\u001a3CY>\u001c7nR3oKJ\fGo\u001c:tA!I\u00111\u0006\u0001C\u0002\u0013%\u0011QF\u0001\u001eI\u00164\u0017-\u001e7u\u00052|7m[$f]\u0016\u0014\u0018\r^8s\u0019&\u001cH/\u001a8feV\u0011\u0011q\u0006\n\u0007\u0003c\tI$a\u0010\u0007\u000f\u0005M\u0012Q\u0007\u0001\u00020\taAH]3gS:,W.\u001a8u}!A\u0011q\u0007\u0001!\u0002\u0013\ty#\u0001\u0010eK\u001a\fW\u000f\u001c;CY>\u001c7nR3oKJ\fGo\u001c:MSN$XM\\3sAA\u00191%a\u000f\n\u0007\u0005uBE\u0001\u0004B]f\u0014VM\u001a\t\u0004\u001d\u0005\u0005\u0013bAA\"\u0005\t1\"\t\\8dW\u001e+g.\u001a:bi>\u0014H*[:uK:,'\u000fC\u0005\u0002H\u0001\u0011\r\u0011\"\u0003\u0002J\u0005)B-\u001a4bk2$(\t\\8dW\u001e+g.\u001a:bi>\u0014XCAA\u0010\u0011!\ti\u0005\u0001Q\u0001\n\u0005}\u0011A\u00063fM\u0006,H\u000e\u001e\"m_\u000e\\w)\u001a8fe\u0006$xN\u001d\u0011\t\u0011\u0005E\u0003\u0001\"\u0011\u0005\u0003'\n1cZ3u\u0007V\u0014(/\u001a8u%\u0006$X\rT5nSR,\"!!\u0016\u0011\u0007\r\n9&C\u0002\u0002Z\u0011\u0012A\u0001T8oO\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013A\u00039vg\"\u001c\u0016N\\4mKR!\u0011\u0011MA4!\r\u0019\u00131M\u0005\u0004\u0003K\"#\u0001B+oSRDq!!\u001b\u0002\\\u0001\u0007\u0001&\u0001\u0003eCR\f\u0007bBA7\u0001\u0011\u0005\u0011qN\u0001\u0010aV\u001c\b.\u0011:sCf\u0014UO\u001a4feRA\u0011\u0011MA9\u0003\u001b\u000b\u0019\n\u0003\u0005\u0002t\u0005-\u0004\u0019AA;\u0003-\t'O]1z\u0005V4g-\u001a:1\t\u0005]\u0014\u0011\u0012\t\u0007\u0003s\n\u0019)a\"\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nq!\\;uC\ndWMC\u0002\u0002\u0002\u0012\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t))a\u001f\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0004=\u0005%EaCAF\u0003c\n\t\u0011!A\u0003\u0002\u0005\u00121a\u0018\u00134\u0011!\ty)a\u001bA\u0002\u0005E\u0015AD7fi\u0006$\u0017\r^1PaRLwN\u001c\t\u0004GyB\u0003\u0002CAK\u0003W\u0002\r!a&\u0002\u001b\tdwnY6JI>\u0003H/[8o!\u0011\u0019c(!'\u0011\t\u0005m\u0015\u0011U\u0007\u0003\u0003;S1!a(\u0007\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a)\u0002\u001e\ni1\u000b\u001e:fC6\u0014En\\2l\u0013\u0012Dq!a*\u0001\t\u0003\tI+\u0001\u0007qkND\u0017\n^3sCR|'\u000f\u0006\u0005\u0002b\u0005-\u0016\u0011ZAf\u0011!\ti+!*A\u0002\u0005=\u0016\u0001C5uKJ\fGo\u001c:1\t\u0005E\u0016Q\u0019\t\u0007\u0003g\u000bi,a1\u000f\t\u0005U\u0016\u0011\u0018\b\u0004\u0007\u0006]\u0016\"A\u0013\n\u0007\u0005mF%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0016\u0011\u0019\u0002\t\u0013R,'/\u0019;pe*\u0019\u00111\u0018\u0013\u0011\u0007y\t)\rB\u0006\u0002H\u0006-\u0016\u0011!A\u0001\u0006\u0003\t#aA0%i!A\u0011qRAS\u0001\u0004\t\t\n\u0003\u0005\u0002\u0016\u0006\u0015\u0006\u0019AAL\u0011\u001d\ty\r\u0001C\u0001\u0003#\f\u0011\u0002];tQ\nKH/Z:\u0015\u0011\u0005\u0005\u00141[Ar\u0003KD\u0001\"!6\u0002N\u0002\u0007\u0011q[\u0001\u0006Ef$Xm\u001d\t\u0005\u00033\fy.\u0004\u0002\u0002\\*!\u0011Q\\A\u0003\u0003\rq\u0017n\\\u0005\u0005\u0003C\fYN\u0001\u0006CsR,')\u001e4gKJD\u0001\"a$\u0002N\u0002\u0007\u0011\u0011\u0013\u0005\t\u0003+\u000bi\r1\u0001\u0002\u0018\"9\u0011\u0011\u001e\u0001\u0005\u0002\u0005-\u0018A\u00059vg\"\fe\u000e\u001a*fa>\u0014HO\u00117pG.$\u0002\"!\u0019\u0002n\u0006]\u0018\u0011 \u0005\t\u0003_\f9\u000f1\u0001\u0002r\u0006i!/Z2fSZ,GM\u00117pG.\u00042ADAz\u0013\r\t)P\u0001\u0002\u000e%\u0016\u001cW-\u001b<fI\ncwnY6\t\u0011\u0005=\u0015q\u001da\u0001\u0003#C\u0001\"!&\u0002h\u0002\u0007\u0011q\u0013\u0005\b\u0003{\u0004A\u0011AA\u0000\u0003-\u0011X\r]8si\u0016\u0013(o\u001c:\u0015\r\u0005\u0005$\u0011\u0001B\u0003\u0011\u001d\u0011\u0019!a?A\u0002\u0001\u000bq!\\3tg\u0006<W\r\u0003\u0005\u0003\b\u0005m\b\u0019\u0001B\u0005\u0003\u0015)'O]8s!\u0011\t\u0019La\u0003\n\t\t5\u0011\u0011\u0019\u0002\n)\"\u0014xn^1cY\u0016DqA!\u0005\u0001\t#\u0012\u0019\"A\u0004p]N#\u0018M\u001d;\u0015\u0005\u0005\u0005\u0004b\u0002B\f\u0001\u0011E#\u0011D\u0001\u0007_:\u001cFo\u001c9\u0015\r\u0005\u0005$1\u0004B\u000f\u0011\u001d\u0011\u0019A!\u0006A\u0002\u0001C\u0001Ba\u0002\u0003\u0016\u0001\u0007!q\u0004\t\u0005Gy\u0012I\u0001C\u0004\u0003$\u0001!\tF!\n\u0002\u001f=t'+Z2fSZ,'o\u0015;beR$\"Aa\n\u0011\u0007\r\u0012I#C\u0002\u0003,\u0011\u0012qAQ8pY\u0016\fg\u000eC\u0004\u00030\u0001!\tF!\r\u0002\u001d=t'+Z2fSZ,'o\u0015;paR1\u0011\u0011\rB\u001a\u0005kAqAa\u0001\u0003.\u0001\u0007\u0001\t\u0003\u0005\u0003\b\t5\u0002\u0019\u0001B\u0010\u0011\u001d\u0011I\u0004\u0001C!\u0005w\tAc\u0019:fCR,'\t\\8dW\u001e+g.\u001a:bi>\u0014H\u0003BA\u0010\u0005{A\u0001Ba\u0010\u00038\u0001\u0007\u0011qH\u0001\u0017E2|7m[$f]\u0016\u0014\u0018\r^8s\u0019&\u001cH/\u001a8fe\"9!1\t\u0001\u0005\n\t\u0015\u0013a\u00038fqR\u0014En\\2l\u0013\u0012,\"!!'\t\u000f\t%\u0003\u0001\"\u0003\u0003L\u0005\u00012\r\\3b]V\u0004x\n\u001c3CY>\u001c7n\u001d\u000b\u0005\u0003C\u0012i\u0005\u0003\u0005\u0003P\t\u001d\u0003\u0019\u0001B)\u0003E\u0019G.Z1okB$\u0006N]3tQRKW.\u001a\t\u0005\u0005'\u0012)&D\u0001\u0005\u0013\r\u00119\u0006\u0002\u0002\u0005)&lW\r")
public class ReceiverSupervisorImpl
extends ReceiverSupervisor {
    private final Receiver<?> receiver;
    public final SparkEnv org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env;
    private final String host;
    private final String executorId;
    private final ReceivedBlockHandler receivedBlockHandler;
    private final RpcEndpointRef trackerEndpoint;
    private final RpcEndpointRef endpoint;
    private final AtomicLong newBlockId;
    private final ConcurrentLinkedQueue<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    private final BlockGeneratorListener defaultBlockGeneratorListener;
    private final BlockGenerator defaultBlockGenerator;

    private String host() {
        return this.host;
    }

    private String executorId() {
        return this.executorId;
    }

    private ReceivedBlockHandler receivedBlockHandler() {
        return this.receivedBlockHandler;
    }

    private RpcEndpointRef trackerEndpoint() {
        return this.trackerEndpoint;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private AtomicLong newBlockId() {
        return this.newBlockId;
    }

    public ConcurrentLinkedQueue<BlockGenerator> org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators() {
        return this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators;
    }

    private BlockGeneratorListener defaultBlockGeneratorListener() {
        return this.defaultBlockGeneratorListener;
    }

    private BlockGenerator defaultBlockGenerator() {
        return this.defaultBlockGenerator;
    }

    @Override
    public long getCurrentRateLimit() {
        return this.defaultBlockGenerator().getCurrentLimit();
    }

    @Override
    public void pushSingle(Object data) {
        this.defaultBlockGenerator().addData(data);
    }

    @Override
    public void pushArrayBuffer(ArrayBuffer<?> arrayBuffer, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ArrayBufferBlock(arrayBuffer), metadataOption, blockIdOption);
    }

    @Override
    public void pushIterator(Iterator<?> iterator, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new IteratorBlock(iterator), metadataOption, blockIdOption);
    }

    @Override
    public void pushBytes(ByteBuffer bytes, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        this.pushAndReportBlock(new ByteBufferBlock(bytes), metadataOption, blockIdOption);
    }

    public void pushAndReportBlock(ReceivedBlock receivedBlock, Option<Object> metadataOption, Option<StreamBlockId> blockIdOption) {
        StreamBlockId blockId = (StreamBlockId)blockIdOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.nextBlockId());
        long time = System.currentTimeMillis();
        ReceivedBlockStoreResult blockStoreResult = this.receivedBlockHandler().storeBlock(blockId, receivedBlock);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Pushed block ").append(blockId).append(" in ").append(System.currentTimeMillis() - time).append(" ms").toString());
        Option<Object> numRecords = blockStoreResult.numRecords();
        ReceivedBlockInfo blockInfo = new ReceivedBlockInfo(this.streamId(), numRecords, metadataOption, blockStoreResult);
        if (!BoxesRunTime.unboxToBoolean((Object)this.trackerEndpoint().askSync((Object)new AddBlock(blockInfo), ClassTag$.MODULE$.Boolean()))) {
            throw new SparkException("Failed to add block to receiver tracker.");
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Reported block ").append(blockId).toString());
    }

    @Override
    public void reportError(String message, Throwable error) {
        String errorString = (String)Option$.MODULE$.apply((Object)error).map((Function1 & Serializable & scala.Serializable)x$1 -> Throwables.getStackTraceAsString((Throwable)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.trackerEndpoint().send((Object)new ReportError(this.streamId(), message, errorString));
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Reported error ").append(message).append(" - ").append(error).toString());
    }

    @Override
    public void onStart() {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void onStop(String message, Option<Throwable> error) {
        ReceivedBlockHandler receivedBlockHandler = this.receivedBlockHandler();
        if (receivedBlockHandler instanceof WriteAheadLogBasedBlockHandler) {
            WriteAheadLogBasedBlockHandler writeAheadLogBasedBlockHandler = (WriteAheadLogBasedBlockHandler)receivedBlockHandler;
            writeAheadLogBasedBlockHandler.stop();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.stop();
            return BoxedUnit.UNIT;
        });
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv().stop(this.endpoint());
    }

    @Override
    public boolean onReceiverStart() {
        RegisterReceiver msg = new RegisterReceiver(this.streamId(), this.receiver.getClass().getSimpleName(), this.host(), this.executorId(), this.endpoint());
        return BoxesRunTime.unboxToBoolean((Object)this.trackerEndpoint().askSync((Object)msg, ClassTag$.MODULE$.Boolean()));
    }

    @Override
    public void onReceiverStop(String message, Option<Throwable> error) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Deregistering receiver ").append(this.streamId()).toString());
        String errorString = (String)error.map((Function1 & Serializable & scala.Serializable)x$1 -> Throwables.getStackTraceAsString((Throwable)x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        this.trackerEndpoint().askSync((Object)new DeregisterReceiver(this.streamId(), message, errorString), ClassTag$.MODULE$.Boolean());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Stopped receiver ").append(this.streamId()).toString());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public BlockGenerator createBlockGenerator(BlockGeneratorListener blockGeneratorListener) {
        void var3_3;
        Iterable stoppedGenerators = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isStopped()));
        stoppedGenerators.foreach((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReceiverSupervisorImpl.$anonfun$createBlockGenerator$2(this, x$4)));
        BlockGenerator newBlockGenerator = new BlockGenerator(blockGeneratorListener, this.streamId(), this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.conf(), BlockGenerator$.MODULE$.$lessinit$greater$default$4());
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().add(newBlockGenerator);
        return var3_3;
    }

    private StreamBlockId nextBlockId() {
        return new StreamBlockId(this.streamId(), this.newBlockId().getAndIncrement());
    }

    public void org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(Time cleanupThreshTime) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Cleaning up blocks older then ").append(cleanupThreshTime).toString());
        this.receivedBlockHandler().cleanupOldBlocks(cleanupThreshTime.milliseconds());
    }

    public static final /* synthetic */ boolean $anonfun$createBlockGenerator$2(ReceiverSupervisorImpl $this, BlockGenerator x$4) {
        return $this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators().remove(x$4);
    }

    public ReceiverSupervisorImpl(Receiver<?> receiver, SparkEnv env, Configuration hadoopConf, Option<String> checkpointDirOption) {
        Logging logging;
        this.receiver = receiver;
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env = env;
        super(receiver, env.conf());
        this.host = SparkEnv$.MODULE$.get().blockManager().blockManagerId().host();
        this.executorId = SparkEnv$.MODULE$.get().blockManager().blockManagerId().executorId();
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(env.conf())) {
            if (checkpointDirOption.isEmpty()) {
                throw new SparkException("Cannot enable receiver write-ahead log without checkpoint directory set. Please use streamingContext.checkpoint() to set the checkpoint directory. See documentation for more details.");
            }
            logging = new WriteAheadLogBasedBlockHandler(env.blockManager(), env.serializerManager(), receiver.streamId(), receiver.storageLevel(), env.conf(), hadoopConf, (String)checkpointDirOption.get(), WriteAheadLogBasedBlockHandler$.MODULE$.$lessinit$greater$default$8());
        } else {
            logging = new BlockManagerBasedBlockHandler(env.blockManager(), receiver.storageLevel());
        }
        this.receivedBlockHandler = logging;
        this.trackerEndpoint = RpcUtils$.MODULE$.makeDriverRef("ReceiverTracker", env.conf(), env.rpcEnv());
        this.endpoint = env.rpcEnv().setupEndpoint(new StringBuilder(10).append("Receiver-").append(this.streamId()).append("-").append(System.currentTimeMillis()).toString(), (RpcEndpoint)new ThreadSafeRpcEndpoint(this){
            private final RpcEnv rpcEnv;
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public final RpcEndpointRef self() {
                return RpcEndpoint.self$((RpcEndpoint)this);
            }

            public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
                return RpcEndpoint.receiveAndReply$((RpcEndpoint)this, (RpcCallContext)context);
            }

            public void onError(Throwable cause) {
                RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
            }

            public void onConnected(RpcAddress remoteAddress) {
                RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
            }

            public void onDisconnected(RpcAddress remoteAddress) {
                RpcEndpoint.onDisconnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
            }

            public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
                RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
            }

            public void onStart() {
                RpcEndpoint.onStart$((RpcEndpoint)this);
            }

            public void onStop() {
                RpcEndpoint.onStop$((RpcEndpoint)this);
            }

            public final void stop() {
                RpcEndpoint.stop$((RpcEndpoint)this);
            }

            public RpcEnv rpcEnv() {
                return this.rpcEnv;
            }

            public PartialFunction<Object, BoxedUnit> receive() {
                return new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anon$1 $outer;

                    public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        if (StopReceiver$.MODULE$.equals(A1)) {
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received stop signal");
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().stop("Stopped by driver", (Option<Throwable>)None$.MODULE$);
                            object = BoxedUnit.UNIT;
                        } else if (A1 instanceof CleanupOldBlocks) {
                            CleanupOldBlocks cleanupOldBlocks = (CleanupOldBlocks)A1;
                            Time threshTime = cleanupOldBlocks.threshTime();
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Received delete old batch signal");
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$cleanupOldBlocks(threshTime);
                            object = BoxedUnit.UNIT;
                        } else if (A1 instanceof UpdateRateLimit) {
                            UpdateRateLimit updateRateLimit = (UpdateRateLimit)A1;
                            long eps = updateRateLimit.elementsPerSecond();
                            this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Received a new rate limit: ").append(eps).append(".").toString());
                            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer().org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators()).asScala()).foreach((Function1 & Serializable & scala.Serializable)bg -> {
                                $anon$1$$anonfun$receive$1.$anonfun$applyOrElse$4(eps, bg);
                                return BoxedUnit.UNIT;
                            });
                            object = BoxedUnit.UNIT;
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Object x1) {
                        Object object = x1;
                        boolean bl = StopReceiver$.MODULE$.equals(object) ? true : (object instanceof CleanupOldBlocks ? true : object instanceof UpdateRateLimit);
                        return bl;
                    }

                    public static final /* synthetic */ void $anonfun$applyOrElse$4(long eps$1, BlockGenerator bg) {
                        bg.updateRate(eps$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(), $anonfun$applyOrElse$2(), $anonfun$applyOrElse$3(long ), $anonfun$applyOrElse$4$adapted(long org.apache.spark.streaming.receiver.BlockGenerator )}, serializedLambda);
                    }
                };
            }

            public /* synthetic */ ReceiverSupervisorImpl org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                RpcEndpoint.$init$((RpcEndpoint)this);
                this.rpcEnv = $outer.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$env.rpcEnv();
            }
        });
        this.newBlockId = new AtomicLong(System.currentTimeMillis());
        this.org$apache$spark$streaming$receiver$ReceiverSupervisorImpl$$registeredBlockGenerators = new ConcurrentLinkedQueue();
        this.defaultBlockGeneratorListener = new BlockGeneratorListener(this){
            private final /* synthetic */ ReceiverSupervisorImpl $outer;

            public void onAddData(Object data, Object metadata) {
            }

            public void onGenerateBlock(StreamBlockId blockId) {
            }

            public void onError(String message, Throwable throwable) {
                this.$outer.reportError(message, throwable);
            }

            public void onPushBlock(StreamBlockId blockId, ArrayBuffer<?> arrayBuffer) {
                this.$outer.pushArrayBuffer(arrayBuffer, (Option<Object>)None$.MODULE$, (Option<StreamBlockId>)new Some((Object)blockId));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.defaultBlockGenerator = this.createBlockGenerator(this.defaultBlockGeneratorListener());
    }
}

