/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3Q!\u0001\u0002\u0001\t1\u0011\u0001#\u00138qkRLeNZ8Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0004gN\u001c7\u0001\u0001\t\u0003;yi\u0011\u0001B\u0005\u0003?\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001bA\u0001\u0007A\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002+\t\fGo\u00195US6,Gk\\%oaV$\u0018J\u001c4pgV\t\u0011\u0006\u0005\u0003+_E\"T\"A\u0016\u000b\u00051j\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003]=\t!bY8mY\u0016\u001cG/[8o\u0013\t\u00014FA\u0004ICNDW*\u00199\u0011\u0005u\u0011\u0014BA\u001a\u0005\u0005\u0011!\u0016.\\3\u0011\t)zS\u0007\u000f\t\u0003\u001dYJ!aN\b\u0003\u0007%sG\u000f\u0005\u0002%s%\u0011!H\u0001\u0002\u0010'R\u0014X-Y7J]B,H/\u00138g_\"1A\b\u0001Q\u0001\n%\naCY1uG\"$\u0016.\\3U_&s\u0007/\u001e;J]\u001a|7\u000f\t\u0005\u0006}\u0001!\taP\u0001\u000be\u0016\u0004xN\u001d;J]\u001a|Gc\u0001!D\u000bB\u0011a\"Q\u0005\u0003\u0005>\u0011A!\u00168ji\")A)\u0010a\u0001c\u0005I!-\u0019;dQRKW.\u001a\u0005\u0006\rv\u0002\r\u0001O\u0001\nS:\u0004X\u000f^%oM>DQ\u0001\u0013\u0001\u0005\u0002%\u000bqaZ3u\u0013:4w\u000e\u0006\u0002K+B!1JU\u001b9\u001d\ta\u0005\u000b\u0005\u0002N\u001f5\taJ\u0003\u0002P7\u00051AH]8pizJ!!U\b\u0002\rA\u0013X\rZ3g\u0013\t\u0019FKA\u0002NCBT!!U\b\t\u000b\u0011;\u0005\u0019A\u0019\t\u000b]\u0003A\u0011\u0001-\u0002\u000f\rdW-\u00198vaR\u0011\u0001)\u0017\u0005\u00065Z\u0003\r!M\u0001\u0010E\u0006$8\r\u001b+ie\u0016\u001c\b\u000eV5nK\u0002")
public class InputInfoTracker
implements Logging {
    private final HashMap<Time, HashMap<Object, StreamInputInfo>> batchTimeToInputInfos;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private HashMap<Time, HashMap<Object, StreamInputInfo>> batchTimeToInputInfos() {
        return this.batchTimeToInputInfos;
    }

    public void reportInfo(Time batchTime, StreamInputInfo inputInfo) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            HashMap inputInfos = (HashMap)this.batchTimeToInputInfos().getOrElseUpdate((Object)batchTime, (Function0 & Serializable & scala.Serializable)() -> new HashMap());
            if (inputInfos.contains((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()))) {
                throw new IllegalStateException(new StringBuilder(24).append("Input stream ").append(inputInfo.inputStreamId()).append(" for batch ").append(new StringBuilder(65).append(batchTime).append(" is already added into InputInfoTracker, this is an illegal state").toString()).toString());
            }
            inputInfos.$plus$eq(new Tuple2((Object)BoxesRunTime.boxToInteger((int)inputInfo.inputStreamId()), (Object)inputInfo));
        }
    }

    public synchronized Map<Object, StreamInputInfo> getInfo(Time batchTime) {
        Option inputInfos = this.batchTimeToInputInfos().get((Object)batchTime);
        return (Map)inputInfos.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toMap(Predef$.MODULE$.$conforms())).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$));
    }

    public void cleanup(Time batchThreshTime) {
        InputInfoTracker inputInfoTracker = this;
        synchronized (inputInfoTracker) {
            Iterable timesToCleanup = (Iterable)this.batchTimeToInputInfos().keys().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.$less(batchThreshTime)));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("remove old batch metadata: ").append(timesToCleanup.mkString(" ")).toString());
            HashMap cfr_ignored_0 = (HashMap)this.batchTimeToInputInfos().$minus$minus$eq((TraversableOnce)timesToCleanup);
        }
    }

    public InputInfoTracker(StreamingContext ssc) {
        Logging.$init$((Logging)this);
        this.batchTimeToInputInfos = new HashMap();
    }
}

