/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SimpleFutureAction;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorCacheTaskLocation;
import org.apache.spark.scheduler.TaskLocation;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.receiver.CleanupOldBlocks;
import org.apache.spark.streaming.receiver.Receiver;
import org.apache.spark.streaming.receiver.ReceiverSupervisorImpl;
import org.apache.spark.streaming.receiver.StopReceiver$;
import org.apache.spark.streaming.receiver.UpdateRateLimit;
import org.apache.spark.streaming.scheduler.AddBlock;
import org.apache.spark.streaming.scheduler.AllReceiverIds$;
import org.apache.spark.streaming.scheduler.DeregisterReceiver;
import org.apache.spark.streaming.scheduler.GetAllReceiverInfo$;
import org.apache.spark.streaming.scheduler.ReceivedBlockInfo;
import org.apache.spark.streaming.scheduler.ReceivedBlockTracker;
import org.apache.spark.streaming.scheduler.ReceiverErrorInfo;
import org.apache.spark.streaming.scheduler.ReceiverSchedulingPolicy;
import org.apache.spark.streaming.scheduler.ReceiverState$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$;
import org.apache.spark.streaming.scheduler.ReceiverTracker$TrackerState$;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo;
import org.apache.spark.streaming.scheduler.ReceiverTrackingInfo$;
import org.apache.spark.streaming.scheduler.RegisterReceiver;
import org.apache.spark.streaming.scheduler.ReportError;
import org.apache.spark.streaming.scheduler.RestartReceiver;
import org.apache.spark.streaming.scheduler.StartAllReceivers;
import org.apache.spark.streaming.scheduler.StopAllReceivers$;
import org.apache.spark.streaming.scheduler.StreamingListenerBus;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverError;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStarted;
import org.apache.spark.streaming.scheduler.StreamingListenerReceiverStopped;
import org.apache.spark.streaming.scheduler.UpdateReceiverRateLimit;
import org.apache.spark.streaming.util.WriteAheadLogUtils$;
import org.apache.spark.util.CallSite;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\ree!B\u0001\u0003\u0001\u0011a!a\u0004*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0005tiJ,\u0017-\\5oO*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xmE\u0002\u0001\u001bM\u0001\"AD\t\u000e\u0003=Q\u0011\u0001E\u0001\u0006g\u000e\fG.Y\u0005\u0003%=\u0011a!\u00118z%\u00164\u0007C\u0001\u000b\u0018\u001b\u0005)\"B\u0001\f\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\r\u0016\u0005\u001daunZ4j]\u001eD\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0004gN\u001c7\u0001\u0001\t\u0003;yi\u0011\u0001B\u0005\u0003?\u0011\u0011\u0001c\u0015;sK\u0006l\u0017N\\4D_:$X\r\u001f;\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\n!c]6jaJ+7-Z5wKJd\u0015-\u001e8dQB\u0011abI\u0005\u0003I=\u0011qAQ8pY\u0016\fg\u000eC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0004Q)Z\u0003CA\u0015\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e&\u0001\u0004a\u0002bB\u0011&!\u0003\u0005\rA\t\u0005\b[\u0001\u0011\r\u0011\"\u0003/\u0003Q\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ngV\tq\u0006E\u0002\u000faIJ!!M\b\u0003\u000b\u0005\u0013(/Y=1\u0005MZ\u0004c\u0001\u001b8s5\tQG\u0003\u00027\t\u00059Am\u001d;sK\u0006l\u0017B\u0001\u001d6\u0005Q\u0011VmY3jm\u0016\u0014\u0018J\u001c9vi\u0012\u001bFO]3b[B\u0011!h\u000f\u0007\u0001\t%a\u0004!!A\u0001\u0002\u000b\u0005\u0011IA\u0002`IaJ!AP \u0002/\u001d,GOU3dK&4XM]%oaV$8\u000b\u001e:fC6\u001c\u0018B\u0001!\u0005\u00051!5\u000b\u001e:fC6<%/\u00199i#\t\u0011U\t\u0005\u0002\u000f\u0007&\u0011Ai\u0004\u0002\b\u001d>$\b.\u001b8h!\tqa)\u0003\u0002H\u001f\t\u0019\u0011I\\=\t\r%\u0003\u0001\u0015!\u00030\u0003U\u0011XmY3jm\u0016\u0014\u0018J\u001c9viN#(/Z1ng\u0002Bqa\u0013\u0001C\u0002\u0013%A*\u0001\fsK\u000e,\u0017N^3s\u0013:\u0004X\u000f^*ue\u0016\fW.\u00133t+\u0005i\u0005c\u0001\b1\u001dB\u0011abT\u0005\u0003!>\u00111!\u00138u\u0011\u0019\u0011\u0006\u0001)A\u0005\u001b\u00069\"/Z2fSZ,'/\u00138qkR\u001cFO]3b[&#7\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0003Q\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6feV\ta\u000b\u0005\u0002*/&\u0011\u0001L\u0001\u0002\u0015%\u0016\u001cW-\u001b<fI\ncwnY6Ue\u0006\u001c7.\u001a:\t\ri\u0003\u0001\u0015!\u0003W\u0003U\u0011XmY3jm\u0016$'\t\\8dWR\u0013\u0018mY6fe\u0002Bq\u0001\u0018\u0001C\u0002\u0013%Q,A\u0006mSN$XM\\3s\u0005V\u001cX#\u00010\u0011\u0005%z\u0016B\u00011\u0003\u0005Q\u0019FO]3b[&tw\rT5ti\u0016tWM\u001d\"vg\"1!\r\u0001Q\u0001\ny\u000bA\u0002\\5ti\u0016tWM\u001d\"vg\u0002:Q\u0001\u001a\u0001\t\u0002\u0015\fA\u0002\u0016:bG.,'o\u0015;bi\u0016\u0004\"AZ4\u000e\u0003\u00011Q\u0001\u001b\u0001\t\u0002%\u0014A\u0002\u0016:bG.,'o\u0015;bi\u0016\u001c\"a\u001a6\u0011\u00059Y\u0017B\u00017\u0010\u0005-)e.^7fe\u0006$\u0018n\u001c8\t\u000b\u0019:G\u0011\u00018\u0015\u0003\u0015,A\u0001[4\u0001aB\u0011\u0011O]\u0007\u0002O&\u00111o\u001b\u0002\u0006-\u0006dW/\u001a\u0005\bk\u001e\u0014\r\u0011\"\u0001w\u0003-Ie.\u001b;jC2L'0\u001a3\u0016\u0003ADa\u0001_4!\u0002\u0013\u0001\u0018\u0001D%oSRL\u0017\r\\5{K\u0012\u0004\u0003b\u0002>h\u0005\u0004%\tA^\u0001\b'R\f'\u000f^3e\u0011\u0019ax\r)A\u0005a\u0006A1\u000b^1si\u0016$\u0007\u0005C\u0004\u007fO\n\u0007I\u0011\u0001<\u0002\u0011M#x\u000e\u001d9j]\u001eDq!!\u0001hA\u0003%\u0001/A\u0005Ti>\u0004\b/\u001b8hA!A\u0011QA4C\u0002\u0013\u0005a/A\u0004Ti>\u0004\b/\u001a3\t\u000f\u0005%q\r)A\u0005a\u0006A1\u000b^8qa\u0016$\u0007\u0005C\u0005\u0002\u000e\u0001\u0001\r\u0011\"\u0003\u0002\u0010\u0005aAO]1dW\u0016\u00148\u000b^1uKV\u0011\u0011\u0011\u0003\t\u0004\u0003'\u0011hB\u00014d\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\"\u0001\tue\u0006\u001c7.\u001a:Ti\u0006$Xm\u0018\u0013fcR!\u00111DA\u0011!\rq\u0011QD\u0005\u0004\u0003?y!\u0001B+oSRD!\"a\t\u0002\u0016\u0005\u0005\t\u0019AA\t\u0003\rAH%\r\u0005\t\u0003O\u0001\u0001\u0015)\u0003\u0002\u0012\u0005iAO]1dW\u0016\u00148\u000b^1uK\u0002BC!!\n\u0002,A\u0019a\"!\f\n\u0007\u0005=rB\u0001\u0005w_2\fG/\u001b7f\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)$\u0001\u0005f]\u0012\u0004x.\u001b8u+\t\t9\u0004\u0005\u0003\u0002:\u0005}RBAA\u001e\u0015\r\tiDB\u0001\u0004eB\u001c\u0017\u0002BA!\u0003w\u0011aB\u00159d\u000b:$\u0007o\\5oiJ+g\rC\u0005\u0002F\u0001\u0001\r\u0011\"\u0003\u0002H\u0005aQM\u001c3q_&tGo\u0018\u0013fcR!\u00111DA%\u0011)\t\u0019#a\u0011\u0002\u0002\u0003\u0007\u0011q\u0007\u0005\t\u0003\u001b\u0002\u0001\u0015)\u0003\u00028\u0005IQM\u001c3q_&tG\u000f\t\u0005\n\u0003#\u0002!\u0019!C\u0005\u0003'\n\u0001c]2iK\u0012,H.\u001b8h!>d\u0017nY=\u0016\u0005\u0005U\u0003cA\u0015\u0002X%\u0019\u0011\u0011\f\u0002\u00031I+7-Z5wKJ\u001c6\r[3ek2Lgn\u001a)pY&\u001c\u0017\u0010\u0003\u0005\u0002^\u0001\u0001\u000b\u0011BA+\u0003E\u00198\r[3ek2Lgn\u001a)pY&\u001c\u0017\u0010\t\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003G\nAC]3dK&4XM\u001d&pE\u0016C\u0018\u000e\u001e'bi\u000eDWCAA3!\u0011\t9'!\u001e\u000e\u0005\u0005%$\u0002BA6\u0003[\n!bY8oGV\u0014(/\u001a8u\u0015\u0011\ty'!\u001d\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0003g\nAA[1wC&!\u0011qOA5\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"a\u001f\u0001A\u0003%\u0011QM\u0001\u0016e\u0016\u001cW-\u001b<fe*{'-\u0012=ji2\u000bGo\u00195!\u0011%\ty\b\u0001b\u0001\n\u0013\t\t)A\u000bsK\u000e,\u0017N^3s)J\f7m[5oO&sgm\\:\u0016\u0005\u0005\r\u0005cBAC\u0003\u001fs\u00151S\u0007\u0003\u0003\u000fSA!!#\u0002\f\u00069Q.\u001e;bE2,'bAAG\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u0015q\u0011\u0002\b\u0011\u0006\u001c\b.T1q!\rI\u0013QS\u0005\u0004\u0003/\u0013!\u0001\u0006*fG\u0016Lg/\u001a:Ue\u0006\u001c7.\u001b8h\u0013:4w\u000e\u0003\u0005\u0002\u001c\u0002\u0001\u000b\u0011BAB\u0003Y\u0011XmY3jm\u0016\u0014HK]1dW&tw-\u00138g_N\u0004\u0003\"CAP\u0001\t\u0007I\u0011BAQ\u0003i\u0011XmY3jm\u0016\u0014\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t+\t\t\u0019\u000bE\u0004\u0002\u0006\u0006=e*!*\u0011\u000b9\t9+a+\n\u0007\u0005%vB\u0001\u0004PaRLwN\u001c\t\u0005\u0003[\u000bYL\u0004\u0003\u00020\u0006]\u0006cAAY\u001f5\u0011\u00111\u0017\u0006\u0004\u0003k[\u0012A\u0002\u001fs_>$h(C\u0002\u0002:>\ta\u0001\u0015:fI\u00164\u0017\u0002BA_\u0003\u007f\u0013aa\u0015;sS:<'bAA]\u001f!A\u00111\u0019\u0001!\u0002\u0013\t\u0019+A\u000esK\u000e,\u0017N^3s!J,g-\u001a:sK\u0012dunY1uS>t7\u000f\t\u0005\b\u0003\u000f\u0004A\u0011AAe\u0003\u0015\u0019H/\u0019:u)\t\tY\u0002C\u0004\u0002N\u0002!\t!a4\u0002\tM$x\u000e\u001d\u000b\u0005\u00037\t\t\u000eC\u0004\u0002T\u0006-\u0007\u0019\u0001\u0012\u0002\u0011\u001d\u0014\u0018mY3gk2Dq!a6\u0001\t\u0003\tI.A\u000bbY2|7-\u0019;f\u00052|7m[:U_\n\u000bGo\u00195\u0015\t\u0005m\u00111\u001c\u0005\t\u0003;\f)\u000e1\u0001\u0002`\u0006I!-\u0019;dQRKW.\u001a\t\u0004;\u0005\u0005\u0018bAAr\t\t!A+[7f\u0011\u001d\t9\u000f\u0001C\u0001\u0003S\f\u0001cZ3u\u00052|7m[:PM\n\u000bGo\u00195\u0015\t\u0005-(\u0011\u0002\t\b\u0003[\u000biOTAy\u0013\u0011\ty/a0\u0003\u00075\u000b\u0007\u000f\u0005\u0004\u0002t\u0006u(1\u0001\b\u0005\u0003k\fIP\u0004\u0003\u00022\u0006]\u0018\"\u0001\t\n\u0007\u0005mx\"A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}(\u0011\u0001\u0002\u0004'\u0016\f(bAA~\u001fA\u0019\u0011F!\u0002\n\u0007\t\u001d!AA\tSK\u000e,\u0017N^3e\u00052|7m[%oM>D\u0001\"!8\u0002f\u0002\u0007\u0011q\u001c\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0003e9W\r\u001e\"m_\u000e\\7o\u00144CCR\u001c\u0007.\u00118e'R\u0014X-Y7\u0015\r\u0005E(\u0011\u0003B\n\u0011!\tiNa\u0003A\u0002\u0005}\u0007b\u0002B\u000b\u0005\u0017\u0001\rAT\u0001\tgR\u0014X-Y7JI\"9!\u0011\u0004\u0001\u0005\u0002\tm\u0011AG2mK\u0006tW\u000f](mI\ncwnY6t\u0003:$')\u0019;dQ\u0016\u001cH\u0003BA\u000e\u0005;A\u0001Ba\b\u0003\u0018\u0001\u0007\u0011q\\\u0001\u0012G2,\u0017M\\;q)\"\u0014Xm\u001d5US6,\u0007b\u0002B\u0012\u0001\u0011\u0005!QE\u0001\u0013C2dwnY1uK\u0012,\u00050Z2vi>\u00148\u000f\u0006\u0002\u0003(A9\u0011QVAw\u001d\u0006\u0015\u0006b\u0002B\u0016\u0001\u0011\u0005!QF\u0001\r]Vl'+Z2fSZ,'o\u001d\u000b\u0002\u001d\"9!\u0011\u0007\u0001\u0005\n\tM\u0012\u0001\u0005:fO&\u001cH/\u001a:SK\u000e,\u0017N^3s)5\u0011#Q\u0007B\u001c\u0005w\u0011yDa\u0011\u0003H!9!Q\u0003B\u0018\u0001\u0004q\u0005\u0002\u0003B\u001d\u0005_\u0001\r!a+\u0002\u0007QL\b\u000f\u0003\u0005\u0003>\t=\u0002\u0019AAV\u0003\u0011Awn\u001d;\t\u0011\t\u0005#q\u0006a\u0001\u0003W\u000b!\"\u001a=fGV$xN]%e\u0011!\u0011)Ea\fA\u0002\u0005]\u0012\u0001\u0005:fG\u0016Lg/\u001a:F]\u0012\u0004x.\u001b8u\u0011!\u0011IEa\fA\u0002\t-\u0013!D:f]\u0012,'/\u00113ee\u0016\u001c8\u000f\u0005\u0003\u0002:\t5\u0013\u0002\u0002B(\u0003w\u0011!B\u00159d\u0003\u0012$'/Z:t\u0011\u001d\u0011\u0019\u0006\u0001C\u0005\u0005+\n!\u0003Z3sK\u001eL7\u000f^3s%\u0016\u001cW-\u001b<feRA\u00111\u0004B,\u00053\u0012i\u0006C\u0004\u0003\u0016\tE\u0003\u0019\u0001(\t\u0011\tm#\u0011\u000ba\u0001\u0003W\u000bq!\\3tg\u0006<W\r\u0003\u0005\u0003`\tE\u0003\u0019AAV\u0003\u0015)'O]8s\u0011\u001d\u0011\u0019\u0007\u0001C\u0001\u0005K\nab]3oIJ\u000bG/Z+qI\u0006$X\r\u0006\u0004\u0002\u001c\t\u001d$1\u000e\u0005\b\u0005S\u0012\t\u00071\u0001O\u0003%\u0019HO]3b[VKE\t\u0003\u0005\u0003n\t\u0005\u0004\u0019\u0001B8\u0003\u001dqWm\u001e*bi\u0016\u00042A\u0004B9\u0013\r\u0011\u0019h\u0004\u0002\u0005\u0019>tw\rC\u0004\u0003x\u0001!IA!\u001f\u0002\u0011\u0005$GM\u00117pG.$2A\tB>\u0011!\u0011iH!\u001eA\u0002\t\r\u0011!\u0005:fG\u0016Lg/\u001a3CY>\u001c7.\u00138g_\"9!\u0011\u0011\u0001\u0005\n\t\r\u0015a\u0003:fa>\u0014H/\u0012:s_J$\u0002\"a\u0007\u0003\u0006\n\u001d%\u0011\u0012\u0005\b\u0005+\u0011y\b1\u0001O\u0011!\u0011YFa A\u0002\u0005-\u0006\u0002\u0003B0\u0005\u007f\u0002\r!a+\t\u000f\t5\u0005\u0001\"\u0003\u0003\u0010\u0006\u00012o\u00195fIVdWMU3dK&4XM\u001d\u000b\u0005\u0005#\u0013i\n\u0005\u0004\u0002t\u0006u(1\u0013\t\u0005\u0005+\u0013I*\u0004\u0002\u0003\u0018*\u00111AB\u0005\u0005\u00057\u00139J\u0001\u0007UCN\\Gj\\2bi&|g\u000eC\u0004\u0003 \n-\u0005\u0019\u0001(\u0002\u0015I,7-Z5wKJLE\rC\u0004\u0003$\u0002!IA!*\u0002AU\u0004H-\u0019;f%\u0016\u001cW-\u001b<feN\u001b\u0007.\u001a3vY\u0016$W\t_3dkR|'o\u001d\u000b\u0007\u00037\u00119K!+\t\u000f\t}%\u0011\u0015a\u0001\u001d\"A!1\u0016BQ\u0001\u0004\u0011\t*\u0001\ntG\",G-\u001e7fI2{7-\u0019;j_:\u001c\bb\u0002BX\u0001\u0011\u0005!\u0011W\u0001\u0015Q\u0006\u001cXK\\1mY>\u001c\u0017\r^3e\u00052|7m[:\u0016\u0003\tBqA!.\u0001\t\u0013\u00119,\u0001\u0007hKR,\u00050Z2vi>\u00148/\u0006\u0002\u0003:B1\u00111_A\u007f\u0005w\u0003BA!&\u0003>&!!q\u0018BL\u0005e)\u00050Z2vi>\u00148)Y2iKR\u000b7o\u001b'pG\u0006$\u0018n\u001c8\t\u000f\t\r\u0007\u0001\"\u0003\u0002J\u0006\u0001\"/\u001e8Ek6l\u0017p\u00159be.TuN\u0019\u0005\b\u0005\u000f\u0004A\u0011BAe\u0003=a\u0017-\u001e8dQJ+7-Z5wKJ\u001c\bb\u0002Bf\u0001\u0011%!\u0011W\u0001\u0011SN$&/Y2lKJ\u001cF/\u0019:uK\u0012DqAa4\u0001\t\u0013\u0011\t,A\tjgR\u0013\u0018mY6feN#x\u000e\u001d9j]\u001eDqAa5\u0001\t\u0013\u0011\t,\u0001\tjgR\u0013\u0018mY6feN#x\u000e\u001d9fI\u001a1!q\u001b\u0001\u0005\u00053\u0014qCU3dK&4XM\u001d+sC\u000e\\WM]#oIB|\u0017N\u001c;\u0014\u000b\tUWBa7\u0011\t\u0005e\"Q\\\u0005\u0005\u0005?\fYDA\u000bUQJ,\u0017\rZ*bM\u0016\u0014\u0006oY#oIB|\u0017N\u001c;\t\u0017\t\r(Q\u001bBC\u0002\u0013\u0005#Q]\u0001\u0007eB\u001cWI\u001c<\u0016\u0005\t\u001d\b\u0003BA\u001d\u0005SLAAa;\u0002<\t1!\u000b]2F]ZD1Ba<\u0003V\n\u0005\t\u0015!\u0003\u0003h\u00069!\u000f]2F]Z\u0004\u0003b\u0002\u0014\u0003V\u0012\u0005!1\u001f\u000b\u0005\u0005k\u00149\u0010E\u0002g\u0005+D\u0001Ba9\u0003r\u0002\u0007!q\u001d\u0005\u000b\u0005w\u0014)N1A\u0005\n\tu\u0018!F<bY\n\u000bGo\u00195j]\u001e$\u0006N]3bIB{w\u000e\\\u000b\u0003\u0005\u007f\u0004Ba!\u0001\u0004\u00065\u001111\u0001\u0006\u0004\u0003Wz\u0011\u0002BB\u0004\u0007\u0007\u0011q$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0011%\u0019YA!6!\u0002\u0013\u0011y0\u0001\fxC2\u0014\u0015\r^2iS:<G\u000b\u001b:fC\u0012\u0004vn\u001c7!\u0011)\u0019yA!6A\u0002\u0013%!\u0011W\u0001\u0007C\u000e$\u0018N^3\t\u0015\rM!Q\u001ba\u0001\n\u0013\u0019)\"\u0001\u0006bGRLg/Z0%KF$B!a\u0007\u0004\u0018!I\u00111EB\t\u0003\u0003\u0005\rA\t\u0005\t\u00077\u0011)\u000e)Q\u0005E\u00059\u0011m\u0019;jm\u0016\u0004\u0003\u0006BB\r\u0003WA\u0001b!\t\u0003V\u0012\u000531E\u0001\be\u0016\u001cW-\u001b<f+\t\u0019)\u0003\u0005\u0004\u000f\u0007O)\u00151D\u0005\u0004\u0007Sy!a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\t\u0011\r5\"Q\u001bC!\u0007_\tqB]3dK&4X-\u00118e%\u0016\u0004H.\u001f\u000b\u0005\u0007K\u0019\t\u0004\u0003\u0005\u00044\r-\u0002\u0019AB\u001b\u0003\u001d\u0019wN\u001c;fqR\u0004B!!\u000f\u00048%!1\u0011HA\u001e\u00059\u0011\u0006oY\"bY2\u001cuN\u001c;fqRD\u0001b!\u0010\u0003V\u0012%1qH\u0001\u001cO\u0016$8\u000b^8sK\u0012\u001c6\r[3ek2,G-\u0012=fGV$xN]:\u0015\t\tE5\u0011\t\u0005\b\u0005?\u001bY\u00041\u0001O\u0011!\u0019)E!6\u0005\n\r\u001d\u0013!D:uCJ$(+Z2fSZ,'\u000f\u0006\u0004\u0002\u001c\r%3q\f\u0005\t\u0007\u0017\u001a\u0019\u00051\u0001\u0004N\u0005A!/Z2fSZ,'\u000f\r\u0003\u0004P\rm\u0003CBB)\u0007+\u001aI&\u0004\u0002\u0004T)\u001911\n\u0003\n\t\r]31\u000b\u0002\t%\u0016\u001cW-\u001b<feB\u0019!ha\u0017\u0005\u0017\ru3\u0011JA\u0001\u0002\u0003\u0015\t!\u0011\u0002\u0004?\u0012\u001a\u0004\u0002\u0003BV\u0007\u0007\u0002\rA!%\t\u0011\r\r$Q\u001bC!\u0003\u0013\faa\u001c8Ti>\u0004\b\u0002CB4\u0005+$Ia!\u001b\u0002'=t'+Z2fSZ,'OS8c\r&t\u0017n\u001d5\u0015\t\u0005m11\u000e\u0005\b\u0005?\u001b)\u00071\u0001O\u0011!\u0019yG!6\u0005\n\u0005%\u0017!D:u_B\u0014VmY3jm\u0016\u00148o\u0002\u0006\u0004t\t\t\t\u0011#\u0001\u0005\u0007k\nqBU3dK&4XM\u001d+sC\u000e\\WM\u001d\t\u0004S\r]d!C\u0001\u0003\u0003\u0003E\t\u0001BB='\r\u00199(\u0004\u0005\bM\r]D\u0011AB?)\t\u0019)\b\u0003\u0006\u0004\u0002\u000e]\u0014\u0013!C\u0001\u0007\u0007\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCABCU\r\u00113qQ\u0016\u0003\u0007\u0013\u0003Baa#\u0004\u00166\u00111Q\u0012\u0006\u0005\u0007\u001f\u001b\t*A\u0005v]\u000eDWmY6fI*\u001911S\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004\u0018\u000e5%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ReceiverTracker
implements Logging {
    private volatile ReceiverTracker$TrackerState$ TrackerState$module;
    public final StreamingContext org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc;
    private final boolean skipReceiverLaunch;
    private final ReceiverInputDStream<?>[] receiverInputStreams;
    private final int[] receiverInputStreamIds;
    private final ReceivedBlockTracker receivedBlockTracker;
    private final StreamingListenerBus listenerBus;
    private volatile Enumeration.Value trackerState;
    private RpcEndpointRef endpoint;
    private final ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    private final CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    private final HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    private final HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$2() {
        return ReceiverTracker$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public ReceiverTracker$TrackerState$ TrackerState() {
        if (this.TrackerState$module == null) {
            this.TrackerState$lzycompute$1();
        }
        return this.TrackerState$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ReceiverInputDStream<?>[] receiverInputStreams() {
        return this.receiverInputStreams;
    }

    private int[] receiverInputStreamIds() {
        return this.receiverInputStreamIds;
    }

    private ReceivedBlockTracker receivedBlockTracker() {
        return this.receivedBlockTracker;
    }

    private StreamingListenerBus listenerBus() {
        return this.listenerBus;
    }

    private Enumeration.Value trackerState() {
        return this.trackerState;
    }

    private void trackerState_$eq(Enumeration.Value x$1) {
        this.trackerState = x$1;
    }

    private RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    private void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public ReceiverSchedulingPolicy org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy;
    }

    public CountDownLatch org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch;
    }

    public HashMap<Object, ReceiverTrackingInfo> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos;
    }

    public HashMap<Object, Option<String>> org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations() {
        return this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations;
    }

    public synchronized void start() {
        block2: {
            if (this.isTrackerStarted()) {
                throw new SparkException("ReceiverTracker already started");
            }
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).isEmpty()) break block2;
            this.endpoint_$eq(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().setupEndpoint("ReceiverTracker", (RpcEndpoint)new ReceiverTrackerEndpoint(this, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv())));
            if (!this.skipReceiverLaunch) {
                this.launchReceivers();
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ReceiverTracker started");
            this.trackerState_$eq(this.TrackerState().Started());
        }
    }

    public synchronized void stop(boolean graceful) {
        boolean isStarted = this.isTrackerStarted();
        this.trackerState_$eq(this.TrackerState().Stopping());
        if (isStarted) {
            if (!this.skipReceiverLaunch) {
                Seq receivers;
                this.endpoint().askSync((Object)StopAllReceivers$.MODULE$, ClassTag$.MODULE$.Boolean());
                this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await(10L, TimeUnit.SECONDS);
                if (graceful) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waiting for receiver job to terminate gracefully");
                    this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().await();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Waited for receiver job to terminate gracefully");
                }
                if ((receivers = (Seq)this.endpoint().askSync((Object)AllReceiverIds$.MODULE$, ClassTag$.MODULE$.apply(Seq.class))).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Not all of the receivers have deregistered, ").append(receivers).toString());
                } else {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All of the receivers have deregistered successfully");
                }
            }
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.env().rpcEnv().stop(this.endpoint());
            this.endpoint_$eq(null);
        }
        this.receivedBlockTracker().stop();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "ReceiverTracker stopped");
        this.trackerState_$eq(this.TrackerState().Stopped());
    }

    public void allocateBlocksToBatch(Time batchTime) {
        block0: {
            if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).nonEmpty()) break block0;
            this.receivedBlockTracker().allocateBlocksToBatch(batchTime);
        }
    }

    public scala.collection.immutable.Map<Object, Seq<ReceivedBlockInfo>> getBlocksOfBatch(Time batchTime) {
        return this.receivedBlockTracker().getBlocksOfBatch(batchTime);
    }

    public Seq<ReceivedBlockInfo> getBlocksOfBatchAndStream(Time batchTime, int streamId) {
        return this.receivedBlockTracker().getBlocksOfBatchAndStream(batchTime, streamId);
    }

    public void cleanupOldBlocksAndBatches(Time cleanupThreshTime) {
        this.receivedBlockTracker().cleanupOldBatches(cleanupThreshTime, false);
        if (WriteAheadLogUtils$.MODULE$.enableReceiverLog(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf())) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Cleanup old received batch data: ").append(cleanupThreshTime).toString());
            ReceiverTracker receiverTracker = this;
            synchronized (receiverTracker) {
                if (this.isTrackerStarted()) {
                    this.endpoint().send((Object)new CleanupOldBlocks(cleanupThreshTime));
                }
            }
        }
    }

    public synchronized scala.collection.immutable.Map<Object, Option<String>> allocatedExecutors() {
        return this.isTrackerStarted() ? ((scala.collection.immutable.MapLike)this.endpoint().askSync((Object)GetAllReceiverInfo$.MODULE$, ClassTag$.MODULE$.apply(scala.collection.immutable.Map.class))).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.runningExecutor().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.executorId())) : Predef$.MODULE$.Map().empty();
    }

    public int numReceivers() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).size();
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(int streamId, String typ, String host, String executorId, RpcEndpointRef receiverEndpoint, RpcAddress senderAddress) {
        boolean bl;
        Seq<TaskLocation> acceptableExecutors;
        if (!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.receiverInputStreamIds())).contains((Object)BoxesRunTime.boxToInteger((int)streamId))) {
            throw new SparkException(new StringBuilder(36).append("Register received for unexpected id ").append(streamId).toString());
        }
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped()) {
            return false;
        }
        Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)streamId))).scheduledLocations();
        Seq<TaskLocation> seq = acceptableExecutors = scheduledLocations.nonEmpty() ? (Seq<TaskLocation>)scheduledLocations.get() : this.scheduleReceiver(streamId);
        if (!ReceiverTracker.isAcceptable$1(host, executorId, acceptableExecutors)) {
            bl = false;
        } else {
            String name = new StringBuilder(1).append(typ).append("-").append(streamId).toString();
            ReceiverTrackingInfo receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.ACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)new Some((Object)new ExecutorCacheTaskLocation(host, executorId)), (Option<String>)new Some((Object)name), (Option<RpcEndpointRef>)new Some((Object)receiverEndpoint), ReceiverTrackingInfo$.MODULE$.apply$default$7());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)receiverTrackingInfo);
            this.listenerBus().post(new StreamingListenerReceiverStarted(receiverTrackingInfo.toReceiverInfo()));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Registered receiver for stream ").append(streamId).append(" from ").append(senderAddress).toString());
            bl = true;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(int streamId, String message, String error) {
        if (error == null) ** GOTO lbl-1000
        v0 = error;
        var7_4 = "";
        if (!(v0 != null ? v0.equals(var7_4) == false : var7_4 != null)) lbl-1000:
        // 2 sources

        {
            v1 = -1L;
        } else {
            v1 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis();
        }
        lastErrorTime = v1;
        errorInfo = new ReceiverErrorInfo(message, error, lastErrorTime);
        var10_7 = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
        if (var10_7 instanceof Some) {
            var11_8 = (Some)var10_7;
            oldInfo = (ReceiverTrackingInfo)var11_8.value();
            x$15 = ReceiverState$.MODULE$.INACTIVE();
            x$16 = new Some((Object)errorInfo);
            x$17 = oldInfo.copy$default$1();
            x$18 = oldInfo.copy$default$3();
            x$19 = oldInfo.copy$default$4();
            x$20 = oldInfo.copy$default$5();
            x$21 = oldInfo.copy$default$6();
            var4_17 = oldInfo.copy(x$17, x$15, x$18, x$19, x$20, x$21, (Option<ReceiverErrorInfo>)x$16);
        } else if (None$.MODULE$.equals(var10_7)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$deregisterReceiver$1(), ()Ljava/lang/String;)());
            var4_17 = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
        } else {
            throw new MatchError((Object)var10_7);
        }
        newReceiverTrackingInfo = var4_17;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
        this.listenerBus().post(new StreamingListenerReceiverStopped(newReceiverTrackingInfo.toReceiverInfo()));
        messageWithError = error != null && error.isEmpty() == false ? new StringBuilder(3).append(message).append(" - ").append(error).toString() : String.valueOf(message);
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$deregisterReceiver$2(int java.lang.String ), ()Ljava/lang/String;)((int)streamId, (String)messageWithError));
    }

    public synchronized void sendRateUpdate(int streamUID, long newRate) {
        block0: {
            if (!this.isTrackerStarted()) break block0;
            this.endpoint().send((Object)new UpdateReceiverRateLimit(streamUID, newRate));
        }
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(ReceivedBlockInfo receivedBlockInfo) {
        return this.receivedBlockTracker().addBlock(receivedBlockInfo);
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(int streamId, String message, String error) {
        ReceiverTrackingInfo receiverTrackingInfo;
        Option option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamId));
        if (option instanceof Some) {
            Some some = (Some)option;
            ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.value();
            ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, BoxesRunTime.unboxToLong((Object)oldInfo.errorInfo().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.lastErrorTime())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
            Some x$22 = new Some((Object)errorInfo);
            int x$23 = oldInfo.copy$default$1();
            Enumeration.Value x$24 = oldInfo.copy$default$2();
            Option<Seq<TaskLocation>> x$25 = oldInfo.copy$default$3();
            Option<ExecutorCacheTaskLocation> x$26 = oldInfo.copy$default$4();
            Option<String> x$27 = oldInfo.copy$default$5();
            Option<RpcEndpointRef> x$28 = oldInfo.copy$default$6();
            receiverTrackingInfo = oldInfo.copy(x$23, x$24, x$25, x$26, x$27, x$28, (Option<ReceiverErrorInfo>)x$22);
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No prior receiver info");
            ReceiverErrorInfo errorInfo = new ReceiverErrorInfo(message, error, this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.scheduler().clock().getTimeMillis());
            receiverTrackingInfo = new ReceiverTrackingInfo(streamId, ReceiverState$.MODULE$.INACTIVE(), (Option<Seq<TaskLocation>>)None$.MODULE$, (Option<ExecutorCacheTaskLocation>)None$.MODULE$, (Option<String>)None$.MODULE$, (Option<RpcEndpointRef>)None$.MODULE$, (Option<ReceiverErrorInfo>)new Some((Object)errorInfo));
        } else {
            throw new MatchError((Object)option);
        }
        ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)streamId), (Object)newReceiverTrackingInfo);
        this.listenerBus().post(new StreamingListenerReceiverError(newReceiverTrackingInfo.toReceiverInfo()));
        String messageWithError = error != null && !error.isEmpty() ? new StringBuilder(3).append(message).append(" - ").append(error).toString() : String.valueOf(message);
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Error reported by receiver for stream ").append(streamId).append(": ").append(messageWithError).toString());
    }

    /*
     * WARNING - void declaration
     */
    private Seq<TaskLocation> scheduleReceiver(int receiverId) {
        void var3_3;
        Option preferredLocation = (Option)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().getOrElse((Object)BoxesRunTime.boxToInteger((int)receiverId), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        Seq<TaskLocation> scheduledLocations = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiverId, (Option<String>)preferredLocation, (Map<Object, ReceiverTrackingInfo>)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiverId, scheduledLocations);
        return var3_3;
    }

    public void org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(int receiverId, Seq<TaskLocation> scheduledLocations) {
        ReceiverTrackingInfo receiverTrackingInfo;
        Option option = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)receiverId));
        if (option instanceof Some) {
            Some some = (Some)option;
            ReceiverTrackingInfo oldInfo = (ReceiverTrackingInfo)some.value();
            Enumeration.Value x$29 = ReceiverState$.MODULE$.SCHEDULED();
            Some x$30 = new Some(scheduledLocations);
            int x$31 = oldInfo.copy$default$1();
            Option<ExecutorCacheTaskLocation> x$32 = oldInfo.copy$default$4();
            Option<String> x$33 = oldInfo.copy$default$5();
            Option<RpcEndpointRef> x$34 = oldInfo.copy$default$6();
            Option<ReceiverErrorInfo> x$35 = oldInfo.copy$default$7();
            receiverTrackingInfo = oldInfo.copy(x$31, x$29, (Option<Seq<TaskLocation>>)x$30, x$32, x$33, x$34, x$35);
        } else if (None$.MODULE$.equals(option)) {
            receiverTrackingInfo = new ReceiverTrackingInfo(receiverId, ReceiverState$.MODULE$.SCHEDULED(), (Option<Seq<TaskLocation>>)new Some(scheduledLocations), (Option<ExecutorCacheTaskLocation>)None$.MODULE$, ReceiverTrackingInfo$.MODULE$.apply$default$5(), ReceiverTrackingInfo$.MODULE$.apply$default$6(), ReceiverTrackingInfo$.MODULE$.apply$default$7());
        } else {
            throw new MatchError((Object)option);
        }
        ReceiverTrackingInfo newReceiverTrackingInfo = receiverTrackingInfo;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().put((Object)BoxesRunTime.boxToInteger((int)receiverId), (Object)newReceiverTrackingInfo);
    }

    public boolean hasUnallocatedBlocks() {
        return this.receivedBlockTracker().hasUnallocatedReceivedBlocks();
    }

    public Seq<ExecutorCacheTaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors() {
        Seq seq;
        if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().isLocal()) {
            BlockManagerId blockManagerId = this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().blockManagerId();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ExecutorCacheTaskLocation[]{new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId())}));
        } else {
            seq = ((TraversableOnce)((TraversableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().env().blockManager().master().getMemoryStatus().filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTracker.$anonfun$getExecutors$1(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
                ExecutorCacheTaskLocation executorCacheTaskLocation = new ExecutorCacheTaskLocation(blockManagerId.host(), blockManagerId.executorId());
                return executorCacheTaskLocation;
            }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        }
        return seq;
    }

    private void runDummySparkJob() {
        Object object = !this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().isLocal() ? RDD$.MODULE$.rddToPairRDDFunctions(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().makeRDD((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 50), 50, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)x -> ReceiverTracker.$anonfun$runDummySparkJob$1(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6, 20).collect() : BoxedUnit.UNIT;
        Predef$.MODULE$.assert(this.org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().nonEmpty());
    }

    private void launchReceivers() {
        Receiver[] receivers = (Receiver[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).map((Function1 & Serializable & scala.Serializable)nis -> {
            void var1_1;
            Receiver rcvr = nis.getReceiver();
            rcvr.setReceiverId(nis.id());
            return var1_1;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Receiver.class)));
        this.runDummySparkJob();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Starting ").append(receivers.length).append(" receivers").toString());
        this.endpoint().send((Object)new StartAllReceivers((Seq<Receiver<?>>)Predef$.MODULE$.wrapRefArray((Object[])receivers)));
    }

    private boolean isTrackerStarted() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Started();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopping();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped() {
        Enumeration.Value value = this.trackerState();
        Enumeration.Value value2 = this.TrackerState().Stopped();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    private final void TrackerState$lzycompute$1() {
        ReceiverTracker receiverTracker = this;
        synchronized (receiverTracker) {
            if (this.TrackerState$module == null) {
                this.TrackerState$module = new ReceiverTracker$TrackerState$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$registerReceiver$1(String host$1, String executorId$1, TaskLocation x0$1) {
        boolean bl;
        TaskLocation taskLocation = x0$1;
        if (taskLocation instanceof ExecutorCacheTaskLocation) {
            ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
            String string = executorCacheTaskLocation.executorId();
            String string2 = executorId$1;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else if (taskLocation != null) {
            TaskLocation taskLocation2 = taskLocation;
            String string = taskLocation2.host();
            String string3 = host$1;
            bl = !(string != null ? !string.equals(string3) : string3 != null);
        } else {
            throw new MatchError((Object)taskLocation);
        }
        return bl;
    }

    private static final boolean isAcceptable$1(String host$1, String executorId$1, Seq acceptableExecutors$1) {
        return acceptableExecutors$1.exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTracker.$anonfun$registerReceiver$1(host$1, executorId$1, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$deregisterReceiver$1() {
        return "No prior receiver info";
    }

    public static final /* synthetic */ String $anonfun$deregisterReceiver$2(int streamId$2, String messageWithError$1) {
        return new StringBuilder(35).append("Deregistered receiver for stream ").append(streamId$2).append(": ").append(messageWithError$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$getExecutors$1(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BlockManagerId blockManagerId = (BlockManagerId)tuple2._1();
        String string = blockManagerId.executorId();
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        boolean bl = string == null ? string2 != null : !string.equals(string2);
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$runDummySparkJob$1(int x) {
        return new Tuple2.mcII.sp(x, 1);
    }

    public ReceiverTracker(StreamingContext ssc, boolean skipReceiverLaunch) {
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc = ssc;
        this.skipReceiverLaunch = skipReceiverLaunch;
        Logging.$init$((Logging)this);
        this.receiverInputStreams = ssc.graph().getReceiverInputStreams();
        this.receiverInputStreamIds = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.receiverInputStreams())).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        this.receivedBlockTracker = new ReceivedBlockTracker(ssc.sparkContext().conf(), ssc.sparkContext().hadoopConfiguration(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(this.receiverInputStreamIds()), ssc.scheduler().clock(), ssc.isCheckpointPresent(), (Option<String>)Option$.MODULE$.apply((Object)ssc.checkpointDir()));
        this.listenerBus = ssc.scheduler().listenerBus();
        this.trackerState = this.TrackerState().Initialized();
        this.endpoint = null;
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy = new ReceiverSchedulingPolicy();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch = new CountDownLatch(this.receiverInputStreams().length);
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos = new HashMap();
        this.org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations = new HashMap();
    }

    public class ReceiverTrackerEndpoint
    implements ThreadSafeRpcEndpoint {
        private final RpcEnv rpcEnv;
        private final ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        private volatile boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        public final /* synthetic */ ReceiverTracker $outer;

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            RpcEndpoint.onDisconnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public ExecutionContextExecutorService org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool;
        }

        public boolean org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active() {
            return this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active;
        }

        private void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(boolean x$1) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = x$1;
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof StartAllReceivers) {
                        StartAllReceivers startAllReceivers = (StartAllReceivers)A1;
                        Seq<Receiver<?>> receivers = startAllReceivers.receiver();
                        Map<Object, Seq<TaskLocation>> scheduledLocations = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().scheduleReceivers(receivers, this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        receivers.foreach((Function1 & Serializable & scala.Serializable)receiver -> {
                            ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$1(this, scheduledLocations, receiver);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof RestartReceiver) {
                        Seq<TaskLocation> seq;
                        RestartReceiver restartReceiver = (RestartReceiver)A1;
                        Receiver<?> receiver2 = restartReceiver.receiver();
                        Seq<TaskLocation> oldScheduledExecutors = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(receiver2.streamId());
                        if (oldScheduledExecutors.nonEmpty()) {
                            seq = oldScheduledExecutors;
                        } else {
                            ReceiverTrackingInfo oldReceiverInfo = (ReceiverTrackingInfo)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiver2.streamId()));
                            Enumeration.Value x$36 = ReceiverState$.MODULE$.INACTIVE();
                            None$ x$37 = None$.MODULE$;
                            int x$38 = oldReceiverInfo.copy$default$1();
                            Option<ExecutorCacheTaskLocation> x$39 = oldReceiverInfo.copy$default$4();
                            Option<String> x$40 = oldReceiverInfo.copy$default$5();
                            Option<RpcEndpointRef> x$41 = oldReceiverInfo.copy$default$6();
                            Option<ReceiverErrorInfo> x$42 = oldReceiverInfo.copy$default$7();
                            ReceiverTrackingInfo newReceiverInfo = oldReceiverInfo.copy(x$38, x$36, (Option<Seq<TaskLocation>>)x$37, x$39, x$40, x$41, x$42);
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().update((Object)BoxesRunTime.boxToInteger((int)receiver2.streamId()), (Object)newReceiverInfo);
                            seq = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$schedulingPolicy().rescheduleReceiver(receiver2.streamId(), receiver2.preferredLocation(), (Map<Object, ReceiverTrackingInfo>)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos(), this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors());
                        }
                        Seq<TaskLocation> scheduledLocations = seq;
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver2, scheduledLocations);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CleanupOldBlocks) {
                        CleanupOldBlocks cleanupOldBlocks = (CleanupOldBlocks)A1;
                        ((IterableLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1 & Serializable & scala.Serializable)x$7 -> Option$.MODULE$.option2Iterable(x$7.endpoint()), scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                            ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$3(cleanupOldBlocks, x$8);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof UpdateReceiverRateLimit) {
                        UpdateReceiverRateLimit updateReceiverRateLimit = (UpdateReceiverRateLimit)A1;
                        int streamUID = updateReceiverRateLimit.streamUID();
                        long newRate = updateReceiverRateLimit.newRate();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().get((Object)BoxesRunTime.boxToInteger((int)streamUID)).foreach((Function1 & Serializable & scala.Serializable)info -> {
                            ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$4(newRate, info);
                            return BoxedUnit.UNIT;
                        });
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ReportError) {
                        ReportError reportError = (ReportError)A1;
                        int streamId = reportError.streamId();
                        String message = reportError.message();
                        String error = reportError.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$reportError(streamId, message, error);
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof StartAllReceivers ? true : (object instanceof RestartReceiver ? true : (object instanceof CleanupOldBlocks ? true : (object instanceof UpdateReceiverRateLimit ? true : object instanceof ReportError)));
                    return bl;
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$1(ReceiverTrackerEndpoint$$anonfun$receive$1 $this, Map scheduledLocations$1, Receiver receiver) {
                    Seq executors = (Seq)scheduledLocations$1.apply((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()));
                    $this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$updateReceiverScheduledExecutors(receiver.streamId(), (Seq<TaskLocation>)executors);
                    $this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverPreferredLocations().update((Object)BoxesRunTime.boxToInteger((int)receiver.streamId()), receiver.preferredLocation());
                    $this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(receiver, (Seq<TaskLocation>)executors);
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$3(CleanupOldBlocks x6$1, RpcEndpointRef x$8) {
                    x$8.send((Object)x6$1);
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$5(long newRate$1, RpcEndpointRef eP) {
                    eP.send((Object)new UpdateRateLimit(newRate$1));
                }

                public static final /* synthetic */ void $anonfun$applyOrElse$4(long newRate$1, ReceiverTrackingInfo info) {
                    info.endpoint().foreach((Function1 & Serializable & scala.Serializable)eP -> {
                        ReceiverTrackerEndpoint$$anonfun$receive$1.$anonfun$applyOrElse$5(newRate$1, eP);
                        return BoxedUnit.UNIT;
                    });
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receive$1 scala.collection.Map org.apache.spark.streaming.receiver.Receiver ), $anonfun$applyOrElse$2(org.apache.spark.streaming.scheduler.ReceiverTrackingInfo ), $anonfun$applyOrElse$3$adapted(org.apache.spark.streaming.receiver.CleanupOldBlocks org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$4$adapted(long org.apache.spark.streaming.scheduler.ReceiverTrackingInfo ), $anonfun$applyOrElse$5$adapted(long org.apache.spark.rpc.RpcEndpointRef )}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReceiverTrackerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof RegisterReceiver) {
                        RegisterReceiver registerReceiver = (RegisterReceiver)A1;
                        int streamId = registerReceiver.streamId();
                        String typ = registerReceiver.typ();
                        String host = registerReceiver.host();
                        String executorId = registerReceiver.executorId();
                        RpcEndpointRef receiverEndpoint = registerReceiver.receiverEndpoint();
                        boolean successful = this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$registerReceiver(streamId, typ, host, executorId, receiverEndpoint, this.context$1.senderAddress());
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)successful));
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof AddBlock) {
                        BoxedUnit boxedUnit;
                        AddBlock addBlock = (AddBlock)A1;
                        ReceivedBlockInfo receivedBlockInfo = addBlock.receivedBlockInfo();
                        if (WriteAheadLogUtils$.MODULE$.isBatchingEnabled(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.conf(), true)) {
                            this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().execute(new Runnable(this, receivedBlockInfo){
                                private final /* synthetic */ ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final ReceivedBlockInfo receivedBlockInfo$1;

                                public void run() {
                                    Utils$.MODULE$.tryLogNonFatalError((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                                        if ($this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active()) {
                                            $this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)$this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock($this.receivedBlockInfo$1)));
                                        } else {
                                            $this.$outer.context$1.sendFailure((Throwable)new IllegalStateException("ReceiverTracker RpcEndpoint already shut down."));
                                        }
                                    });
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.receivedBlockInfo$1 = receivedBlockInfo$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(org.apache.spark.streaming.scheduler.ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1$$anon$1 )}, serializedLambda);
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$addBlock(receivedBlockInfo)));
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else if (A1 instanceof DeregisterReceiver) {
                        DeregisterReceiver deregisterReceiver = (DeregisterReceiver)A1;
                        int streamId = deregisterReceiver.streamId();
                        String message = deregisterReceiver.msg();
                        String error = deregisterReceiver.error();
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$deregisterReceiver(streamId, message, error);
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else if (AllReceiverIds$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)((MapLike)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTrackerEndpoint$$anonfun$receiveAndReply$1.$anonfun$applyOrElse$6(x$9)))).keys().toSeq());
                        object = BoxedUnit.UNIT;
                    } else if (GetAllReceiverInfo$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().toMap(Predef$.MODULE$.$conforms()));
                        object = BoxedUnit.UNIT;
                    } else if (StopAllReceivers$.MODULE$.equals(A1)) {
                        Predef$.MODULE$.assert(this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() || this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped());
                        this.$outer.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers();
                        this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x2) {
                    Object object = x2;
                    boolean bl = object instanceof RegisterReceiver ? true : (object instanceof AddBlock ? true : (object instanceof DeregisterReceiver ? true : (AllReceiverIds$.MODULE$.equals(object) ? true : (GetAllReceiverInfo$.MODULE$.equals(object) ? true : StopAllReceivers$.MODULE$.equals(object)))));
                    return bl;
                }

                public /* synthetic */ ReceiverTrackerEndpoint org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }

                public static final /* synthetic */ boolean $anonfun$applyOrElse$6(Tuple2 x$9) {
                    Enumeration.Value value = ((ReceiverTrackingInfo)x$9._2()).state();
                    Enumeration.Value value2 = ReceiverState$.MODULE$.INACTIVE();
                    return value == null ? value2 != null : !value.equals(value2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6$adapted(scala.Tuple2 )}, serializedLambda);
                }
            };
        }

        public Seq<TaskLocation> org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$getStoredScheduledExecutors(int receiverId) {
            Nil$ nil$;
            if (this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().contains((Object)BoxesRunTime.boxToInteger((int)receiverId))) {
                Option<Seq<TaskLocation>> scheduledLocations = ((ReceiverTrackingInfo)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().apply((Object)BoxesRunTime.boxToInteger((int)receiverId))).scheduledLocations();
                if (scheduledLocations.nonEmpty()) {
                    Set executors = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$getExecutors().toSet();
                    nil$ = (Seq)((TraversableLike)scheduledLocations.get()).filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)ReceiverTrackerEndpoint.$anonfun$getStoredScheduledExecutors$1(executors, x0$4)));
                } else {
                    nil$ = Nil$.MODULE$;
                }
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$startReceiver(Receiver<?> receiver, Seq<TaskLocation> scheduledLocations) {
            RDD rDD;
            int receiverId = receiver.streamId();
            if (!this.shouldStartReceiver$1()) {
                this.onReceiverJobFinish(receiverId);
                return;
            }
            Option checkpointDirOption = Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.checkpointDir());
            SerializableConfiguration serializableHadoopConf = new SerializableConfiguration(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().hadoopConfiguration());
            Function1 & Serializable & scala.Serializable startReceiverFunc = (Function1 & Serializable & scala.Serializable)iterator -> {
                ReceiverTrackerEndpoint.$anonfun$startReceiver$1(checkpointDirOption, serializableHadoopConf, iterator);
                return BoxedUnit.UNIT;
            };
            if (scheduledLocations.isEmpty()) {
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Receiver[]{receiver})), 1, ClassTag$.MODULE$.apply(Receiver.class));
            } else {
                Seq preferredLocations = (Seq)((SeqLike)scheduledLocations.map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.toString(), Seq$.MODULE$.canBuildFrom())).distinct();
                rDD = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sc().makeRDD((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(receiver), (Object)preferredLocations)})), ClassTag$.MODULE$.apply(Receiver.class));
            }
            RDD receiverRDD = rDD;
            receiverRDD.setName(new StringBuilder(9).append("Receiver ").append(receiverId).toString());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setJobDescription(new StringBuilder(31).append("Streaming job running receiver ").append(receiverId).toString());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().setCallSite((CallSite)Option$.MODULE$.apply((Object)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.getStartSite()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Utils$.MODULE$.getCallSite(Utils$.MODULE$.getCallSite$default$1())));
            SimpleFutureAction future = this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$ssc.sparkContext().submitJob(receiverRDD, (Function1)startReceiverFunc, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReceiverTrackerEndpoint.$anonfun$startReceiver$5(BoxesRunTime.unboxToInt((Object)x$11), x$12);
                return BoxedUnit.UNIT;
            }, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {});
            future.onComplete((Function1 & Serializable & scala.Serializable)x0$5 -> {
                ReceiverTrackerEndpoint.$anonfun$startReceiver$6(this, receiver, receiverId, x0$5);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Receiver ").append(receiver.streamId()).append(" started").toString());
        }

        public void onStop() {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active_$eq(false);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool().shutdown();
        }

        private void onReceiverJobFinish(int receiverId) {
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverJobExitLatch().countDown();
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().remove((Object)BoxesRunTime.boxToInteger((int)receiverId)).foreach((Function1 & Serializable & scala.Serializable)receiverTrackingInfo -> {
                ReceiverTrackerEndpoint.$anonfun$onReceiverJobFinish$1(this, receiverId, receiverTrackingInfo);
                return BoxedUnit.UNIT;
            });
        }

        public void org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$stopReceivers() {
            ((IterableLike)this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().values().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> Option$.MODULE$.option2Iterable(x$13.endpoint()), scala.collection.Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                x$14.send((Object)StopReceiver$.MODULE$);
                return BoxedUnit.UNIT;
            });
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sent stop signal to all ").append(this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$receiverTrackingInfos().size()).append(" receivers").toString());
        }

        public /* synthetic */ ReceiverTracker org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$getStoredScheduledExecutors$1(Set executors$1, TaskLocation x0$4) {
            boolean bl;
            TaskLocation taskLocation = x0$4;
            if (taskLocation instanceof ExecutorCacheTaskLocation) {
                ExecutorCacheTaskLocation executorCacheTaskLocation = (ExecutorCacheTaskLocation)taskLocation;
                bl = executors$1.apply((Object)executorCacheTaskLocation);
            } else if (taskLocation != null) {
                bl = true;
            } else {
                throw new MatchError((Object)taskLocation);
            }
            return bl;
        }

        private final boolean shouldStartReceiver$1() {
            return !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopping() && !this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().org$apache$spark$streaming$scheduler$ReceiverTracker$$isTrackerStopped();
        }

        public static final /* synthetic */ void $anonfun$startReceiver$1(Option checkpointDirOption$1, SerializableConfiguration serializableHadoopConf$1, Iterator iterator) {
            block1: {
                if (!iterator.hasNext()) {
                    throw new SparkException("Could not start receiver as object not found.");
                }
                if (TaskContext$.MODULE$.get().attemptNumber() != 0) break block1;
                Receiver receiver = (Receiver)iterator.next();
                Predef$.MODULE$.assert(!iterator.hasNext());
                ReceiverSupervisorImpl supervisor = new ReceiverSupervisorImpl(receiver, SparkEnv$.MODULE$.get(), serializableHadoopConf$1.value(), (Option<String>)checkpointDirOption$1);
                supervisor.start();
                supervisor.awaitTermination();
            }
        }

        public static final /* synthetic */ void $anonfun$startReceiver$5(int x$11, BoxedUnit x$12) {
        }

        public static final /* synthetic */ void $anonfun$startReceiver$6(ReceiverTrackerEndpoint $this, Receiver receiver$1, int receiverId$1, Try x0$5) {
            Try try_ = x0$5;
            if (try_ instanceof Success) {
                BoxedUnit boxedUnit;
                if (!$this.shouldStartReceiver$1()) {
                    $this.onReceiverJobFinish(receiverId$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Restarting Receiver ").append(receiverId$1).toString());
                    $this.self().send((Object)new RestartReceiver(receiver$1));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                if (!$this.shouldStartReceiver$1()) {
                    $this.onReceiverJobFinish(receiverId$1);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Receiver has been stopped. Try to restart it.", e);
                    $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Restarting Receiver ").append(receiverId$1).toString());
                    $this.self().send((Object)new RestartReceiver(receiver$1));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                throw new MatchError((Object)try_);
            }
        }

        public static final /* synthetic */ void $anonfun$onReceiverJobFinish$1(ReceiverTrackerEndpoint $this, int receiverId$2, ReceiverTrackingInfo receiverTrackingInfo) {
            block0: {
                Enumeration.Value value = receiverTrackingInfo.state();
                Enumeration.Value value2 = ReceiverState$.MODULE$.ACTIVE();
                if (value != null ? !value.equals(value2) : value2 != null) break block0;
                $this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$$outer().logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Receiver ").append(receiverId$2).append(" exited but didn't deregister").toString());
            }
        }

        public ReceiverTrackerEndpoint(ReceiverTracker $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$walBatchingThreadPool = ExecutionContext$.MODULE$.fromExecutorService((ExecutorService)ThreadUtils$.MODULE$.newDaemonCachedThreadPool("wal-batching-thread-pool"));
            this.org$apache$spark$streaming$scheduler$ReceiverTracker$ReceiverTrackerEndpoint$$active = true;
        }
    }
}

