/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.ui;

import java.io.Serializable;
import org.apache.spark.streaming.ui.BatchUIData;
import org.apache.spark.streaming.ui.OutputOperationUIData;
import org.apache.spark.streaming.ui.UIUtils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001y3a!\u0001\u0002\u0002\u0002\ta!A\u0004\"bi\u000eDG+\u00192mK\n\u000b7/\u001a\u0006\u0003\u0007\u0011\t!!^5\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001B\u0001B\u0003%a#A\u0004uC\ndW-\u00133\u0004\u0001A\u0011qC\b\b\u00031q\u0001\"!G\b\u000e\u0003iQ!aG\u000b\u0002\rq\u0012xn\u001c;?\u0013\tir\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0001\u0012aa\u0015;sS:<'BA\u000f\u0010\u0011!\u0011\u0003A!A!\u0002\u0013\u0019\u0013!\u00042bi\u000eD\u0017J\u001c;feZ\fG\u000e\u0005\u0002\u000fI%\u0011Qe\u0004\u0002\u0005\u0019>tw\rC\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0004S-b\u0003C\u0001\u0016\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b'\u0001\u00041\u0002\"\u0002\u0012'\u0001\u0004\u0019\u0003\"\u0002\u0018\u0001\t#y\u0013aB2pYVlgn]\u000b\u0002aA\u0019\u0011GN\u001d\u000f\u0005I\"dBA\r4\u0013\u0005\u0001\u0012BA\u001b\u0010\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000e\u001d\u0003\u0007M+\u0017O\u0003\u00026\u001fA\u0011!(P\u0007\u0002w)\u0011AhD\u0001\u0004q6d\u0017B\u0001 <\u0005\u0011qu\u000eZ3\t\u000b\u0001\u0003A\u0011C!\u0002+\u001d,GOR5sgR4\u0015-\u001b7ve\u0016\u0014V-Y:p]R\u0011!)\u0012\t\u0004\u001d\r3\u0012B\u0001#\u0010\u0005\u0019y\u0005\u000f^5p]\")ai\u0010a\u0001\u000f\u00069!-\u0019;dQ\u0016\u001c\bcA\u00197\u0011B\u0011!&S\u0005\u0003\u0015\n\u00111BQ1uG\",\u0016\nR1uC\")A\n\u0001C\t\u001b\u0006Ar-\u001a;GSJ\u001cHOR1jYV\u0014X\rV1cY\u0016\u001cU\r\u001c7\u0015\u0005Ar\u0005\"B(L\u0001\u0004A\u0015!\u00022bi\u000eD\u0007\"B)\u0001\t#\u0011\u0016a\u00022bg\u0016\u0014vn\u001e\u000b\u0003aMCQa\u0014)A\u0002!CQ!\u0016\u0001\u0005\n=\n!BY1uG\"$\u0016M\u00197f\u0011\u00159\u0006\u0001\"\u00010\u0003%!xNT8eKN+\u0017\u000fC\u0003Z\u0001\u0011E!,\u0001\u0011de\u0016\fG/Z(viB,Ho\u00149fe\u0006$\u0018n\u001c8Qe><'/Z:t\u0005\u0006\u0014HC\u0001\u0019\\\u0011\u0015y\u0005\f1\u0001I\u0011\u0015i\u0006A\"\u00050\u0003)\u0011XM\u001c3feJ{wo\u001d")
public abstract class BatchTableBase {
    private final String tableId;
    private final long batchInterval;

    /*
     * WARNING - void declaration
     */
    public Seq<Node> columns() {
        void var1_1;
        void var3_3;
        void var2_2;
        NodeBuffer $buf = new NodeBuffer();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("Batch Time"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Records"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("Scheduling Delay\n        "));
        $buf4.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken by Streaming scheduler to submit jobs of a batch", "top"));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Processing Time\n        "));
        $buf5.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.tooltip("Time taken to process all jobs of a batch", "top"));
        $buf.$amp$plus((Object)new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        return var1_1;
    }

    public Option<String> getFirstFailureReason(Seq<BatchUIData> batches) {
        return ((TraversableLike)batches.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> (Iterable)x$1.outputOperations().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(((OutputOperationUIData)x$2._2()).failureReason()), Iterable$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).headOption();
    }

    public Seq<Node> getFirstFailureTableCell(BatchUIData batch) {
        Option firstFailureReason = ((TraversableLike)batch.outputOperations().flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable(((OutputOperationUIData)x$3._2()).failureReason()), Iterable$.MODULE$.canBuildFrom())).headOption();
        return (Seq)firstFailureReason.map((Function1 & Serializable & scala.Serializable)failureReason -> {
            String failureReasonForUI = UIUtils$.MODULE$.createOutputOperationFailureForUI((String)failureReason);
            return UIUtils$.MODULE$.failureReasonCell(failureReasonForUI, 1, false);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            void var0;
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("-"));
            return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var0);
        });
    }

    public Seq<Node> baseRow(BatchUIData batch) {
        long batchTime = batch.batchTime().milliseconds();
        String formattedBatchTime = UIUtils$.MODULE$.formatBatchTime(batchTime, this.batchInterval, UIUtils$.MODULE$.formatBatchTime$default$3(), UIUtils$.MODULE$.formatBatchTime$default$4());
        long numRecords = batch.numRecords();
        Option<Object> schedulingDelay = batch.schedulingDelay();
        String formattedSchedulingDelay = (String)schedulingDelay.map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        Option<Object> processingTime = batch.processingDelay();
        String formattedProcessingTime = (String)processingTime.map((Function1 & Serializable & scala.Serializable)milliseconds -> org.apache.spark.ui.UIUtils$.MODULE$.formatDuration(BoxesRunTime.unboxToLong((Object)milliseconds))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "-");
        String batchTimeId = new StringBuilder(6).append("batch-").append(batchTime).toString();
        NodeBuffer $buf = new NodeBuffer();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("isFailed", ((Object)BoxesRunTime.boxToBoolean((boolean)batch.isFailed())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToLong((long)batchTime)).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("id", batchTimeId, (MetaData)$md);
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n      "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("href", new StringBuilder(9).append("batch?id=").append(batchTime).toString(), (MetaData)$md2);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)formattedBatchTime);
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf2.$amp$plus((Object)new Elem(null, "a", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf2.$amp$plus((Object)new Text("\n    "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("sorttable_customkey", ((Object)BoxesRunTime.boxToLong((long)numRecords)).toString(), (MetaData)$md3);
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)((Object)BoxesRunTime.boxToLong((long)numRecords)).toString());
        $buf4.$amp$plus((Object)new Text(" records"));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        Null$ $md4 = Null$.MODULE$;
        $md4 = new UnprefixedAttribute("sorttable_customkey", schedulingDelay.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md4);
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)formattedSchedulingDelay);
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md4, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        Null$ $md5 = Null$.MODULE$;
        $md5 = new UnprefixedAttribute("sorttable_customkey", processingTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Long.MAX_VALUE).toString(), (MetaData)$md5);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)formattedProcessingTime);
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)$md5, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        return $buf;
    }

    /*
     * WARNING - void declaration
     */
    private Seq<Node> batchTable() {
        void var2_2;
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("table table-bordered table-striped table-condensed sortable"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", this.tableId, (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(this.columns());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus(this.renderRows());
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "tbody", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "table", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var2_2);
    }

    public Seq<Node> toNodeSeq() {
        return this.batchTable();
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Node> createOutputOperationProgressBar(BatchUIData batch) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("progress-cell"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)org.apache.spark.ui.UIUtils$.MODULE$.makeProgressBar(batch.numActiveOutputOp(), batch.numCompletedOutputOp(), batch.numFailedOutputOp(), 0, Predef$.MODULE$.Map().empty(), batch.outputOperations().size()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "td", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public abstract Seq<Node> renderRows();

    public BatchTableBase(String tableId, long batchInterval) {
        this.tableId = tableId;
        this.batchInterval = batchInterval;
    }
}

