/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.util.RecurringTimer$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005eb!B\u0001\u0003\u0001\u0011a!A\u0004*fGV\u0014(/\u001b8h)&lWM\u001d\u0006\u0003\u0007\u0011\tA!\u001e;jY*\u0011QAB\u0001\ngR\u0014X-Y7j]\u001eT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\n\u0004\u00015\u0019\u0002C\u0001\b\u0012\u001b\u0005y!\"\u0001\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iy!AB!osJ+g\r\u0005\u0002\u0015/5\tQC\u0003\u0002\u0017\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u0019+\t9Aj\\4hS:<\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000b\rdwnY6\u0004\u0001A\u0011QdH\u0007\u0002=)\u00111AB\u0005\u0003Ay\u0011Qa\u00117pG.D\u0001B\t\u0001\u0003\u0002\u0003\u0006IaI\u0001\u0007a\u0016\u0014\u0018n\u001c3\u0011\u00059!\u0013BA\u0013\u0010\u0005\u0011auN\\4\t\u0011\u001d\u0002!\u0011!Q\u0001\n!\n\u0001bY1mY\n\f7m\u001b\t\u0005\u001d%\u001a3&\u0003\u0002+\u001f\tIa)\u001e8di&|g.\r\t\u0003\u001d1J!!L\b\u0003\tUs\u0017\u000e\u001e\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005!a.Y7f!\t\t\u0004H\u0004\u00023mA\u00111gD\u0007\u0002i)\u0011QgG\u0001\u0007yI|w\u000e\u001e \n\u0005]z\u0011A\u0002)sK\u0012,g-\u0003\u0002:u\t11\u000b\u001e:j]\u001eT!aN\b\t\u000bq\u0002A\u0011A\u001f\u0002\rqJg.\u001b;?)\u0015q\u0004)\u0011\"D!\ty\u0004!D\u0001\u0003\u0011\u0015Q2\b1\u0001\u001d\u0011\u0015\u00113\b1\u0001$\u0011\u001593\b1\u0001)\u0011\u0015y3\b1\u00011\u0011\u001d)\u0005A1A\u0005\n\u0019\u000ba\u0001\u001e5sK\u0006$W#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001\u00027b]\u001eT\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0013\n1A\u000b\u001b:fC\u0012Da\u0001\u0015\u0001!\u0002\u00139\u0015a\u0002;ie\u0016\fG\r\t\u0005\b%\u0002\u0001\r\u0011\"\u0003T\u0003!\u0001(/\u001a<US6,W#A\u0012\t\u000fU\u0003\u0001\u0019!C\u0005-\u0006a\u0001O]3w)&lWm\u0018\u0013fcR\u00111f\u0016\u0005\b1R\u000b\t\u00111\u0001$\u0003\rAH%\r\u0005\u00075\u0002\u0001\u000b\u0015B\u0012\u0002\u0013A\u0014XM\u001e+j[\u0016\u0004\u0003FA-]!\tqQ,\u0003\u0002_\u001f\tAao\u001c7bi&dW\rC\u0004a\u0001\u0001\u0007I\u0011B*\u0002\u00119,\u0007\u0010\u001e+j[\u0016DqA\u0019\u0001A\u0002\u0013%1-\u0001\u0007oKb$H+[7f?\u0012*\u0017\u000f\u0006\u0002,I\"9\u0001,YA\u0001\u0002\u0004\u0019\u0003B\u00024\u0001A\u0003&1%A\u0005oKb$H+[7fA!\u0012Q\r\u0018\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012a\u001b\t\u0003\u001d1L!!\\\b\u0003\u000f\t{w\u000e\\3b]\"9q\u000e\u0001a\u0001\n\u0013\u0001\u0018aC:u_B\u0004X\rZ0%KF$\"aK9\t\u000fas\u0017\u0011!a\u0001W\"11\u000f\u0001Q!\n-\f\u0001b\u001d;paB,G\r\t\u0015\u0003erCQA\u001e\u0001\u0005\u0002]\fAbZ3u'R\f'\u000f\u001e+j[\u0016$\u0012a\t\u0005\u0006s\u0002!\tA_\u0001\u000fO\u0016$(+Z:uCJ$H+[7f)\t\u00193\u0010C\u0003}q\u0002\u00071%A\tpe&<\u0017N\\1m'R\f'\u000f\u001e+j[\u0016DQA \u0001\u0005\u0002}\fQa\u001d;beR$2aIA\u0001\u0011\u0019\t\u0019! a\u0001G\u0005I1\u000f^1siRKW.\u001a\u0005\u0006}\u0002!\ta\u001e\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0003\u0011\u0019Ho\u001c9\u0015\u0007\r\ni\u0001C\u0004\u0002\u0010\u0005\u001d\u0001\u0019A6\u0002\u001d%tG/\u001a:skB$H+[7fe\"9\u00111\u0003\u0001\u0005\n\u0005U\u0011\u0001\b;sS\u001e<WM]!di&|gNR8s\u001d\u0016DH/\u00138uKJ4\u0018\r\u001c\u000b\u0002W!9\u0011\u0011\u0004\u0001\u0005\n\u0005U\u0011\u0001\u00027p_B<\u0001\"!\b\u0003\u0011\u0003!\u0011qD\u0001\u000f%\u0016\u001cWO\u001d:j]\u001e$\u0016.\\3s!\ry\u0014\u0011\u0005\u0004\b\u0003\tA\t\u0001BA\u0012'\u0011\t\t#D\n\t\u000fq\n\t\u0003\"\u0001\u0002(Q\u0011\u0011q\u0004\u0005\t\u0003W\t\t\u0003\"\u0001\u0002.\u0005!Q.Y5o)\rY\u0013q\u0006\u0005\t\u0003c\tI\u00031\u0001\u00024\u0005!\u0011M]4t!\u0011q\u0011Q\u0007\u0019\n\u0007\u0005]rBA\u0003BeJ\f\u0017\u0010")
public class RecurringTimer
implements Logging {
    private final Clock clock;
    private final long period;
    private final Function1<Object, BoxedUnit> callback;
    public final String org$apache$spark$streaming$util$RecurringTimer$$name;
    private final Thread thread;
    private volatile long prevTime;
    private volatile long nextTime;
    private volatile boolean stopped;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        RecurringTimer$.MODULE$.main(stringArray);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Thread thread() {
        return this.thread;
    }

    private long prevTime() {
        return this.prevTime;
    }

    private void prevTime_$eq(long x$1) {
        this.prevTime = x$1;
    }

    private long nextTime() {
        return this.nextTime;
    }

    private void nextTime_$eq(long x$1) {
        this.nextTime = x$1;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public long getStartTime() {
        return (long)(package$.MODULE$.floor((double)this.clock.getTimeMillis() / (double)this.period) + 1.0) * this.period;
    }

    public long getRestartTime(long originalStartTime) {
        long gap = this.clock.getTimeMillis() - originalStartTime;
        return ((long)package$.MODULE$.floor((double)gap / (double)this.period) + 1L) * this.period + originalStartTime;
    }

    public synchronized long start(long startTime) {
        this.nextTime_$eq(startTime);
        this.thread().start();
        this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(27).append("Started timer for ").append($this.org$apache$spark$streaming$util$RecurringTimer$$name).append(" at time ").append(this.nextTime()).toString());
        return this.nextTime();
    }

    public long start() {
        return this.start(this.getStartTime());
    }

    public synchronized long stop(boolean interruptTimer) {
        block1: {
            if (this.stopped()) break block1;
            this.stopped_$eq(true);
            if (interruptTimer) {
                this.thread().interrupt();
            }
            this.thread().join();
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(30).append("Stopped timer for ").append($this.org$apache$spark$streaming$util$RecurringTimer$$name).append(" after time ").append(this.prevTime()).toString());
        }
        return this.prevTime();
    }

    private void triggerActionForNextInterval() {
        this.clock.waitTillTime(this.nextTime());
        this.callback.apply$mcVJ$sp(this.nextTime());
        this.prevTime_$eq(this.nextTime());
        this.nextTime_$eq(this.nextTime() + this.period);
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(29).append("Callback for ").append($this.org$apache$spark$streaming$util$RecurringTimer$$name).append(" called at time ").append(this.prevTime()).toString());
    }

    public void org$apache$spark$streaming$util$RecurringTimer$$loop() {
        try {
            while (!this.stopped()) {
                this.triggerActionForNextInterval();
            }
            this.triggerActionForNextInterval();
        }
        catch (InterruptedException interruptedException) {}
    }

    public RecurringTimer(Clock clock, long period, Function1<Object, BoxedUnit> callback, String name) {
        this.clock = clock;
        this.period = period;
        this.callback = callback;
        this.org$apache$spark$streaming$util$RecurringTimer$$name = name;
        Logging.$init$((Logging)this);
        this.thread = new Thread(this){
            private final /* synthetic */ RecurringTimer $outer;

            public void run() {
                this.$outer.org$apache$spark$streaming$util$RecurringTimer$$loop();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(new StringBuilder(17).append("RecurringTimer - ").append($outer.org$apache$spark$streaming$util$RecurringTimer$$name).toString());
                this.setDaemon(true);
            }
        };
        this.prevTime = -1L;
        this.nextTime = -1L;
        this.stopped = false;
    }
}

