/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.dictionary.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apdplat.word.dictionary.Dictionary;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryTrie
implements Dictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryTrie.class);
    private static final int INDEX_LENGTH = WordConfTools.getInt("dictionary.trie.index.size", 24000);
    private final TrieNode[] ROOT_NODES_INDEX = new TrieNode[INDEX_LENGTH];
    private int maxLength;

    public DictionaryTrie() {
        LOGGER.info("\u521d\u59cb\u5316\u8bcd\u5178\uff1a" + this.getClass().getName());
    }

    @Override
    public void clear() {
        for (int i = 0; i < INDEX_LENGTH; ++i) {
            this.ROOT_NODES_INDEX[i] = null;
        }
    }

    public void showConflict() {
        int n = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        for (TrieNode trieNode : this.ROOT_NODES_INDEX) {
            if (trieNode == null) {
                ++n;
                continue;
            }
            int n2 = 0;
            while ((trieNode = trieNode.getSibling()) != null) {
                ++n2;
            }
            if (n2 <= 0) continue;
            Integer n3 = (Integer)hashMap.get(n2);
            if (n3 == null) {
                n3 = 1;
            } else {
                Integer n4 = n3;
                Integer n5 = n3 = Integer.valueOf(n3 + 1);
            }
            hashMap.put(n2, n3);
        }
        int n6 = 0;
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n7 = (Integer)iterator.next();
            int n8 = (Integer)hashMap.get(n7);
            n6 += n7 * n8;
            LOGGER.info("\u51b2\u7a81\u6b21\u6570\u4e3a\uff1a" + n7 + " \u7684\u5143\u7d20\u4e2a\u6570\uff1a" + n8);
        }
        LOGGER.info("\u51b2\u7a81\u6b21\u6570\uff1a" + n6);
        LOGGER.info("\u603b\u69fd\u6570\uff1a" + INDEX_LENGTH);
        LOGGER.info("\u7528\u69fd\u6570\uff1a" + (INDEX_LENGTH - n));
        LOGGER.info("\u4f7f\u7528\u7387\uff1a" + (float)(INDEX_LENGTH - n) / (float)INDEX_LENGTH * 100.0f + "%");
        LOGGER.info("\u5269\u69fd\u6570\uff1a" + n);
    }

    private TrieNode getRootNodeIfNotExistThenCreate(char c) {
        TrieNode trieNode = this.getRootNode(c);
        if (trieNode == null) {
            trieNode = new TrieNode(c);
            this.addRootNode(trieNode);
        }
        return trieNode;
    }

    private void addRootNode(TrieNode trieNode) {
        int n = trieNode.getCharacter() % INDEX_LENGTH;
        TrieNode trieNode2 = this.ROOT_NODES_INDEX[n];
        if (trieNode2 != null) {
            trieNode.setSibling(trieNode2);
        }
        this.ROOT_NODES_INDEX[n] = trieNode;
    }

    private TrieNode getRootNode(char c) {
        TrieNode trieNode;
        int n = c % INDEX_LENGTH;
        for (trieNode = this.ROOT_NODES_INDEX[n]; trieNode != null && c != trieNode.getCharacter(); trieNode = trieNode.getSibling()) {
        }
        return trieNode;
    }

    public List<String> prefix(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = (string = string.trim()).length();
        if (n < 1) {
            return arrayList;
        }
        TrieNode trieNode = this.getRootNode(string.charAt(0));
        if (trieNode == null) {
            return arrayList;
        }
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            TrieNode trieNode2 = trieNode.getChild(c);
            if (trieNode2 == null) {
                return arrayList;
            }
            trieNode = trieNode2;
        }
        for (TrieNode trieNode3 : trieNode.getChildren()) {
            arrayList.add(string + trieNode3.getCharacter());
        }
        return arrayList;
    }

    @Override
    public boolean contains(String string) {
        return this.contains(string, 0, string.length());
    }

    @Override
    public boolean contains(String string, int n, int n2) {
        TrieNode trieNode;
        if (n < 0 || n2 < 1) {
            return false;
        }
        if (string == null || string.length() < n2) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u5f00\u59cb\u67e5\u8bcd\u5178\uff1a{}", (Object)string.substring(n, n + n2));
        }
        if ((trieNode = this.getRootNode(string.charAt(n))) == null) {
            return false;
        }
        for (int i = 1; i < n2; ++i) {
            char c = string.charAt(i + n);
            TrieNode trieNode2 = trieNode.getChild(c);
            if (trieNode2 == null) {
                return false;
            }
            trieNode = trieNode2;
        }
        if (trieNode.isTerminal()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u5728\u8bcd\u5178\u4e2d\u67e5\u5230\u8bcd\uff1a{}", (Object)string.substring(n, n + n2));
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeAll(List<String> list) {
        for (String string : list) {
            this.remove(string);
        }
    }

    @Override
    public void remove(String string) {
        TrieNode trieNode;
        if (string == null || string.isEmpty()) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u4ece\u8bcd\u5178\u4e2d\u79fb\u9664\u8bcd\uff1a{}", (Object)string);
        }
        if ((trieNode = this.getRootNode(string.charAt(0))) == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bcd\u4e0d\u5b58\u5728\uff1a{}", (Object)string);
            }
            return;
        }
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            char c = string.charAt(i);
            TrieNode trieNode2 = trieNode.getChild(c);
            if (trieNode2 == null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("\u8bcd\u4e0d\u5b58\u5728\uff1a{}", (Object)string);
                }
                return;
            }
            trieNode = trieNode2;
        }
        if (trieNode.isTerminal()) {
            trieNode.setTerminal(false);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u6210\u529f\u4ece\u8bcd\u5178\u4e2d\u79fb\u9664\u8bcd\uff1a{}", (Object)string);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bcd\u4e0d\u5b58\u5728\uff1a{}", (Object)string);
        }
    }

    @Override
    public void addAll(List<String> list) {
        for (String string : list) {
            this.add(string);
        }
    }

    @Override
    public void add(String string) {
        int n = (string = string.trim()).length();
        if (n < 1) {
            return;
        }
        if (n > this.maxLength) {
            this.maxLength = n;
        }
        TrieNode trieNode = this.getRootNodeIfNotExistThenCreate(string.charAt(0));
        for (int i = 1; i < n; ++i) {
            TrieNode trieNode2;
            char c = string.charAt(i);
            trieNode = trieNode2 = trieNode.getChildIfNotExistThenCreate(c);
        }
        trieNode.setTerminal(true);
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    public void show(char c) {
        this.show(this.getRootNode(c), "");
    }

    public void show() {
        for (TrieNode trieNode : this.ROOT_NODES_INDEX) {
            if (trieNode == null) continue;
            this.show(trieNode, "");
        }
    }

    private void show(TrieNode trieNode, String string) {
        if (trieNode.isTerminal()) {
            LOGGER.info(string + trieNode.getCharacter() + "(T)");
        } else {
            LOGGER.info(string + trieNode.getCharacter());
        }
        for (TrieNode trieNode2 : trieNode.getChildren()) {
            this.show(trieNode2, string + "\t");
        }
    }

    public static void main(String[] stringArray) {
        DictionaryTrie dictionaryTrie = new DictionaryTrie();
        dictionaryTrie.add("APDPlat");
        dictionaryTrie.add("APP");
        dictionaryTrie.add("APD");
        dictionaryTrie.add("\u6768\u5c1a\u5ddd");
        dictionaryTrie.add("\u6768\u5c1a\u6606");
        dictionaryTrie.add("\u6768\u5c1a\u559c");
        dictionaryTrie.add("\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd");
        dictionaryTrie.add("\u4e2d\u534e\u4eba\u6c11\u6253\u592a\u6781");
        dictionaryTrie.add("\u4e2d\u534e");
        dictionaryTrie.add("\u4e2d\u5fc3\u601d\u60f3");
        dictionaryTrie.add("\u6768\u5bb6\u5c06");
        dictionaryTrie.show();
        LOGGER.info(dictionaryTrie.prefix("\u4e2d").toString());
        LOGGER.info(dictionaryTrie.prefix("\u4e2d\u534e").toString());
        LOGGER.info(dictionaryTrie.prefix("\u6768").toString());
        LOGGER.info(dictionaryTrie.prefix("\u6768\u5c1a").toString());
    }

    private static class TrieNode
    implements Comparable {
        private char character;
        private boolean terminal;
        private TrieNode sibling;
        private TrieNode[] children = new TrieNode[0];

        public TrieNode(char c) {
            this.character = c;
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public void setTerminal(boolean bl) {
            this.terminal = bl;
        }

        public char getCharacter() {
            return this.character;
        }

        public void setCharacter(char c) {
            this.character = c;
        }

        public TrieNode getSibling() {
            return this.sibling;
        }

        public void setSibling(TrieNode trieNode) {
            this.sibling = trieNode;
        }

        public Collection<TrieNode> getChildren() {
            return Arrays.asList(this.children);
        }

        public TrieNode getChild(char c) {
            int n = Arrays.binarySearch(this.children, Character.valueOf(c));
            if (n >= 0) {
                return this.children[n];
            }
            return null;
        }

        public TrieNode getChildIfNotExistThenCreate(char c) {
            TrieNode trieNode = this.getChild(c);
            if (trieNode == null) {
                trieNode = new TrieNode(c);
                this.addChild(trieNode);
            }
            return trieNode;
        }

        public void addChild(TrieNode trieNode) {
            this.children = this.insert(this.children, trieNode);
        }

        private TrieNode[] insert(TrieNode[] trieNodeArray, TrieNode trieNode) {
            int n = trieNodeArray.length;
            if (n == 0) {
                trieNodeArray = new TrieNode[]{trieNode};
                return trieNodeArray;
            }
            TrieNode[] trieNodeArray2 = new TrieNode[n + 1];
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                if (trieNode.getCharacter() <= trieNodeArray[i].getCharacter()) {
                    trieNodeArray2[i] = trieNode;
                    System.arraycopy(trieNodeArray, i, trieNodeArray2, i + 1, n - i);
                    bl = true;
                    break;
                }
                trieNodeArray2[i] = trieNodeArray[i];
            }
            if (!bl) {
                trieNodeArray2[n] = trieNode;
            }
            return trieNodeArray2;
        }

        public int compareTo(Object object) {
            return this.getCharacter() - ((Character)object).charValue();
        }
    }
}

