/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.tagging;

import java.util.List;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinyinTagging {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinyinTagging.class);

    private PinyinTagging() {
    }

    public static void process(List<Word> list) {
        for (Word word : list) {
            String string = word.getText();
            word.setFullPinYin(PinyinTagging.getFullPinYin(string));
            word.setAcronymPinYin(PinyinTagging.getAcronymPinYin(string));
        }
    }

    private static String getAcronymPinYin(String string) {
        return PinyinTagging.getPinYin(string, true);
    }

    private static String getFullPinYin(String string) {
        return PinyinTagging.getPinYin(string, false);
    }

    private static String getPinYin(String string, boolean bl) {
        HanyuPinyinOutputFormat hanyuPinyinOutputFormat = new HanyuPinyinOutputFormat();
        hanyuPinyinOutputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        hanyuPinyinOutputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        hanyuPinyinOutputFormat.setVCharType(HanyuPinyinVCharType.WITH_U_UNICODE);
        char[] cArray = string.trim().toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (char c : cArray) {
                if (Character.toString(c).matches("[\u4e00-\u9fa5]+")) {
                    String[] stringArray = PinyinHelper.toHanyuPinyinStringArray((char)c, (HanyuPinyinOutputFormat)hanyuPinyinOutputFormat);
                    if (bl) {
                        stringBuilder.append(stringArray[0].charAt(0));
                        continue;
                    }
                    stringBuilder.append(stringArray[0]);
                    continue;
                }
                return null;
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u62fc\u97f3\u6807\u6ce8\u5931\u8d25", (Throwable)exception);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] stringArray) {
        List<Word> list = SegmentationFactory.getSegmentation(SegmentationAlgorithm.BidirectionalMaximumMatching).seg("\u300a\u901f\u5ea6\u4e0e\u6fc0\u60c57\u300b\u7684\u4e2d\u56fd\u5185\u5730\u7968\u623f\u81ea4\u670812\u65e5\u4e0a\u6620\u4ee5\u6765\uff0c\u5728\u77ed\u77ed\u4e24\u5468\u5185\u7a81\u783420\u4ebf\u4eba\u6c11\u5e01");
        System.out.println(list);
        PinyinTagging.process(list);
        System.out.println(list);
    }
}

