/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleIntMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleIntMap;
import org.eclipse.collections.impl.factory.primitive.DoubleIntMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleIntSingletonMap;

public class ImmutableDoubleIntMapFactoryImpl
implements ImmutableDoubleIntMapFactory {
    public static final ImmutableDoubleIntMapFactory INSTANCE = new ImmutableDoubleIntMapFactoryImpl();

    public ImmutableDoubleIntMap empty() {
        return ImmutableDoubleIntEmptyMap.INSTANCE;
    }

    public ImmutableDoubleIntMap of() {
        return this.empty();
    }

    public ImmutableDoubleIntMap with() {
        return this.empty();
    }

    public ImmutableDoubleIntMap of(double key, int value) {
        return this.with(key, value);
    }

    public ImmutableDoubleIntMap with(double key, int value) {
        return new ImmutableDoubleIntSingletonMap(key, value);
    }

    public ImmutableDoubleIntMap ofAll(DoubleIntMap map) {
        return this.withAll(map);
    }

    public ImmutableDoubleIntMap withAll(DoubleIntMap map) {
        if (map instanceof ImmutableDoubleIntMap) {
            return (ImmutableDoubleIntMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            double key = map.keysView().doubleIterator().next();
            return new ImmutableDoubleIntSingletonMap(key, map.get(key));
        }
        return new ImmutableDoubleIntHashMap(map);
    }

    public <T> ImmutableDoubleIntMap from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, IntFunction<? super T> valueFunction) {
        return DoubleIntMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

