/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.temporal.ChronoField;
import org.exparity.hamcrest.date.core.TemporalAdapter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class IsYear<T>
extends TypeSafeDiagnosingMatcher<T> {
    private final int expected;
    private final TemporalAdapter<T> accessor;

    public IsYear(int expected, TemporalAdapter<T> accessor) {
        this.expected = expected;
        this.accessor = accessor;
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        int actualYear = this.accessor.asTemporal(actual).get(ChronoField.YEAR);
        if (this.expected != actualYear) {
            mismatchDescription.appendText("the date has the year " + actualYear);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is in the year " + this.expected);
    }
}

