/*
Copyright 2009-2014 Igor Polevoy

Licensed under the Apache License, Version 2.0 (the "License"); 
you may not use this file except in compliance with the License. 
You may obtain a copy of the License at 

http://www.apache.org/licenses/LICENSE-2.0 

Unless required by applicable law or agreed to in writing, software 
distributed under the License is distributed on an "AS IS" BASIS, 
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
See the License for the specific language governing permissions and 
limitations under the License. 
*/
package org.javalite.activeweb.controller_filters;

import org.javalite.activeweb.HttpSupport;

/**
 * This class is to be overridden by those filters that are to produce/override responses generated by controller.
 * One use case is to catch all exceptions and respond with a canned error (page), another is an authentication controller
 * that will redirect to a login page if user not logged in.  
 *
 * @author Igor Polevoy
 */
public class HttpSupportFilter extends HttpSupport implements ControllerFilter{
    public void before() {}

    public void after() {}

    /**
     *
     * @param e exception.
     * @return true if the filter has handled the exception and no help needed from the framework.
     */
    public void onException(Exception e) {}
}
