/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.excel.imports;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.jeecgframework.poi.excel.entity.params.ExcelImportEntity;
import org.jeecgframework.poi.excel.entity.sax.SaxReadCellEntity;
import org.jeecgframework.poi.exception.excel.ExcelImportException;
import org.jeecgframework.poi.exception.excel.enums.ExcelImportEnum;
import org.jeecgframework.poi.handler.inter.IExcelDataHandler;
import org.jeecgframework.poi.util.PoiPublicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellValueServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(CellValueServer.class);
    private List<String> hanlderList = null;

    private Object getCellValue(String xclass, Cell cell, ExcelImportEntity entity) {
        if (cell == null) {
            return "";
        }
        Object result = null;
        if ("class java.util.Date".equals(xclass) || "class java.sql.Time".equals(xclass)) {
            if (0 == cell.getCellType()) {
                result = cell.getDateCellValue();
            } else {
                cell.setCellType(1);
                result = this.getDateData(entity, cell.getStringCellValue());
            }
            if ("class java.sql.Time".equals(xclass)) {
                result = new Time(((Date)result).getTime());
            }
        } else {
            result = 0 == cell.getCellType() ? Double.valueOf(cell.getNumericCellValue()) : (4 == cell.getCellType() ? Boolean.valueOf(cell.getBooleanCellValue()) : cell.getStringCellValue());
        }
        return result;
    }

    private Date getDateData(ExcelImportEntity entity, String value) {
        if (StringUtils.isNotEmpty((CharSequence)entity.getFormat()) && StringUtils.isNotEmpty((CharSequence)value)) {
            SimpleDateFormat format = new SimpleDateFormat(entity.getFormat());
            try {
                return format.parse(value);
            }
            catch (ParseException e) {
                LOGGER.error("\u65f6\u95f4\u683c\u5f0f\u5316\u5931\u8d25,\u683c\u5f0f\u5316:{},\u503c:{}", (Object)entity.getFormat(), (Object)value);
                throw new ExcelImportException(ExcelImportEnum.GET_VALUE_ERROR);
            }
        }
        return null;
    }

    public Object getValue(IExcelDataHandler dataHanlder, Object object, Cell cell, Map<String, ExcelImportEntity> excelParams, String titleString) throws Exception {
        ExcelImportEntity entity = excelParams.get(titleString);
        String xclass = "class java.lang.Object";
        if (!(object instanceof Map)) {
            Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
            Type[] ts = setMethod.getGenericParameterTypes();
            xclass = ts[0].toString();
        }
        Object result = this.getCellValue(xclass, cell, entity);
        if (entity != null) {
            result = this.hanlderSuffix(entity.getSuffix(), result);
            result = this.replaceValue(entity.getReplace(), result, entity.isMultiReplace());
        }
        result = this.hanlderValue(dataHanlder, object, result, titleString);
        return this.getValueByType(xclass, result, entity);
    }

    public Object getValue(IExcelDataHandler dataHanlder, Object object, SaxReadCellEntity cellEntity, Map<String, ExcelImportEntity> excelParams, String titleString) {
        ExcelImportEntity entity = excelParams.get(titleString);
        Method setMethod = entity.getMethods() != null && entity.getMethods().size() > 0 ? entity.getMethods().get(entity.getMethods().size() - 1) : entity.getMethod();
        Type[] ts = setMethod.getGenericParameterTypes();
        String xclass = ts[0].toString();
        Object result = cellEntity.getValue();
        result = this.hanlderSuffix(entity.getSuffix(), result);
        result = this.replaceValue(entity.getReplace(), result, entity.isMultiReplace());
        result = this.hanlderValue(dataHanlder, object, result, titleString);
        return this.getValueByType(xclass, result, entity);
    }

    private Object hanlderSuffix(String suffix, Object result) {
        if (StringUtils.isNotEmpty((CharSequence)suffix) && result != null && result.toString().endsWith(suffix)) {
            String temp = result.toString();
            return temp.substring(0, temp.length() - suffix.length());
        }
        return result;
    }

    private Object getValueByType(String xclass, Object result, ExcelImportEntity entity) {
        try {
            if (result == null || "".equals(String.valueOf(result))) {
                return null;
            }
            if ("class java.util.Date".equals(xclass)) {
                return result;
            }
            if ("class java.lang.Boolean".equals(xclass) || "boolean".equals(xclass)) {
                return Boolean.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Double".equals(xclass) || "double".equals(xclass)) {
                return Double.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Long".equals(xclass) || "long".equals(xclass)) {
                return Long.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Float".equals(xclass) || "float".equals(xclass)) {
                return Float.valueOf(String.valueOf(result));
            }
            if ("class java.lang.Integer".equals(xclass) || "int".equals(xclass)) {
                return Integer.valueOf(String.valueOf(result));
            }
            if ("class java.math.BigDecimal".equals(xclass)) {
                return new BigDecimal(String.valueOf(result));
            }
            if ("class java.lang.String".equals(xclass)) {
                if (result instanceof String) {
                    return result;
                }
                if (result instanceof Double) {
                    return PoiPublicUtil.doubleToString((Double)result);
                }
                return String.valueOf(result);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ExcelImportException(ExcelImportEnum.GET_VALUE_ERROR);
        }
    }

    private Object hanlderValue(IExcelDataHandler dataHanlder, Object object, Object result, String titleString) {
        if (dataHanlder == null || dataHanlder.getNeedHandlerFields() == null || dataHanlder.getNeedHandlerFields().length == 0) {
            return result;
        }
        if (this.hanlderList == null) {
            this.hanlderList = Arrays.asList(dataHanlder.getNeedHandlerFields());
        }
        if (this.hanlderList.contains(titleString)) {
            return dataHanlder.importHandler(object, titleString, result);
        }
        return result;
    }

    private Object replaceValue(String[] replace, Object result, boolean multiReplace) {
        if (result == null) {
            return "";
        }
        if (replace == null || replace.length <= 0) {
            return result;
        }
        String temp = String.valueOf(result);
        String backValue = "";
        if (temp.indexOf(",") > 0 && multiReplace) {
            String[] multiReplaces;
            for (String str : multiReplaces = temp.split(",")) {
                backValue = backValue.concat(this.replaceSingleValue(replace, str) + ",");
            }
            backValue = backValue.equals("") ? temp : backValue.substring(0, backValue.length() - 1);
        } else {
            backValue = this.replaceSingleValue(replace, temp);
        }
        return backValue;
    }

    private String replaceSingleValue(String[] replace, String temp) {
        for (int i = 0; i < replace.length; ++i) {
            String[] tempArr = replace[i].split("_");
            if (!temp.equals(tempArr[0])) continue;
            return tempArr[1];
        }
        return temp;
    }
}

