/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.workspace;

import java.util.Map;
import lombok.NonNull;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.cpu.nativecpu.workspace.CpuWorkspace;
import org.nd4j.linalg.memory.provider.BasicWorkspaceManager;

public class CpuWorkspaceManager
extends BasicWorkspaceManager {
    public MemoryWorkspace createNewWorkspace(@NonNull WorkspaceConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        this.ensureThreadExistense();
        CpuWorkspace workspace = new CpuWorkspace(configuration);
        ((Map)this.backingMap.get()).put(workspace.getId(), workspace);
        this.pickReference((MemoryWorkspace)workspace);
        return workspace;
    }

    public MemoryWorkspace createNewWorkspace() {
        this.ensureThreadExistense();
        CpuWorkspace workspace = new CpuWorkspace(this.defaultConfiguration);
        ((Map)this.backingMap.get()).put(workspace.getId(), workspace);
        this.pickReference((MemoryWorkspace)workspace);
        return workspace;
    }

    public MemoryWorkspace createNewWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String id) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.ensureThreadExistense();
        CpuWorkspace workspace = new CpuWorkspace(configuration, id);
        ((Map)this.backingMap.get()).put(id, workspace);
        this.pickReference((MemoryWorkspace)workspace);
        return workspace;
    }

    public MemoryWorkspace createNewWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String id, Integer deviceId) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.ensureThreadExistense();
        CpuWorkspace workspace = new CpuWorkspace(configuration, id, deviceId);
        ((Map)this.backingMap.get()).put(id, workspace);
        this.pickReference((MemoryWorkspace)workspace);
        return workspace;
    }

    public MemoryWorkspace getWorkspaceForCurrentThread(@NonNull WorkspaceConfiguration configuration, @NonNull String id) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.ensureThreadExistense();
        Object workspace = (MemoryWorkspace)((Map)this.backingMap.get()).get(id);
        if (workspace == null) {
            workspace = new CpuWorkspace(configuration, id);
            ((Map)this.backingMap.get()).put(id, workspace);
            this.pickReference((MemoryWorkspace)workspace);
        }
        return workspace;
    }
}

