/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.async;

import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.async.AsyncLog;
import org.neo4j.logging.async.AsyncLogEvent;
import org.neo4j.util.concurrent.AsyncEventSender;

public class AsyncLogProvider
implements LogProvider {
    private final LogProvider provider;
    private final AsyncEventSender<AsyncLogEvent> events;

    public AsyncLogProvider(AsyncEventSender<AsyncLogEvent> events, LogProvider provider) {
        this.provider = provider;
        this.events = events;
    }

    @Override
    public Log getLog(Class loggingClass) {
        return new AsyncLog(this.events, this.provider.getLog(loggingClass));
    }

    @Override
    public Log getLog(String name) {
        return new AsyncLog(this.events, this.provider.getLog(name));
    }
}

