/*
 * Decompiled with CFR 0.152.
 */
package org.nlpcn.commons.lang.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final char DY = '\'';
    private static final char DH = ',';
    private static int[] filter = new int[128];
    private static int[] filterEnd = new int[128];
    private static final String EMPTY = "";
    private static final String NULL = "null";

    public static String rmHtmlTag(String input) {
        if (StringUtil.isBlank(input)) {
            return EMPTY;
        }
        int length = input.length();
        int tl = 0;
        StringBuilder sb = new StringBuilder();
        char c = '\u0000';
        block5: for (int i = 0; i < length; ++i) {
            c = input.charAt(i);
            if (c > '\u007f') {
                sb.append(c);
                continue;
            }
            switch (filter[c]) {
                case -1: {
                    continue block5;
                }
                case 0: {
                    sb.append(c);
                    continue block5;
                }
                case 1: {
                    if (sb.length() > 0 && sb.charAt(sb.length() - 1) != c) {
                        sb.append(c);
                    }
                    while (++i < length && input.charAt(i) == c) {
                    }
                    if (i >= length && input.charAt(length - 1) == c) continue block5;
                    --i;
                    continue block5;
                }
                default: {
                    tl = filter[c] + i;
                    int tempOff = i++;
                    boolean flag = false;
                    char end = (char)filterEnd[c];
                    while (i < length && i < tl) {
                        c = input.charAt(i);
                        if (c <= '\u007f' && c == end) {
                            flag = true;
                            break;
                        }
                        ++i;
                    }
                    if (flag) continue block5;
                    i = tempOff;
                    sb.append(input.charAt(i));
                }
            }
        }
        return sb.toString();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtil.isBlank(cs);
    }

    public static String makeSqlInString(String str) {
        String[] strs = str.split(",");
        StringBuilder sb = new StringBuilder();
        String field = null;
        for (int i = 0; i < strs.length; ++i) {
            field = strs[i].trim();
            if (!StringUtil.isNotBlank(field)) continue;
            sb.append('\'');
            sb.append(field);
            sb.append('\'');
            if (i >= strs.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static char[] sortCharArray(String str) {
        char[] chars = str.toCharArray();
        Arrays.sort(chars);
        return chars;
    }

    public static String joiner(int[] ints, String split) {
        if (ints.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(ints[0]));
        for (int i = 1; i < ints.length; ++i) {
            sb.append(split);
            sb.append(ints[i]);
        }
        return sb.toString();
    }

    public static String joiner(double[] doubles, String split) {
        if (doubles.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(doubles[0]));
        for (int i = 1; i < doubles.length; ++i) {
            sb.append(split);
            sb.append(doubles[i]);
        }
        return sb.toString();
    }

    public static String joiner(float[] floats, String split) {
        if (floats.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(floats[0]));
        for (int i = 1; i < floats.length; ++i) {
            sb.append(split);
            sb.append(floats[i]);
        }
        return sb.toString();
    }

    public static String joiner(long[] longs, String split) {
        if (longs.length == 0) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(String.valueOf(longs[0]));
        for (int i = 1; i < longs.length; ++i) {
            sb.append(split);
            sb.append(longs[i]);
        }
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (obj == null) {
            return NULL;
        }
        return obj.toString();
    }

    public static String joiner(Collection<?> c, String split) {
        Iterator<?> iterator = c.iterator();
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(iterator.next().toString());
        while (iterator.hasNext()) {
            sb.append(split);
            sb.append(StringUtil.toString(iterator.next()).toString());
        }
        return sb.toString();
    }

    public static boolean isBlank(char[] chars) {
        int strLen;
        if (chars == null || (strLen = chars.length) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(chars[i])) continue;
            return false;
        }
        return true;
    }

    public static String matcherFirst(String regex, String input) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        if (matcher.find()) {
            return input.substring(matcher.start(), matcher.end());
        }
        return null;
    }

    public static String trim(String value) {
        int st;
        if (value == null) {
            return value;
        }
        int len = value.length();
        for (st = 0; st < len && (Character.isWhitespace(value.charAt(st)) || value.charAt(st) == '\ufeff' || value.charAt(st) == '\u00a0' || value.charAt(st) == '\u3000'); ++st) {
        }
        while (st < len && (Character.isWhitespace(value.charAt(len - 1)) || value.charAt(st) == '\u00a0' || value.charAt(st) == '\u3000')) {
            --len;
        }
        return st > 0 || len < value.length() ? value.substring(st, len) : value;
    }

    public static List<String> matcherAll(String regex, String input) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = Pattern.compile(regex).matcher(input);
        while (matcher.find()) {
            result.add(input.substring(matcher.start(), matcher.end()));
        }
        return result;
    }

    public static String matcherLast(String regex, String input) {
        List<String> result = StringUtil.matcherAll(regex, input);
        if (result.size() == 0) {
            return null;
        }
        return result.get(result.size() - 1);
    }

    static {
        StringUtil.filter[60] = 0x3FFFFFFF;
        StringUtil.filterEnd[60] = 62;
        StringUtil.filter[38] = 10;
        StringUtil.filterEnd[38] = 59;
        StringUtil.filter[59] = -1;
        StringUtil.filter[10] = -1;
        StringUtil.filter[13] = -1;
        StringUtil.filter[9] = -1;
        StringUtil.filter[32] = 1;
        StringUtil.filter[42] = 1;
        StringUtil.filter[45] = 1;
        StringUtil.filter[46] = 1;
        StringUtil.filter[35] = 1;
    }
}

