/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.linalg.BitVector$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.DenseVector$canDaxpy$;
import breeze.linalg.DenseVector$canDotD$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Matrix;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.TensorLike;
import breeze.linalg.Vector;
import breeze.linalg.Vector$;
import breeze.linalg.any$;
import breeze.linalg.diag$;
import breeze.linalg.max$;
import breeze.math.Ring$;
import breeze.math.Semiring$;
import breeze.storage.Zero;
import breeze.storage.Zero$DoubleZero$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class InteriorPoint$ {
    public static InteriorPoint$ MODULE$;
    private final double TOLERANCE;

    static {
        new InteriorPoint$();
    }

    public double TOLERANCE() {
        return this.TOLERANCE;
    }

    public DenseVector<Object> minimize(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x0, double tol) {
        int m = A.rows();
        int n = A.cols();
        DenseVector<Object> x = DenseVector$.MODULE$.zeros$mDc$sp(n, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        x.$plus$eq(x0, DenseVector$.MODULE$.canAddIntoD());
        Object object = ((TensorLike)((ImmutableNumericOps)A.$times(x0, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD())).$minus(b, DenseVector$.MODULE$.canSubD())).values().exists((JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 > 0.0) ? x.$colon$eq(this.phase1(A, b, c, x0), DenseVector$.MODULE$.dv_dv_UpdateOp_Double_OpSet()) : BoxedUnit.UNIT;
        DenseVector<Object> s = DenseVector$.MODULE$.ones$mDc$sp(m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
        DenseVector<Object> z = DenseVector$.MODULE$.ones$mDc$sp(m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Semiring$.MODULE$.semiringD());
        boolean converged = false;
        double lastGap = Double.POSITIVE_INFINITY;
        while (!converged) {
            try {
                Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> tuple3 = this.computeAffineScalingDir(A, b, c, x, s, z);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector zAff = (DenseVector)tuple3._1();
                DenseVector xAff = (DenseVector)tuple3._2();
                DenseVector sAff = (DenseVector)tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)zAff, (Object)xAff, (Object)sAff);
                Tuple3 tuple33 = tuple32;
                DenseVector zAff2 = (DenseVector)tuple33._1();
                DenseVector xAff2 = (DenseVector)tuple33._2();
                DenseVector sAff2 = (DenseVector)tuple33._3();
                double scaleX = this.lineSearch(s, sAff2);
                double scaleZ = this.lineSearch(z, zAff2);
                double sigma = package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)((ImmutableNumericOps)s.$plus(sAff2.$times(BoxesRunTime.boxToDouble((double)scaleX), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.canAddD())).dot(z.$plus(zAff2.$times(BoxesRunTime.boxToDouble((double)scaleZ), DenseVector$.MODULE$.dv_s_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.canAddD()), DenseVector$canDotD$.MODULE$)) / BoxesRunTime.unboxToDouble((Object)s.dot(z, DenseVector$canDotD$.MODULE$)), 3.0);
                Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> tuple34 = this.computeCenteringCorrectorDir(A, b, c, x, s, z, sAff2, zAff2, sigma);
                if (tuple34 == null) {
                    throw new MatchError(tuple34);
                }
                DenseVector zCC = (DenseVector)tuple34._1();
                DenseVector xCC = (DenseVector)tuple34._2();
                DenseVector sCC = (DenseVector)tuple34._3();
                Tuple3 tuple35 = new Tuple3((Object)zCC, (Object)xCC, (Object)sCC);
                Tuple3 tuple36 = tuple35;
                DenseVector zCC2 = (DenseVector)tuple36._1();
                DenseVector xCC2 = (DenseVector)tuple36._2();
                DenseVector sCC2 = (DenseVector)tuple36._3();
                DenseVector dz = (DenseVector)zAff2.$plus$eq(zCC2, DenseVector$.MODULE$.canAddIntoD());
                DenseVector dx = (DenseVector)xAff2.$plus$eq(xCC2, DenseVector$.MODULE$.canAddIntoD());
                DenseVector ds = (DenseVector)sAff2.$plus$eq(sCC2, DenseVector$.MODULE$.canAddIntoD());
                double scaleXF = this.lineSearch(s, ds);
                double scaleZF = this.lineSearch(z, dz);
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleXF)), dx, x, DenseVector$canDaxpy$.MODULE$);
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleXF)), ds, s, DenseVector$canDaxpy$.MODULE$);
                breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(0.99 * scaleZF)), dz, z, DenseVector$canDaxpy$.MODULE$);
                double gap = BoxesRunTime.unboxToDouble((Object)c.dot(x, DenseVector$canDotD$.MODULE$)) + BoxesRunTime.unboxToDouble((Object)b.dot(z, DenseVector$canDotD$.MODULE$));
                boolean bl = converged = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(gap)) < tol;
                if (gap > lastGap) {
                    breeze.linalg.package$.MODULE$.axpy(BoxesRunTime.boxToDouble((double)(-(0.99 * scaleXF))), dx, x, DenseVector$canDaxpy$.MODULE$);
                }
                lastGap = gap;
            }
            catch (MatrixSingularException m2) {
                converged = true;
            }
        }
        return x;
    }

    public double minimize$default$5() {
        return this.TOLERANCE();
    }

    private DenseVector<Object> phase1(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x0) {
        DenseVector<Object> r;
        block1: {
            double s = BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(((ImmutableNumericOps)A.$times(x0, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD())).$minus(b, DenseVector$.MODULE$.canSubD()), max$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))) + 1.0E-7;
            Matrix newA = DenseMatrix$.MODULE$.zeros$mDc$sp(A.rows() + 1, A.cols() + 1, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$);
            ((NumericOps)((DenseMatrix)newA).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows()), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.cols()), DenseMatrix$.MODULE$.canSliceColsAndRows())).$colon$eq(A, DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet());
            ((NumericOps)((DenseMatrix)newA).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), A.rows() + 1), BoxesRunTime.boxToInteger((int)A.cols()), DenseMatrix$.MODULE$.canSlicePartOfCol())).$colon$eq(BoxesRunTime.boxToDouble((double)-1.0), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpSet());
            DenseVector newB = (DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp(b.size() + 1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> i < b.size() ? b.apply$mcD$sp(i) : 0.0, ClassTag$.MODULE$.Double());
            DenseVector<Object> newC = DenseVector$.MODULE$.zeros$mDc$sp(c.size() + 1, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
            newC.update$mcD$sp(c.size(), 1.0);
            DenseVector newX = (DenseVector)DenseVector$.MODULE$.tabulate$mDc$sp(x0.size() + 1, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> i < x0.size() ? x0.apply$mcD$sp(i) : s, ClassTag$.MODULE$.Double());
            if (BoxesRunTime.unboxToBoolean((Object)any$.MODULE$.apply(((NumericOps)((ImmutableNumericOps)((DenseMatrix)newA).$times(newX, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD())).$minus(newB, DenseVector$.MODULE$.canSubD())).$greater$colon$greater(BoxesRunTime.boxToDouble((double)0.0), DenseVector$.MODULE$.dv_s_CompOp_Double_OpGT()), BitVector$.MODULE$.anyImpl()))) {
                throw new RuntimeException("Problem seems to be infeasible!");
            }
            r = this.minimize((DenseMatrix<Object>)newA, newB, newC, newX, this.minimize$default$5());
            if (!(r.apply$mcD$sp(x0.size()) > 1.0E-8)) break block1;
            Predef$.MODULE$.println((Object)("Problem appears to be infeasible: " + r.apply$mcD$sp(x0.size())));
        }
        return r.slice$mcD$sp(0, x0.size(), r.slice$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private double lineSearch(DenseVector<Object> x, Vector<Object> dx) {
        void var3_3;
        double alpha = 1.0;
        while (((Vector)x.$plus(dx.$times(BoxesRunTime.boxToDouble((double)alpha), Vector$.MODULE$.v_s_Op_Double_OpMulMatrix()), DenseVector$.MODULE$.dv_v_Op_Double_OpAdd())).valuesIterator().exists((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 < 0.0)) {
            alpha *= 0.8;
        }
        return (double)var3_3;
    }

    private Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> computeAffineScalingDir(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x, DenseVector<Object> s, DenseVector<Object> z) {
        DenseMatrix<Object> XiZ = diag$.MODULE$.apply(z.$div$colon$div(s, DenseVector$.MODULE$.dv_dv_Op_Double_OpDiv()), diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$));
        DenseMatrix<Object> AtXiZ = ((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times(XiZ, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD());
        DenseVector<Object> rx = ((ImmutableNumericOps)((NumericOps)A.$times(x, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD())).$plus(s, DenseVector$.MODULE$.canAddD())).$minus(b, DenseVector$.MODULE$.canSubD());
        DenseVector<Object> rz = ((NumericOps)((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times(z, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD())).$plus(c, DenseVector$.MODULE$.canAddD());
        DenseMatrix<Object> mat = AtXiZ.$times(A, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DMD_eq_DMD());
        DenseVector<Object> dx = mat.$bslash(((ImmutableNumericOps)((ImmutableNumericOps)((ImmutableNumericOps)A.t(DenseMatrix$.MODULE$.canTranspose())).$times(z, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD())).$minus(rz, DenseVector$.MODULE$.canSubD())).$minus(AtXiZ.$times(rx, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), DenseVector$.MODULE$.canSubD()), DenseMatrix$.MODULE$.implOpSolveMatrixBy_DMD_DVD_eq_DVD());
        DenseVector<Object> ds = ((ImmutableNumericOps)rx.unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.dv_s_Op_Double_OpMulScalar(), Ring$.MODULE$.ringD()))).$minus(A.$times(dx, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), DenseVector$.MODULE$.canSubD());
        DenseVector<Object> dz = ((ImmutableNumericOps)z.unary_$minus(DenseVector$.MODULE$.negFromScale(DenseVector$.MODULE$.dv_s_Op_Double_OpMulScalar(), Ring$.MODULE$.ringD()))).$minus(XiZ.$times(ds, DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), DenseVector$.MODULE$.canSubD());
        return new Tuple3(dz, dx, ds);
    }

    private Tuple3<DenseVector<Object>, DenseVector<Object>, DenseVector<Object>> computeCenteringCorrectorDir(DenseMatrix<Object> A, DenseVector<Object> b, DenseVector<Object> c, DenseVector<Object> x, DenseVector<Object> s, DenseVector<Object> z, DenseVector<Object> dsaff, DenseVector<Object> dzaff, double sigma) {
        int n = A.cols();
        int m = A.rows();
        DenseMatrix<Object> mat = DenseMatrix$.MODULE$.vertcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{DenseMatrix$.MODULE$.zeros$mDc$sp(m, m, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$), A, DenseMatrix$.MODULE$.eye$mDc$sp(m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$, Semiring$.MODULE$.semiringD())}), Predef$.MODULE$.$conforms(), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$), DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{A.t(DenseMatrix$.MODULE$.canTranspose()), DenseMatrix$.MODULE$.zeros$mDc$sp(n, n + m, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$)}), Predef$.MODULE$.$conforms(), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$), DenseMatrix$.MODULE$.horzcat(Predef$.MODULE$.wrapRefArray((Object[])new DenseMatrix[]{diag$.MODULE$.apply(s, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$)), DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero$DoubleZero$.MODULE$), diag$.MODULE$.apply(z, diag$.MODULE$.diagDVDMImpl(ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$))}), Predef$.MODULE$.$conforms(), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$)}), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        ((NumericOps)diag$.MODULE$.apply(mat, diag$.MODULE$.diagDMDVImpl())).$plus$eq(BoxesRunTime.boxToDouble((double)1.0E-20), DenseVector$.MODULE$.dv_s_UpdateOp_Double_OpAdd());
        DenseVector<Object> r = DenseVector$.MODULE$.zeros$mDc$sp(m + n + m, (ClassTag<Object>)ClassTag$.MODULE$.Double(), Zero$DoubleZero$.MODULE$);
        r.slice$mcD$sp(m + n, m + n + m, r.slice$default$3()).$minus$eq(((ImmutableNumericOps)dsaff.$times$colon$times(dzaff, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar())).$minus(BoxesRunTime.boxToDouble((double)(sigma / (double)m * BoxesRunTime.unboxToDouble((Object)s.dot(z, DenseVector$canDotD$.MODULE$)))), DenseVector$.MODULE$.dv_s_Op_Double_OpSub()), DenseVector$.MODULE$.canSubIntoD());
        DenseVector<Object> sol = mat.$bslash(r, DenseMatrix$.MODULE$.implOpSolveMatrixBy_DMD_DVD_eq_DVD());
        return new Tuple3(sol.slice$mcD$sp(0, m, sol.slice$default$3()), sol.slice$mcD$sp(m, n + m, sol.slice$default$3()), sol.slice$mcD$sp(n + m, n + m + m, sol.slice$default$3()));
    }

    private InteriorPoint$() {
        MODULE$ = this;
        this.TOLERANCE = 1.0E-18;
    }
}

