/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.support.converter;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.amqp.support.converter.AbstractMessageConverter;
import org.springframework.util.PatternMatchUtils;

public abstract class WhiteListDeserializingMessageConverter
extends AbstractMessageConverter {
    private final Set<String> whiteListPatterns = new LinkedHashSet<String>();

    public void setWhiteListPatterns(List<String> whiteListPatterns) {
        this.whiteListPatterns.clear();
        this.whiteListPatterns.addAll(whiteListPatterns);
    }

    protected void checkWhiteList(Class<?> clazz) throws IOException {
        if (this.whiteListPatterns.isEmpty()) {
            return;
        }
        if (clazz.isArray() || clazz.isPrimitive() || clazz.equals(String.class) || Number.class.isAssignableFrom(clazz)) {
            return;
        }
        String className = clazz.getName();
        for (String pattern : this.whiteListPatterns) {
            if (!PatternMatchUtils.simpleMatch((String)pattern, (String)className)) continue;
            return;
        }
        throw new SecurityException("Attempt to deserialize unauthorized " + clazz);
    }
}

