/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.groovy.config;

import groovy.lang.Binding;
import groovy.lang.MissingPropertyException;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationNotAllowedException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.integration.config.AbstractSimpleMessageHandlerFactoryBean;
import org.springframework.integration.groovy.GroovyCommandMessageProcessor;
import org.springframework.integration.handler.MessageProcessor;
import org.springframework.integration.handler.ServiceActivatingHandler;
import org.springframework.integration.scripting.ScriptVariableGenerator;
import org.springframework.integration.support.management.IntegrationManagedResource;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.CustomizableThreadCreator;

public class GroovyControlBusFactoryBean
extends AbstractSimpleMessageHandlerFactoryBean<MessageHandler>
implements BeanClassLoaderAware {
    private volatile Long sendTimeout;
    private volatile GroovyObjectCustomizer customizer;
    private volatile ClassLoader beanClassLoader;

    public void setSendTimeout(Long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setCustomizer(GroovyObjectCustomizer customizer) {
        this.customizer = customizer;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected MessageHandler createHandler() {
        ManagedBeansBinding binding = new ManagedBeansBinding(this.getBeanFactory());
        GroovyCommandMessageProcessor processor = new GroovyCommandMessageProcessor(binding, new ScriptVariableGenerator(){

            public Map<String, Object> generateScriptVariables(Message<?> message) {
                HashMap<String, Object> variables = new HashMap<String, Object>();
                variables.put("headers", message.getHeaders());
                return variables;
            }
        });
        if (this.customizer != null) {
            processor.setCustomizer(this.customizer);
        }
        if (this.beanClassLoader != null) {
            processor.setBeanClassLoader(this.beanClassLoader);
        }
        if (this.getBeanFactory() != null) {
            processor.setBeanFactory(this.getBeanFactory());
        }
        return this.configureHandler(new ServiceActivatingHandler((MessageProcessor)processor));
    }

    private ServiceActivatingHandler configureHandler(ServiceActivatingHandler handler) {
        if (this.sendTimeout != null) {
            handler.setSendTimeout(this.sendTimeout.longValue());
        }
        return handler;
    }

    private static class ManagedBeansBinding
    extends Binding {
        private final ConfigurableListableBeanFactory beanFactory;

        public ManagedBeansBinding(BeanFactory beanFactory) {
            this.beanFactory = beanFactory instanceof ConfigurableListableBeanFactory ? (ConfigurableListableBeanFactory)beanFactory : null;
        }

        public Object getVariable(String name) {
            try {
                return super.getVariable(name);
            }
            catch (MissingPropertyException missingPropertyException) {
                if (this.beanFactory == null) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass());
                }
                Object bean = null;
                try {
                    bean = this.beanFactory.getBean(name);
                }
                catch (NoSuchBeanDefinitionException e) {
                    throw new MissingPropertyException(name, ((Object)((Object)this)).getClass(), (Throwable)e);
                }
                if (bean instanceof Lifecycle || bean instanceof CustomizableThreadCreator || AnnotationUtils.findAnnotation(bean.getClass(), ManagedResource.class) != null || AnnotationUtils.findAnnotation(bean.getClass(), IntegrationManagedResource.class) != null) {
                    return bean;
                }
                throw new BeanCreationNotAllowedException(name, "Only beans with @ManagedResource or beans which implement org.springframework.context.Lifecycle or org.springframework.util.CustomizableThreadCreator are allowed to use as ControlBus components.");
            }
        }
    }
}

