/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.mx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tachyon.org.jets3t.service.model.StorageBucket;
import tachyon.org.jets3t.service.model.StorageObject;
import tachyon.org.jets3t.service.mx.MxInterface;

public class MxDelegate
implements MxInterface {
    private static final Log log = LogFactory.getLog(MxDelegate.class);
    private MxInterface handler = null;
    private static MxDelegate instance = null;

    public static MxDelegate getInstance() {
        if (instance == null) {
            instance = new MxDelegate();
        }
        return instance;
    }

    protected MxDelegate() {
    }

    public void init() {
        if (System.getProperty("com.sun.management.jmxremote") == null && System.getProperty("jets3t.mx") == null) {
            this.handler = null;
            return;
        }
        try {
            Class<?> impl = Class.forName("contribs.mx.MxImpl");
            this.handler = (MxInterface)impl.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"JMX instrumentation package 'contribs.mx' could not be found,  instrumentation will not available", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)"JMX instrumentation implementation in package 'contribs.mx'  could not be loaded", (Throwable)e);
        }
    }

    public boolean isJmxDelegationActive() {
        return this.handler != null;
    }

    public void registerS3ServiceMBean() {
        if (this.handler != null) {
            this.handler.registerS3ServiceMBean();
        }
    }

    public void registerS3ServiceExceptionMBean() {
        if (this.handler != null) {
            this.handler.registerS3ServiceExceptionMBean();
        }
    }

    public void registerS3ServiceExceptionEvent() {
        if (this.handler != null) {
            this.handler.registerS3ServiceExceptionEvent();
        }
    }

    public void registerS3ServiceExceptionEvent(String s3ErrorCode) {
        if (this.handler != null) {
            this.handler.registerS3ServiceExceptionEvent(s3ErrorCode);
        }
    }

    public void registerStorageBucketMBeans(StorageBucket[] buckets) {
        if (this.handler != null) {
            this.handler.registerStorageBucketMBeans(buckets);
        }
    }

    public void registerStorageBucketListEvent(String bucketName) {
        if (this.handler != null) {
            this.handler.registerStorageBucketListEvent(bucketName);
        }
    }

    public void registerStorageObjectMBean(String bucketName, StorageObject[] objects) {
        if (this.handler != null) {
            this.handler.registerStorageObjectMBean(bucketName, objects);
        }
    }

    public void registerStorageObjectPutEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerStorageObjectPutEvent(bucketName, key);
        }
    }

    public void registerStorageObjectGetEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerStorageObjectGetEvent(bucketName, key);
        }
    }

    public void registerStorageObjectHeadEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerStorageObjectHeadEvent(bucketName, key);
        }
    }

    public void registerStorageObjectDeleteEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerStorageObjectDeleteEvent(bucketName, key);
        }
    }

    public void registerStorageObjectCopyEvent(String bucketName, String key) {
        if (this.handler != null) {
            this.handler.registerStorageObjectCopyEvent(bucketName, key);
        }
    }
}

