/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeWav
extends PrimitiveOp {
    private Output<Float> audio;
    private Output<Integer> sampleRate;

    public static DecodeWav create(Scope scope, Operand<String> contents, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DecodeWav", scope.makeOpName("DecodeWav"));
        opBuilder.addInput(contents.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.desiredChannels != null) {
                    opBuilder.setAttr("desired_channels", opts.desiredChannels);
                }
                if (opts.desiredSamples == null) continue;
                opBuilder.setAttr("desired_samples", opts.desiredSamples);
            }
        }
        return new DecodeWav(opBuilder.build());
    }

    public static Options desiredChannels(Long desiredChannels) {
        return new Options().desiredChannels(desiredChannels);
    }

    public static Options desiredSamples(Long desiredSamples) {
        return new Options().desiredSamples(desiredSamples);
    }

    public Output<Float> audio() {
        return this.audio;
    }

    public Output<Integer> sampleRate() {
        return this.sampleRate;
    }

    private DecodeWav(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.audio = operation.output(outputIdx++);
        this.sampleRate = operation.output(outputIdx++);
    }

    public static class Options {
        private Long desiredChannels;
        private Long desiredSamples;

        public Options desiredChannels(Long desiredChannels) {
            this.desiredChannels = desiredChannels;
            return this;
        }

        public Options desiredSamples(Long desiredSamples) {
            this.desiredSamples = desiredSamples;
            return this;
        }

        private Options() {
        }
    }
}

