/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class Sum<T>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T, U extends Number> Sum<T> create(Scope scope, Operand<T> input, Operand<U> axis, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("Sum", scope.makeOpName("Sum"));
        opBuilder.addInput(input.asOutput());
        opBuilder.addInput(axis.asOutput());
        if (options != null) {
            for (Options opts : options) {
                if (opts.keepDims == null) continue;
                opBuilder.setAttr("keep_dims", opts.keepDims);
            }
        }
        return new Sum<T>(opBuilder.build());
    }

    public static Options keepDims(Boolean keepDims) {
        return new Options().keepDims(keepDims);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private Sum(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private Boolean keepDims;

        public Options keepDims(Boolean keepDims) {
            this.keepDims = keepDims;
            return this;
        }

        private Options() {
        }
    }
}

