/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exception;

import java.util.List;
import java.util.Locale;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.ExceptionUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.exception.ErrorCode;
import org.tinygroup.exception.ErrorCodeFactory;
import org.tinygroup.exception.ErrorContext;
import org.tinygroup.exception.util.ErrorUtil;
import org.tinygroup.i18n.I18nMessage;
import org.tinygroup.i18n.I18nMessageFactory;

public class BaseCheckedException
extends Exception {
    private static final long serialVersionUID = -1141168272047460629L;
    private static final I18nMessage i18nMessage = I18nMessageFactory.getI18nMessages();
    private String errorMsg;
    private ErrorCode errorCode;

    public BaseCheckedException(String errorCode, Object ... params) {
        this(errorCode, "", LocaleUtil.getContext().getLocale(), params);
    }

    public BaseCheckedException(String errorCode, String defaultErrorMsg, Locale locale, Object ... params) {
        String errorI18nMsg = i18nMessage.getMessage(errorCode, locale, defaultErrorMsg, params);
        this.initErrorCode(errorCode, errorI18nMsg);
    }

    public BaseCheckedException(String errorCode, Throwable throwable, Object ... params) {
        this(errorCode, "", LocaleUtil.getContext().getLocale(), throwable, params);
    }

    public BaseCheckedException(String errorCode, String defaultErrorMsg, Throwable throwable, Object ... params) {
        this(errorCode, defaultErrorMsg, LocaleUtil.getContext().getLocale(), throwable, params);
    }

    public BaseCheckedException(String errorCode, String defaultErrorMsg, Locale locale, Throwable throwable, Object ... params) {
        super(throwable);
        String errorI18nMsg = i18nMessage.getMessage(errorCode, locale, defaultErrorMsg, params);
        this.initErrorCode(errorCode, errorI18nMsg);
    }

    public BaseCheckedException(String errorCode, Context context, Locale locale) {
        this(errorCode, "", context, locale);
    }

    public BaseCheckedException(String errorCode, String defaultErrorMsg, Context context, Locale locale) {
        String errorI18nMsg = i18nMessage.getMessage(errorCode, defaultErrorMsg, context, locale);
        this.initErrorCode(errorCode, errorI18nMsg);
    }

    public BaseCheckedException(String errorCode, Context context) {
        this(errorCode, "", context, LocaleUtil.getContext().getLocale());
    }

    public BaseCheckedException() {
    }

    public BaseCheckedException(Throwable cause) {
        super(cause);
    }

    public static ErrorContext getErrorContext(Throwable throwable) {
        ErrorContext errorContext = new ErrorContext();
        List causes = ExceptionUtil.getCauses((Throwable)throwable, (boolean)true);
        for (Throwable cause : causes) {
            if (!(cause instanceof BaseCheckedException)) continue;
            BaseCheckedException exception = (BaseCheckedException)cause;
            ErrorUtil.makeAndAddError(errorContext, exception.getErrorCode(), exception.getMessage());
        }
        return errorContext;
    }

    @Override
    public String getMessage() {
        StringBuffer msgBuffer = new StringBuffer();
        if (this.errorCode == null) {
            if (StringUtil.isBlank((String)this.errorMsg)) {
                return super.getMessage();
            }
            msgBuffer.append(this.errorMsg);
        } else {
            msgBuffer.append(String.format("[%s]", this.errorCode));
            if (!StringUtil.isBlank((String)this.errorMsg)) {
                msgBuffer.append(" : ").append(this.errorMsg);
            }
        }
        return msgBuffer.toString();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    private void initErrorCode(String errorCode, String errorI18nMsg) {
        this.errorMsg = StringUtil.isBlank((String)errorI18nMsg) ? errorCode : errorI18nMsg;
        try {
            this.errorCode = ErrorCodeFactory.parseErrorCode(errorCode, this);
        }
        catch (Exception e) {
            this.errorCode = null;
        }
    }

    public boolean contains(Class exType) {
        if (exType == null) {
            return false;
        }
        if (exType.isInstance(this)) {
            return true;
        }
        Throwable cause = this.getCause();
        if (cause == this) {
            return false;
        }
        if (cause instanceof BaseCheckedException) {
            return ((BaseCheckedException)cause).contains(exType);
        }
        while (cause != null) {
            if (exType.isInstance(cause)) {
                return true;
            }
            if (cause.getCause() == cause) break;
            cause = cause.getCause();
        }
        return false;
    }
}

