/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.exception;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.exception.ErrorCode;
import org.tinygroup.exception.ErrorCodeParser;
import org.tinygroup.exception.errorcode.ErrorCodeDefault;
import org.tinygroup.exception.errorcode.ErrorCodeLength16;

public class ErrorCodeFactory {
    private static List<ErrorCodeParser> codeParsers = new ArrayList<ErrorCodeParser>();

    private ErrorCodeFactory() {
    }

    public static void addCodeParser(ErrorCodeParser errorCodeParser) {
        codeParsers.add(errorCodeParser);
    }

    public static ErrorCode parseErrorCode(String errorCode, Throwable cause) {
        Assert.assertNotNull((Object)errorCode, (String)"errorCode must not be null", (Object[])new Object[0]);
        ErrorCodeParser parser = ErrorCodeFactory.findParser(errorCode, cause);
        if (parser == null) {
            return null;
        }
        return parser.parse(errorCode);
    }

    private static ErrorCodeParser findParser(String errorCodeStr, Throwable cause) {
        for (ErrorCodeParser errorCodeParser : codeParsers) {
            if (!errorCodeParser.isMatch(errorCodeStr)) continue;
            return errorCodeParser;
        }
        throw new IllegalArgumentException(String.format("\u672a\u627e\u5230\u9519\u8bef\u7801:%s,\u5bf9\u5e94\u7684\u9519\u8bef\u7801\u89e3\u6790\u89c4\u8303", errorCodeStr), cause);
    }

    static {
        codeParsers.add(new ErrorCodeDefault());
        codeParsers.add(new ErrorCodeLength16());
    }
}

