/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.bizdatatype.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.metadata.bizdatatype.BusinessTypeProcessor;
import org.tinygroup.metadata.config.bizdatatype.BusinessType;
import org.tinygroup.metadata.config.bizdatatype.BusinessTypes;
import org.tinygroup.metadata.exception.MetadataRuntimeException;
import org.tinygroup.metadata.stddatatype.StandardTypeProcessor;
import org.tinygroup.metadata.stddatatype.impl.StandardTypeProcessorImpl;
import org.tinygroup.metadata.util.ConfigUtil;
import org.tinygroup.metadata.util.MetadataUtil;

public class BusinessTypeProcessorImpl
implements BusinessTypeProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(BusinessTypeProcessorImpl.class);
    private static BusinessTypeProcessor businessTypeProcessor = new BusinessTypeProcessorImpl();
    private Map<String, BusinessType> businessTypeMap = new HashMap<String, BusinessType>();
    private StandardTypeProcessor standardTypeProcessor;

    public static BusinessTypeProcessor getBusinessTypeProcessor() {
        businessTypeProcessor.setStandardTypeProcessor(StandardTypeProcessorImpl.getStandardTypeProcessor());
        return businessTypeProcessor;
    }

    @Override
    public StandardTypeProcessor getStandardTypeProcessor() {
        return this.standardTypeProcessor;
    }

    @Override
    public void setStandardTypeProcessor(StandardTypeProcessor standardDataTypeProcessor) {
        this.standardTypeProcessor = standardDataTypeProcessor;
    }

    @Override
    public String getType(String id, String language) {
        BusinessType type = this.getBusinessTypes(id);
        String stdType = this.standardTypeProcessor.getType(type.getTypeId(), language);
        String result = MetadataUtil.formatType(stdType, type.getPlaceholderValueList());
        if (result != null) {
            return result;
        }
        throw new MetadataRuntimeException("0TE120061013", id, language);
    }

    @Override
    public void addBusinessTypes(BusinessTypes businessTypes) {
        if (businessTypes != null && businessTypes.getBusinessTypeList() != null) {
            for (BusinessType type : businessTypes.getBusinessTypeList()) {
                if (this.businessTypeMap.containsKey(type.getId())) {
                    if (ConfigUtil.isCheckStrict()) {
                        throw new MetadataRuntimeException("0TE120061011", type.getName(), type.getId());
                    }
                    LOGGER.error((Throwable)((Object)new MetadataRuntimeException("0TE120061011", type.getName(), type.getId())));
                }
                this.businessTypeMap.put(type.getId(), type);
            }
        }
    }

    @Override
    public BusinessType getBusinessTypes(String id) {
        if (this.businessTypeMap.containsKey(id)) {
            return this.businessTypeMap.get(id);
        }
        throw new MetadataRuntimeException("0TE120061012", id);
    }

    @Override
    public void removeBusinessTypes(BusinessTypes businessTypes) {
        if (businessTypes != null && businessTypes.getBusinessTypeList() != null) {
            for (BusinessType type : businessTypes.getBusinessTypeList()) {
                this.businessTypeMap.remove(type.getId());
            }
        }
    }

    @Override
    public Map<String, BusinessType> getBusinessTypeMap() {
        return this.businessTypeMap;
    }
}

