/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.metadata.constants.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.metadata.config.constants.Constant;
import org.tinygroup.metadata.config.constants.Constants;
import org.tinygroup.metadata.constants.ConstantProcessor;

public class ConstantsProcessorImpl
implements ConstantProcessor {
    private static ConstantProcessor constantProcessor = new ConstantsProcessorImpl();
    private Map<String, Constant> constantsMap = new HashMap<String, Constant>();

    public static ConstantProcessor getConstantProcessor() {
        return constantProcessor;
    }

    @Override
    public boolean getBooleanValue(String name) {
        String value = this.getValue(name);
        return Boolean.parseBoolean(value);
    }

    @Override
    public double getDoubleValue(String name) {
        String value = this.getValue(name);
        return Double.parseDouble(value);
    }

    @Override
    public float getFloatValue(String name) {
        String value = this.getValue(name);
        return Float.parseFloat(value);
    }

    @Override
    public char getCharValue(String name) {
        String value = this.getValue(name);
        return value.charAt(0);
    }

    @Override
    public short getShortValue(String name) {
        String value = this.getValue(name);
        return Short.parseShort(value);
    }

    @Override
    public byte getByteValue(String name) {
        String value = this.getValue(name);
        return new Byte(value);
    }

    @Override
    public long getLongValue(String id) {
        String value = this.getValue(id);
        return Long.parseLong(value);
    }

    @Override
    public String getStringValue(String id) {
        return this.getValue(id);
    }

    @Override
    public int getIntValue(String name) {
        String value = this.getValue(name);
        return Integer.parseInt(value);
    }

    @Override
    public void addConstants(Constants constants) {
        if (constants != null && constants.getConstantList() != null) {
            for (Constant c : constants.getConstantList()) {
                this.constantsMap.put(c.getId(), c);
            }
        }
    }

    @Override
    public void removeConstants(Constants constants) {
        if (constants != null && constants.getConstantList() != null) {
            for (Constant c : constants.getConstantList()) {
                this.constantsMap.remove(c.getId());
            }
        }
    }

    private String getValue(String id) {
        if (this.constantsMap.containsKey(id)) {
            return this.constantsMap.get(id).getValue();
        }
        throw new RuntimeException(String.format("ID:[%s]\u7684\u5e38\u91cf\u4e0d\u5b58\u5728\u3002", id));
    }
}

