/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.serviceweblayer.impl;

import java.util.HashMap;
import java.util.Map;
import org.tinygroup.serviceweblayer.ServiceMappingManager;
import org.tinygroup.serviceweblayer.config.ServiceViewMapping;
import org.tinygroup.serviceweblayer.config.ServiceViewMappings;

public class ServiceMappingManagerImpl
implements ServiceMappingManager {
    Map<String, String> urlMapping = new HashMap<String, String>();
    Map<String, ServiceViewMapping> viewMapping = new HashMap<String, ServiceViewMapping>();

    @Override
    public void addServiceMappings(ServiceViewMappings mappings) {
        for (ServiceViewMapping mapping : mappings.getServiceViewMappings()) {
            this.urlMapping.put(mapping.getServiceId(), mapping.getPath());
            this.viewMapping.put(mapping.getServiceId(), mapping);
        }
    }

    @Override
    public void removeServiceMappings(ServiceViewMappings mappings) {
        for (ServiceViewMapping mapping : mappings.getServiceViewMappings()) {
            this.urlMapping.remove(mapping.getServiceId());
            this.viewMapping.remove(mapping.getServiceId());
        }
    }

    @Override
    public String getUrl(String serviceId) {
        return this.urlMapping.get(serviceId);
    }

    @Override
    public void addServiceMapping(ServiceViewMapping mapping) {
        if (mapping != null) {
            this.urlMapping.put(mapping.getServiceId(), mapping.getPath());
            this.viewMapping.put(mapping.getServiceId(), mapping);
        }
    }

    @Override
    public ServiceViewMapping getServiceViewMapping(String serviceId) {
        return this.viewMapping.get(serviceId);
    }
}

