/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.serviceweblayer.processor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.context.Context;
import org.tinygroup.context.util.ContextFactory;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.exception.BaseRuntimeException;
import org.tinygroup.serviceweblayer.json.JsonInputMessage;
import org.tinygroup.serviceweblayer.json.JsonOutputMessage;
import org.tinygroup.weblayer.AbstractTinyProcessor;
import org.tinygroup.weblayer.WebContext;

public class JsonServiceTinyProcessor
extends AbstractTinyProcessor {
    public static final String BEAN_NAME = "jsonServiceTinyProcessor";
    private static Map<String, Class<?>> basicClasses = new HashMap();
    private CEPCore core;

    public CEPCore getCore() {
        return this.core;
    }

    public void setCore(CEPCore core) {
        this.core = core;
    }

    protected void customInit() throws ServletException {
    }

    public void reallyProcess(String urlString, WebContext context) throws ServletException, IOException {
        byte[] data = StreamUtil.readBytes((InputStream)context.getRequest().getInputStream(), (boolean)true).toByteArray();
        String characterEncoding = context.getRequest().getCharacterEncoding();
        String inputJson = new String(data, characterEncoding);
        String resultJson = this.process(inputJson);
        context.getResponse().getOutputStream().write(resultJson.getBytes(characterEncoding));
    }

    public String process(String inputJson) {
        JsonInputMessage jsonInputMessage = (JsonInputMessage)JSON.parseObject((String)inputJson, JsonInputMessage.class);
        Map<String, String> head = jsonInputMessage.getHead();
        String body = jsonInputMessage.getBody();
        String serviceId = head.get("serviceid");
        ServiceInfo serviceInfo = this.core.getServiceInfo(serviceId);
        Context context = ContextFactory.getContext();
        String errorCode = "";
        String errorInfo = "\u4ea4\u6613\u6210\u529f";
        JsonOutputMessage outputMessage = new JsonOutputMessage();
        try {
            this.processParam(body, serviceInfo, context);
            Event e = Event.createEvent((String)serviceId, (Context)context);
            this.core.process(e);
            this.dealResult(serviceInfo, outputMessage, e);
        }
        catch (BaseRuntimeException e) {
            errorCode = e.getErrorCode().toString();
            errorInfo = e.getMessage();
        }
        catch (Exception e) {
            errorCode = "\u672a\u5b9a\u4e49\u7684errrCode";
            errorInfo = e.getMessage();
        }
        head.put("ErrorCode", errorCode);
        head.put("ErrorInfo", errorInfo);
        outputMessage.setHead(head);
        return JSON.toJSONString((Object)outputMessage);
    }

    private void dealResult(ServiceInfo serviceInfo, JsonOutputMessage outputMessage, Event e) {
        List results = serviceInfo.getResults();
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        for (Parameter p : results) {
            resultMap.put(p.getName(), e.getServiceRequest().getContext().get(p.getName()));
        }
        outputMessage.setBody(resultMap);
    }

    private void processParam(String body, ServiceInfo serviceInfo, Context context) {
        List list = serviceInfo.getParameters();
        JSONObject object = JSON.parseObject((String)body);
        for (Parameter p : list) {
            String name = p.getName();
            String type = p.getType();
            boolean isCollection = !StringUtil.isBlank((String)p.getCollectionType());
            boolean isArray = p.isArray();
            boolean isRequired = p.isRequired();
            Class<?> clazz = this.getClass(type);
            if ((!isRequired || object.containsKey((Object)name)) && !isRequired && !object.containsKey((Object)name)) continue;
            if (isArray) {
                this.parseArray(context, object, name, clazz);
                continue;
            }
            if (isCollection) {
                this.parseCollection(context, object, name, clazz, p.getCollectionType());
                continue;
            }
            this.parseObject(context, object, name, clazz);
        }
    }

    private void parseObject(Context context, JSONObject value, String name, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                context.put(name, (Object)value.getIntValue(name));
            } else if (clazz == Double.TYPE) {
                context.put(name, (Object)value.getDoubleValue(name));
            } else if (clazz == Long.TYPE) {
                context.put(name, (Object)value.getLongValue(name));
            } else if (clazz == Short.TYPE) {
                context.put(name, (Object)value.getShortValue(name));
            } else if (clazz == Byte.TYPE) {
                context.put(name, (Object)value.getByteValue(name));
            } else if (clazz == Character.TYPE) {
                context.put(name, (Object)value.getString(name));
            } else if (clazz == Boolean.TYPE) {
                context.put(name, (Object)value.getBooleanValue(name));
            } else {
                context.put(name, (Object)value.getString(name));
            }
        } else {
            String jsonString = JSON.toJSONString((Object)value.get((Object)name));
            context.put(name, JSON.parseObject((String)jsonString, clazz));
        }
    }

    private void parseCollection(Context context, JSONObject value, String name, Class<?> clazz, String collectionType) {
        String jsonString = JSON.toJSONString((Object)value.get((Object)name));
        context.put(name, (Object)JSON.parseArray((String)jsonString, clazz));
    }

    private void parseArray(Context context, JSONObject value, String name, Class<?> clazz) {
        Class<?> clazzArray = Array.newInstance(clazz, 0).getClass();
        String valueString = value.getString(name);
        context.put(name, JSON.parseObject((String)valueString, clazzArray));
    }

    private Class<?> getClass(String type) {
        try {
            if (basicClasses.containsKey(type)) {
                return basicClasses.get(type);
            }
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("\u672a\u627e\u5230\u5bf9\u5e94\u7c7b" + type, e);
        }
    }

    static {
        basicClasses.put("int", Integer.TYPE);
        basicClasses.put("double", Double.TYPE);
        basicClasses.put("float", Float.TYPE);
        basicClasses.put("short", Float.TYPE);
        basicClasses.put("boolean", Boolean.TYPE);
        basicClasses.put("char", Character.TYPE);
        basicClasses.put("byte", Byte.TYPE);
    }
}

