/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apprunner.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apprunner.AppRunnerClient;
import software.amazon.awssdk.services.apprunner.internal.UserAgentUtils;
import software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsRequest;
import software.amazon.awssdk.services.apprunner.model.ListVpcConnectorsResponse;

public class ListVpcConnectorsIterable
implements SdkIterable<ListVpcConnectorsResponse> {
    private final AppRunnerClient client;
    private final ListVpcConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVpcConnectorsIterable(AppRunnerClient client, ListVpcConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListVpcConnectorsResponseFetcher();
    }

    public Iterator<ListVpcConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListVpcConnectorsResponseFetcher
    implements SyncPageFetcher<ListVpcConnectorsResponse> {
        private ListVpcConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListVpcConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVpcConnectorsResponse nextPage(ListVpcConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListVpcConnectorsIterable.this.client.listVpcConnectors(ListVpcConnectorsIterable.this.firstRequest);
            }
            return ListVpcConnectorsIterable.this.client.listVpcConnectors((ListVpcConnectorsRequest)((Object)ListVpcConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

